import java.awt.*;
import java.awt.event.*;
import com.java4less.rss.*;


/**
 * This program shows the user of J4L RSS and EAN-UCC Composite component
 */
public class Examples extends Frame {
  Button btnExit = new Button();
  Label label1 = new Label();
  Button btnSave = new Button();
  MenuBar menuBar1 = new MenuBar();
  MenuBar menuBar2 = new MenuBar();
  Choice comboExample = new Choice();
  Panel panel1 = new Panel();
  Label lblDescription = new Label();

  // barcode component
  BarCode bc= new BarCode();
  Button btnSave1 = new Button();


  public Examples() {
    try {
      jbInit();
      userInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  public static void main(String[] args) {
    Examples examples1 = new Examples();
    examples1.show();
  }

  private void userInit() throws Exception {
      comboExample.addItem("UPC E");
      comboExample.addItem("UPC E with 2D Component");
      comboExample.addItem("EAN 8");
      comboExample.addItem("EAN 8 with 2D Component");
      comboExample.addItem("EAN 13");
      comboExample.addItem("EAN 13 with 2D Component");
      comboExample.addItem("UPC A");
      comboExample.addItem("UPC A with 2D Component");
      comboExample.addItem("EAN 128");
      comboExample.addItem("EAN 128 with 2D Component");
      comboExample.addItem("RSS14");
      comboExample.addItem("RSS14 Stacked");
      comboExample.addItem("RSS14 Truncated");
      comboExample.addItem("RSS14 Stacked Omnnidirectional");
      comboExample.addItem("RSS14 Stacked with 2D Component");
      comboExample.addItem("RSS Limited");
      comboExample.addItem("RSS Limited with 2D Component");
      comboExample.addItem("RSS Expanded");
      comboExample.addItem("RSS Expanded Stacked");
      comboExample.addItem("RSS Expanded with 2D Component");
      comboExample.addItem("RSS Expanded Stacked with 2D Component");
      this.setSize(700,500);
      this.setLocation(100,100);
      this.setBackground(java.awt.Color.lightGray);
      setBarcodeComponent(0);

  }


  private void jbInit() throws Exception {
    btnExit.setLabel("Exit");
    btnExit.setBounds(new Rectangle(232, 444, 97, 27));
    btnExit.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        btnExit_actionPerformed(e);
      }
    });
    this.setLayout(null);
    label1.setText("Select Example");
    label1.setBounds(new Rectangle(17, 41, 107, 17));
    btnSave.setLabel("Save GIF");
    btnSave.setBounds(new Rectangle(18, 444, 95, 27));
    btnSave.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        btnSave_actionPerformed(e);
      }
    });
    this.setTitle("RSS and EAN-UCC Barcodes");
    this.setMenuBar(menuBar1);
    comboExample.setBounds(new Rectangle(135, 40, 476, 21));
    comboExample.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        comboExample_itemStateChanged(e);
      }
    });
    panel1.setLayout(null);
    panel1.setBounds(new Rectangle(16, 76, 597, 310));
    lblDescription.setFont(new java.awt.Font("Dialog", 0, 10));
    lblDescription.setBounds(new Rectangle(15, 412, 609, 24));
    btnSave1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        btnSave1_actionPerformed(e);
      }
    });
    btnSave1.setBounds(new Rectangle(124, 444, 95, 27));
    btnSave1.setActionCommand("Save JPG");
    btnSave1.setLabel("Save JPG");
    this.add(panel1, null);
    this.add(btnSave, null);
    this.add(comboExample, null);
    this.add(label1, null);
    this.add(btnExit, null);
    this.add(lblDescription, null);
    this.add(btnSave1, null);
  }

  void btnExit_actionPerformed(ActionEvent e) {
        System.exit(0);
  }

  void comboExample_itemStateChanged(ItemEvent e) {
      if (comboExample.getSelectedIndex()>=0) setBarcodeComponent(comboExample.getSelectedIndex());
  }

  void btnSave_actionPerformed(ActionEvent e) {
        ImageEncoder encoder=new ImageEncoder(this.bc,"GIF","barcode.gif");
        if (encoder.result) this.lblDescription.setText("*** The file barcode.gif has been created ***");
        else this.lblDescription.setText("ERROR: could not export to GIF, did you install the GIF encoder?");
  }

  private void setBarcodeComponent(int index) {

  panel1.removeAll();

    switch (index) {
    case 0:
      this.bc=new BarCode();
      this.bc.setSymbology(BarCode.UPCE);
      this.bc.setCode("012000001239");
      this.lblDescription.setText("UPCE barcode encodes 012000001239");
      break;
    case 1:
      this.bc=new BarCode();
      this.bc.setSymbology(BarCode.UPCE);
      this.bc.setCode("012000001239");
      this.bc.setSecondaryCode("15021231");
      this.lblDescription.setText("UPCE barcode encodes 012000001239 and 2D Component encodes 15021231");
      break;
    case 2:
      this.bc=new BarCode();
      this.bc.setSymbology(BarCode.EAN8);
      this.bc.setCode("12345670");
      this.lblDescription.setText("EAN8 barcode encodes 12345670");
      break;
    case 3:
      this.bc=new BarCode();
      this.bc.setSymbology(BarCode.EAN8);
      this.bc.setCode("12345670");
      this.bc.setSecondaryCode("21A12345678");
      this.lblDescription.setText("EAN8 barcode encodes 12345670 and 2D Component encodes 21A12345678");
      break;
    case 4:
      this.bc=new BarCode();
      this.bc.setSymbology(BarCode.EAN13);
      this.bc.setCode("3312345678903");
      this.lblDescription.setText("EAN13 barcode encodes 3312345678903");
      break;
    case 5:
      this.bc=new BarCode();
      this.bc.setSymbology(BarCode.EAN13);
      this.bc.setCode("3312345678903");
      this.bc.setSecondaryCode("991234-abcd");
      this.lblDescription.setText("EAN13 barcode encodes 3312345678903 and 2D Component encodes 991234-abcd");
      break;
    case 6:
      this.bc=new BarCode();
      this.bc.setSymbology(BarCode.UPCA);
      this.bc.setCode("31234567890");
      this.lblDescription.setText("UPCA barcode encodes 31234567890");
      break;
    case 7:
      this.bc=new BarCode();
      this.bc.setSymbology(BarCode.UPCA);
      this.bc.setCode("31234567890");
      this.bc.setSecondaryCode("991234-abcd");
      this.lblDescription.setText("UPCA barcode encodes 31234567890 and 2D Component encodes 991234-abcd");
      break;
    case 8:
      this.bc=new BarCode();
      this.bc.setSymbology(BarCode.EAN128);
      this.bc.setCode("0103212345678906");
      this.bc.setHumanReadableCode("(01)03212345678906");
      this.lblDescription.setText("EAN128 barcode encodes 0103212345678906");
      break;
    case 9:
      this.bc=new BarCode();
      this.bc.setSymbology(BarCode.EAN128);
      this.bc.setCode("0193812345678901");
      this.bc.setHumanReadableCode("(01)93812345678901");
      this.bc.setSecondaryCode("10ABCD123456#4103898765432108");
      this.lblDescription.setText("EAN128 barcode encodes 0193812345678901 and 2D Component encodes 10ABCD123456#4103898765432108");
      break;
    case 10:
      this.bc=new RSS();
      ((RSS) this.bc).setRSSFormat(RSS.FORMAT_REGULAR);
      this.bc.setCode("0361234567890");
      this.lblDescription.setText("RSS14 barcode encodes 0361234567890");
      break;
    case 11:
      this.bc=new RSS();
      ((RSS) this.bc).setRSSFormat(RSS.FORMAT_STACKED);
      this.bc.setCode("0341234567890");
      this.lblDescription.setText("RSS14 stacked barcode encodes 0341234567890");
      break;
    case 12:
      this.bc=new RSS();
      ((RSS) this.bc).setRSSFormat(RSS.FORMAT_TRUNCATED);
      this.bc.setCode("0341234567890");
      this.lblDescription.setText("RSS14 truncated barcode encodes 0341234567890");
      break;

    case 13:
      this.bc=new RSS();
      ((RSS) this.bc).setRSSFormat(RSS.FORMAT_STACKED_OMNIDIRECTIONAL);
      this.bc.setCode("2001234567890");
      this.lblDescription.setText("RSS14 stacked omnidirectional barcode encodes 2001234567890");
      break;

    case 14:
      this.bc=new RSS();
      ((RSS) this.bc).setRSSFormat(RSS.FORMAT_STACKED);
      this.bc.setCode("0341234567890");
      this.bc.setSecondaryCode("17010200");
      this.lblDescription.setText("RSS14 stacked barcode encodes 0341234567890  and 2D Component encodes 17010200");
      break;

    case 15:
      this.bc=new RSSLimited();
      this.bc.setCode("0031234567890");
      this.lblDescription.setText("RSS limited barcode encodes 0031234567890");
      break;

    case 16:
      this.bc=new RSSLimited();
      this.bc.setCode("1311234567890");
      this.bc.setSecondaryCode("1701061510A123456");
      this.lblDescription.setText("RSS limited  barcode encodes 1311234567890  and 2D Component encodes 1701061510A123456");
      break;

    case 17:
      this.bc=new RSSExpanded();
      ((RSS) this.bc).setRSSFormat(RSS.FORMAT_EXPANDED);
      this.bc.setCode("01937123456789043103001234");
      this.lblDescription.setText("RSS14 expanded barcode encodes 01937123456789043103001234");
      break;

    case 18:
      this.bc=new RSSExpanded();
      ((RSS) this.bc).setRSSFormat(RSS.FORMAT_EXPANDED_STACKED);
      this.bc.setCode("010001234567890510ABCDEF");
      this.lblDescription.setText("RSS14 expanded stacked barcode encodes 010001234567890510ABCDEF");
      break;

    case 19:
      this.bc=new RSSExpanded();
      ((RSS) this.bc).setRSSFormat(RSS.FORMAT_EXPANDED);
      this.bc.setCode("01937123456789043103001234");
      this.bc.setSecondaryCode("911A2B3C4D5E");
      this.lblDescription.setText("RSS14 expanded barcode encodes 01937123456789043103001234  and 2D Component encodes 911A2B3C4D5E");
      break;

    case 20:
      this.bc=new RSSExpanded();
      ((RSS) this.bc).setRSSFormat(RSS.FORMAT_EXPANDED_STACKED);
      this.bc.setCode("010001234567890510ABCDEF");
      this.bc.setSecondaryCode("2112345678");
      this.lblDescription.setText("RSS14 expanded stacked barcode encodes 010001234567890510ABCDEF  and 2D Component encodes 2112345678");
      break;
   } // switch

    this.bc.setLeftMargin(20);
    this.bc.setTopMargin(20);
    panel1.add(this.bc);
    this.bc.setBounds(10,10,400,400);



  }
  void btnSave1_actionPerformed(ActionEvent e) {
     ImageEncoder encoder=new ImageEncoder(this.bc,"JPG","barcode.jpg");
        if (encoder.result) this.lblDescription.setText("*** The file barcode.jpg has been created ***");
        else this.lblDescription.setText("ERROR: could not export to JPG. Are you using Java 1.2 or later?");
  }

}
