/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rss.cc;

import com.java4less.rss.BarCode;
import com.java4less.rss.RSSUtil;
import com.java4less.rss.cc.CC;
import com.java4less.rss.cc.CC_B;

public class CC_A
extends CC {
    private static final int BIT_LEN = 197;
    private static final int MAX_BYTES = 148;
    private static final int CONF_COLUMNS = 0;
    private static final int CONF_ROWS = 1;
    private static final int CONF_CODEWORDS = 2;
    private static final int CONF_EC = 3;
    public static int FORMAT_2X5;
    public static int FORMAT_2X6;
    public static int FORMAT_2X7;
    public static int FORMAT_2X8;
    public static int FORMAT_2X9;
    public static int FORMAT_2X10;
    public static int FORMAT_2X12;
    public static int FORMAT_3X4;
    public static int FORMAT_3X5;
    public static int FORMAT_3X6;
    public static int FORMAT_3X7;
    public static int FORMAT_3X8;
    public static int FORMAT_4X3;
    public static int FORMAT_4X4;
    public static int FORMAT_4X5;
    public static int FORMAT_4X6;
    public static int FORMAT_4X7;
    public static int[] dataCw4;
    public static int[] eccCw4;
    public static int[] configurations4;
    public static int[] dataCw3;
    public static int[] eccCw3;
    public static int[] configurations3;
    public static int[] dataCw2;
    public static int[] eccCw2;
    public static int[] configurations2;
    public int[] CCSizes = null;
    public int[] dataCw;
    public int[] eccCw;
    public int[] cwConfigurations;
    protected int selectedConfiguration = -1;
    int[][] patterns = new int[][]{{1, 2, 2, 1, 3, 1, 1, 1, 1, 2, 2, 3, 1}, {2, 3, 1, 1, 3, 1, 1, 1, 2, 1, 2, 3, 1}, {3, 3, 1, 2, 2, 1, 1, 1, 2, 2, 1, 3, 1}, {4, 2, 2, 2, 2, 1, 1, 1, 3, 1, 1, 3, 1}, {5, 2, 1, 3, 2, 1, 1, 1, 3, 1, 2, 2, 1}, {6, 2, 1, 4, 1, 1, 1, 1, 3, 2, 1, 2, 1}, {7, 2, 2, 3, 1, 1, 1, 1, 4, 1, 1, 2, 1}, {8, 3, 1, 3, 1, 1, 1, 1, 4, 1, 2, 1, 1}, {9, 3, 2, 2, 1, 1, 1, 1, 4, 2, 1, 1, 1}, {10, 4, 1, 2, 1, 1, 1, 1, 3, 3, 1, 1, 1}, {11, 4, 2, 1, 1, 1, 1, 1, 3, 2, 2, 1, 1}, {12, 3, 3, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1}, {13, 2, 4, 1, 1, 1, 1, 1, 2, 2, 3, 1, 1}, {14, 2, 3, 2, 1, 1, 1, 1, 2, 3, 2, 1, 1}, {15, 2, 3, 1, 2, 1, 1, 1, 2, 4, 1, 1, 1}, {16, 3, 2, 1, 2, 1, 1, 1, 1, 5, 1, 1, 1}, {17, 4, 1, 1, 2, 1, 1, 1, 1, 4, 2, 1, 1}, {18, 4, 1, 1, 1, 2, 1, 1, 1, 4, 1, 2, 1}, {19, 4, 1, 1, 1, 1, 2, 1, 2, 3, 1, 2, 1}, {20, 3, 2, 1, 1, 1, 2, 1, 2, 3, 1, 1, 2}, {21, 3, 1, 2, 1, 1, 2, 1, 2, 2, 2, 1, 2}, {22, 3, 1, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1}, {23, 3, 1, 1, 2, 2, 1, 1, 2, 1, 3, 2, 1}, {24, 3, 1, 1, 1, 3, 1, 1, 2, 1, 4, 1, 1}, {25, 3, 1, 1, 1, 2, 2, 1, 1, 2, 4, 1, 1}, {26, 3, 1, 1, 1, 1, 3, 1, 1, 3, 3, 1, 1}, {27, 2, 2, 1, 1, 1, 3, 1, 1, 3, 2, 2, 1}, {28, 2, 2, 1, 1, 2, 2, 1, 1, 3, 2, 1, 2}, {29, 2, 2, 1, 1, 3, 1, 1, 1, 3, 1, 2, 2}, {30, 2, 2, 1, 2, 2, 1, 1, 2, 2, 1, 2, 2}, {31, 2, 2, 2, 1, 2, 1, 1, 3, 1, 1, 2, 2}, {32, 3, 1, 2, 1, 2, 1, 1, 3, 1, 1, 1, 3}, {33, 3, 2, 1, 1, 2, 1, 1, 2, 2, 1, 1, 3}, {34, 2, 3, 1, 1, 2, 1, 1, 1, 3, 1, 1, 3}, {35, 2, 3, 1, 1, 1, 2, 1, 1, 2, 2, 1, 3}, {36, 2, 2, 2, 1, 1, 2, 1, 1, 2, 2, 2, 2}, {37, 2, 1, 3, 1, 1, 2, 1, 1, 2, 3, 1, 2}, {38, 2, 1, 2, 2, 1, 2, 1, 1, 2, 3, 2, 1}, {39, 2, 1, 2, 2, 2, 1, 1, 1, 1, 4, 2, 1}, {40, 2, 1, 2, 1, 3, 1, 1, 1, 1, 3, 3, 1}, {41, 2, 1, 2, 1, 2, 2, 1, 1, 1, 3, 2, 2}, {42, 2, 1, 2, 1, 1, 3, 1, 1, 1, 2, 3, 2}, {43, 2, 1, 1, 2, 1, 3, 1, 1, 1, 2, 2, 3}, {44, 2, 1, 1, 1, 2, 3, 1, 1, 1, 1, 3, 3}, {45, 2, 1, 1, 1, 3, 2, 1, 1, 1, 1, 2, 4}, {46, 2, 1, 1, 1, 4, 1, 1, 1, 1, 2, 1, 4}, {47, 2, 1, 1, 2, 3, 1, 1, 1, 2, 1, 1, 4}, {48, 2, 1, 1, 2, 2, 2, 1, 2, 1, 1, 1, 4}, {49, 2, 1, 1, 3, 1, 2, 1, 2, 1, 1, 2, 3}, {50, 2, 1, 1, 3, 2, 1, 1, 2, 1, 1, 3, 2}, {51, 2, 1, 1, 4, 1, 1, 1, 1, 2, 1, 3, 2}, {52, 2, 1, 2, 3, 1, 1, 1, 1, 2, 1, 4, 1}};
    int[][] startingPatternNumbers = new int[][]{{2, 5, 39, 0, 19}, {2, 6, 1, 0, 33}, {2, 7, 32, 0, 12}, {2, 8, 8, 0, 40}, {2, 9, 14, 0, 46}, {2, 10, 43, 0, 23}, {2, 12, 20, 0, 52}, {3, 4, 11, 43, 23}, {3, 5, 1, 33, 13}, {3, 6, 5, 37, 17}, {3, 7, 15, 47, 27}, {3, 8, 21, 1, 33}, {4, 3, 40, 20, 52}, {4, 4, 43, 23, 3}, {4, 5, 46, 26, 6}, {4, 6, 34, 14, 46}, {4, 7, 29, 9, 41}};
    int[][] configurations = new int[][]{{2, 5, 10, 4}, {2, 6, 12, 4}, {2, 7, 14, 5}, {2, 8, 16, 5}, {2, 9, 18, 6}, {2, 10, 20, 6}, {2, 12, 24, 7}, {3, 4, 12, 4}, {3, 5, 15, 5}, {3, 6, 18, 6}, {3, 7, 21, 7}, {3, 8, 24, 7}, {4, 3, 12, 4}, {4, 4, 16, 5}, {4, 5, 20, 6}, {4, 6, 24, 7}, {4, 7, 28, 8}};
    private int[][] pwr928 = new int[69][7];

    public int[][] paintPDF417() {
        int mapWidth = 0;
        if (this.PDFColumns == 2) {
            this.eccCw = eccCw2;
            this.dataCw = dataCw2;
            this.CCSizes = RSSUtil.CC2Sizes;
            this.cwConfigurations = configurations2;
            mapWidth = 55;
        }
        if (this.PDFColumns == 3) {
            this.eccCw = eccCw3;
            this.dataCw = dataCw3;
            this.CCSizes = RSSUtil.CC3Sizes;
            this.cwConfigurations = configurations3;
            mapWidth = 72;
        }
        if (this.PDFColumns == 4) {
            this.eccCw = eccCw4;
            this.dataCw = dataCw4;
            this.CCSizes = RSSUtil.CC4Sizes;
            this.cwConfigurations = configurations4;
            mapWidth = 99;
        }
        this.currentY = 0;
        this.currentX = 0;
        int[] cwords = null;
        RSSUtil rssUtil = new RSSUtil();
        byte[] b = new byte[148];
        cwords = new int[176];
        rssUtil.CCSizes = this.CCSizes;
        int symbolSizeIndex = rssUtil.pack(this.code, b, 0);
        boolean useCCB = false;
        if (this.PDFColumns == 2 && symbolSizeIndex > RSSUtil.MAX_CCA2_SIZE) {
            useCCB = true;
        }
        if (this.PDFColumns == 3 && symbolSizeIndex > RSSUtil.MAX_CCA3_SIZE) {
            useCCB = true;
        }
        if (this.PDFColumns == 4 && symbolSizeIndex > RSSUtil.MAX_CCA4_SIZE) {
            useCCB = true;
        }
        if (useCCB) {
            CC_B ccb = new CC_B();
            ccb.PDFColumns = this.PDFColumns;
            ccb.setCode(this.code);
            return ccb.paintPDF417();
        }
        this.selectedConfiguration = this.cwConfigurations[symbolSizeIndex];
        this.init928();
        int result = this.encode928(b, cwords, this.CCSizes[symbolSizeIndex]);
        this.ReedSolomon(cwords, this.dataCw[symbolSizeIndex], this.eccCw[symbolSizeIndex]);
        if (cwords == null) {
            return null;
        }
        int inp = 0;
        this.PDFRows = this.configurations[this.selectedConfiguration][1];
        int leftPattern = 0;
        int centerPattern = 0;
        int rightPattern = 0;
        for (int i = 0; i < this.startingPatternNumbers.length; ++i) {
            if (this.startingPatternNumbers[i][0] != this.PDFColumns || this.startingPatternNumbers[i][1] != this.PDFRows) continue;
            leftPattern = this.startingPatternNumbers[i][2];
            centerPattern = this.startingPatternNumbers[i][3];
            rightPattern = this.startingPatternNumbers[i][4];
        }
        int[][] map = BarCode.createBarMap(mapWidth, this.PDFRows, BarCode.EMPTY);
        for (int row = 0; row < this.PDFRows; ++row) {
            int h;
            this.currentX = 0;
            int v = this.PDFColumns - 1;
            int w = row % 3;
            int x = row / 3;
            int y = (this.PDFRows - 1) / 3;
            String left = "";
            if (this.PDFColumns != 3) {
                for (int h2 = 0; h2 < 6; ++h2) {
                    left = String.valueOf(String.valueOf(left)).concat(String.valueOf(String.valueOf(this.patterns[leftPattern - 1][1 + h2])));
                }
                this.currentX += this.paintCharWithHeight(map, "bwbwbw", left, this.currentX, this.currentY);
            }
            for (int i = 1; i <= this.PDFColumns; ++i) {
                if (this.PDFColumns == 3 && i == 2 || this.PDFColumns == 4 && i == 3) {
                    String center = "";
                    for (h = 0; h < 6; ++h) {
                        center = String.valueOf(String.valueOf(center)).concat(String.valueOf(String.valueOf(this.patterns[centerPattern - 1][7 + h])));
                    }
                    this.currentX += this.paintCharWithHeight(map, "bwbwbw", center, this.currentX, this.currentY);
                }
                int K = (leftPattern - 1) % 3 * 3;
                this.currentX += this.paintCharWithHeight(map, "bwbwbwbw", this.toXSecuence(this.PDF417_BITS[K / 3][cwords[inp++]]), this.currentX, this.currentY);
            }
            String right = "";
            for (h = 0; h < 6; ++h) {
                right = String.valueOf(String.valueOf(right)).concat(String.valueOf(String.valueOf(this.patterns[rightPattern - 1][1 + h])));
            }
            this.currentX += this.paintCharWithHeight(map, "bwbwbw", right, this.currentX, this.currentY);
            this.currentX += this.paintCharWithHeight(map, "b", "1", this.currentX, this.currentY);
            ++this.currentY;
            if (++leftPattern == 53) {
                leftPattern = 1;
            }
            if (++centerPattern == 53) {
                centerPattern = 1;
            }
            if (++rightPattern != 53) continue;
            rightPattern = 1;
        }
        BarCode.printBarMap(map, this.currentY);
        return map;
    }

    public long min(long a, long b) {
        if (a > b) {
            return b;
        }
        return a;
    }

    public void putBits(int[] bitStr, int bitPos, int length, int bits) {
        if (bitPos > 1600 || length > 16) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("\nerror ").append(bitPos).append(", ").append(length).append("\n"))));
            return;
        }
        for (int i = length - 1; i >= 0; --i) {
            if ((bits & 1) != 0) {
                int n = (bitPos + i) / 16;
                bitStr[n] = bitStr[n] | 32768 >> (bitPos + i) % 16;
            } else {
                int n = (bitPos + i) / 16;
                bitStr[n] = bitStr[n] & ~(32768 >> (bitPos + i) % 16);
            }
            bits >>= 1;
        }
    }

    protected void ReedSolomon(int[] sym, int len, int ECCLen) {
        int j;
        int[] c = new int[512];
        int gf = 929;
        int[] log = new int[gf];
        int[] alog = new int[gf];
        for (j = 0; j < 929; ++j) {
            log[j] = 0;
        }
        int i = 1;
        j = 0;
        while (j < 928) {
            alog[j] = i;
            log[i] = j++;
            i = i * 3 % 929;
        }
        c[0] = 1;
        for (i = 1; i < ECCLen + 1; ++i) {
            c[i] = 0;
        }
        for (i = 0; i < ECCLen; ++i) {
            for (j = i; j >= 0; --j) {
                c[j + 1] = (c[j] + this.mult(c[j + 1], alog[i + 1], log, alog, gf)) % gf;
            }
            c[0] = this.mult(c[0], alog[i + 1], log, alog, gf);
        }
        for (i = ECCLen - 1; i >= 0; i -= 2) {
            c[i] = (gf - c[i]) % gf;
        }
        for (i = len; i < len + ECCLen; ++i) {
            sym[i] = 0;
        }
        for (int n = 0; n < len; ++n) {
            int t = (sym[len] + sym[n]) % gf;
            for (i = 0; i < ECCLen - 1; ++i) {
                sym[len + i] = (sym[len + i + 1] + gf - this.mult(t, c[ECCLen - 1 - i], log, alog, gf)) % gf;
            }
            sym[len + ECCLen - 1] = (gf - this.mult(t, c[0], log, alog, gf)) % gf;
        }
        for (i = len; i < len + ECCLen; ++i) {
            sym[i] = (gf - sym[i]) % gf;
        }
    }

    protected int findChar(String[][] table, String c) {
        for (int i = 0; i < table.length; ++i) {
            if (c.compareTo(table[i][0]) != 0) continue;
            return i;
        }
        return -1;
    }

    int getBit(byte[] bitStr, int bitPos) {
        return (bitStr[bitPos / 8] & 128 >> bitPos % 8) == 0 ? 0 : 1;
    }

    int encode928(byte[] bitString, int[] codeWords, int bitLng) {
        int b = 0;
        int cwLng = 0;
        int cwNdx = 0;
        while (b < bitLng) {
            int i;
            int bitCnt = (int)this.min(bitLng - b, 69L);
            int cwCnt = bitCnt / 10 + 1;
            cwLng += cwCnt;
            for (i = 0; i < cwCnt; ++i) {
                codeWords[cwNdx + i] = 0;
            }
            for (i = 0; i < bitCnt; ++i) {
                if (this.getBit(bitString, b + bitCnt - i - 1) != 1) continue;
                for (int j = 0; j < cwCnt; ++j) {
                    int n = cwNdx + j;
                    codeWords[n] = codeWords[n] + this.pwr928[i][j + 7 - cwCnt];
                }
            }
            for (i = cwCnt - 1; i > 0; --i) {
                int n = cwNdx + i - 1;
                codeWords[n] = (int)((long)codeWords[n] + (long)codeWords[cwNdx + i] / 928L);
                int n2 = cwNdx + i;
                codeWords[n2] = (int)((long)codeWords[n2] % 928L);
            }
            b += 69;
            cwNdx += 7;
        }
        return cwLng;
    }

    int decode928(byte[] bitString, int[] codeWords, int cwLng) {
        long[] vals = new long[5];
        int b = 0;
        int bitLng = 0;
        for (int cwNdx = 0; cwNdx < cwLng; cwNdx += 7) {
            int j;
            int i;
            int cwCnt = (int)this.min(cwLng - cwNdx, 7L);
            int bitCnt = cwCnt * 10 - 1;
            bitLng += bitCnt;
            vals[4] = codeWords[cwNdx];
            for (i = 3; i >= 0; --i) {
                vals[i] = 0L;
            }
            for (i = 1; i < cwCnt; ++i) {
                j = 4;
                while (j > 0) {
                    int n = j--;
                    vals[n] = vals[n] * (long)928;
                }
                vals[4] = vals[4] + (long)codeWords[cwNdx + i];
                j = 4;
                while (j > 0) {
                    int n = j - 1;
                    vals[n] = vals[n] + (vals[j] >> 16);
                    int n2 = j--;
                    vals[n2] = vals[n2] & (long)65535;
                }
            }
            RSSUtil rssUtil = new RSSUtil();
            j = 4;
            for (i = bitCnt; i >= 0; i -= 16) {
                int k = (int)this.min(i, 16L);
                rssUtil.putBits(bitString, b + i - k, k, (int)vals[j], -1);
                --j;
            }
            b += 69;
        }
        return bitLng;
    }

    private int mult(int x, int y, int[] log, int[] alog, int gf) {
        if (x == 0 || y == 0) {
            return 0;
        }
        int r = alog[(log[x] + log[y]) % (gf - 1)];
        return r;
    }

    private void init928() {
        int i;
        int[] cw = new int[7];
        cw[6] = 1;
        for (i = 5; i >= 0; --i) {
            cw[i] = 0;
        }
        for (i = 0; i < 7; ++i) {
            this.pwr928[0][i] = cw[i];
        }
        for (int j = 1; j < 69; ++j) {
            int v = 0;
            for (i = 6; i >= 1; --i) {
                v = 2 * cw[i] + v / 928;
                this.pwr928[j][i] = cw[i] = v % 928;
            }
            this.pwr928[j][0] = cw[0] = 2 * cw[0] + v / 928;
        }
    }

    static {
        BIT_LEN = 197;
        MAX_BYTES = 148;
        CONF_COLUMNS = 0;
        CONF_ROWS = 1;
        CONF_CODEWORDS = 2;
        CONF_EC = 3;
        FORMAT_2X5 = 0;
        FORMAT_2X6 = 1;
        FORMAT_2X7 = 2;
        FORMAT_2X8 = 3;
        FORMAT_2X9 = 4;
        FORMAT_2X10 = 5;
        FORMAT_2X12 = 6;
        FORMAT_3X4 = 7;
        FORMAT_3X5 = 8;
        FORMAT_3X6 = 9;
        FORMAT_3X7 = 10;
        FORMAT_3X8 = 11;
        FORMAT_4X3 = 12;
        FORMAT_4X4 = 13;
        FORMAT_4X5 = 14;
        FORMAT_4X6 = 15;
        FORMAT_4X7 = 16;
        dataCw4 = new int[]{8, 11, 14, 17, 20};
        eccCw4 = new int[]{4, 5, 6, 7, 8};
        configurations4 = new int[]{FORMAT_4X3, FORMAT_4X4, FORMAT_4X5, FORMAT_4X6, FORMAT_4X7};
        dataCw3 = new int[]{8, 10, 12, 14, 17};
        eccCw3 = new int[]{4, 5, 6, 7, 7};
        configurations3 = new int[]{FORMAT_3X4, FORMAT_3X5, FORMAT_3X6, FORMAT_3X7, FORMAT_3X8};
        dataCw2 = new int[]{6, 8, 9, 11, 12, 14, 17};
        eccCw2 = new int[]{4, 4, 5, 5, 6, 6, 7};
        configurations2 = new int[]{FORMAT_2X5, FORMAT_2X6, FORMAT_2X7, FORMAT_2X8, FORMAT_2X9, FORMAT_2X10, FORMAT_2X12};
    }
}

