/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rss;

import com.java4less.rss.BarCode;
import com.java4less.rss.CC_A;
import java.awt.Graphics;
import java.math.BigInteger;

public class RSS
extends BarCode {
    public static int FORMAT_REGULAR = 0;
    public static int FORMAT_TRUNCATED = 1;
    public static int FORMAT_STACKED = 2;
    public static int FORMAT_STACKED_OMNIDIRECTIONAL = 3;
    public static int FORMAT_LIMITED = 4;
    public static int FORMAT_EXPANDED = 5;
    public static int FORMAT_EXPANDED_STACKED = 6;
    private static int[][] _$78264 = new int[][]{{10, 7, 5, 2, 4, 335, 0}, {8, 5, 7, 4, 20, 1035, 336}, {6, 3, 9, 6, 48, 1515, 1036}, {4, 1, 11, 8, 81, 1596, 1516}};
    private static int[][] _$78280 = new int[][]{{12, 8, 4, 1, 1, 160, 0}, {10, 6, 6, 3, 10, 960, 161}, {8, 4, 8, 5, 34, 2014, 961}, {6, 3, 10, 6, 70, 2714, 2015}, {4, 1, 12, 8, 126, 2840, 2715}};
    private static int[] _$78297 = new int[]{3, 8, 2, 3, 5, 5, 3, 3, 7, 3, 1, 9, 2, 7, 4, 2, 5, 6, 2, 3, 8, 1, 5, 7, 1, 3, 9};
    private static int[] _$78070 = new int[]{1, 3, 9, 27, 2, 6, 18, 54, 4, 12, 36, 29, 8, 24, 72, 58};
    private static int[] _$78081 = new int[]{16, 48, 65, 37, 32, 17, 51, 74, 64, 34, 23, 69, 49, 68, 46, 59};
    protected int leftChecksum = 0;
    protected int rightChecksum = 0;
    protected boolean linkFlag = false;
    protected int format = FORMAT_REGULAR;
    private final int _$78341 = 6;
    private final int _$78351 = 5;
    private final int _$78362 = 4;
    private final int _$78373 = 4;
    private final int _$78383 = 9;
    private final int _$75942 = 79;
    private boolean _$78396 = false;

    public RSS() {
        this.barType = 6;
    }

    public int getRSSFormat() {
        return this.format;
    }

    public void setRSSFormat(int f) {
        this.format = f;
    }

    protected void paintStackedBarcode(Graphics g, int[] pattern) throws Exception {
        int i;
        int x = 0;
        int y = 0;
        int[][] map = null;
        int[] rowHeights = null;
        if (this.format == FORMAT_STACKED) {
            map = BarCode.createBarMap(50, 3, 0);
            rowHeights = new int[]{5 * this.X, this.X, 7 * this.X};
        } else {
            map = BarCode.createBarMap(50, 5, 0);
            rowHeights = new int[]{this.barHeight, this.X, this.X, this.X, this.barHeight};
        }
        x += BarCode.addBarMap(map, x, y, 1, false);
        x += BarCode.addBarMap(map, x, y, 1, true);
        boolean bWhite = true;
        for (i = 0; i < pattern.length / 2; ++i) {
            x += BarCode.addBarMap(map, x, y, pattern[i], !bWhite);
            bWhite = !bWhite;
        }
        x += BarCode.addBarMap(map, x, y, 1, true);
        x += BarCode.addBarMap(map, x, y, 1, false);
        y = this.format == FORMAT_STACKED ? 2 : 4;
        x = 0;
        x += BarCode.addBarMap(map, x, y, 1, true);
        x += BarCode.addBarMap(map, x, y, 1, false);
        for (i = pattern.length / 2; i < pattern.length; ++i) {
            x += BarCode.addBarMap(map, x, y, pattern[i], !bWhite);
            bWhite = !bWhite;
        }
        x += BarCode.addBarMap(map, x, y, 1, false);
        x += BarCode.addBarMap(map, x, y, 1, true);
        if (this.format == FORMAT_STACKED) {
            this._$78413(map);
        } else {
            this._$78434(map);
        }
        int[] separator2D = new int[map[0].length];
        this._$78470(map[0], separator2D);
        if (this.format == FORMAT_STACKED) {
            this.renderRSS(g, map, separator2D, true, false, 2);
        } else {
            this.renderRSS(g, map, separator2D, true, false, 3);
        }
    }

    protected void paintNonStackedBarcode(Graphics g, int[] pattern) throws Exception {
        int[][] map = BarCode.createBarMap(96, 1, BarCode.EMPTY);
        int x = 0;
        if (this.format == FORMAT_TRUNCATED) {
            this.barHeight = this.X * 13;
        }
        x += BarCode.addBarMap(map, x, 0, 1, false);
        x += BarCode.addBarMap(map, x, 0, 1, true);
        boolean bWhite = true;
        for (int i = 0; i < pattern.length; ++i) {
            x += BarCode.addBarMap(map, x, 0, pattern[i], !bWhite);
            bWhite = !bWhite;
        }
        x += BarCode.addBarMap(map, x, 0, 1, false);
        x += BarCode.addBarMap(map, x, 0, 1, true);
        int[] separator2D = new int[map[0].length];
        this._$78489(map[0], separator2D);
        this.renderRSS(g, map, separator2D, false, false, 4);
    }

    protected void paintBarcode(Graphics g) throws Exception {
        super.paintBarcode(g);
        if (this.barType != 6) {
            return;
        }
        if (this.format != FORMAT_REGULAR && this.format != FORMAT_STACKED_OMNIDIRECTIONAL && this.format != FORMAT_TRUNCATED && this.format != FORMAT_STACKED) {
            this.format = FORMAT_REGULAR;
        }
        this.linkFlag = this.secondaryCode.length() > 0;
        this.currentX = this.leftMargin;
        this.currentY = this.topMargin;
        if (this.barHeight < this.X * 33) {
            this.barHeight = this.X * 33;
        }
        int[] pattern = this.createRSS14Pattern(this.code);
        if (this.format == FORMAT_REGULAR || this.format == FORMAT_TRUNCATED) {
            this.paintNonStackedBarcode(g, pattern);
        } else {
            this.paintStackedBarcode(g, pattern);
        }
    }

    protected int[] createRSS14Pattern(String dataStr) {
        int i;
        int i2;
        int group;
        BigInteger dataBig = new BigInteger(dataStr, 10);
        boolean composite = this.linkFlag;
        int[] output = new int[42];
        int checksum = 0;
        if (composite) {
            dataBig = dataBig.add(new BigInteger("10000000000000", 10));
        }
        if (this._$78396) {
            System.out.println("Data is ".concat(String.valueOf(String.valueOf(dataBig.toString(10)))));
        }
        output[11] = 1;
        output[12] = 1;
        output[29] = 1;
        output[30] = 1;
        long VLpair = (long)Math.floor(dataBig.divide(new BigInteger("4537077", 10)).longValue());
        long VRpair = dataBig.mod(new BigInteger("4537077", 10)).longValue();
        long CLOutside = (long)Math.floor(VLpair / (long)1597);
        long CLInside = VLpair % (long)1597;
        for (group = 0; CLOutside > (long)_$78280[group][5] && group < 4; ++group) {
        }
        int eleN = _$78280[group][0];
        int eleMax = _$78280[group][1];
        long Vodd = (long)Math.floor((CLOutside - (long)_$78280[group][6]) / (long)_$78280[group][4]);
        long Veven = (CLOutside - (long)_$78280[group][6]) % (long)_$78280[group][4];
        if (this._$78396) {
            System.out.println("Value 1 is  ".concat(String.valueOf(String.valueOf(Vodd))));
        }
        int[] widths = this.getRSSwidths((int)Vodd, eleN, 4, eleMax, 1);
        checksum = 0;
        for (i2 = 0; i2 < 4; ++i2) {
            if (this._$78396) {
                System.out.println("width is ".concat(String.valueOf(String.valueOf(widths[i2]))));
            }
            output[i2 * 2] = widths[i2];
            checksum += _$78070[i2 * 2] * widths[i2];
            checksum %= 79;
        }
        eleN = _$78280[group][2];
        eleMax = _$78280[group][3];
        if (this._$78396) {
            System.out.println("Value 2 is  ".concat(String.valueOf(String.valueOf(Veven))));
        }
        widths = this.getRSSwidths((int)Veven, eleN, 4, eleMax, 0);
        for (i2 = 0; i2 < 4; ++i2) {
            if (this._$78396) {
                System.out.println("width is ".concat(String.valueOf(String.valueOf(widths[i2]))));
            }
            output[1 + i2 * 2] = widths[i2];
            checksum += _$78070[i2 * 2 + 1] * widths[i2];
            checksum %= 79;
        }
        for (group = 0; CLInside > (long)_$78264[group][5] && group < 3; ++group) {
        }
        eleN = _$78264[group][0];
        eleMax = _$78264[group][1];
        Vodd = (long)Math.floor((CLInside - (long)_$78264[group][6]) / (long)_$78264[group][4]);
        Veven = (CLInside - (long)_$78264[group][6]) % (long)_$78264[group][4];
        if (this._$78396) {
            System.out.println("Value 3 is  ".concat(String.valueOf(String.valueOf(Vodd))));
        }
        widths = this.getRSSwidths((int)Vodd, eleN, 4, eleMax, 1);
        for (i2 = 0; i2 < 4; ++i2) {
            if (this._$78396) {
                System.out.println("width is ".concat(String.valueOf(String.valueOf(widths[i2]))));
            }
            output[19 - i2 * 2] = widths[i2];
            checksum += _$78070[i2 * 2 + 1 + 8] * widths[i2];
            checksum %= 79;
        }
        eleN = _$78264[group][2];
        eleMax = _$78264[group][3];
        if (this._$78396) {
            System.out.println("Value 4 is  ".concat(String.valueOf(String.valueOf(Veven))));
        }
        widths = this.getRSSwidths((int)Veven, eleN, 4, eleMax, 0);
        for (i2 = 0; i2 < 4; ++i2) {
            if (this._$78396) {
                System.out.println("width is ".concat(String.valueOf(String.valueOf(widths[i2]))));
            }
            output[20 - i2 * 2] = widths[i2];
            checksum += _$78070[i2 * 2 + 8] * widths[i2];
            checksum %= 79;
        }
        VRpair = dataBig.mod(new BigInteger("4537077", 10)).longValue();
        long CROutside = (long)Math.floor(VRpair / (long)1597);
        long CRInside = VRpair % (long)1597;
        for (group = 0; CROutside > (long)_$78280[group][5] && group < 4; ++group) {
        }
        eleN = _$78280[group][0];
        eleMax = _$78280[group][1];
        Vodd = (long)Math.floor((CROutside - (long)_$78280[group][6]) / (long)_$78280[group][4]);
        Veven = (CROutside - (long)_$78280[group][6]) % (long)_$78280[group][4];
        if (this._$78396) {
            System.out.println("Value 5 is  ".concat(String.valueOf(String.valueOf(Vodd))));
        }
        widths = this.getRSSwidths((int)Vodd, eleN, 4, eleMax, 1);
        for (i = 0; i < 4; ++i) {
            if (this._$78396) {
                System.out.println("width is ".concat(String.valueOf(String.valueOf(widths[i]))));
            }
            output[41 - i * 2] = widths[i];
            checksum += _$78081[i * 2] * widths[i];
            checksum %= 79;
        }
        eleN = _$78280[group][2];
        eleMax = _$78280[group][3];
        if (this._$78396) {
            System.out.println("Value 6 is  ".concat(String.valueOf(String.valueOf(Veven))));
        }
        widths = this.getRSSwidths((int)Veven, eleN, 4, eleMax, 0);
        for (i = 0; i < 4; ++i) {
            if (this._$78396) {
                System.out.println("width is ".concat(String.valueOf(String.valueOf(widths[i]))));
            }
            output[40 - i * 2] = widths[i];
            checksum += _$78081[i * 2 + 1] * widths[i];
            checksum %= 79;
        }
        for (group = 0; CRInside > (long)_$78264[group][5] && group < 3; ++group) {
        }
        eleN = _$78264[group][0];
        eleMax = _$78264[group][1];
        Vodd = (long)Math.floor((CRInside - (long)_$78264[group][6]) / (long)_$78264[group][4]);
        Veven = (CRInside - (long)_$78264[group][6]) % (long)_$78264[group][4];
        if (this._$78396) {
            System.out.println("Value 7 is  ".concat(String.valueOf(String.valueOf(Vodd))));
        }
        widths = this.getRSSwidths((int)Vodd, eleN, 4, eleMax, 1);
        for (i = 0; i < 4; ++i) {
            if (this._$78396) {
                System.out.println("width is ".concat(String.valueOf(String.valueOf(widths[i]))));
            }
            output[22 + i * 2] = widths[i];
            checksum += _$78081[i * 2 + 1 + 8] * widths[i];
            checksum %= 79;
        }
        eleN = _$78264[group][2];
        eleMax = _$78264[group][3];
        if (this._$78396) {
            System.out.println("Value 8 is  ".concat(String.valueOf(String.valueOf(Veven))));
        }
        widths = this.getRSSwidths((int)Veven, eleN, 4, eleMax, 0);
        for (i = 0; i < 4; ++i) {
            if (this._$78396) {
                System.out.println("width is ".concat(String.valueOf(String.valueOf(widths[i]))));
            }
            output[21 + i * 2] = widths[i];
            checksum += _$78081[i * 2 + 8] * widths[i];
            checksum %= 79;
        }
        if (checksum >= 8) {
            ++checksum;
        }
        if (checksum >= 72) {
            ++checksum;
        }
        if (this._$78396) {
            System.out.println("Checksum is ".concat(String.valueOf(String.valueOf(checksum))));
        }
        this.leftChecksum = checksum / 9;
        this.rightChecksum = checksum % 9;
        for (i = 0; i < 3; ++i) {
            output[8 + i] = _$78297[this.leftChecksum * 3 + i];
        }
        for (i = 0; i < 3; ++i) {
            output[33 - i] = _$78297[this.rightChecksum * 3 + i];
        }
        for (i = 0; i < output.length; ++i) {
            if (!this._$78396) continue;
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Bar ").append(i).append(" = ").append(output[i]))));
        }
        return output;
    }

    protected int[] getRSSwidths(int val, int n, int elements, int maxWidth, int noNarrow) {
        int narrowMask = 0;
        int[] widths = new int[14];
        for (int bar = 0; bar < elements - 1; ++bar) {
            int subVal;
            int elmWidth = 1;
            narrowMask |= 1 << bar;
            while (true) {
                subVal = this.combins(n - elmWidth - 1, elements - bar - 2);
                if (noNarrow == 0 && narrowMask == 0 && n - elmWidth - (elements - bar - 1) >= elements - bar - 1) {
                    subVal -= this.combins(n - elmWidth - (elements - bar), elements - bar - 2);
                }
                if (elements - bar - 1 > 1) {
                    int lessVal = 0;
                    for (int mxwElement = n - elmWidth - (elements - bar - 2); mxwElement > maxWidth; --mxwElement) {
                        lessVal += this.combins(n - elmWidth - mxwElement - 1, elements - bar - 3);
                    }
                    subVal -= lessVal * (elements - 1 - bar);
                } else if (n - elmWidth > maxWidth) {
                    --subVal;
                }
                if ((val -= subVal) < 0) break;
                ++elmWidth;
                narrowMask &= ~(1 << bar);
            }
            val += subVal;
            n -= elmWidth;
            widths[bar] = elmWidth;
        }
        widths[bar] = n;
        return widths;
    }

    protected int combins(int n, int r) {
        int maxDenom;
        int minDenom;
        if (n - r > r) {
            minDenom = r;
            maxDenom = n - r;
        } else {
            minDenom = n - r;
            maxDenom = r;
        }
        int val = 1;
        int j = 1;
        for (int i = n; i > maxDenom; --i) {
            val *= i;
            if (j > minDenom) continue;
            val /= j;
            ++j;
        }
        while (j <= minDenom) {
            val /= j;
            ++j;
        }
        return val;
    }

    protected void renderRSS(Graphics g, int[][] map, int[] separator, boolean isStacked, boolean isExpanded, int columns) {
        int[] heights;
        int[][] map2D = null;
        int offsetX = this.leftMargin;
        int offsetY = this.topMargin;
        if (this.linkFlag) {
            CC_A cc = new CC_A();
            cc.setCode(this.secondaryCode);
            cc.PDFColumns = columns;
            map2D = cc.paintPDF417();
            if (!isStacked && !isExpanded) {
                offsetX = this.leftMargin;
            }
            if (isStacked && !isExpanded) {
                offsetX = this.leftMargin + 1;
            }
            if (isStacked && isExpanded) {
                offsetX = this.leftMargin + 2;
            }
            BarCode.renderBarMap(g, offsetX, offsetY, map2D, this.barHeight2D, map2D.length, this.X, this.barColor);
            offsetY += this.barHeight2D * map2D.length;
            if (!isStacked && !isExpanded) {
                offsetX = this.leftMargin + map2D[0].length - map[0].length + 1;
            }
            if (isStacked && !isExpanded) {
                offsetX = this.leftMargin;
            }
            if (isStacked && isExpanded) {
                offsetX = this.leftMargin;
            }
            int[][] mapSeparator = new int[][]{separator};
            BarCode.renderBarMap(g, offsetX, offsetY, mapSeparator, this.X, 1, this.X, this.barColor);
            offsetY += this.X;
        }
        if (!isStacked) {
            BarCode.renderBarMap(g, offsetX, offsetY, map, this.barHeight, map.length, this.X, this.barColor);
            offsetY += this.barHeight;
        }
        if (isStacked && !isExpanded) {
            heights = new int[map.length];
            int totalHeight = 0;
            int dataRowInterval = 2;
            if (this.format == FORMAT_STACKED_OMNIDIRECTIONAL) {
                dataRowInterval = 4;
            }
            for (int i = 0; i < heights.length; ++i) {
                heights[i] = i % dataRowInterval == 0 ? this.barHeight : this.X;
                totalHeight += heights[i];
            }
            BarCode.renderBarMap(g, offsetX, offsetY, map, heights, map.length, this.X, 0, 0, this.barColor);
            offsetY += totalHeight;
        }
        if (isStacked && isExpanded) {
            heights = new int[map.length];
            int totalHeight = 0;
            for (int i = 0; i < heights.length; ++i) {
                heights[i] = i % 4 == 0 ? this.barHeight : this.X;
                totalHeight += heights[i];
            }
            BarCode.renderBarMap(g, offsetX, offsetY, map, heights, map.length, this.X, 0, 0, this.barColor);
            offsetY += totalHeight;
        }
        if (!isExpanded) {
            String tmpCode = this.code;
            while (tmpCode.length() < 13) {
                tmpCode = "0".concat(String.valueOf(String.valueOf(tmpCode)));
            }
            String codeText = String.valueOf(String.valueOf(new StringBuffer("(01)").append(tmpCode).append(this.UPCEANCheck(tmpCode))));
            if (this.humanReadableCode != null) {
                codeText = this.humanReadableCode;
            }
            this.paintText(g, codeText, this.currentX, offsetY);
        } else if (this.humanReadableCode != null) {
            this.paintText(g, this.humanReadableCode, this.currentX, offsetY);
        }
        this.currentY = offsetY;
    }

    private void _$78413(int[][] map) {
        int x = 0;
        boolean lastColorBar = false;
        int separatorY = 1;
        int w = map[0].length;
        x += BarCode.addBarMap(map, x, separatorY, 1, false);
        for (int i = 1; i < w; ++i) {
            if (map[0][x] == map[2][x]) {
                if (map[0][x] == 1) {
                    x += BarCode.addBarMap(map, x, separatorY, 1, false);
                    lastColorBar = false;
                    continue;
                }
                x += BarCode.addBarMap(map, x, separatorY, 1, true);
                lastColorBar = true;
                continue;
            }
            lastColorBar = i <= 3 || i >= w - 4 ? false : !lastColorBar;
            x += BarCode.addBarMap(map, x, separatorY, 1, lastColorBar);
        }
    }

    private void _$78470(int[] maprow, int[] separator) {
        int w = maprow.length;
        for (int i = 4; i < w - 4; ++i) {
            if (i >= 18 && i <= 30) {
                if (this.leftChecksum == 3 && i == 27) {
                    separator[i + 1] = BarCode.BLACK;
                    continue;
                }
                if (this.leftChecksum == 3 && i == 28) continue;
                if (maprow[i] == BarCode.BLACK) {
                    separator[i] = BarCode.WHITE;
                    continue;
                }
                separator[i] = separator[i - 1] == BarCode.BLACK ? BarCode.WHITE : BarCode.BLACK;
                continue;
            }
            separator[i] = maprow[i] == BarCode.WHITE ? BarCode.BLACK : BarCode.WHITE;
        }
    }

    private void _$78489(int[] maprow, int[] separator) {
        int w = maprow.length;
        for (int i = 4; i < w - 4; ++i) {
            if (i >= 18 && i <= 30 || i >= 65 && i <= 77) {
                if (this.rightChecksum == 3 && i == 74) {
                    separator[i + 1] = BarCode.BLACK;
                    continue;
                }
                if (this.rightChecksum == 3 && i == 75) continue;
                if (this.leftChecksum == 3 && i == 27) {
                    separator[i + 1] = BarCode.BLACK;
                    continue;
                }
                if (this.leftChecksum == 3 && i == 28) continue;
                if (maprow[i] == BarCode.BLACK) {
                    separator[i] = BarCode.WHITE;
                    continue;
                }
                separator[i] = separator[i - 1] == BarCode.BLACK ? BarCode.WHITE : BarCode.BLACK;
                continue;
            }
            separator[i] = maprow[i] == BarCode.WHITE ? BarCode.BLACK : BarCode.WHITE;
        }
    }

    private void _$78434(int[][] map) {
        int i;
        boolean lastColorBar = false;
        int separatorY = 1;
        int w = map[0].length;
        for (i = 4; i < w - 4; ++i) {
            if (i >= 18 && i <= 30) {
                if (map[0][i] == 1) {
                    BarCode.addBarMap(map, i, separatorY, 1, false);
                    continue;
                }
                BarCode.addBarMap(map, i, separatorY, 1, map[1][i - 1] == 0);
                continue;
            }
            if (map[0][i] == 0) {
                BarCode.addBarMap(map, i, separatorY, 1, true);
                continue;
            }
            BarCode.addBarMap(map, i, separatorY, 1, false);
        }
        separatorY = 2;
        lastColorBar = false;
        for (i = 4; i < w - 4; ++i) {
            BarCode.addBarMap(map, i, separatorY, 1, lastColorBar);
            lastColorBar = !lastColorBar;
        }
        separatorY = 3;
        for (i = 4; i < w - 4; ++i) {
            if (i >= 19 && i <= 31) {
                if (this.rightChecksum == 3 && i == 28) {
                    BarCode.addBarMap(map, i + 1, separatorY, 1, true);
                    continue;
                }
                if (this.rightChecksum == 3 && i == 29) continue;
                if (map[4][i] == 1) {
                    BarCode.addBarMap(map, i, separatorY, 1, false);
                    continue;
                }
                BarCode.addBarMap(map, i, separatorY, 1, map[3][i - 1] == 0);
                continue;
            }
            if (map[4][i] == 0) {
                BarCode.addBarMap(map, i, separatorY, 1, true);
                continue;
            }
            BarCode.addBarMap(map, i, separatorY, 1, false);
        }
    }
}

