/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rss;

import com.java4less.rss.CC;
import com.java4less.rss.CC_A;
import com.java4less.rss.CC_C;
import com.java4less.rss.RImageCreator;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class BarCode
extends Canvas {
    public static final int UPCA = 1;
    public static final int EAN13 = 2;
    public static final int EAN8 = 3;
    public static final int UPCE = 4;
    public static final int EAN128 = 5;
    public static final int RSS14 = 6;
    public static final int RSSLIMITED = 7;
    public static final int RSSEXPANDED = 8;
    protected static final int d = 0;
    protected static int WHITE;
    protected static int BLACK;
    protected static int BLACK_GUARDBAR;
    protected static int BLACK_SUPLEMENT;
    protected static int EMPTY;
    protected int barType = 2;
    protected String code = "";
    protected String secondaryCode = "";
    protected String humanReadableCode = null;
    protected int cccColumns = 4;
    protected boolean EANUPCPrintFlag = true;
    protected boolean EAN128WithCCC = false;
    protected int barHeight2D = 4;
    private String _$4492 = "";
    protected boolean checkCharacter = true;
    protected int leftMargin = 0;
    protected int topMargin = 0;
    protected String supplement = "";
    protected boolean guardBars = true;
    protected Color backColor = Color.white;
    private String _$4551 = "";
    protected int barHeight = 30;
    protected Font textFont = new Font("Arial", 0, 11);
    protected Color fontColor = Color.black;
    protected Color barColor = Color.black;
    protected char UPCESytem = (char)49;
    protected boolean UPCEANSupplement2 = false;
    protected boolean UPCEANSupplement5 = false;
    protected int X = 1;
    public double H = 0.45;
    public int L = 0;
    private int _$4640 = 0;
    protected int rotate = 0;
    protected int supSeparation = 10;
    protected double supHeight = 0.8;
    protected boolean processTilde = false;
    protected int currentX = 0;
    protected int currentY = 0;
    protected String[][] setUPCALeft = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCARight = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCEOdd = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCEEven = new String[][]{{"0", "1123"}, {"1", "1222"}, {"2", "2212"}, {"3", "1141"}, {"4", "2311"}, {"5", "1321"}, {"6", "4111"}, {"7", "2131"}, {"8", "3121"}, {"9", "2113"}};
    protected String[] UPCESystem0 = new String[]{"EEEOOO", "EEOEOO", "EEOOEO", "EEOOOE", "EOEEOO", "EOOEEO", "EOOOEE", "EOEOEO", "EOEOOE", "EOOEOE"};
    protected String[] UPCESystem1 = new String[]{"OOOEEE", "OOEOEE", "OOEEOE", "OOEEEO", "OEOOEE", "OEEOOE", "OEEEOO", "OEOEOE", "OEOEEO", "OEEOEO"};
    protected String[][] setEANLeftA = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setEANLeftB = new String[][]{{"0", "1123"}, {"1", "1222"}, {"2", "2212"}, {"3", "1141"}, {"4", "2311"}, {"5", "1321"}, {"6", "4111"}, {"7", "2131"}, {"8", "3121"}, {"9", "2113"}};
    protected String[][] setEANRight = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[] setEANCode = new String[]{"AAAAA", "ABABB", "ABBAB", "ABBBA", "BAABB", "BBAAB", "BBBAA", "BABAB", "BABBA", "BBABA"};
    protected String[] fiveSuplement = new String[]{"EEOOO", "EOEOO", "EOOEO", "EOOOE", "OEEOO", "OOEEO", "OOOEE", "OEOEO", "OEOOE", "OOEOE"};
    protected String[] set128 = new String[]{"212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131"};
    protected String[] set128A = new String[]{" ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "\u0000", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u000e", "\u000f", "\u0010", "\u0011", "\u0012", "\u0013", "\u0014", "\u0015", "\u0016", "\u0017", "\u0018", "\u0019", "\u001a", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "_96", "_97", "_98", "_99", "_100", "_101", "_102"};
    protected String[] set128B = new String[]{" ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "_92", "}", "~", "_95", "_96", "_97", "_98", "_99", "_100", "_101", "_102"};
    protected String[] set128C = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "_100", "_101", "_102"};
    private int _$4821 = 0;
    private int _$4833 = 0;
    private int _$4852 = 0;
    private int _$4869 = 0;
    private int _$4882 = 0;
    private int _$4891;
    private int _$4905;
    private int _$4917;
    private int _$4935 = 0;
    private int _$4949 = 0;

    public int getCCCColumns() {
        return this.cccColumns;
    }

    public void setCCCColumns(int c) {
        this.cccColumns = c;
    }

    public boolean getEANUPCPrintFlag() {
        return this.EANUPCPrintFlag;
    }

    public void setEANUPCPrintFlag(boolean b) {
        this.EANUPCPrintFlag = b;
    }

    public boolean getEAN128WithCCC() {
        return this.EAN128WithCCC;
    }

    public void setEAN128WithCCC(boolean b) {
        this.EAN128WithCCC = b;
    }

    public int getBarHeight2D() {
        return this.barHeight2D;
    }

    public void setBarHeight2D(int h) {
        this.barHeight2D = h;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String c) {
        this.code = c;
    }

    public String getSecondaryCode() {
        return this.secondaryCode;
    }

    public void setSecondaryCode(String c) {
        this.secondaryCode = c;
    }

    public String getHumanReadableCode() {
        return this.humanReadableCode;
    }

    public void setHumanReadableCode(String c) {
        this.humanReadableCode = c;
    }

    public int getSymbology() {
        return this.barType;
    }

    public void setSymbology(int c) {
        this.barType = c;
    }

    public String getBarType() {
        switch (this.barType) {
            case 1: {
                return "UPCA";
            }
            case 2: {
                return "EAN13";
            }
            case 3: {
                return "EAN8";
            }
            case 4: {
                return "UPCE";
            }
            case 5: {
                return "EAN128";
            }
            case 6: {
                return "RSS14";
            }
            case 7: {
                return "RSSLIMITED";
            }
            case 8: {
                return "RSSEXPANDED";
            }
        }
        return "";
    }

    public void setBarType(String t) {
        if ((t = t.toUpperCase()).compareTo("EAN13") == 0) {
            this.barType = 2;
        }
        if (t.compareTo("EAN8") == 0) {
            this.barType = 3;
        }
        if (t.compareTo("UPCA") == 0) {
            this.barType = 1;
        }
        if (t.compareTo("UPCE") == 0) {
            this.barType = 4;
        }
        if (t.compareTo("EAN128") == 0) {
            this.barType = 5;
        }
        if (t.compareTo("RSS14") == 0) {
            this.barType = 6;
        }
        if (t.compareTo("RSSLIMITED") == 0) {
            this.barType = 7;
        }
        if (t.compareTo("RSSEXPANDED") == 0) {
            this.barType = 8;
        }
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int d) {
        this.leftMargin = d;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int d) {
        this.topMargin = d;
    }

    public String getSuplement() {
        return this.supplement;
    }

    public void setSuplement(String c) {
        this.supplement = c;
    }

    public boolean getGuardBars() {
        return this.guardBars;
    }

    public void setGuardBars(boolean b) {
        this.guardBars = b;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color c) {
        this.backColor = c;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(int d) {
        this.barHeight = d;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font f) {
        this.textFont = f;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color c) {
        this.fontColor = c;
    }

    public Color getBarColor() {
        return this.barColor;
    }

    public void setBarColor(Color c) {
        this.barColor = c;
    }

    public String getUPCESytem() {
        return "".concat(String.valueOf(String.valueOf(this.UPCESytem)));
    }

    public void setUPCESytem(String d) {
        if (d.length() > 0) {
            this.UPCESytem = d.charAt(0);
        }
    }

    public boolean getUPCEANSupplement2() {
        return this.UPCEANSupplement2;
    }

    public void setUPCEANSupplement2(boolean b) {
        this.UPCEANSupplement2 = b;
    }

    public boolean getUPCEANSupplement5() {
        return this.UPCEANSupplement5;
    }

    public void setUPCEANSupplement5(boolean b) {
        this.UPCEANSupplement5 = b;
    }

    public int getX() {
        return this.X;
    }

    public void setX(int d) {
        this.X = d;
    }

    public double getH() {
        return this.H;
    }

    public void setH(double d) {
        this.H = d;
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int i) {
        this.rotate = i;
    }

    public int getSupSeparation() {
        return this.supSeparation;
    }

    public void setSupSeparation(int d) {
        this.supSeparation = d;
    }

    public double getSupHeight() {
        return this.supHeight;
    }

    public void setSupHeight(double d) {
        this.supHeight = d;
    }

    public String getName() {
        return "RBarCode-RSS";
    }

    public boolean getProcessTilde() {
        return this.processTilde;
    }

    public void setProcessTilde(boolean pt) {
        this.processTilde = pt;
    }

    public void paint(Graphics g2) {
        Graphics g = g2;
        Image im = null;
        if (this.topMargin < 30) {
            this.topMargin = 30;
        }
        if (this.rotate != 0) {
            String v = System.getProperty("java.version");
            if (v.indexOf("1.2") == 0 || v.indexOf("1.3") == 0 || v.indexOf("1.4") == 0) {
                RImageCreator imc = new RImageCreator();
                im = imc.getImage(this.getSize().width, this.getSize().height);
                g = imc.getGraphics();
            } else {
                im = this.getSize().width > this.getSize().height ? this.createImage(this.getSize().width, this.getSize().width) : this.createImage(this.getSize().height, this.getSize().height);
                g = im.getGraphics();
            }
        }
        if (this.processTilde) {
            this.code = this._$3842(this.code);
            this.secondaryCode = this._$3842(this.secondaryCode);
        }
        g2.setColor(this.backColor);
        g2.fillRect(0, 0, this.getSize().width, this.getSize().height);
        boolean errorPrinted = false;
        try {
            this.paintBarcode(g);
        }
        catch (Exception e) {
            e.printStackTrace();
            g2.setColor(this.barColor);
            g.setFont(new Font("Arial", 0, 11));
            g2.drawString("Error: ".concat(String.valueOf(String.valueOf(e.getMessage()))), 10, 30);
            errorPrinted = true;
        }
        if (!errorPrinted) {
            long rnd = System.currentTimeMillis();
            g.setFont(new Font("Arial", 0, 11));
            int textH = g.getFontMetrics().getHeight();
            int textW = g.getFontMetrics().stringWidth("XXXX");
            if (rnd % (long)2 == (long)0) {
                g.setColor(this.backColor);
                g.fillRect(this.leftMargin, this.topMargin + (this.currentY - this.topMargin) / 2 - textH, textW, textH);
                g.setColor(Color.red);
                g.setFont(new Font("Arial", 0, 11));
                g.drawString("DEMO", this.leftMargin, this.topMargin + (this.currentY - this.topMargin) / 2);
            }
            g.setColor(this.fontColor);
            g.drawString("Register at www.java4less.com", this.topMargin, textH + 4);
        }
        if (this.rotate != 0) {
            int maxw = this.currentX + this.topMargin;
            int maxh = this.currentY + this.topMargin;
            Image imRotated = this.rotate(im, this.rotate, maxw, maxh);
            if (imRotated == null) {
                g2.drawImage(im, 0, 0, null);
            } else {
                g2.drawImage(imRotated, 0, 0, null);
            }
        }
    }

    protected int findChar(String[][] table, String c) {
        for (int i = 0; i < table.length; ++i) {
            if (c.compareTo(table[i][0]) != 0) continue;
            return i;
        }
        return -1;
    }

    protected String UPCEANCheck(String s) {
        boolean odd = true;
        int sumodd = 0;
        int sum = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            if (odd) {
                sumodd += new Integer("".concat(String.valueOf(String.valueOf(s.charAt(i))))).intValue();
            } else {
                sum += new Integer("".concat(String.valueOf(String.valueOf(s.charAt(i))))).intValue();
            }
            odd = !odd;
        }
        int c = (int)BarCode.mod(sum = sumodd * 3 + sum, 10.0);
        if (c != 0) {
            c = 10 - c;
        }
        return "".concat(String.valueOf(String.valueOf(c)));
    }

    protected void paintUPCA(Graphics g) throws Exception {
        int pos = 0;
        boolean sum = false;
        if (this.code.length() == 11 && this.checkCharacter) {
            this.code = String.valueOf(String.valueOf(this.code)).concat(String.valueOf(String.valueOf(this.UPCEANCheck(this.code))));
        }
        if (this.code.length() < 12) {
            throw new Exception("Code length must be 11 or 12");
        }
        this.calculateL(this.code);
        int[][] map = BarCode.createBarMap(this.L + this._$4640, 1, EMPTY);
        int x = 0;
        this._$4551 = this.code;
        x += this.paintGuardChar(map, "bwb", "nnn", x, 0);
        this._$4821 = x;
        for (int i = 0; i < this.code.length(); ++i) {
            String c = "".concat(String.valueOf(String.valueOf(this.code.charAt(i))));
            pos = -1;
            if (i <= 5) {
                pos = this.findChar(this.setUPCALeft, c);
                x += this.paintCharBarMap(map, "wbwb", this.setUPCALeft[pos][1], x, 0);
            } else {
                pos = this.findChar(this.setUPCARight, c);
                x += this.paintCharBarMap(map, "bwbw", this.setUPCARight[pos][1], x, 0);
            }
            if (i != 5) continue;
            this._$4833 = x;
            x += this.paintGuardChar(map, "wbwbw", "nnnnn", x, 0);
            this._$4852 = x;
        }
        this._$4869 = x;
        x += this.paintGuardChar(map, "bwb", "nnn", x, 0);
        this._$4882 = x;
        if (this.UPCEANSupplement2) {
            this.paintSup2(map, this.code.substring(1, 3), x);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(map, this.code.substring(1, 6), x);
        }
        BarCode.printBarMap(map, 0);
        this.renderEANUPC(g, map, 4);
    }

    protected void paintEAN13(Graphics g) throws Exception {
        int pos = 0;
        boolean sum = false;
        if (this.code.length() == 12 && this.checkCharacter) {
            this._$4551 = this.code = String.valueOf(String.valueOf(this.code)).concat(String.valueOf(String.valueOf(this.UPCEANCheck(this.code))));
        }
        if (this.code.length() < 13) {
            throw new Exception("Code length must be 12 or 13");
        }
        this.calculateL(this.code);
        int[][] map = BarCode.createBarMap(this.L + this._$4640, 1, EMPTY);
        int x = 0;
        this._$4551 = this.code;
        x += this.paintGuardChar(map, "bwb", "nnn", x, 0);
        this._$4821 = x;
        String sets = this.setEANCode[new Integer("".concat(String.valueOf(String.valueOf(this.code.charAt(0)))))];
        pos = this.findChar(this.setEANLeftA, "".concat(String.valueOf(String.valueOf(this.code.charAt(1)))));
        x += this.paintCharBarMap(map, "wbwb", this.setEANLeftA[pos][1], x, 0);
        for (int i = 2; i < 12; ++i) {
            String c = "".concat(String.valueOf(String.valueOf(this.code.charAt(i))));
            pos = -1;
            if (i <= 6) {
                String[][] leftset = this.setEANLeftA;
                if (sets.charAt(i - 2) == 'B') {
                    leftset = this.setEANLeftB;
                }
                pos = this.findChar(leftset, c);
                x += this.paintCharBarMap(map, "wbwb", leftset[pos][1], x, 0);
            } else {
                pos = this.findChar(this.setEANRight, c);
                x += this.paintCharBarMap(map, "bwbw", this.setEANRight[pos][1], x, 0);
            }
            if (i != 6) continue;
            this._$4833 = x;
            x += this.paintGuardChar(map, "wbwbw", "nnnnn", x, 0);
            this._$4852 = x;
        }
        pos = this.findChar(this.setEANRight, "".concat(String.valueOf(String.valueOf(this.code.charAt(12)))));
        x += this.paintCharBarMap(map, "bwbw", this.setEANRight[pos][1], x, 0);
        this._$4869 = x;
        x += this.paintGuardChar(map, "bwb", "nnn", x, 0);
        this._$4882 = x;
        if (this.UPCEANSupplement2) {
            this.paintSup2(map, this.code.substring(2, 4), x);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(map, this.code.substring(2, 7), x);
        }
        this.renderEANUPC(g, map, 4);
    }

    protected void paintEAN128(Graphics g) throws Exception {
        int currentSet;
        int pos = 0;
        int check = 0;
        int symbols = 0;
        this.calculateL("#".concat(String.valueOf(String.valueOf(this.code))));
        int[][] map = BarCode.createBarMap(this.L + this._$4640, 1, EMPTY);
        int x = 0;
        this._$4551 = this.code;
        int Code128Set = 67;
        String[] set = this.set128A;
        if (Code128Set == 66) {
            set = this.set128B;
        }
        int sum = 103;
        if (Code128Set == 66) {
            set = this.set128B;
            sum = 104;
        }
        if (Code128Set == 67) {
            set = this.set128C;
            sum = 105;
        }
        int previousSet = currentSet = Code128Set;
        if (Code128Set == 66) {
            x += this.paintCharBarMap(map, "bwbwbw", "211214", x, 0);
        }
        if (Code128Set == 67) {
            x += this.paintCharBarMap(map, "bwbwbw", "211232", x, 0);
        }
        if (Code128Set != 66 && Code128Set != 67) {
            x += this.paintCharBarMap(map, "bwbwbw", "211412", x, 0);
        }
        ++symbols;
        int w = 1;
        for (int i = 0; i < this.code.length(); ++i) {
            int pos2;
            previousSet = currentSet;
            set = this.set128A;
            if (currentSet == 66) {
                set = this.set128B;
            }
            if (currentSet == 67) {
                set = this.set128C;
            }
            String c = "".concat(String.valueOf(String.valueOf(this.code.charAt(i))));
            c = this._$6029(c);
            if (this.barType == 5 && i == 0) {
                pos = this._$6054(this.set128C, "_102");
                x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos], x, 0);
                ++symbols;
                sum += pos * w;
                ++w;
            }
            if (currentSet == 67) {
                boolean done = false;
                if (i < this.code.length() - 1 && this._$6065("".concat(String.valueOf(String.valueOf(c)))) && this._$6065("".concat(String.valueOf(String.valueOf(this.code.charAt(i + 1)))))) {
                    pos = this._$6054(this.set128C, c = String.valueOf(String.valueOf(c)).concat(String.valueOf(String.valueOf(this.code.charAt(i + 1)))));
                    if (pos >= 0) {
                        x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos], x, 0);
                        ++symbols;
                        sum += pos * w;
                    }
                    done = true;
                    ++i;
                }
                if (!done && !this._$6065(c) && (pos = this._$6054(this.set128C, c)) >= 0) {
                    x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos], x, 0);
                    ++symbols;
                    sum += pos * w;
                    done = true;
                }
                if (!done && this._$6065(c)) {
                    currentSet = 66;
                    if (i < this.code.length() - 1 && this._$6072(this.code, i + 1) < this._$6090(this.code, i + 1)) {
                        currentSet = 65;
                    }
                    pos = this._$6054(this.set128C, "_100");
                    if (currentSet == 65) {
                        pos = this._$6054(this.set128C, "_101");
                    }
                    sum += pos * w;
                    ++w;
                    x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos], x, 0);
                    ++symbols;
                    pos = this._$6054(this.set128B, c);
                    if (pos >= 0) {
                        x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos], x, 0);
                        ++symbols;
                        sum += pos * w;
                    }
                    done = true;
                }
                if (!done && !this._$6065(c)) {
                    currentSet = this._$6106(this.code, i);
                    int pos22 = 0;
                    if (currentSet == 65) {
                        pos22 = this._$6054(set, "_101");
                    }
                    if (currentSet == 66) {
                        pos22 = this._$6054(set, "_100");
                    }
                    x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos22], x, 0);
                    ++symbols;
                    sum += pos22 * w;
                    --i;
                }
            } else if (this._$6106(this.code, i) == 'C') {
                --i;
                pos2 = 0;
                pos2 = this._$6054(this.set128B, "_99");
                if (currentSet == 65) {
                    pos2 = this._$6054(this.set128A, "_99");
                }
                x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos2], x, 0);
                sum += pos2 * w;
                ++symbols;
                currentSet = 67;
            } else {
                pos = this._$6054(set, c);
                if (currentSet == 65 && pos == -1 && this._$6054(this.set128B, c) >= 0) {
                    pos2 = 0;
                    if (this._$6072(this.code, i) < this._$6090(this.code, i)) {
                        pos2 = this._$6054(set, "_98");
                    } else {
                        pos2 = this._$6054(set, "_100");
                        currentSet = 66;
                    }
                    x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos2], x, 0);
                    ++symbols;
                    sum += pos2 * w;
                    ++w;
                    set = this.set128B;
                }
                if (currentSet == 66 && pos == -1 && this._$6054(this.set128A, c) >= 0) {
                    pos2 = 0;
                    if (this._$6072(this.code, i) > this._$6090(this.code, i)) {
                        pos2 = this._$6054(set, "_98");
                    } else {
                        pos2 = this._$6054(set, "_101");
                        currentSet = 65;
                    }
                    x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos2], x, 0);
                    ++symbols;
                    sum += pos2 * w;
                    ++w;
                    set = this.set128A;
                }
                if ((pos = this._$6054(set, c)) >= 0) {
                    x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos], x, 0);
                    ++symbols;
                    sum += pos * w;
                }
            }
            ++w;
        }
        if (this.secondaryCode.length() > 0) {
            int pos2 = 0;
            if (!this.EAN128WithCCC) {
                if (currentSet == 65) {
                    pos2 = this._$6054(this.set128A, "_100");
                }
                if (currentSet == 66) {
                    pos2 = this._$6054(this.set128B, "_99");
                }
                if (currentSet == 67) {
                    pos2 = this._$6054(this.set128C, "_101");
                }
            } else {
                if (currentSet == 65) {
                    pos2 = this._$6054(this.set128A, "_99");
                }
                if (currentSet == 66) {
                    pos2 = this._$6054(this.set128B, "_101");
                }
                if (currentSet == 67) {
                    pos2 = this._$6054(this.set128C, "_100");
                }
            }
            x += this.paintCharBarMap(map, "bwbwbw", this.set128[pos2], x, 0);
            ++symbols;
            sum += pos2 * w;
        }
        if (this.checkCharacter) {
            check = (int)BarCode.mod(sum, 103.0);
            x += this.paintCharBarMap(map, "bwbwbw", this.set128[check], x, 0);
            ++symbols;
        }
        x += this.paintCharBarMap(map, "bwbwbwb", "2331112", x, 0);
        this._$4882 = x;
        this.renderEAN128(g, map, ++symbols);
    }

    protected void paintEAN8(Graphics g) throws Exception {
        int pos = 0;
        boolean sum = false;
        if (this.code.length() == 7 && this.checkCharacter) {
            this.code = String.valueOf(String.valueOf(this.code)).concat(String.valueOf(String.valueOf(this.UPCEANCheck(this.code))));
        }
        if (this.code.length() < 8) {
            throw new Exception("Code length must be 7 or 8");
        }
        this.calculateL(this.code);
        int[][] map = BarCode.createBarMap(this.L + this._$4640, 1, EMPTY);
        int x = 0;
        this._$4551 = this.code;
        x += this.paintGuardChar(map, "bwb", "nnn", x, 0);
        this._$4821 = x;
        for (int i = 0; i < 8; ++i) {
            String c = "".concat(String.valueOf(String.valueOf(this.code.charAt(i))));
            pos = -1;
            if (i <= 3) {
                pos = this.findChar(this.setEANLeftA, c);
                x += this.paintCharBarMap(map, "wbwb", this.setEANLeftA[pos][1], x, 0);
            } else {
                pos = this.findChar(this.setEANRight, c);
                x += this.paintCharBarMap(map, "bwbw", this.setEANRight[pos][1], x, 0);
            }
            if (i != 3) continue;
            this._$4833 = x;
            x += this.paintGuardChar(map, "wbwbw", "nnnnn", x, 0);
            this._$4852 = x;
        }
        this._$4869 = x;
        x += this.paintGuardChar(map, "bwb", "nnn", x, 0);
        this._$4882 = x;
        if (this.UPCEANSupplement2) {
            this.paintSup2(map, this.code.substring(2, 4), x);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(map, this.code.substring(2, 7), x);
        }
        this.renderEANUPC(g, map, 3);
    }

    protected void paintUPCE(Graphics g) throws Exception {
        int pos = 0;
        boolean sum = false;
        int checkchar = 0;
        String codetmp = "";
        if (this.code.length() == 11 && this.checkCharacter) {
            this.code = String.valueOf(String.valueOf(this.code)).concat(String.valueOf(String.valueOf(this.UPCEANCheck(this.code))));
        }
        if (this.code.length() < 12) {
            return;
        }
        this.calculateL(this.code);
        int[][] map = BarCode.createBarMap(this.L + this._$4640, 1, EMPTY);
        int x = 0;
        checkchar = new Integer("".concat(String.valueOf(String.valueOf(this.code.charAt(11)))));
        if (this.code.substring(3, 6).compareTo("000") == 0 || this.code.substring(3, 6).compareTo("100") == 0 || this.code.substring(3, 6).compareTo("200") == 0) {
            codetmp = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.code.substring(1, 3)))).append(this.code.substring(8, 11)).append(this.code.charAt(3))));
        }
        if (this.code.substring(3, 6).compareTo("300") == 0 || this.code.substring(3, 6).compareTo("400") == 0 || this.code.substring(3, 6).compareTo("500") == 0 || this.code.substring(3, 6).compareTo("600") == 0 || this.code.substring(3, 6).compareTo("700") == 0 || this.code.substring(3, 6).compareTo("800") == 0 || this.code.substring(3, 6).compareTo("900") == 0) {
            codetmp = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.code.substring(1, 4)))).append(this.code.substring(9, 11)).append("3")));
        }
        if (this.code.substring(4, 6).compareTo("10") == 0 || this.code.substring(4, 6).compareTo("20") == 0 || this.code.substring(4, 6).compareTo("30") == 0 || this.code.substring(4, 6).compareTo("40") == 0 || this.code.substring(4, 6).compareTo("50") == 0 || this.code.substring(4, 6).compareTo("60") == 0 || this.code.substring(4, 6).compareTo("70") == 0 || this.code.substring(4, 6).compareTo("80") == 0 || this.code.substring(4, 6).compareTo("90") == 0) {
            codetmp = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.code.substring(1, 5)))).append(this.code.substring(10, 11)).append("4")));
        }
        if (this.code.substring(5, 6).compareTo("0") != 0) {
            codetmp = String.valueOf(String.valueOf(this.code.substring(1, 6))).concat(String.valueOf(String.valueOf(this.code.substring(10, 11))));
        }
        this._$4551 = codetmp;
        x += this.paintGuardChar(map, "bwb", "nnn", x, 0);
        this._$4821 = x;
        String System2 = this.UPCESystem0[checkchar];
        if (this.UPCESytem == '1') {
            System2 = this.UPCESystem1[checkchar];
        }
        for (int i = 0; i < codetmp.length(); ++i) {
            String c = "".concat(String.valueOf(String.valueOf(codetmp.charAt(i))));
            pos = -1;
            String[][] setLeft = this.setUPCEOdd;
            if (System2.charAt(i) == 'E') {
                setLeft = this.setUPCEEven;
            }
            pos = this.findChar(setLeft, c);
            String inverted = "";
            for (int j = 0; j < setLeft[pos][1].length(); ++j) {
                inverted = String.valueOf(String.valueOf(setLeft[pos][1].charAt(j))).concat(String.valueOf(String.valueOf(inverted)));
            }
            x += this.paintCharBarMap(map, "wbwb", inverted, x, 0);
        }
        this._$4869 = x;
        x += this.paintGuardChar(map, "wbwbwb", "nnnnnn", x, 0);
        this._$4882 = x;
        if (this.UPCEANSupplement2) {
            this.paintSup2(map, codetmp.substring(0, 2), x);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(map, codetmp.substring(0, 5), x);
        }
        this.renderEANUPC(g, map, 2);
    }

    protected void paintSup2(int[][] map, String chars, int x) {
        int i;
        if (this.supplement.length() > 0) {
            chars = this.supplement;
        }
        if (this._$4492.length() == 0) {
            this._$4492 = chars;
        }
        if (chars.length() != 2) {
            return;
        }
        this._$4891 = x += this.supSeparation;
        try {
            i = Integer.valueOf(chars);
        }
        catch (Exception e) {
            i = 0;
        }
        String Parity = "OO";
        if (BarCode.mod(i, 4.0) == 1.0) {
            Parity = "OE";
        }
        if (BarCode.mod(i, 4.0) == (double)2) {
            Parity = "EO";
        }
        if (BarCode.mod(i, 4.0) == (double)3) {
            Parity = "EE";
        }
        x += this.paintCharBarMap(map, "bwb", "112", x, 0, BLACK_SUPLEMENT);
        String[][] set = this.setUPCEOdd;
        if (Parity.charAt(0) == 'E') {
            set = this.setUPCEEven;
        }
        int pos = this.findChar(set, "".concat(String.valueOf(String.valueOf(chars.charAt(0)))));
        x += this.paintCharBarMap(map, "wbwb", set[pos][1], x, 0, BLACK_SUPLEMENT);
        x += this.paintCharBarMap(map, "wb", "11", x, 0, BLACK_SUPLEMENT);
        set = this.setUPCEOdd;
        if (Parity.charAt(1) == 'E') {
            set = this.setUPCEEven;
        }
        pos = this.findChar(set, "".concat(String.valueOf(String.valueOf(chars.charAt(1)))));
        x += this.paintCharBarMap(map, "wbwb", set[pos][1], x, 0, BLACK_SUPLEMENT);
        this._$4905 = x;
    }

    protected void paintSup5(int[][] map, String chars, int x) {
        if (this.supplement.length() > 0) {
            chars = this.supplement;
        }
        if (chars.length() != 5) {
            return;
        }
        boolean odd = true;
        int sumodd = 0;
        int sum = 0;
        for (int i = chars.length() - 1; i >= 0; --i) {
            if (odd) {
                sumodd += new Integer("".concat(String.valueOf(String.valueOf(chars.charAt(i))))).intValue();
            } else {
                sum += new Integer("".concat(String.valueOf(String.valueOf(chars.charAt(i))))).intValue();
            }
            odd = !odd;
        }
        sum = sumodd * 3 + sum * 9;
        String sumstr = "".concat(String.valueOf(String.valueOf(sum)));
        int c = new Integer("".concat(String.valueOf(String.valueOf(sumstr.charAt(sumstr.length() - 1)))));
        String Parity = this.fiveSuplement[c];
        this._$4891 = x += this.supSeparation;
        x += this.paintCharBarMap(map, "bwb", "112", x, 0, BLACK_SUPLEMENT);
        String[][] set = null;
        for (int j = 0; j < 5; ++j) {
            set = this.setUPCEOdd;
            if (Parity.charAt(j) == 'E') {
                set = this.setUPCEEven;
            }
            int pos = this.findChar(set, "".concat(String.valueOf(String.valueOf(chars.charAt(j)))));
            x += this.paintCharBarMap(map, "wbwb", set[pos][1], x, 0, BLACK_SUPLEMENT);
            if (j >= 4) continue;
            x += this.paintCharBarMap(map, "wb", "11", x, 0, BLACK_SUPLEMENT);
        }
        this._$4905 = x;
    }

    protected int paintCharBarMap(int[][] map, String patternColor, String patternBars, int x, int y) {
        return this.paintCharBarMap(map, patternColor, patternBars, x, y, BLACK);
    }

    protected int paintCharBarMap(int[][] map, String patternColor, String patternBars, int x, int y, int barType) {
        int x1 = 0;
        for (int i = 0; i < patternColor.length(); ++i) {
            char cColor = patternColor.charAt(i);
            int cBar = patternBars.charAt(i);
            if (cBar == 110) {
                cBar = 49;
            }
            if (cBar == 119) {
                throw new RuntimeException("Pattern w not supported");
            }
            int w = BarCode.addBarMap(map, x, y, cBar - 48, cColor == 'b', false, barType);
            x += w;
            x1 += w;
        }
        return x1;
    }

    protected int paintGuardChar(int[][] map, String patternColor, String patternBars, int x, int y) {
        return this.paintCharBarMap(map, patternColor, patternBars, x, y, BLACK_GUARDBAR);
    }

    protected void calculateL(String codeStr) {
        block8: {
            block7: {
                int C = codeStr.length();
                if (this.barType == 1) {
                    this.L = 95;
                }
                if (this.barType == 2) {
                    this.L = 95;
                }
                if (this.barType == 3) {
                    this.L = 67;
                }
                if (this.barType == 5) {
                    if (this.checkCharacter) {
                        ++C;
                    }
                    this.L = 11 * C + 35;
                }
                if (this.barType == 4) {
                    this.L = 51;
                }
                if (this.barHeight == 0) {
                    this.barHeight = (int)((double)this.L * this.H * (double)this.X);
                }
                this._$4640 = 0;
                if (!this.UPCEANSupplement2) break block7;
                this._$4640 = this.supSeparation + 4 + 7 + 2 + 7;
                break block8;
            }
            if (!this.UPCEANSupplement5) break block8;
            this._$4640 = this.supSeparation + 4 + 35 + 2;
        }
    }

    protected void paintBarcode(Graphics g) throws Exception {
        if (this._$4935 == 0 && this.textFont != null) {
            g.setFont(this.textFont);
            this._$4935 = g.getFontMetrics().getHeight();
        }
        if (this.barType == 3) {
            this.paintEAN8(g);
        }
        if (this.barType == 2) {
            this.paintEAN13(g);
        }
        if (this.barType == 1) {
            this.paintUPCA(g);
        }
        if (this.barType == 4) {
            this.paintUPCE(g);
        }
        if (this.barType == 5) {
            this.paintEAN128(g);
        }
        long rnd = System.currentTimeMillis();
        g.setFont(new Font("Arial", 0, 11));
        int textH = g.getFontMetrics().getHeight();
        int textW = g.getFontMetrics().stringWidth("XXXX");
        if (rnd % (long)2 == (long)0) {
            g.setColor(this.backColor);
            g.fillRect(this.leftMargin, this.topMargin + (this.currentY - this.topMargin) / 2 - textH, textW, textH);
            g.setColor(Color.red);
            g.setFont(new Font("Arial", 0, 11));
            g.drawString("DEMO", this.leftMargin, this.topMargin + (this.currentY - this.topMargin) / 2);
        }
        g.setColor(this.fontColor);
        g.drawString("Register at www.java4less.com", this.topMargin, textH + 4);
    }

    protected void paintText(Graphics g, String codeText, int rightX, int Y) {
        if (this.textFont != null) {
            g.setColor(this.fontColor);
            g.setFont(this.textFont);
            int TextH = g.getFontMetrics().getHeight();
            int charW = g.getFontMetrics().stringWidth("X");
            int toCenterX = (rightX - this.leftMargin - g.getFontMetrics().stringWidth(codeText)) / 2;
            if (toCenterX < 0) {
                toCenterX = 0;
            }
            g.drawString(codeText, this.leftMargin + toCenterX, Y + TextH + 4);
            this.currentY = Y + TextH + 1;
        }
    }

    protected Image rotate(Image im, int angle, int maxw, int maxh) {
        int w = im.getWidth(null);
        int h = im.getHeight(null);
        if (maxw > w) {
            maxw = w;
        }
        if (maxh > h) {
            maxh = h;
        }
        int[] pixels = new int[w * h];
        int[] pixels2 = new int[maxw * maxh];
        PixelGrabber pg = new PixelGrabber(im, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            Image image = null;
            return image;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        if (angle == 90) {
            for (int i = 0; i < maxw; ++i) {
                for (int j = 0; j < maxh; ++j) {
                    pixels2[maxh * (maxw - (i + 1)) + j] = pixels[j * w + i];
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(maxh, maxw, pixels2, 0, maxh));
        }
        if (angle == 180) {
            for (int i = 0; i < maxw; ++i) {
                for (int j = 0; j < maxh; ++j) {
                    pixels2[(maxh - (j + 1)) * maxw + (maxw - (i + 1))] = pixels[j * w + i];
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(maxw, maxh, pixels2, 0, maxw));
        }
        if (angle == 270) {
            for (int i = 0; i < maxw; ++i) {
                for (int j = 0; j < maxh; ++j) {
                    pixels2[maxh * i + (maxh - (j + 1))] = pixels[j * w + i];
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(maxh, maxw, pixels2, 0, maxh));
        }
        return null;
    }

    protected void renderEAN128(Graphics g, int[][] inMap, int symbols) throws Exception {
        this.currentY = this.topMargin;
        this.currentX = this.leftMargin;
        int linearComponentLeft = this.leftMargin;
        int width1D = 0;
        for (int i = 0; i < inMap[0].length && inMap[0][i] != EMPTY; ++i) {
            ++width1D;
        }
        int[][] map = new int[1][width1D];
        for (int i = 0; i < width1D; ++i) {
            map[0][i] = inMap[0][i];
        }
        int lastBarX = map[0].length;
        if (this.secondaryCode.length() > 0) {
            CC cc;
            int[][] map2D = null;
            if (this.EAN128WithCCC) {
                cc = new CC_C();
                cc.setCode(this.secondaryCode);
                int L_PAD = 1;
                int colCnt = (symbols * 11 + 22 - L_PAD - 5) / 17 - 4;
                if (colCnt < 1) {
                    throw new RuntimeException("UCC-128 is too small");
                }
                cc.PDFColumns = colCnt;
                map2D = ((CC_C)cc).paintPDF417();
            } else {
                cc = new CC_A();
                cc.setCode(this.secondaryCode);
                cc.PDFColumns = this.cccColumns;
                map2D = ((CC_A)cc).paintPDF417();
            }
            if (!this.EAN128WithCCC) {
                if (symbols < 9) {
                    throw new RuntimeException("Linear component is too short.");
                }
                int rightMargin = (int)(Math.floor((symbols - 9) / 2) * (double)11);
                if (rightMargin > 0) {
                    rightMargin += 2;
                }
                this.currentX = this.leftMargin + (map[0].length - (map2D[0].length + rightMargin + 1));
            }
            BarCode.renderBarMap(g, this.currentX, this.currentY, map2D, this.barHeight2D, map2D.length, this.X, this.barColor);
            this.currentY += this.barHeight2D * map2D.length;
            this.currentX = this.leftMargin;
            int[][] separator = BarCode.createBarMap(map[0].length, 1, WHITE);
            for (int i = 0; i < map[0].length; ++i) {
                separator[0][i] = map[0][i] == BLACK ? WHITE : BLACK;
            }
            if (this.EAN128WithCCC) {
                int firstInteriorSpace = 8;
                int secondModule = 1;
                this.currentX = this.leftMargin + firstInteriorSpace - secondModule;
            } else {
                this.currentX = this.leftMargin;
            }
            BarCode.renderBarMap(g, this.currentX, this.currentY, separator, this.X, 1, this.X, this.barColor);
            this.currentY += this.X;
            linearComponentLeft = this.currentX;
        }
        BarCode.renderBarMap(g, this.currentX, this.currentY, map, this.barHeight, map.length, this.X, this.barColor);
        this.currentY += this.barHeight;
        this._$4882 += linearComponentLeft;
        if (this.textFont != null) {
            g.setColor(this.fontColor);
            g.setFont(this.textFont);
            if (this.humanReadableCode != null) {
                this._$4551 = this.humanReadableCode;
            }
            int TextH = g.getFontMetrics().getHeight();
            int charW = g.getFontMetrics().stringWidth("X");
            int toCenterX = (this._$4882 - linearComponentLeft - g.getFontMetrics().stringWidth(this._$4551)) / 2;
            if (toCenterX < 0) {
                toCenterX = 0;
            }
            g.drawString(this._$4551, linearComponentLeft + toCenterX, this.currentY + TextH + 4);
            this.currentY = this.currentY + TextH + 1;
        }
    }

    protected void renderEANUPC(Graphics g, int[][] map, int compositeColumns) {
        this.currentY = this.topMargin;
        int linearComponentTop = this.topMargin;
        int linearComponentLeft = this.leftMargin;
        this.currentX = this.leftMargin;
        int lastBarX = map[0].length - 1;
        int[][] map2D = null;
        int[][] separator = null;
        if (this.secondaryCode.length() > 0) {
            CC_A cc = new CC_A();
            cc.setCode(this.secondaryCode);
            cc.PDFColumns = compositeColumns;
            map2D = cc.paintPDF417();
            BarCode.renderBarMap(g, this.currentX, this.currentY, map2D, this.barHeight2D, map2D.length, this.X, this.barColor);
            this.currentY += this.barHeight2D * map2D.length;
            this.currentX = this.leftMargin;
            separator = BarCode.createBarMap(map[0].length + 2, 3, WHITE);
            separator[0][1] = BLACK;
            separator[0][lastBarX + 1] = BLACK;
            separator[1][0] = BLACK;
            separator[1][lastBarX + 2] = BLACK;
            separator[2][1] = BLACK;
            separator[2][lastBarX + 1] = BLACK;
            BarCode.renderBarMap(g, this.currentX + (map2D[0].length - separator[0].length), this.currentY, separator, this.X * 2, 3, this.X, this.barColor);
            this.currentY += this.X * 6;
            this.currentX = this.leftMargin + (map2D[0].length - 1 - map[0].length);
            linearComponentTop = this.currentY;
            linearComponentLeft = this.currentX;
        }
        int[] heights = new int[]{this.barHeight};
        BarCode.renderBarMap(g, this.currentX, this.currentY, map, heights, map.length, this.X, 0, this._$4935, this.barColor);
        this.currentY += this.barHeight;
        this.currentX = map2D != null ? this.leftMargin + this._$6604(map2D[0].length, ((void)separator[0]).length, map[0].length) : this.leftMargin + map[0].length;
        this._$4821 += linearComponentLeft;
        this._$4833 += linearComponentLeft;
        this._$4852 += linearComponentLeft;
        this._$4869 += linearComponentLeft;
        this._$4882 += linearComponentLeft;
        if (this.textFont != null) {
            int groupCenterX;
            g.setColor(this.fontColor);
            g.setFont(this.textFont);
            if (this.humanReadableCode != null) {
                this._$4551 = this.humanReadableCode;
            }
            int TextH = g.getFontMetrics().getHeight();
            int charW = g.getFontMetrics().stringWidth("X");
            if ((this.UPCEANSupplement2 || this.UPCEANSupplement5) && (this.barType == 3 || this.barType == 1 || this.barType == 4 || this.barType == 2)) {
                groupCenterX = (this._$4905 - this._$4891 - g.getFontMetrics().stringWidth(this._$4492)) / 2;
                if (groupCenterX < 0) {
                    groupCenterX = 0;
                }
                g.drawString(this._$4492, this._$4891 + groupCenterX, linearComponentTop + this._$4917 - 2);
            }
            if (this.barType == 2 && this.guardBars && this._$4551.length() >= 13) {
                groupCenterX = 0;
                g.drawString(this._$4551.substring(0, 1), linearComponentLeft - charW, this.currentY + TextH + 1);
                groupCenterX = (this._$4833 - this._$4821 - g.getFontMetrics().stringWidth(this._$4551.substring(1, 7))) / 2;
                if (groupCenterX < 0) {
                    groupCenterX = 0;
                }
                g.drawString(this._$4551.substring(1, 7), this._$4821 + groupCenterX, this.currentY + TextH + 1);
                groupCenterX = (this._$4869 - this._$4852 - g.getFontMetrics().stringWidth(this._$4551.substring(7, 13))) / 2;
                if (groupCenterX < 0) {
                    groupCenterX = 0;
                }
                g.drawString(this._$4551.substring(7, 13), this._$4852 + groupCenterX, this.currentY + TextH + 1);
                this.currentY = this.currentY + TextH + 1;
                return;
            }
            if (this.barType == 1 && this.guardBars && this._$4551.length() >= 12) {
                groupCenterX = 0;
                g.drawString(this._$4551.substring(0, 1), linearComponentLeft - charW, this.currentY + TextH + 1);
                groupCenterX = (this._$4833 - this._$4821 - g.getFontMetrics().stringWidth(this._$4551.substring(1, 6))) / 2;
                if (groupCenterX < 0) {
                    groupCenterX = 0;
                }
                g.drawString(this._$4551.substring(1, 6), this._$4821 + groupCenterX, this.currentY + TextH + 1);
                groupCenterX = (this._$4869 - this._$4852 - g.getFontMetrics().stringWidth(this._$4551.substring(6, 11))) / 2;
                if (groupCenterX < 0) {
                    groupCenterX = 0;
                }
                g.drawString(this._$4551.substring(6, 11), this._$4852 + groupCenterX, this.currentY + TextH + 1);
                g.drawString(this._$4551.substring(11, 12), this._$4882 + 3, this.currentY + TextH + 1);
                this.currentY = this.currentY + TextH + 1;
                return;
            }
            if (this.barType == 3 && this.guardBars && this._$4551.length() >= 8) {
                groupCenterX = 0;
                groupCenterX = (this._$4833 - this._$4821 - g.getFontMetrics().stringWidth(this._$4551.substring(0, 4))) / 2;
                if (groupCenterX < 0) {
                    groupCenterX = 0;
                }
                g.drawString(this._$4551.substring(0, 4), this._$4821 + groupCenterX, this.currentY + TextH + 1);
                groupCenterX = (this._$4869 - this._$4852 - g.getFontMetrics().stringWidth(this._$4551.substring(4, 8))) / 2;
                if (groupCenterX < 0) {
                    groupCenterX = 0;
                }
                g.drawString(this._$4551.substring(4, 8), this._$4852 + groupCenterX, this.currentY + TextH + 1);
                this.currentY = this.currentY + TextH + 1;
                return;
            }
            if (this.barType == 4 && this.guardBars) {
                groupCenterX = 0;
                if (this.EANUPCPrintFlag) {
                    g.drawString(this.code.substring(0, 1), linearComponentLeft - charW, this.currentY + TextH + 1);
                }
                if ((groupCenterX = (this._$4869 - this._$4821 - g.getFontMetrics().stringWidth(this._$4551)) / 2) < 0) {
                    groupCenterX = 0;
                }
                g.drawString(this._$4551, this._$4821 + groupCenterX, this.currentY + TextH + 1);
                this.currentY = this.barHeight + TextH + 1 + this.topMargin;
                return;
            }
        }
    }

    private int _$6054(String[] s1, String c) {
        for (int j = 0; j < s1.length; ++j) {
            if (s1[j].compareTo(c) != 0) continue;
            return j;
        }
        return -1;
    }

    private String _$6029(String c) {
        String FNC1 = "\u00ca";
        String FNC2 = "\u00c5";
        String FNC3 = "\u00c4";
        String FNC4A = "\u00c9";
        String FNC4B = "\u00c8";
        if (c.compareTo(FNC1) == 0) {
            c = "_102";
        }
        if (c.compareTo(FNC4A) == 0) {
            c = "_101";
        }
        if (c.compareTo(FNC4B) == 0) {
            c = "_100";
        }
        if (c.compareTo(FNC2) == 0) {
            c = "_97";
        }
        if (c.compareTo(FNC3) == 0) {
            c = "_96";
        }
        return c;
    }

    private boolean _$6065(String c) {
        if (c.length() > 1) {
            return false;
        }
        return c.charAt(0) >= '0' && c.charAt(0) <= '9';
    }

    private int _$6090(String s, int i) {
        for (int j = i; j < s.length(); ++j) {
            if (s.charAt(j) < 'a' || s.charAt(j) > 'z') continue;
            return j;
        }
        return 9999;
    }

    private int _$6072(String s, int i) {
        for (int j = i; j < s.length(); ++j) {
            if (s.charAt(j) >= ' ') continue;
            return j;
        }
        return 9999;
    }

    private boolean _$6643(String s, int i) {
        boolean even = true;
        for (int j = i; j < s.length(); ++j) {
            if (!this._$6065("".concat(String.valueOf(String.valueOf(s.charAt(j)))))) {
                return even;
            }
            even = !even;
        }
        return even;
    }

    private char _$6106(String s, int i) {
        if (s.length() >= i + 4 && this._$6065("".concat(String.valueOf(String.valueOf(s.charAt(i))))) && this._$6065("".concat(String.valueOf(String.valueOf(s.charAt(i + 1))))) && this._$6065("".concat(String.valueOf(String.valueOf(s.charAt(i + 2))))) && this._$6065("".concat(String.valueOf(String.valueOf(s.charAt(i + 3)))))) {
            return 'C';
        }
        if (this._$6072(s, i) < this._$6090(s, i)) {
            return 'A';
        }
        return 'B';
    }

    private String _$3842(String code) {
        char c = '\u0000';
        int longi = code.length();
        String result = "";
        boolean done = false;
        for (int i = 0; i < longi; ++i) {
            c = code.charAt(i);
            if (c == '~') {
                if (i >= longi - 1) continue;
                char nextc = code.charAt(i + 1);
                if (nextc == '~') {
                    result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf('~')));
                    ++i;
                    continue;
                }
                if (i >= longi - 3) continue;
                String ascString = code.substring(i + 1, i + 4);
                int asc = 0;
                try {
                    asc = new Integer(ascString);
                }
                catch (Exception e) {
                    asc = 0;
                }
                if (asc > 255) {
                    asc = 255;
                }
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf((char)asc)));
                i += 3;
                continue;
            }
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(c)));
        }
        return result;
    }

    private int _$6604(int a, int b, int c) {
        if (a >= b && a >= c) {
            return a;
        }
        if (b >= a && b >= c) {
            return b;
        }
        return c;
    }

    protected static int addBarMap(int[][] map, int x, int y, int w, boolean black) {
        return BarCode.addBarMap(map, x, y, w, black, false, BLACK);
    }

    protected static int[][] createBarMap(int w, int h, int initValue) {
        int[][] map = new int[h][w];
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                map[i][j] = initValue;
            }
        }
        return map;
    }

    protected static void printBarMap(int[][] map, int mheight) {
        for (int i = 0; i < mheight; ++i) {
            System.out.println("");
            for (int j = 0; j < map[0].length; ++j) {
                if (map[i][j] == BLACK) {
                    System.out.print("X");
                }
                if (map[i][j] == BLACK_SUPLEMENT) {
                    System.out.print("X");
                }
                if (map[i][j] == BLACK_GUARDBAR) {
                    System.out.print("X");
                }
                if (map[i][j] == WHITE) {
                    System.out.print(" ");
                }
                if (map[i][j] != EMPTY) continue;
                System.out.print("_");
            }
        }
    }

    protected static void renderBarMap(Graphics g, int x, int y, int[][] map, int rowHeight, int mapHeight, int moduleWidth, Color barColor) {
        int[] heights = new int[mapHeight];
        for (int i = 0; i < mapHeight; ++i) {
            heights[i] = rowHeight;
        }
        BarCode.renderBarMap(g, x, y, map, heights, mapHeight, moduleWidth, 0, 0, barColor);
    }

    protected static void renderBarMap(Graphics g, int x, int y, int[][] map, int[] rowHeights, int mapHeight, int moduleWidth, int supBarHeight, int guardBarHeight, Color barColor) {
        int x1 = x;
        int y1 = y;
        int currentValue = 0;
        int currentLength = 0;
        for (int i = 0; i < mapHeight; ++i) {
            x1 = x;
            currentValue = WHITE;
            currentLength = 0;
            for (int j = 0; j < map[0].length; ++j) {
                if (currentValue == BLACK && (map[i][j] == WHITE || map[i][j] == EMPTY)) {
                    x1 += BarCode.addBarAt(g, x1, y1, currentLength * moduleWidth, rowHeights[i], true, barColor);
                    currentLength = 0;
                    currentValue = WHITE;
                }
                if (currentValue == WHITE && map[i][j] != WHITE && map[i][j] != EMPTY) {
                    x1 += BarCode.addBarAt(g, x1, y1, currentLength * moduleWidth, rowHeights[i], false, barColor);
                    currentLength = 0;
                    currentValue = map[i][j];
                }
                if (currentValue == BLACK_GUARDBAR && (map[i][j] == WHITE || map[i][j] == EMPTY)) {
                    x1 += BarCode.addBarAt(g, x1, y1, currentLength * moduleWidth, rowHeights[i] + guardBarHeight, true, barColor);
                    currentLength = 0;
                    currentValue = WHITE;
                }
                if (currentValue == BLACK_SUPLEMENT && (map[i][j] == WHITE || map[i][j] == EMPTY)) {
                    x1 += BarCode.addBarAt(g, x1, y1 + (rowHeights[i] - supBarHeight), currentLength * moduleWidth, supBarHeight, true, barColor);
                    currentLength = 0;
                    currentValue = WHITE;
                }
                ++currentLength;
            }
            x1 = currentValue == BLACK_GUARDBAR ? (x1 += BarCode.addBarAt(g, x1, y1, currentLength * moduleWidth, rowHeights[i] + guardBarHeight, true, barColor)) : (currentValue == BLACK_SUPLEMENT ? (x1 += BarCode.addBarAt(g, x1, y1 + (rowHeights[i] - supBarHeight), currentLength * moduleWidth, supBarHeight, true, barColor)) : (x1 += BarCode.addBarAt(g, x1, y1, currentLength * moduleWidth, rowHeights[i], currentValue == BLACK, barColor)));
            y1 += rowHeights[i];
        }
    }

    protected static int addBarAt(Graphics g, int x, int y, int w, int h, boolean black, Color barColor) {
        if (black) {
            g.setColor(barColor);
            g.fillRect(x, y, w, h);
        }
        return w;
    }

    protected static int addBarMap(int[][] map, int x, int y, int w, boolean black, boolean reverse, int barType) {
        int bar = barType;
        if (reverse) {
            if (black) {
                for (int i = x; i > x - w; --i) {
                    map[y][i] = bar;
                }
            } else {
                for (int i = x; i > x - w; --i) {
                    map[y][i] = WHITE;
                }
            }
        } else if (black) {
            for (int i = x; i < x + w; ++i) {
                map[y][i] = bar;
            }
        } else {
            for (int i = x; i < x + w; ++i) {
                map[y][i] = WHITE;
            }
        }
        return w;
    }

    protected static double mod(double a, double b) {
        double f = a / b;
        double i = Math.round(f);
        if (i > f) {
            i -= 1.0;
        }
        return a - b * i;
    }

    static {
        UPCA = 1;
        EAN13 = 2;
        EAN8 = 3;
        UPCE = 4;
        EAN128 = 5;
        RSS14 = 6;
        RSSLIMITED = 7;
        RSSEXPANDED = 8;
        d = 0;
        WHITE = 0;
        BLACK = 1;
        BLACK_GUARDBAR = 2;
        BLACK_SUPLEMENT = 3;
        EMPTY = -1;
    }
}

