/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rss;

import com.java4less.rss.BarCode;
import com.java4less.rss.RSS;
import com.java4less.rss.RSSExpanded;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;

public class BCApplet
extends Applet {
    protected BarCode barcode = null;
    protected String codeType = "";
    protected boolean isStandalone = false;

    public BCApplet() {
        this.setLayout(new BorderLayout());
    }

    public void start() {
        this.barcode.paint(this.getGraphics());
    }

    public void refresh() {
        this.barcode.paint(this.barcode.getGraphics());
        this.paintAll(this.getGraphics());
    }

    public void init() {
        if (this.barcode == null) {
            this.barcode = new RSSExpanded();
        }
        if (!this.isStandalone) {
            this.add("Center", this.barcode);
        }
        this._$149698("CODE_TYPE");
        this._$149698("X");
        this._$149698("H");
        this._$149698("BAR_HEIGHT");
        this._$149698("BAR_COLOR");
        this._$149698("FONT_COLOR");
        this._$149698("TEXT_FONT");
        this._$149698("UPCE_SYSTEM");
        this._$149698("BACK_COLOR");
        this._$149698("LEFT_MARGIN");
        this._$149698("TOP_MARGIN");
        this._$149698("PRIMARY_CODE");
        this._$149698("SECONDARY_CODE");
        this._$149698("READABLE_CODE");
        this._$149698("READABLE_SECONDARY_CODE");
        this._$149698("PROCESS_TILDE");
        this._$149698("GUARDBARS");
        this._$149698("ROTATE");
        this._$149698("SUPPLEMENT");
        this._$149698("SUPPLEMENT_HEIGHT");
        this._$149698("SUPPLEMENT_SEPARATION");
        this._$149698("RSS_FORMAT");
        this._$149698("BAR_HEIGHT2D");
        this._$149698("CCC_COLUMNS");
        this._$149698("EAN128_CCC");
        this._$149698("EANUPC_FLAG");
        this._$149698("RSS_FORMAT");
    }

    public void setParameter(String p, String v) {
        try {
            if (v == null) {
                return;
            }
            if (p.compareTo("RSS_FORMAT") == 0) {
                if (this.barcode instanceof RSS) {
                    if (v.compareTo("FORMAT_REGULAR") == 0) {
                        ((RSS)this.barcode).format = RSS.FORMAT_REGULAR;
                    }
                    if (v.compareTo("FORMAT_TRUNCATED") == 0) {
                        ((RSS)this.barcode).format = RSS.FORMAT_TRUNCATED;
                    }
                    if (v.compareTo("FORMAT_STACKED") == 0) {
                        ((RSS)this.barcode).format = RSS.FORMAT_STACKED;
                    }
                    if (v.compareTo("FORMAT_STACKED_OMNIDIRECTIONAL") == 0) {
                        ((RSS)this.barcode).format = RSS.FORMAT_STACKED_OMNIDIRECTIONAL;
                    }
                    if (p.compareTo("BAR_HEIGHT2D") == 0) {
                        ((RSS)this.barcode).barHeight2D = new Integer(v);
                    }
                }
                if (this.barcode instanceof RSSExpanded) {
                    if (v.compareTo("FORMAT_EXPANDED") == 0) {
                        ((RSS)this.barcode).format = RSS.FORMAT_EXPANDED;
                    }
                    if (v.compareTo("FORMAT_EXPANDED_STACKED") == 0) {
                        ((RSS)this.barcode).format = RSS.FORMAT_EXPANDED_STACKED;
                    }
                }
            }
            if (p.compareTo("CODE_TYPE") == 0) {
                this.barcode.setBarType(v);
            }
            if (p.compareTo("CCC_COLUMNS") == 0) {
                this.barcode.cccColumns = new Integer(v);
            }
            if (p.compareTo("EAN128_CCC") == 0) {
                this.barcode.EAN128WithCCC = v.toUpperCase().equals("Y");
            }
            if (p.compareTo("EANUPC_FLAG") == 0) {
                this.barcode.EANUPCPrintFlag = v.toUpperCase().equals("Y");
            }
            if (p.compareTo("SECONDARY_CODE") == 0) {
                this.barcode.setSecondaryCode(v);
            }
            if (p.compareTo("PRIMARY_CODE") == 0) {
                this.barcode.setCode(v);
            }
            if (p.compareTo("READABLE_CODE") == 0) {
                this.barcode.setHumanReadableCode(v);
            }
            if (p.compareTo("READABLE_SECONDARY_CODE") == 0) {
                this.barcode.setHumanReadableCode(v);
            }
            if (p.compareTo("SUPPLEMENT_SEPARATION") == 0) {
                this.barcode.supSeparation = new Integer(v);
            }
            if (p.compareTo("SUPPLEMENT_SEPARATION") == 0) {
                this.barcode.supSeparation = new Integer(v);
            }
            if (p.compareTo("BAR_HEIGHT") == 0) {
                this.barcode.setBarHeight(new Integer(v));
            }
            if (p.compareTo("BAR_HEIGHT2D") == 0) {
                this.barcode.setBarHeight2D(new Integer(v));
            }
            if (p.compareTo("SUPPLEMENT_HEIGHT") == 0) {
                this.barcode.supHeight = new Double(v);
            }
            if (p.compareTo("SUPPLEMENT") == 0) {
                this.barcode.UPCEANSupplement2 = false;
                this.barcode.UPCEANSupplement5 = false;
                if (v.compareTo("2") == 0) {
                    this.barcode.UPCEANSupplement2 = true;
                }
                if (v.compareTo("5") == 0) {
                    this.barcode.UPCEANSupplement5 = true;
                }
            }
            if (p.compareTo("ROTATE") == 0) {
                this.barcode.rotate = (int)new Double(v).doubleValue();
            }
            if (p.compareTo("X") == 0) {
                this.barcode.X = new Integer(v);
            }
            if (p.compareTo("LEFT_MARGIN") == 0) {
                this.barcode.leftMargin = new Integer(v);
            }
            if (p.compareTo("TOP_MARGIN") == 0) {
                this.barcode.topMargin = new Integer(v);
            }
            if (p.compareTo("BAR_COLOR") == 0) {
                this.barcode.barColor = this.convertColor(v);
            }
            if (p.compareTo("PROCESS_TILDE") == 0) {
                boolean bl = this.barcode.processTilde = v.compareTo("Y") == 0;
            }
            if (p.compareTo("FONT_COLOR") == 0) {
                this.barcode.fontColor = this.convertColor(v);
            }
            if (p.compareTo("BACK_COLOR") == 0) {
                this.barcode.backColor = this.convertColor(v);
            }
            if (p.compareTo("GUARDBARS") == 0) {
                boolean bl = this.barcode.guardBars = v.compareTo("Y") == 0;
            }
            if (p.compareTo("UPCE_SYSTEM") == 0) {
                this.barcode.UPCESytem = new String(String.valueOf(String.valueOf(v)).concat("1")).charAt(0);
            }
            if (p.compareTo("TEXT_FONT") == 0) {
                this.barcode.textFont = this.convertFont(v);
            }
            if (p.compareTo("H") == 0) {
                this.barcode.H = new Double(v);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Color convertColor(String c) {
        if (c.compareTo("NULL") == 0) {
            return null;
        }
        if (c.compareTo("RED") == 0) {
            return Color.red;
        }
        if (c.compareTo("BLACK") == 0) {
            return Color.black;
        }
        if (c.compareTo("BLUE") == 0) {
            return Color.blue;
        }
        if (c.compareTo("CYAN") == 0) {
            return Color.cyan;
        }
        if (c.compareTo("DARKGRAY") == 0) {
            return Color.darkGray;
        }
        if (c.compareTo("GRAY") == 0) {
            return Color.gray;
        }
        if (c.compareTo("GREEN") == 0) {
            return Color.green;
        }
        if (c.compareTo("LIGHTGRAY") == 0) {
            return Color.lightGray;
        }
        if (c.compareTo("MAGENTA") == 0) {
            return Color.magenta;
        }
        if (c.compareTo("ORANGE") == 0) {
            return Color.orange;
        }
        if (c.compareTo("PINK") == 0) {
            return Color.pink;
        }
        if (c.compareTo("WHITE") == 0) {
            return Color.white;
        }
        if (c.compareTo("YELLOW") == 0) {
            return Color.yellow;
        }
        try {
            Color color = Color.decode(c);
            return color;
        }
        catch (Exception e) {
            Color color = Color.black;
            return color;
        }
    }

    protected Font convertFont(String f) {
        String[] items = this._$149747(f);
        if (items == null) {
            return null;
        }
        if (items.length < 3) {
            return null;
        }
        int s = 0;
        if (items[1].compareTo("BOLD") == 0) {
            s = 1;
        }
        if (items[1].compareTo("ITALIC") == 0) {
            s = 2;
        }
        try {
            Font font = new Font(items[0], s, new Integer(items[2]));
            return font;
        }
        catch (Exception e) {
            Font font = null;
            return font;
        }
    }

    protected String getStringParam(String Param, String def) {
        return this._$13195(Param, def);
    }

    private void _$149698(String p) {
        String v = this.getStringParam(p, "");
        if (v.length() == 0) {
            return;
        }
        this.setParameter(p, v);
    }

    private String _$13195(String key, String def) {
        if (this.isStandalone) {
            return def;
        }
        if (this.getParameter(key) != null) {
            return this.getParameter(key);
        }
        return def;
    }

    private String[] _$149747(String items) {
        String[] itema = new String[500];
        int itemCount = 0;
        int p = items.indexOf("|");
        while (p >= 0) {
            itema[itemCount++] = items.substring(0, p);
            items = items.substring(p + 1, items.length());
            p = items.indexOf("|");
        }
        if (items.compareTo("") != 0) {
            itema[itemCount++] = items;
        }
        if (itemCount == 0) {
            return null;
        }
        String[] result = new String[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            result[i] = itema[i];
        }
        return result;
    }

    private Integer _$149797(String Param, Integer def) {
        try {
            String s = this._$13195(Param, "");
            if (s.compareTo("") == 0) {
                Integer n = def;
                return n;
            }
            Integer n = new Integer(s);
            return n;
        }
        catch (Exception e) {
            Integer n = def;
            return n;
        }
    }

    private Double _$149808(String Param, Double def) {
        try {
            String s = this._$13195(Param, "");
            if (s.compareTo("") == 0) {
                Double d = def;
                return d;
            }
            Double d = new Double(s);
            return d;
        }
        catch (Exception e) {
            Double d = def;
            return d;
        }
    }
}

