


import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import com.java4less.rchart.*;
import com.java4less.rchart.gc.GraphicsProvider;
import com.java4less.rchart.gc.swt.SwtGraphicsProvider;
import com.java4less.rchart.swt.*;

/**
 * Sample application for displaying charts in SWT
 */
public class SwtExamples  {

	public static void main(String[] args) {
		SwtExamples app=new SwtExamples();
		app.runExamples();
	}
	
	// menu items in the sample application
	MenuItem itemLoad;
	MenuItem itemSave;			
	MenuItem itemExit;

	MenuItem itemExample0;
	MenuItem itemExample1;
	MenuItem itemExample2;
	MenuItem itemExample3;
	MenuItem itemExample4;
	MenuItem itemExample5;
	MenuItem itemExample6;
	MenuItem itemExample7;
	MenuItem itemExample8;
	MenuItem itemExample9;
	MenuItem itemExample10;
	MenuItem itemExample11;
	MenuItem itemExample12;
	MenuItem itemExample13;
	MenuItem itemExample14;
	MenuItem itemExample15;
	
	MenuItem itemLoader0;
	MenuItem itemLoader1;
	MenuItem itemLoader2;
	MenuItem itemLoader3;
	MenuItem itemLoader4;
	MenuItem itemLoader5;
	MenuItem itemLoader6;
	MenuItem itemLoader7;
	MenuItem itemLoader8;
	MenuItem itemLoader9;
	MenuItem itemLoader10;
	MenuItem itemLoader11;
	MenuItem itemLoader12;
	MenuItem itemLoader13;
	MenuItem itemLoader14;
	MenuItem itemLoader15;
	MenuItem itemLoader16;
	MenuItem itemLoader17;
	MenuItem itemLoader18;
	MenuItem itemLoader19;
	MenuItem itemLoader20;
	MenuItem itemLoader21;
	MenuItem itemLoader22;
	MenuItem itemLoader23;
	MenuItem itemLoader24;
	MenuItem itemLoader25;
	MenuItem itemLoader26;
	
	
	ChartViewer chartViewer;
	Shell shell;
	
	// create chart listener 
	ChartAdapter chartAdapter=new ChartAdapter() {
					public void chartEvent(Chart c,int type) {
						if (type==ChartListener.EVENT_POINT_CLICKED) {
							MessageBox msg=new MessageBox(shell);
							msg.setText("Point clicked");
							msg.setMessage("You just clicked on series "+ c.selectedSerie.name.toUpperCase() + " point "+ (c.selectedSeriePoint+1));
							msg.open();							
						}
						
						// rebuild chart with new data
						if (type==ChartListener.EVENT_BEFORE_UPDATE) {
							// // get a new random value between 0 and 40 and update 3 of the values in the serie
							int newValue=(int) (System.currentTimeMillis() % 40); 
							c.plotters[0].getSerie(0).replaceYValueAt(1,newValue);
							c.plotters[0].getSerie(0).replaceYValueAt(2,newValue+10);
							c.plotters[0].getSerie(0).replaceYValueAt(3,newValue-10);							

							// do not allow the chart to be rebuilt from the original parameters
							c.autoRebuild=false;
							
							// an alternative would be:
							// set new parameter
							//c.loader.setParameter("SERIE_DATA_1","10|20|30 ....");
							// rebuild chart from parameters
							// c.autoRebuild=true;
												
						}						
						
					}
				};	
				
	// create chart listener for the drill down chart
	ChartAdapter chartAdapterDrillDown=new ChartAdapter() {
						public void chartEvent(Chart c,int type) {
							// load subchart
							if (type==ChartListener.EVENT_POINT_CLICKED) {		
								if (c.selectedSeriePoint==0) loadNewChart(null,"examples/subpie1.txt");
								else if (c.selectedSeriePoint==1) loadNewChart(null,"examples/subpie2.txt");
								else if (c.selectedSeriePoint==2) loadNewChart(null,"examples/subpie3.txt");		
							}						
						}
					};	
	
	// create chart listener for the drill down chart
	ChartAdapter chartAdapterRealtime=new ChartAdapter() {
						public void chartEvent(Chart c,int type) {
							// load subchart
							if (type==ChartListener.EVENT_BEFORE_UPDATE) createRealtimedata(chartViewer.getChart().loader);
						}
					};		
	

	
	
	public void runExamples() {	

		// initialize SWT mode
		GraphicsProvider.setMode(GraphicsProvider.MODE_SWT);			
		Display display = new Display();		
		SwtGraphicsProvider.setDefaultDisplay(display);
		
		// create main window
		shell = new Shell(display,SWT.DIALOG_TRIM);
		shell.setText("Chart examples");
		shell.setSize(500,500);
		shell.setBounds(100,100,500,500);
		
		// create menus
		Menu menuBar = new Menu(shell, SWT.BAR);
		shell.setMenuBar(menuBar);
		MenuItem item = new MenuItem(menuBar, SWT.CASCADE);
		Menu menu = new Menu(item);
		item.setText("File");
		item.setMenu(menu);
		itemLoad = new MenuItem(menu, SWT.PUSH);
		itemLoad.setText("Load Chart");		
		itemSave = new MenuItem(menu, SWT.PUSH);
		itemSave.setText("Save as Bmp");				
		itemExit = new MenuItem(menu, SWT.PUSH);
		itemExit.setText("Exit");		
		item = new MenuItem(menuBar, SWT.CASCADE);
		menu = new Menu(item);
		item.setText("Examples Java API");
		item.setMenu(menu);
		

		itemExample0 = new MenuItem(menu, SWT.PUSH);
		itemExample0.setText("Columns with Tips (zoom and scroll)");	
		itemExample1 = new MenuItem(menu, SWT.PUSH);
		itemExample1.setText("Linechart (clipped and transparent)");			
		itemExample2 = new MenuItem(menu, SWT.PUSH);
		itemExample2.setText("Horiz. Bars");			
		itemExample3 = new MenuItem(menu, SWT.PUSH);
		itemExample3.setText("Pie chart");			
		itemExample4 = new MenuItem(menu, SWT.PUSH);
		itemExample4.setText("Pie chart 3D");			
		itemExample5 = new MenuItem(menu, SWT.PUSH);
		itemExample5.setText("Area chart");			
		itemExample6 = new MenuItem(menu, SWT.PUSH);
		itemExample6.setText("Bar chart");			
		itemExample7 = new MenuItem(menu, SWT.PUSH);
		itemExample7.setText("Stacked bars");			
		itemExample8 = new MenuItem(menu, SWT.PUSH);
		itemExample8.setText("Bar chart 3D (with negative bar)");			
		itemExample9 = new MenuItem(menu, SWT.PUSH);
		itemExample9.setText("Line chart 3D (gradient background)");			
		itemExample10 = new MenuItem(menu, SWT.PUSH);
		itemExample10.setText("Combined");			
		itemExample11 = new MenuItem(menu, SWT.PUSH);
		itemExample11.setText("OCHL");			
		itemExample12 = new MenuItem(menu, SWT.PUSH);
		itemExample12.setText("Radar chart (transparent filling)");			
		itemExample13 = new MenuItem(menu, SWT.PUSH);
		itemExample13.setText("Bubble chart");			
		itemExample14 = new MenuItem(menu, SWT.PUSH);
		itemExample14.setText("Max./Min.");			
		itemExample15 = new MenuItem(menu, SWT.PUSH);
		itemExample15.setText("Curves and least square");	
		
		item = new MenuItem(menuBar, SWT.CASCADE);
		menu = new Menu(item);
		item.setText("Examples ChartLoader");
		item.setMenu(menu);		

		itemLoader21 = new MenuItem(menu, SWT.PUSH);
		itemLoader21.setText("Several Y Axis and target zone");
		itemLoader22 = new MenuItem(menu, SWT.PUSH);
		itemLoader22.setText("Plotter Target zones");
		itemLoader23 = new MenuItem(menu, SWT.PUSH);
		itemLoader23.setText("Images , notes and gradients");
		itemLoader24 = new MenuItem(menu, SWT.PUSH);
		itemLoader24.setText("Pattern filling and note");
		itemLoader25 = new MenuItem(menu, SWT.PUSH);
		itemLoader25.setText("4 subcharts");
		itemLoader26 = new MenuItem(menu, SWT.PUSH);
		itemLoader26.setText("Stacked axis");	
		itemLoader20 = new MenuItem(menu, SWT.PUSH);
		itemLoader20.setText("Realtime chart with time axis");			
		itemLoader0 = new MenuItem(menu, SWT.PUSH);
		itemLoader0.setText("Combined chart, two Y axis, vertical labels");	
		itemLoader1 = new MenuItem(menu, SWT.PUSH);
		itemLoader1.setText("Gauge");	
		itemLoader2 = new MenuItem(menu, SWT.PUSH);
		itemLoader2.setText("Events (dates on axis)");					
		itemLoader3 = new MenuItem(menu, SWT.PUSH);
		itemLoader3.setText("Radar chart");	
		itemLoader4 = new MenuItem(menu, SWT.PUSH);
		itemLoader4.setText("Area chart (multiline axis labels)");			
		itemLoader5 = new MenuItem(menu, SWT.PUSH);
		itemLoader5.setText("Line chart (clickable points and line styles)");			
		itemLoader6 = new MenuItem(menu, SWT.PUSH);
		itemLoader6.setText("Line chart 3D");			
		itemLoader7 = new MenuItem(menu, SWT.PUSH);
		itemLoader7.setText("Pie chart 3D");	
		itemLoader8 = new MenuItem(menu, SWT.PUSH);
		itemLoader8.setText("Bar chart 3D (with realtime update)");	
		itemLoader9 = new MenuItem(menu, SWT.PUSH);
		itemLoader9.setText("Bar chart (different colors)");	
		itemLoader10 = new MenuItem(menu, SWT.PUSH);
		itemLoader10.setText("Scatter chart (with frame axis)");	
		itemLoader11 = new MenuItem(menu, SWT.PUSH);
		itemLoader11.setText("Bubble chart");			
		itemLoader12 = new MenuItem(menu, SWT.PUSH);
		itemLoader12.setText("Area Chart (log scale)");	
		itemLoader13 = new MenuItem(menu, SWT.PUSH);
		itemLoader13.setText("Curves (B-SP Lines) with filling");	
		itemLoader14 = new MenuItem(menu, SWT.PUSH);
		itemLoader14.setText("Candlestick");	
		itemLoader15 = new MenuItem(menu, SWT.PUSH);
		itemLoader15.setText("Combined chart (show position as tip)");	
		itemLoader16 = new MenuItem(menu, SWT.PUSH);
		itemLoader16.setText("Stacked bar chart (suppress labels)");	
		itemLoader17 = new MenuItem(menu, SWT.PUSH);
		itemLoader17.setText("X Axis on top (and multiline Tips)");	
		itemLoader18 = new MenuItem(menu, SWT.PUSH);
		itemLoader18.setText("Line chart with NULL values");			
		itemLoader19 = new MenuItem(menu, SWT.PUSH);
		itemLoader19.setText("Drill down Chart");
		
				
		SelectionAdapter menuListener= new SelectionAdapter() {
		 	public void widgetSelected(SelectionEvent e) {
				menuSelected(e);
		 	}
		 };		
		
		itemSave.addSelectionListener(menuListener);
		itemExit.addSelectionListener(menuListener);
		itemLoad.addSelectionListener(menuListener);
		itemExample0.addSelectionListener(menuListener);
		itemExample1.addSelectionListener(menuListener);
		itemExample2.addSelectionListener(menuListener);
		itemExample3.addSelectionListener(menuListener);
		itemExample4.addSelectionListener(menuListener);
		itemExample5.addSelectionListener(menuListener);
		itemExample6.addSelectionListener(menuListener);
		itemExample7.addSelectionListener(menuListener);
		itemExample8.addSelectionListener(menuListener);
		itemExample9.addSelectionListener(menuListener);
		itemExample10.addSelectionListener(menuListener);
		itemExample11.addSelectionListener(menuListener);
		itemExample12.addSelectionListener(menuListener);
		itemExample13.addSelectionListener(menuListener);
		itemExample14.addSelectionListener(menuListener);
		itemExample15.addSelectionListener(menuListener);
		itemLoader0.addSelectionListener(menuListener);
		itemLoader1.addSelectionListener(menuListener);
		itemLoader2.addSelectionListener(menuListener);
		itemLoader3.addSelectionListener(menuListener);
		itemLoader4.addSelectionListener(menuListener);
		itemLoader5.addSelectionListener(menuListener);	
		itemLoader6.addSelectionListener(menuListener);	
		itemLoader7.addSelectionListener(menuListener);	
		itemLoader8.addSelectionListener(menuListener);			
		itemLoader9.addSelectionListener(menuListener);
		itemLoader10.addSelectionListener(menuListener);
		itemLoader11.addSelectionListener(menuListener);
		itemLoader12.addSelectionListener(menuListener);
		itemLoader13.addSelectionListener(menuListener);
		itemLoader14.addSelectionListener(menuListener);
		itemLoader15.addSelectionListener(menuListener);
		itemLoader16.addSelectionListener(menuListener);
		itemLoader17.addSelectionListener(menuListener);
		itemLoader18.addSelectionListener(menuListener);
		itemLoader19.addSelectionListener(menuListener);
		itemLoader20.addSelectionListener(menuListener);
		itemLoader21.addSelectionListener(menuListener);	
		itemLoader22.addSelectionListener(menuListener);	
		itemLoader23.addSelectionListener(menuListener);	
		itemLoader24.addSelectionListener(menuListener);	
		itemLoader25.addSelectionListener(menuListener);	
		itemLoader26.addSelectionListener(menuListener);			
		 
		chartViewer=new ChartViewer(shell,SWT.NONE);
			
		chartViewer.setBounds(shell.getClientArea().x,shell.getClientArea().y,shell.getClientArea().width,shell.getClientArea().height-20);

		chartViewer.changePointer=true;
		chartViewer.setChart(ChartExamples.getDefaultChart());

		shell.open();
		
		
		while(!shell.isDisposed())
		if(!display.readAndDispatch())
		display.sleep();
		display.dispose();
		
	}
	
	
	/**
	 * menu item selected, load selected chart
	 * @param e
	 */	
	
	public void menuSelected(SelectionEvent e) {
		loadNewChart(e.getSource(),null);
	}
	
	/**
	 * a new menu item has been selected, load new chart
	 * @param menuItem
	 * @param dataFile chartfile to load
	 */
	private void loadNewChart(Object menuItem,String dataFile) {
		
		Chart c=null;
		String fileToLoad=dataFile;
		
		if (menuItem==this.itemExample0) c=ChartExamples.getDefaultChart();
		if (menuItem==this.itemExample1) c=ChartExamples.Example1();
		if (menuItem==this.itemExample2) c=ChartExamples.Example2();
		if (menuItem==this.itemExample3) c=ChartExamples.Example3();
		if (menuItem==this.itemExample4) c=ChartExamples.Example4();
		if (menuItem==this.itemExample5) c=ChartExamples.Example5();
		if (menuItem==this.itemExample6) c=ChartExamples.Example6();
		if (menuItem==this.itemExample7) c=ChartExamples.Example7();
		if (menuItem==this.itemExample8) c=ChartExamples.Example8();
		if (menuItem==this.itemExample9) c=ChartExamples.Example9();
		if (menuItem==this.itemExample10) c=ChartExamples.Example10();
		if (menuItem==this.itemExample11) c=ChartExamples.Example11();
		if (menuItem==this.itemExample12) c=ChartExamples.Example12();
		if (menuItem==this.itemExample13) c=ChartExamples.Example13();
		if (menuItem==this.itemExample14) c=ChartExamples.Example14();
		if (menuItem==this.itemExample15) c=ChartExamples.Example15();
		if (menuItem==this.itemLoader0) fileToLoad="examplesSWT/combinedChart.txt";
		if (menuItem==this.itemLoader1) fileToLoad="examplesSWT/gauge.txt";
		if (menuItem==this.itemLoader2) fileToLoad="examplesSWT/event.txt";
		if (menuItem==this.itemLoader3) fileToLoad="examplesSWT/radarChart.txt";
		if (menuItem==this.itemLoader4) fileToLoad="examplesSWT/areaChart.txt";
		if (menuItem==this.itemLoader5) fileToLoad="examplesSWT/lineChart.txt";
		if (menuItem==this.itemLoader6) fileToLoad="examplesSWT/lineChart3D.txt";
		if (menuItem==this.itemLoader7) fileToLoad="examplesSWT/pieChart3D.txt";
		if (menuItem==this.itemLoader8) fileToLoad="examplesSWT/barChart3D.txt";
		if (menuItem==this.itemLoader9) fileToLoad="examplesSWT/barChart.txt";
		if (menuItem==this.itemLoader10) fileToLoad="examplesSWT/scatterChart.txt";
		if (menuItem==this.itemLoader11) fileToLoad="examplesSWT/bubbleChart.txt";
		if (menuItem==this.itemLoader12) fileToLoad="examplesSWT/areaChartLog.txt";
		if (menuItem==this.itemLoader13) fileToLoad="examplesSWT/areaCurves.txt";
		if (menuItem==this.itemLoader14) fileToLoad="examplesSWT/candleStick.txt";
		if (menuItem==this.itemLoader15) fileToLoad="examplesSWT/combined2Positions.txt";
		if (menuItem==this.itemLoader16) fileToLoad="examplesSWT/stackedBar.txt";
		if (menuItem==this.itemLoader17) fileToLoad="examplesSWT/axisOnTop.txt";
		if (menuItem==this.itemLoader18) fileToLoad="examplesSWT/linechartNULLS.txt";
		if (menuItem==this.itemLoader19) fileToLoad="examplesSWT/PieDrillDown.txt";
		if (menuItem==this.itemLoader20) fileToLoad="examplesSWT/realtime.txt";
		if (menuItem==this.itemLoader21) fileToLoad="examplesSWT/MultiAxis.txt";
		if (menuItem==this.itemLoader22) fileToLoad="examplesSWT/targetZones.txt";
		if (menuItem==this.itemLoader23) fileToLoad="examplesSWT/barImages.txt";
		if (menuItem==this.itemLoader24) fileToLoad="examplesSWT/patternFilling.txt";
		if (menuItem==this.itemLoader25) fileToLoad="examplesSWT/MultiCharts.txt";
		if (menuItem==this.itemLoader26) fileToLoad="examplesSWT/StackedMultiAxis.txt";

		
		
		// allow user selection of file
		if (menuItem==this.itemLoad) {
				FileDialog dialog=new FileDialog(shell,SWT.OPEN);
				dialog.setText("Select chart file");
				String file=dialog.open();
				if (file!=null) 
					fileToLoad="file:///"+file;
		}
		
	//		load new chart from file
		if (fileToLoad!=null) {
				ChartLoader loader=new ChartLoader();
				loader.loadFromFile(fileToLoad,true);
				
				if (menuItem==this.itemLoader20) this.createRealtimedata(loader);
				c=loader.build(false,false);		
		}
		
		// save file to bmp
		if (menuItem==this.itemSave) 
			try {
			chartViewer.getChart().saveToFile("chart.bmp","BMP");
			
			MessageBox msg=new MessageBox(shell);
			msg.setText("Export to BMP");
			msg.setMessage("The chart has been saved to the file chart.bmp");		
			msg.open();	
			
			} catch (Exception err) {
				err.printStackTrace();
				
				MessageBox msg=new MessageBox(shell);
				msg.setText("Export to BMP");
				msg.setMessage("Could not export chart: "+ err.getMessage());		
				msg.open();					
			}
					
		// finish program
		if (menuItem==this.itemExit) {
			chartViewer.getChart().stopUpdater();
			shell.dispose();
		}
		
		// set new chart, enable zoom for certain examples
		chartViewer.changePointer=false;
		chartViewer.allowZoom=false;
		if (c!=null) {
			
			if (menuItem==this.itemExample0) 
				chartViewer.allowZoom=true;
			
			// set clicked point listener
			if (menuItem==this.itemLoader5) {
				c.addChartListener(chartAdapter);
				c.activateSelection=true;
				chartViewer.changePointer=true;
			}
			
			// set listener for drill down example
			if (menuItem==this.itemLoader19) {
				c.addChartListener(chartAdapterDrillDown);
				c.activateSelection=true;
				chartViewer.changePointer=true;				
			}
			
			// set listener for realtime update example
			if (menuItem==this.itemLoader8) c.addChartListener(chartAdapter);				
			if (menuItem==this.itemLoader20) c.addChartListener(chartAdapterRealtime);

			
			// enable zoom
			if (menuItem==this.itemLoader6) chartViewer.allowZoom=true; 
			
			chartViewer.getChart().stopUpdater();
			// stop update thread of previous chart			
			chartViewer.setChart(c);
			
			chartViewer.redrawChart();
			
			// real time update example, start update thread
			if ((menuItem==this.itemLoader8) || (menuItem==this.itemLoader20))  c.startUpdater();			
			
		} 
		
	
	}

	/**
	 * this method creates realtime data for the realtime example every 2 seconds
	 *
	 */
   private void createRealtimedata(ChartLoader loader) {
		//	create chart

		//	set initial valu of the X Axis based on the time
		java.util.Date now=java.util.Calendar.getInstance().getTime();
		java.text.SimpleDateFormat formatter = new java.text.SimpleDateFormat("dd/MM/yy hh:mm:ss");

		loader.setParameter("XAXIS_INITIAL_DATE",formatter.format(now));


		//	create random data based on the time
		java.util.Calendar cal=java.util.Calendar.getInstance();
		String data1="";
		String data2="";
		for (int i=0;i<9;i++) {		
			cal.add(java.util.Calendar.SECOND,-2);
			if (data1.length()>0) data1="|" + data1;
			data1=""+cal.get(java.util.Calendar.SECOND)+ data1;
			if (data2.length()>0) data2="|" + data2;
			data2=""+(cal.get(java.util.Calendar.SECOND)/6)+ data2;		
		}

		loader.setParameter("SERIE_DATA_1",data1);
		loader.setParameter("SERIE_DATA_2",data2);

   }
}