/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.web;

import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartLoader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Encoder;

public class ChartServlet
extends HttpServlet {
    private boolean debug = false;

    public void init() throws ServletException {
    }

    private Chart getChart(HttpServletRequest request) {
        if (this.debug) {
            System.out.println("Headless Mode is: " + System.getProperty("java.awt.headless"));
        }
        if (this.debug) {
            System.out.println("Current directory is: " + new File("dummy").getAbsolutePath());
        }
        if (this.debug) {
            System.out.println("User directory: " + request.getRequestURI() + " " + request.getPathTranslated() + " " + request.getPathInfo());
        }
        ChartLoader loader = new ChartLoader();
        loader.paintDirect = true;
        String dataFile = null;
        String fileEncoding = "";
        String user = "";
        String psw = "";
        String delim = null;
        if (request != null) {
            boolean isUri = false;
            if (request.getParameter("DEBUG") != null && request.getParameter("DEBUG").toUpperCase().compareTo("ON") == 0) {
                this.debug = true;
            }
            Enumeration ps = request.getParameterNames();
            while (ps.hasMoreElements()) {
                String name = (String)ps.nextElement();
                if (!isUri) {
                    loader.setParameter(name, request.getParameter(name));
                    if (name.compareTo("DATAFILE") == 0) {
                        dataFile = request.getParameter(name);
                    }
                    if (name.compareTo("PSW") == 0) {
                        psw = request.getParameter(name);
                    }
                    if (name.compareTo("USER") == 0) {
                        user = request.getParameter(name);
                    }
                    if (name.compareTo("FILEENCODING") == 0) {
                        fileEncoding = request.getParameter(name);
                    }
                    if (name.compareTo("ISURI") == 0) {
                        dataFile = request.getParameter(name);
                        isUri = true;
                        delim = "?";
                    }
                    if (!this.debug) continue;
                    System.out.println("PARAM: " + name + "=" + request.getParameter(name));
                    continue;
                }
                dataFile = String.valueOf(dataFile) + delim + name + "=" + request.getParameter(name);
                delim = "&";
            }
            if (this.debug) {
                System.out.println("DATAFILE: " + dataFile);
            }
        }
        String encodedUserPsw = "";
        if (user.length() > 0) {
            String userPassword = String.valueOf(user) + ":" + psw;
            encodedUserPsw = new BASE64Encoder().encode(userPassword.getBytes());
            if (this.debug) {
                System.out.println("Aut. :" + encodedUserPsw);
            }
        }
        File f = new File("a.txt");
        if (this.debug) {
            System.out.println(f.getAbsolutePath());
        }
        if (dataFile != null) {
            if (this.debug) {
                System.out.println("file encoding " + fileEncoding);
            }
            loader.fileEncoding = fileEncoding;
            if (this.debug) {
                System.out.println("loading file " + dataFile);
            }
            loader.loadFromFile(dataFile, false, encodedUserPsw);
        }
        Chart chart = loader.build(false, false);
        if (this.debug) {
            System.out.println("Chart Built");
        }
        return chart;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encode = "jpeg";
        if (request != null) {
            if (request.getParameter("FORMAT") != null) {
                encode = request.getParameter("FORMAT").toLowerCase();
            }
            if (encode.toLowerCase().compareTo("gif") != 0 && encode.toLowerCase().compareTo("png") != 0) {
                encode = "jpeg";
            }
        }
        response.setContentType("image/" + encode);
        ServletOutputStream outb = response.getOutputStream();
        response.setDateHeader("Expires", 0L);
        try {
            int w = 500;
            int h = 500;
            if (request != null) {
                if (request.getParameter("WIDTH") != null) {
                    w = new Integer(request.getParameter("WIDTH"));
                }
                if (request.getParameter("HEIGHT") != null) {
                    h = new Integer(request.getParameter("HEIGHT"));
                }
            }
            Chart c = this.getChart(request);
            if (this.debug) {
                System.out.println("Size: " + w + " " + h);
            }
            c.setSize(w, h);
            c.doubleBuffering = false;
            if (this.debug) {
                System.out.println("Double buf. " + c.doubleBuffering);
            }
            c.saveToFile((OutputStream)outb, encode);
            outb.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            this.doGet(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

