/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.web;

import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartLoader;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.GraphicsProvider;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Encoder;

public class ChartMapServlet
extends HttpServlet {
    private boolean debug = false;
    private ChartLoader loader;

    public void init() throws ServletException {
    }

    private Chart getChart(HttpServletRequest request) {
        this.loader = new ChartLoader(null);
        this.loader.paintDirect = true;
        String dataFile = null;
        String fileEncoding = "";
        String user = "";
        String psw = "";
        if (request != null) {
            if (request.getParameter("DEBUG") != null && request.getParameter("DEBUG").toUpperCase().compareTo("ON") == 0) {
                this.debug = true;
            }
            Enumeration ps = request.getParameterNames();
            while (ps.hasMoreElements()) {
                String name = (String)ps.nextElement();
                this.loader.setParameter(name, request.getParameter(name));
                if (this.debug) {
                    System.out.println("PARAM: " + name + "=" + request.getParameter(name));
                }
                if (name.compareTo("DATAFILE") == 0) {
                    dataFile = request.getParameter(name);
                }
                if (name.compareTo("PSW") == 0) {
                    psw = request.getParameter(name);
                }
                if (name.compareTo("USER") == 0) {
                    user = request.getParameter(name);
                }
                if (name.compareTo("FILEENCODING") != 0) continue;
                fileEncoding = request.getParameter(name);
            }
        }
        String encodedUserPsw = "";
        if (user.length() > 0) {
            String userPassword = String.valueOf(user) + ":" + psw;
            encodedUserPsw = new BASE64Encoder().encode(userPassword.getBytes());
            if (this.debug) {
                System.out.println("Aut. :" + encodedUserPsw);
            }
        }
        File f = new File("a.txt");
        if (this.debug) {
            System.out.println(f.getAbsolutePath());
        }
        if (dataFile != null) {
            if (this.debug) {
                System.out.println("file encopding " + fileEncoding);
            }
            this.loader.fileEncoding = fileEncoding;
            if (this.debug) {
                System.out.println("loading file " + dataFile);
            }
            this.loader.loadFromFile(dataFile, false, encodedUserPsw);
        }
        Chart chart = this.loader.build(false, false);
        if (this.debug) {
            System.out.println("Chart Built");
        }
        return chart;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("Getting map");
        PrintWriter outb = response.getWriter();
        try {
            int w = 500;
            int h = 500;
            if (request != null) {
                if (request.getParameter("WIDTH") != null) {
                    w = new Integer(request.getParameter("WIDTH"));
                }
                if (request.getParameter("HEIGHT") != null) {
                    h = new Integer(request.getParameter("HEIGHT"));
                }
            }
            ChartImage chartImage = GraphicsProvider.createImage(w, h);
            ChartGraphics chartGraphics = chartImage.getGraphics();
            Chart c = this.getChart(request);
            if (this.debug) {
                System.out.println("Size: " + w + " " + h);
            }
            c.setSize(w, h);
            c.paint(chartGraphics);
            chartGraphics.dispose();
            chartImage.dispose();
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setContentType("text/html");
            String html = "";
            html = c.getHTMLImageMap("CHARTMAP");
            outb.print(html);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        System.out.println("Getting map (POST)");
        try {
            this.doGet(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

