/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.web;

import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartAdapter;
import com.java4less.rchart.ChartLoader;
import com.java4less.rchart.awt.ChartViewer;
import com.java4less.rchart.gc.awt.ChartAwt1Image;
import com.java4less.rchart.gc.awt.ImageLoader;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import netscape.javascript.JSObject;

public class ChartApplet
extends Applet {
    private ChartLoader loader;
    boolean stopped = false;
    private int lastWidth = -1;
    private int lastHeight = -1;
    public boolean triggerJS = false;
    ChartViewer chartViewer = new ChartViewer();
    private boolean parentSizeChanged = false;
    ChartAdapter chartAdapter = new ChartAdapter(){

        public void chartEvent(Chart c, int type) {
            JSObject JS;
            if (type == 5 && ChartApplet.this.triggerJS) {
                try {
                    JS = JSObject.getWindow((Applet)ChartApplet.this);
                    Object[] o = new Object[]{c.selectedSerie, "" + c.selectedSeriePoint};
                    JS.call("OnClickRChart", o);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (type == 0 && ChartApplet.this.triggerJS) {
                try {
                    JS = JSObject.getWindow((Applet)ChartApplet.this);
                    JS.call("OnRChart", null);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    };

    public ChartApplet() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.chartViewer);
        this.doLayout();
        ChartAwt1Image.visibleComponent = this;
        ImageLoader.chartApplet = this;
    }

    public void init() {
        this.getParent().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (!ChartApplet.this.parentSizeChanged) {
                    ChartApplet.this.setSize(ChartApplet.this.getParent().getSize());
                    ChartApplet.this.parentSizeChanged = true;
                    System.out.println("Setting size to : " + ChartApplet.this.getParent().getSize().width + " , " + ChartApplet.this.getParent().getSize().height);
                }
            }
        });
        this.stopped = false;
        this.loader = new ChartLoader(this);
        if (this.loader.getParameter("CHART_MAX_ZOOM", "").length() > 0) {
            this.chartViewer.maxZoom = (int)this.loader.getDoubleParam("CHART_MAX_ZOOM", new Double(0.0)).doubleValue();
        }
        if (this.loader.getParameter("CHART_MIN_ZOOM", "").length() > 0) {
            this.chartViewer.minZoom = (int)this.loader.getDoubleParam("CHART_MIN_ZOOM", new Double(0.0)).doubleValue();
        }
        if (this.loader.getParameter("CHART_ZOOM_INC", "").length() > 0) {
            this.chartViewer.zoomIncrement = (int)this.loader.getDoubleParam("CHART_ZOOM_INC", new Double(0.0)).doubleValue();
        }
        this.triggerJS = this.loader.getBooleanParam("CHART_JAVASCRIPT_EVENTS", false);
        this.chartViewer.setChart(this.loader.build(true, true));
        if (this.triggerJS) {
            this.chartViewer.getChart().addChartListener(this.chartAdapter);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.getSize().width == 0 || this.getSize().height == 0) {
            System.out.println("Applet size is 0");
        }
        super.paint(g);
    }

    public void start() {
        if (this.stopped) {
            this.init();
        }
        this.stopped = false;
        if (this.loader.getBooleanParam("CHART_REALTIME", false)) {
            this.chartViewer.getChart().startUpdater();
        }
    }

    public void stop() {
        this.stopped = true;
        this.chartViewer.getChart().stopUpdater();
    }

    public void destroy() {
        this.stopped = true;
        this.chartViewer.getChart().stopUpdater();
    }

    public String getAppletInfo() {
        return "RChart 2 Applet";
    }

    public void rebuild(String Clear, String reReadFile) {
        boolean c = false;
        boolean r = false;
        if (Clear.compareTo("Y") == 0) {
            c = true;
        }
        if (reReadFile.compareTo("Y") == 0) {
            r = true;
        }
        this.loader.build(this.chartViewer.getChart(), c, r);
    }

    public void loadFromFile(String psFile, String Clear) {
        boolean c = false;
        if (Clear.compareTo("Y") == 0) {
            c = true;
        }
        this.loader.loadFromFile(psFile, c);
    }

    public String getLoaderParameter(String param) {
        return this.loader.getParameter(param, "");
    }

    public void setParameter(String param, String value) {
        this.loader.setParameter(param, value);
    }

    public void refresh() {
        this.chartViewer.paint(this.chartViewer.getGraphics());
    }
}

