/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.swt;

import com.java4less.rchart.BarPlotter3D;
import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartAdapter;
import com.java4less.rchart.LinePlotter3D;
import com.java4less.rchart.swt.ChartCanvas;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Slider;

public class ChartViewer
extends Composite {
    ChartCanvas canvas = null;
    Slider hSlider = null;
    Slider vSlider = null;
    private int scrollBarWidth = 18;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private int lastZoom = 0;
    private int originalHeight = -1;
    private int originalWidth = -1;
    public boolean allowZoom = true;
    public int maxZoom = 200;
    public int minZoom = 50;
    public int currentZoom = 100;
    public int zoomIncrement = 25;
    public boolean changePointer = true;
    private Cursor defaultCursor = null;
    private Cursor pointCursor = null;
    private Button plusZoom;
    private Button minusZoom;
    private Label zoom;
    private Composite zoomPanel;
    ChartAdapter chartAdapter = new ChartAdapter(){

        public void chartEvent(Chart c, int type) {
            if (type == 2) {
                ChartViewer.this.canvas.setCursor(ChartViewer.this.pointCursor);
            }
            if (type == 3) {
                ChartViewer.this.canvas.setCursor(ChartViewer.this.defaultCursor);
            }
        }
    };

    public ChartViewer(Composite parent, int style) {
        super(parent, style);
        this.canvas = new ChartCanvas(this, 0);
        this.hSlider = new Slider((Composite)this, 256);
        this.vSlider = new Slider((Composite)this, 512);
        this.canvas.setFocus();
        this.zoomPanel = new Composite((Composite)this, 0);
        this.zoomPanel.setSize(90, this.scrollBarWidth);
        this.plusZoom = new Button(this.zoomPanel, 0);
        this.plusZoom.setLocation(0, 0);
        this.plusZoom.setImage(new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/java4less/images/plus.bmp")));
        this.plusZoom.setSize(25, this.scrollBarWidth);
        this.minusZoom = new Button(this.zoomPanel, 0);
        this.minusZoom.setLocation(26, 0);
        this.minusZoom.setSize(25, this.scrollBarWidth);
        this.minusZoom.setImage(new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/java4less/images/minus.bmp")));
        this.zoom = new Label(this.zoomPanel, 0x1000000);
        this.zoom.setLocation(52, 0);
        this.zoom.setSize(38, this.scrollBarWidth);
        this.zoom.setText("" + this.currentZoom + " %");
        this.minusZoom.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ChartViewer.this.minusZoom();
            }
        });
        this.plusZoom.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ChartViewer.this.plusZoom();
            }
        });
        this.hSlider.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ChartViewer.this.canvas.getChart() == null) {
                    return;
                }
                ChartViewer.this.hSliderScroll();
            }
        });
        this.vSlider.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ChartViewer.this.canvas.getChart() == null) {
                    return;
                }
                ChartViewer.this.vSliderScroll();
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (ChartViewer.this.canvas.getChart() == null) {
                    return;
                }
                ChartViewer.this.placeControls();
                ChartViewer.this.updateScrollBarsConfiguration();
                ChartViewer.this.updateSize();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.defaultCursor = new Cursor((Device)parent.getDisplay(), 0);
        this.pointCursor = new Cursor((Device)parent.getDisplay(), 21);
    }

    private void placeControls() {
        int hSliderHeight = 0;
        int vSliderWidth = 0;
        if (this.canvas.getChart().virtualWidth > 0) {
            hSliderHeight = this.scrollBarWidth;
        }
        if (this.canvas.getChart().virtualHeight > 0) {
            vSliderWidth = this.scrollBarWidth;
        }
        this.canvas.setSize(this.getSize().x - vSliderWidth, this.getSize().y - hSliderHeight);
        this.canvas.setLocation(0, 0);
        if (this.allowZoom && (this.canvas.getChart().virtualHeight > 0 || this.canvas.getChart().virtualWidth > 0)) {
            this.zoomPanel.setVisible(true);
            this.zoomPanel.setLocation(0, this.canvas.getSize().y);
        } else {
            this.zoomPanel.setVisible(false);
        }
        if (this.canvas.getChart().virtualWidth > 0) {
            if (this.allowZoom) {
                this.hSlider.setLocation(this.zoomPanel.getSize().x, this.canvas.getSize().y);
                this.hSlider.setSize(this.getSize().x - vSliderWidth - this.zoomPanel.getSize().x, hSliderHeight);
            } else {
                this.hSlider.setSize(this.getSize().x - vSliderWidth, hSliderHeight);
                this.hSlider.setLocation(0, this.canvas.getSize().y);
            }
            this.hSlider.setVisible(true);
            this.canvas.getChart().withScroll = true;
        } else {
            this.hSlider.setVisible(false);
        }
        if (this.canvas.getChart().virtualHeight > 0) {
            this.vSlider.setSize(vSliderWidth, this.getSize().y - hSliderHeight);
            this.vSlider.setLocation(this.canvas.getSize().x, 0);
            this.vSlider.setVisible(true);
            this.canvas.getChart().withScroll = true;
        } else {
            this.vSlider.setVisible(false);
        }
    }

    public Chart getChart() {
        return this.canvas.getChart();
    }

    public void setChart(Chart c) {
        if (this.canvas.getChart() != null) {
            this.canvas.getChart().removeChartListener(this.chartAdapter);
        }
        this.canvas.setChart(c);
        this.originalHeight = this.canvas.getChart().virtualHeight;
        this.originalWidth = this.canvas.getChart().virtualWidth;
        this.resetChart();
        this.placeControls();
        this.updateScrollBarsConfiguration();
        this.updateSize();
        if (this.changePointer) {
            this.canvas.getChart().addChartListener(this.chartAdapter);
        }
    }

    private void vSliderScroll() {
        int newBase = 0;
        int newValue = this.vSlider.getSelection();
        newBase = newValue + this.canvas.getChart().getHeight() < this.canvas.getChart().virtualHeight ? newValue : this.canvas.getChart().virtualHeight - this.canvas.getChart().getHeight();
        if (newBase < 0) {
            newBase = 0;
        }
        this.canvas.getChart().offsetY = newBase;
        if (this.canvas.getChart().plotters[0] instanceof BarPlotter3D) {
            this.canvas.getChart().repaintAll = true;
        }
        if (this.canvas.getChart().plotters[0] instanceof LinePlotter3D) {
            this.canvas.getChart().repaintAll = true;
        }
        this.canvas.redraw();
    }

    private void hSliderScroll() {
        int newBase = 0;
        int newValue = this.hSlider.getSelection();
        newBase = newValue + this.canvas.getChart().getWidth() < this.canvas.getChart().virtualWidth ? newValue : this.canvas.getChart().virtualWidth - this.canvas.getChart().getWidth();
        if (newBase < 0) {
            newBase = 0;
        }
        this.canvas.getChart().offsetX = newBase;
        if (this.canvas.getChart().plotters[0] instanceof LinePlotter3D) {
            this.canvas.getChart().repaintAll = true;
        }
        if (this.canvas.getChart().plotters[0] instanceof BarPlotter3D) {
            this.canvas.getChart().repaintAll = true;
        }
        this.canvas.redraw();
    }

    private void resetChart() {
        this.lastWidth = 0;
        this.lastHeight = 0;
        this.lastZoom = 0;
    }

    private void zoomUpdated() {
        this.zoom.setText("" + this.currentZoom + " %");
        this.updateSize();
        this.updateScrollBarsConfiguration();
        this.canvas.redraw();
    }

    private void plusZoom() {
        this.currentZoom = this.currentZoom + this.zoomIncrement < this.maxZoom ? (this.currentZoom += this.zoomIncrement) : this.maxZoom;
        this.zoomUpdated();
    }

    private void minusZoom() {
        this.currentZoom = this.currentZoom - this.zoomIncrement > this.minZoom ? (this.currentZoom -= this.zoomIncrement) : this.minZoom;
        this.zoomUpdated();
    }

    private void updateScrollBarsConfiguration() {
        if (this.canvas.getChart().virtualWidth > 0) {
            int w = this.canvas.getChart().getWidth();
            this.hSlider.setMinimum(0);
            this.hSlider.setMaximum(this.canvas.getChart().virtualWidth);
            this.hSlider.setIncrement((int)((double)this.canvas.getChart().getWidth() * 0.2));
            this.hSlider.setPageIncrement((int)((double)this.canvas.getChart().getWidth() * 0.75));
            if (this.canvas.getChart().offsetX > this.canvas.getChart().virtualWidth - w) {
                this.canvas.getChart().offsetX = this.canvas.getChart().virtualWidth - w;
            }
            if (this.canvas.getChart().offsetX < 0) {
                this.canvas.getChart().offsetX = 0;
            }
            if (this.canvas.getChart().offsetX > this.canvas.getChart().virtualWidth - w) {
                this.canvas.getChart().offsetX = 0;
            }
            this.hSlider.setThumb(w);
            this.hSlider.setSelection(this.canvas.getChart().offsetX);
        }
        if (this.canvas.getChart().virtualHeight > 0) {
            int h = this.canvas.getChart().getHeight();
            this.vSlider.setMinimum(0);
            this.vSlider.setMaximum(this.canvas.getChart().virtualHeight);
            this.vSlider.setIncrement((int)((double)this.canvas.getChart().getHeight() * 0.2));
            this.vSlider.setPageIncrement((int)((double)this.canvas.getChart().getHeight() * 0.75));
            if (this.canvas.getChart().offsetY > this.canvas.getChart().virtualHeight - h) {
                this.canvas.getChart().offsetY = this.canvas.getChart().virtualHeight - h;
            }
            if (this.canvas.getChart().offsetY < 0) {
                this.canvas.getChart().offsetY = 0;
            }
            if (this.canvas.getChart().offsetY > this.canvas.getChart().virtualHeight - h) {
                this.canvas.getChart().offsetY = 0;
            }
            this.vSlider.setThumb(h);
            this.vSlider.setSelection(this.canvas.getChart().offsetY);
        }
    }

    private void updateSize() {
        this.canvas.getChart().repaintAll = true;
        if (this.lastWidth != this.getSize().x || this.lastHeight != this.getSize().y || this.lastZoom != this.currentZoom) {
            this.canvas.getChart().setSize(this.getSize().x, this.getSize().y);
            this.lastWidth = this.getSize().x;
            this.lastHeight = this.getSize().y;
            this.lastZoom = this.currentZoom;
            if (this.canvas.getChart().withScroll) {
                if (this.allowZoom) {
                    this.canvas.getChart().virtualHeight = this.originalHeight > 0 ? this.originalHeight * this.currentZoom / 100 : 0;
                    this.canvas.getChart().virtualWidth = this.originalWidth > 0 ? this.originalWidth * this.currentZoom / 100 : 0;
                }
                int w = 1 + this.getSize().x;
                if (this.originalHeight > 0) {
                    w -= this.vSlider.getSize().x;
                }
                int h = 1 + this.getSize().y;
                if (this.originalWidth > 0) {
                    h -= this.hSlider.getSize().y;
                }
                this.canvas.getChart().repaintAll = true;
                this.canvas.getChart().setSize(w, h);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.pointCursor != null && !this.pointCursor.isDisposed()) {
            this.pointCursor.dispose();
        }
        if (this.defaultCursor != null && !this.defaultCursor.isDisposed()) {
            this.defaultCursor.dispose();
        }
    }

    public void redrawChart() {
        this.canvas.redraw();
    }
}

