/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.swt;

import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartListener;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.GraphicsProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ChartCanvas
extends Canvas
implements ChartListener {
    private Chart chart = null;

    public ChartCanvas(Composite parent, int style) {
        super(parent, style | 0x40000);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ChartCanvas.this.paintChart(e);
            }
        });
        MouseMoveListener mouseMove = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ChartCanvas.this.mouseMoved(e);
            }
        };
        this.addMouseMoveListener(mouseMove);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ChartCanvas.this.mouseClick();
            }
        };
        this.addMouseListener((MouseListener)mouseAdapter);
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                ChartCanvas.this.resizeChart();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void mouseMoved(MouseEvent e) {
        if (this.chart != null) {
            this.chart.mouseMoved(e.x, e.y);
        }
    }

    private void mouseClick() {
        if (this.chart != null) {
            this.chart.mouseClick();
        }
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart c) {
        if (this.chart != null) {
            this.chart.removeChartListener(this);
        }
        this.chart = c;
        this.chart.addChartListener(this);
    }

    protected void resizeChart() {
        this.chart.setWidth(this.getSize().x + 1);
        this.chart.setHeight(this.getSize().y + 1);
    }

    protected void paintChart(PaintEvent e) {
        try {
            this.resizeChart();
            ChartGraphics g = GraphicsProvider.getGraphics(e.gc);
            this.chart.paint(g);
            g.dispose();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void paintUserExit(Chart c, ChartGraphics g) {
    }

    public void chartEvent(Chart c, int type) {
        if (type == 4) {
            this.redraw();
        }
        if (type == 1) {
            GraphicsProvider.startUIThread(new Runnable(){

                public void run() {
                    if (!ChartCanvas.this.isDisposed()) {
                        ChartCanvas.this.redraw();
                    }
                }
            });
        }
    }
}

