/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.gc.swt;

import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.swt.ChartSwtColor;
import com.java4less.rchart.gc.swt.ChartSwtGraphics;
import com.java4less.rchart.gc.swt.SwtGraphicsProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Hashtable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ChartSwtImage
extends ChartImage {
    private Image image;
    private ChartColor transparentColor;
    static /* synthetic */ Class class$0;

    public ChartSwtImage(Object o) {
        block10: {
            this.image = null;
            this.transparentColor = null;
            try {
                if (o instanceof String) {
                    InputStream is;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.java4less.rchart.gc.swt.ChartSwtImage");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((is = clazz.getClassLoader().getResourceAsStream((String)o)) != null) {
                        this.image = new Image(SwtGraphicsProvider.getDefaultDisplay(), is);
                        return;
                    }
                    this.image = new Image(SwtGraphicsProvider.getDefaultDisplay(), (String)o);
                    break block10;
                }
                if (o instanceof Image) {
                    this.image = (Image)o;
                    break block10;
                }
                if (o instanceof InputStream) {
                    this.image = new Image(SwtGraphicsProvider.getDefaultDisplay(), (InputStream)o);
                    break block10;
                }
                throw new Exception("Class not supported");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ChartSwtImage(int w, int h) {
        this.image = null;
        this.transparentColor = null;
        this.image = new Image(SwtGraphicsProvider.getDefaultDisplay(), w, h);
    }

    public ChartSwtImage(int w, int h, ChartColor transparent) {
        this.image = null;
        this.transparentColor = null;
        this.transparentColor = transparent;
        Color trans = ((ChartSwtColor)transparent).getColor();
        Image tmpImage = new Image(SwtGraphicsProvider.getDefaultDisplay(), w, h);
        ImageData imageData = tmpImage.getImageData();
        tmpImage.dispose();
        imageData.transparentPixel = imageData.palette.getPixel(trans.getRGB());
        this.image = new Image(SwtGraphicsProvider.getDefaultDisplay(), imageData);
        GC g = new GC((Drawable)this.image);
        g.setForeground(trans);
        g.setBackground(trans);
        g.fillRectangle(0, 0, w, h);
        g.dispose();
        trans.dispose();
    }

    protected ChartSwtImage forRotation() {
        int h = this.getHeight();
        int w = this.getWidth();
        ChartSwtImage dest = null;
        if (w > h) {
            dest = new ChartSwtImage(w, w, this.transparentColor);
        } else if (h > w) {
            dest = new ChartSwtImage(h, h, this.transparentColor);
        } else {
            return this;
        }
        ChartGraphics g = dest.getGraphics();
        g.drawImage(this, 0, 0);
        g.dispose();
        return dest;
    }

    public ChartGraphics getGraphics() {
        ChartSwtGraphics g = new ChartSwtGraphics(new GC((Drawable)this.image));
        g.srcImage = this.image;
        return g;
    }

    public int getWidth() {
        if (this.image == null) {
            return 0;
        }
        return this.image.getBounds().width;
    }

    public int getHeight() {
        if (this.image == null) {
            return 0;
        }
        return this.image.getBounds().height;
    }

    public Image getImage() {
        return this.image;
    }

    private RGB getRGBFromImage(ImageData data, int x, int y) {
        return data.palette.getRGB(data.getPixel(x, y));
    }

    private Integer getRGBInt(RGB rgb) {
        return new Integer((rgb.red << 16) + (rgb.green >> 8) + rgb.blue);
    }

    public boolean saveToStream(String sFormat, OutputStream os) {
        try {
            ImageLoader encoder = new ImageLoader();
            ImageData[] iData = new ImageData[]{this.image.getImageData()};
            encoder.data = iData;
            if (sFormat.toUpperCase().compareTo("GIF") == 0) {
                Hashtable<Integer, RGB> colors = new Hashtable<Integer, RGB>();
                RGB[] rgbs = new RGB[256];
                int count = 0;
                ImageData imageData = this.image.getImageData();
                int i = 0;
                while (i < this.image.getBounds().width) {
                    int j = 0;
                    while (j < this.image.getBounds().height) {
                        RGB rgb = this.getRGBFromImage(imageData, i, j);
                        Integer iRGB = this.getRGBInt(rgb);
                        if (!colors.containsKey(iRGB)) {
                            System.out.println("Adding color " + new BigInteger("" + iRGB, 10).toString(16));
                            colors.put(iRGB, rgb);
                            rgbs[count++] = rgb;
                        }
                        if (count >= 256) break;
                        ++j;
                    }
                    ++i;
                }
                i = count;
                while (i < 256) {
                    rgbs[count++] = new RGB(count - 1, count - 1, count - 1);
                    ++i;
                }
                ImageData image2Data = new ImageData(this.image.getBounds().width, this.image.getBounds().height, 8, new PaletteData(rgbs));
                Image image2 = new Image(SwtGraphicsProvider.getDefaultDisplay(), image2Data);
                GC g2 = new GC((Drawable)image2);
                g2.drawImage(this.image, 0, 0);
                g2.dispose();
                ImageData[] image2DataArray = new ImageData[]{image2.getImageData()};
                ImageLoader encoder2 = new ImageLoader();
                encoder2.data = image2DataArray;
                encoder2.save(os, 2);
                image2.dispose();
            }
            if (sFormat.toUpperCase().compareTo("JPEG") == 0) {
                encoder.save(os, 4);
            }
            if (sFormat.toUpperCase().compareTo("JPG") == 0) {
                encoder.save(os, 4);
            }
            if (sFormat.toUpperCase().compareTo("PNG") == 0) {
                encoder.save(os, 5);
            }
            if (sFormat.toUpperCase().compareTo("ICO") == 0) {
                encoder.save(os, 3);
            }
            if (sFormat.toUpperCase().compareTo("BMP") == 0) {
                encoder.save(os, 0);
            }
            if (sFormat.toUpperCase().compareTo("BMP_RLE") == 0) {
                encoder.save(os, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = null;
    }
}

