/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.gc.swt;

import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.GraphicsProvider;
import com.java4less.rchart.gc.swt.ChartSwtColor;
import com.java4less.rchart.gc.swt.ChartSwtFont;
import com.java4less.rchart.gc.swt.ChartSwtImage;
import com.java4less.rchart.gc.swt.SwtGraphicsProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ChartSwtGraphics
extends ChartGraphics {
    private GC graphics;
    private Font currentFont;
    private Color currentColor;
    protected float alphaValue = 1.0f;
    protected Image srcImage;
    private Color transparent = null;
    protected Image imageForTransparentFilling = null;

    public ChartSwtGraphics(Object g) {
        this.graphics = (GC)g;
    }

    public void setColor(ChartColor color) {
        this.disposeCurrentColor();
        this.currentColor = ((ChartSwtColor)color).getColor();
        this.graphics.setForeground(this.currentColor);
        this.graphics.setBackground(this.currentColor);
    }

    private void disposeCurrentColor() {
        if (this.currentColor != null && !this.currentColor.isDisposed()) {
            this.currentColor.dispose();
        }
        this.currentColor = null;
    }

    private void disposeCurrentFont() {
        if (this.currentFont != null && !this.currentFont.isDisposed()) {
            this.currentFont.dispose();
        }
        this.currentFont = null;
    }

    public void setFont(ChartFont font) {
        this.disposeCurrentFont();
        this.currentFont = ((ChartSwtFont)font).getFont();
        this.graphics.setFont(this.currentFont);
    }

    public ChartColor getColor() {
        return new ChartSwtColor(this.currentColor);
    }

    public ChartFont getFont() {
        return new ChartSwtFont(this.currentFont);
    }

    public void drawArc(int x, int y, int w, int h, int a1, int a2) {
        this.graphics.drawArc(x, y, w, h, a1, a2);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    public int getFontHeight(ChartFont font) {
        Font tmpFont = this.currentFont;
        this.currentFont = null;
        if (font != null) {
            this.setFont(font);
        }
        int result = this.graphics.getFontMetrics().getHeight();
        this.disposeCurrentFont();
        this.currentFont = tmpFont;
        return result;
    }

    public int getFontWidth(ChartFont font, String s) {
        Font tmpFont = this.currentFont;
        this.currentFont = null;
        if (font != null) {
            this.setFont(font);
        }
        int result = 0;
        result = this.graphics.textExtent((String)s).x;
        this.disposeCurrentFont();
        this.currentFont = tmpFont;
        return result;
    }

    public boolean drawRotatedText(ChartFont descFont, ChartColor descColor, String txt, int angle, int x, int y, boolean b) {
        int w;
        this.setFont(descFont);
        this.setColor(descColor);
        int h = this.getFontHeight();
        int size = w = this.getFontWidth(txt);
        int toCenterX = 0;
        int toCenterY = 0;
        if (h > w) {
            size = h;
            toCenterX = (size - w) / 2;
        } else {
            toCenterY = (size - h) / 2;
        }
        Image tmpImage = new Image(SwtGraphicsProvider.getDefaultDisplay(), size, size);
        ImageData imageData = tmpImage.getImageData();
        tmpImage.dispose();
        Color transparent = null;
        if (descColor.getRed() == 255 && descColor.getBlue() == 255 && descColor.getGreen() == 255) {
            transparent = new Color(SwtGraphicsProvider.getDefaultDisplay(), 0, 0, 0);
            imageData.transparentPixel = imageData.palette.getPixel(new RGB(0, 0, 0));
        } else {
            transparent = new Color(SwtGraphicsProvider.getDefaultDisplay(), 255, 255, 255);
            imageData.transparentPixel = imageData.palette.getPixel(new RGB(255, 255, 255));
        }
        tmpImage = new Image(SwtGraphicsProvider.getDefaultDisplay(), imageData);
        GC g = new GC((Drawable)tmpImage);
        Color c = ((ChartSwtColor)descColor).getColor();
        Font f = ((ChartSwtFont)descFont).getFont();
        g.setForeground(transparent);
        g.setBackground(transparent);
        g.fillRectangle(0, 0, size, size);
        g.setFont(f);
        g.setForeground(c);
        g.drawText(txt, toCenterX, toCenterY, true);
        g.dispose();
        c.dispose();
        f.dispose();
        ChartImage tmpChartImage = GraphicsProvider.getImage(tmpImage);
        this.paintRotatedImage(tmpChartImage, angle, x - (w - h) / 2, y + 4, ChartGraphics.ROTATE_CENTER);
        tmpChartImage.dispose();
        tmpImage.dispose();
        return true;
    }

    private int rotateX(int x, int y, int angle) {
        if (angle == 90) {
            return y * -1;
        }
        if (angle == -90) {
            return y * 1;
        }
        return (int)((double)x * Math.cos(Math.toRadians(angle)) - (double)y * Math.sin(Math.toRadians(angle)));
    }

    private int rotateY(int x, int y, int angle) {
        if (angle == 90) {
            return x * 1;
        }
        if (angle == -90) {
            return x * -1;
        }
        return (int)((double)x * Math.sin(Math.toRadians(angle)) + (double)y * Math.cos(Math.toRadians(angle)));
    }

    public void paintRotatedImage(ChartImage srcImage, int angle, int x, int y, int alignment) {
        Image srcSwtImage = ((ChartSwtImage)srcImage).getImage();
        int size = srcSwtImage.getImageData().width;
        int h = srcSwtImage.getImageData().height;
        int w = srcSwtImage.getImageData().width;
        int originalH = h;
        int originalW = w;
        if (h != w) {
            srcImage = ((ChartSwtImage)srcImage).forRotation();
            srcSwtImage = ((ChartSwtImage)srcImage).getImage();
            size = srcSwtImage.getImageData().width;
            h = srcSwtImage.getImageData().height;
            w = srcSwtImage.getImageData().width;
        }
        ImageData srcData = srcSwtImage.getImageData();
        ImageData destData = new ImageData(size, size, srcData.depth, srcData.palette);
        destData.transparentPixel = srcData.transparentPixel;
        if (destData.transparentPixel != -1) {
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size) {
                    destData.setPixel(i, j, destData.transparentPixel);
                    ++j;
                }
                ++i;
            }
        }
        int c = 0;
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                int x2 = this.rotateX(i - size / 2, j - size / 2, -angle) + size / 2;
                int y2 = this.rotateY(i - size / 2, j - size / 2, -angle) + size / 2;
                ++c;
                if (x2 < size && y2 < size && x2 >= 0 && y2 >= 0) {
                    destData.setPixel(i, j, srcData.getPixel(x2, y2));
                }
                ++j;
            }
            ++i;
        }
        Image destImage = new Image(SwtGraphicsProvider.getDefaultDisplay(), destData);
        if (alignment == ChartGraphics.ROTATE_LEFTTOP) {
            if (angle == 90) {
                this.graphics.drawImage(destImage, x - (w - originalH), y);
            } else if (angle == -90) {
                this.graphics.drawImage(destImage, x, y);
            }
        } else if (angle == 90) {
            this.graphics.drawImage(destImage, x, y);
        } else if (angle == -90) {
            this.graphics.drawImage(destImage, x, y);
        }
        destImage.dispose();
    }

    public void drawString(String s, int x, int y) {
        this.graphics.drawString(s, x, y - this.graphics.getFontMetrics().getHeight(), true);
    }

    public void drawImage(ChartImage image, int x, int y) {
        if (image == null) {
            return;
        }
        if (((ChartSwtImage)image).getImage() == null) {
            return;
        }
        this.graphics.drawImage(((ChartSwtImage)image).getImage(), x, y);
    }

    public void drawImage(ChartImage image, int x1Dest, int y1Dest, int x2Dest, int y2Dest, int x1Source, int y1Source, int x2Source, int y2Source) {
        if (image == null) {
            return;
        }
        if (((ChartSwtImage)image).getImage() == null) {
            return;
        }
        this.graphics.drawImage(((ChartSwtImage)image).getImage(), x1Source, y1Source, x2Source - x1Source, y2Source - y1Source, x1Dest, y1Dest, x2Dest - x1Dest, y2Dest - y1Dest);
    }

    public void fillPolygon(int[] x1, int[] y1, int count) {
        int[] points = new int[count * 2];
        int j = 0;
        int i = 0;
        while (i < count) {
            points[j++] = x1[i];
            points[j++] = y1[i];
            ++i;
        }
        GC g = this.getGraphicForFilling();
        g.fillPolygon(points);
        this.processFilling(g);
    }

    public void fillRect(int x1, int y1, int w, int h) {
        GC g = this.getGraphicForFilling();
        g.fillRectangle(new Rectangle(x1, y1, w, h));
        this.processFilling(g);
    }

    public void drawPolygon(int[] x1, int[] y1, int count) {
        int[] points = new int[count * 2];
        int j = 0;
        int i = 0;
        while (i < count) {
            points[j++] = x1[i];
            points[j++] = y1[i];
            ++i;
        }
        this.graphics.drawPolygon(points);
    }

    public void drawRect(int x1, int y1, int w, int h) {
        super.drawRect(x1, y1, w, h);
    }

    public void createFadeArea(ChartColor colorFrom, ChartColor colorUntil, int x, int y, int w, int h, boolean vertical, boolean cyclic) {
        Color fore = ((ChartSwtColor)colorFrom).getColor();
        Color back = ((ChartSwtColor)colorUntil).getColor();
        this.graphics.setForeground(fore);
        this.graphics.setBackground(back);
        this.graphics.fillGradientRectangle(x, y, w, h, vertical);
        if (this.currentColor != null) {
            this.graphics.setForeground(this.currentColor);
            this.graphics.setBackground(this.currentColor);
        }
        fore.dispose();
        back.dispose();
    }

    public void fillArc(int x, int y, int w, int h, int a1, int a2) {
        GC g = this.getGraphicForFilling();
        g.fillArc(x, y, w, h, a1, a2);
        this.processFilling(g);
    }

    protected GC getGraphicForFilling() {
        if (this.alphaValue >= 1.0f || this.srcImage == null) {
            this.imageForTransparentFilling = null;
            return this.graphics;
        }
        this.transparent = null;
        this.transparent = this.currentColor.getRed() == 255 && this.currentColor.getBlue() == 255 && this.currentColor.getGreen() == 255 ? new Color(SwtGraphicsProvider.getDefaultDisplay(), 0, 0, 0) : new Color(SwtGraphicsProvider.getDefaultDisplay(), 255, 255, 255);
        RGB[] rgbs = new RGB[256];
        rgbs[0] = this.transparent.getRGB();
        int i = 1;
        while (i <= 255) {
            rgbs[i] = this.currentColor.getRGB();
            ++i;
        }
        ImageData imageData = new ImageData(this.srcImage.getBounds().width, this.srcImage.getBounds().height, this.srcImage.getImageData().depth, this.srcImage.getImageData().palette);
        this.imageForTransparentFilling = new Image(SwtGraphicsProvider.getDefaultDisplay(), imageData);
        GC g = new GC((Drawable)this.imageForTransparentFilling);
        g.setForeground(this.transparent);
        g.setBackground(this.transparent);
        g.fillRectangle(0, 0, this.srcImage.getBounds().width, this.srcImage.getBounds().height);
        g.setForeground(this.currentColor);
        g.setBackground(this.currentColor);
        return g;
    }

    protected void processFilling(GC g) {
        if (g != this.graphics) {
            g.dispose();
            ImageData imageData = this.imageForTransparentFilling.getImageData();
            int i = 0;
            while (i < this.srcImage.getBounds().width) {
                int j = 0;
                while (j < this.srcImage.getBounds().height) {
                    RGB rgb = imageData.palette.getRGB(imageData.getPixel(i, j));
                    if (rgb.red == this.transparent.getRed() && rgb.green == this.transparent.getGreen() && rgb.blue == this.transparent.getBlue()) {
                        imageData.setAlpha(i, j, 0);
                    } else {
                        imageData.setAlpha(i, j, (int)(this.alphaValue * 255.0f));
                    }
                    ++j;
                }
                ++i;
            }
            this.transparent.dispose();
            this.imageForTransparentFilling.dispose();
            this.imageForTransparentFilling = new Image(SwtGraphicsProvider.getDefaultDisplay(), imageData);
            this.graphics.drawImage(this.imageForTransparentFilling, 0, 0);
            this.imageForTransparentFilling.dispose();
            this.imageForTransparentFilling = null;
        }
    }

    public void setAlpha(float a) {
        this.alphaValue = a;
    }

    public void setAlphaComposite(Object a) {
        if (a instanceof Float) {
            this.alphaValue = ((Float)a).floatValue();
        }
    }

    public Object getAlphaComposite() {
        return new Float(this.alphaValue);
    }

    public void dispose() {
        this.disposeCurrentColor();
        this.disposeCurrentFont();
        if (this.graphics != null && !this.graphics.isDisposed()) {
            this.graphics.dispose();
        }
        this.graphics = null;
    }

    public void setLineStyle(int style) {
        super.setLineStyle(style);
    }

    public void setLineWidth(int w) {
        super.setLineWidth(w);
    }
}

