/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.gc.awt;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.OutputStream;

class ImageEncoder {
    ImageEncoder() {
    }

    public static boolean encode(String sFormat, Image image, OutputStream os) throws Exception {
        if (sFormat.toUpperCase().compareTo("GIF") == 0) {
            ImageEncoder.saveToGIF(image, os);
        }
        if (sFormat.toUpperCase().compareTo("JPEG") == 0) {
            ImageEncoder.saveToJPEG(image, os);
        }
        if (sFormat.toUpperCase().compareTo("JPG") == 0) {
            ImageEncoder.saveToJPEG(image, os);
        }
        if (sFormat.toUpperCase().compareTo("PNG") == 0) {
            ImageEncoder.saveToPNG(image, os);
        }
        return false;
    }

    private static void saveToGIF(Image image, OutputStream os) throws Exception {
        Class<?> enClass = Class.forName("Acme.JPM.Encoders.GifEncoder");
        Class[] constructorParams = new Class[]{Class.forName("java.awt.Image"), Class.forName("java.io.OutputStream")};
        Object[] constructorObj = new Object[]{image, os};
        Object encoder = enClass.getConstructor(constructorParams).newInstance(constructorObj);
        Class[] encodeParams = new Class[]{};
        Object[] encodeObj = new Object[]{};
        enClass.getMethod("encode", encodeParams).invoke(encoder, encodeObj);
        os.close();
        image = null;
        os = null;
    }

    private static void saveToJPEG(Image image, OutputStream os) throws Exception {
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)os);
        JPEGEncodeParam params = encoder.getDefaultJPEGEncodeParam((BufferedImage)image);
        params.setQuality(1.0f, false);
        encoder.setJPEGEncodeParam(params);
        encoder.encode((BufferedImage)image);
        os.close();
        os = null;
    }

    private static void saveToPNG(Image image, OutputStream os) throws Exception {
        Class<?> enClass = Class.forName("com.bigfoot.bugar.image.PNGEncoder");
        Class[] constructorParams = new Class[]{Class.forName("java.awt.Image"), Class.forName("java.io.OutputStream")};
        Object[] constructorObj = new Object[]{image, os};
        Object encoder = enClass.getConstructor(constructorParams).newInstance(constructorObj);
        Class[] encodeParams = new Class[]{};
        Object[] encodeObj = new Object[]{};
        enClass.getMethod("encodeImage", encodeParams).invoke(encoder, encodeObj);
        os.close();
        image = null;
        os = null;
    }
}

