/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.gc.awt;

import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.awt.ChartAwtGraphics;
import com.java4less.rchart.gc.awt.ImageEncoder;
import com.java4less.rchart.gc.awt.ImageLoader;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;

public class ChartAwtImage
extends ChartImage {
    private Image image = null;

    public ChartAwtImage(Object o) {
        if (o instanceof String) {
            this.image = ImageLoader.getImage((String)o);
        } else if (o instanceof InputStream) {
            this.image = ImageLoader.getImage((InputStream)o);
        } else if (o instanceof Image) {
            this.image = (Image)o;
        }
    }

    public ChartAwtImage(int w, int h, ChartColor transparent) {
        this.image = new BufferedImage(w, h, 2);
        Graphics2D g2D = (Graphics2D)this.image.getGraphics();
        g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        g2D.fillRect(0, 0, w, h);
    }

    public ChartAwtImage(int w, int h) {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.indexOf("1.1") != 0) {
            this.image = new BufferedImage(w, h, 1);
        } else {
            Frame f = new Frame();
            ((Component)f).setVisible(true);
            this.image = f.createImage(w, h);
            ((Component)f).setVisible(false);
        }
    }

    public ChartGraphics getGraphics() {
        if (this.image == null) {
            return null;
        }
        return new ChartAwtGraphics(this.image.getGraphics());
    }

    public int getWidth() {
        if (this.image == null) {
            return 1;
        }
        return this.image.getWidth(null);
    }

    public int getHeight() {
        if (this.image == null) {
            return 1;
        }
        return this.image.getHeight(null);
    }

    public Image getImage() {
        return this.image;
    }

    public boolean saveToStream(String sFormat, OutputStream os) {
        if (this.image == null) {
            return false;
        }
        try {
            ImageEncoder.encode(sFormat, this.image, os);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

