/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.gc.awt;

import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.awt.ChartAwtColor;
import com.java4less.rchart.gc.awt.ChartAwtFont;
import com.java4less.rchart.gc.awt.ChartAwtImage;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public class ChartAwtGraphics
extends ChartGraphics {
    private Graphics graphics;

    public ChartAwtGraphics(Object g) {
        this.graphics = (Graphics)g;
    }

    public void setColor(ChartColor color) {
        this.graphics.setColor(((ChartAwtColor)color).getColor());
    }

    public void setFont(ChartFont font) {
        this.graphics.setFont(((ChartAwtFont)font).getFont());
    }

    public ChartColor getColor() {
        return new ChartAwtColor(this.graphics.getColor());
    }

    public ChartFont getFont() {
        return new ChartAwtFont(this.graphics.getFont());
    }

    public void drawArc(int x, int y, int w, int h, int a1, int a2) {
        this.graphics.drawArc(x, y, w, h, a1, a2);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.setLineStroke();
        ((Graphics2D)this.graphics).draw(new Line2D.Double(x1, y1, x2, y2));
    }

    public void drawLineWithStyle(int x1, int y1, int x2, int y2) {
        this.drawLine(x1, y1, x2, y2);
    }

    public int getFontHeight(ChartFont font) {
        if (font != null) {
            this.graphics.getFontMetrics(((ChartAwtFont)font).getFont()).getHeight();
        }
        return this.graphics.getFontMetrics().getHeight();
    }

    public int getFontWidth(ChartFont font, String s) {
        if (font != null) {
            this.graphics.getFontMetrics(((ChartAwtFont)font).getFont()).stringWidth(s);
        }
        return this.graphics.getFontMetrics().stringWidth(s);
    }

    public boolean drawRotatedText(ChartFont descFont, ChartColor descColor, String txt, int angle, int x, int y, boolean b) {
        this.setFont(descFont);
        this.setColor(descColor);
        int h = this.getFontHeight();
        int w = this.getFontWidth(txt);
        AffineTransform tmp = ((Graphics2D)this.graphics).getTransform();
        AffineTransform moveAf = new AffineTransform();
        if (angle >= 0 && angle <= 180) {
            moveAf.setToTranslation(x, y);
        } else {
            moveAf.setToTranslation(x, y + w);
        }
        ((Graphics2D)this.graphics).transform(moveAf);
        moveAf.setToRotation(Math.toRadians(angle));
        ((Graphics2D)this.graphics).transform(moveAf);
        this.graphics.drawString(txt, 0, 0);
        ((Graphics2D)this.graphics).setTransform(tmp);
        return true;
    }

    public void paintRotatedImage(ChartImage srcImage, int angle, int x, int y, int alignment) {
        int w;
        int h = srcImage.getHeight();
        int rotatedW = w = srcImage.getWidth();
        int rotatedH = h;
        if (angle == 90 || angle == -90 || angle == 270) {
            rotatedW = h;
        }
        if (angle == 90 || angle == -90 || angle == 270) {
            rotatedH = w;
        }
        AffineTransform tmp = ((Graphics2D)this.graphics).getTransform();
        AffineTransform moveAf = new AffineTransform();
        if (alignment == ChartGraphics.ROTATE_LEFTTOP) {
            if (angle >= 0 && angle <= 180) {
                moveAf.setToTranslation(x + rotatedW, y);
            } else {
                moveAf.setToTranslation(x, y + rotatedH);
            }
        }
        if (alignment == ChartGraphics.ROTATE_CENTER) {
            if (angle >= 0 && angle <= 180) {
                moveAf.setToTranslation(x + w / 2, y);
            } else {
                moveAf.setToTranslation(x + w / 2, y + rotatedH);
            }
        }
        ((Graphics2D)this.graphics).transform(moveAf);
        moveAf.setToRotation(Math.toRadians(angle));
        ((Graphics2D)this.graphics).transform(moveAf);
        this.graphics.drawImage(((ChartAwtImage)srcImage).getImage(), 0, 0, null);
        ((Graphics2D)this.graphics).setTransform(tmp);
    }

    public void drawString(String s, int x, int y) {
        this.graphics.drawString(s, x, y);
    }

    public void drawImage(ChartImage image, int x, int y) {
        if (image == null) {
            return;
        }
        if (((ChartAwtImage)image).getImage() == null) {
            return;
        }
        this.graphics.drawImage(((ChartAwtImage)image).getImage(), x, y, null);
    }

    public void drawImage(ChartImage image, int x1Dest, int y1Dest, int x2Dest, int y2Dest, int x1Source, int y1Source, int x2Source, int y2Source) {
        long start = System.currentTimeMillis();
        ChartAwtImage i = (ChartAwtImage)image;
        if (i == null) {
            return;
        }
        if (i.getImage() == null) {
            return;
        }
        this.graphics.drawImage(i.getImage(), x1Dest, y1Dest, x2Dest, y2Dest, x1Source, y1Source, x2Source, y2Source, null);
    }

    protected void setTexture() {
        if (this.textureImage != null) {
            BufferedImage i = new BufferedImage(((ChartAwtImage)this.textureImage).getWidth(), ((ChartAwtImage)this.textureImage).getHeight(), 1);
            Graphics g = i.getGraphics();
            g.drawImage(((ChartAwtImage)this.textureImage).getImage(), 0, 0, null);
            TexturePaint texture = new TexturePaint(i, new Rectangle2D.Double(0.0, 0.0, i.getWidth(null) - 1, i.getHeight(null) - 1));
            ((Graphics2D)this.graphics).setPaint(texture);
            this.textureImage = null;
        }
    }

    protected void resetTexture() {
        ((Graphics2D)this.graphics).setPaint(null);
    }

    public void fillPolygon(int[] x1, int[] y1, int count) {
        this.setTexture();
        this.graphics.fillPolygon(x1, y1, count);
        this.resetTexture();
    }

    public void fillRect(int x1, int y1, int w, int h) {
        this.setTexture();
        this.graphics.fillRect(x1, y1, w, h);
        this.resetTexture();
    }

    public void drawRoundedRect(int x1, int y1, int w, int h) {
        this.setLineStroke();
        ((Graphics2D)this.graphics).draw(new RoundRectangle2D.Double(x1, y1, w, h, 10.0, 10.0));
    }

    public void fillRoundRect(int x1, int y1, int w, int h) {
        this.setTexture();
        ((Graphics2D)this.graphics).fill(new RoundRectangle2D.Double(x1, y1, w, h, 10.0, 10.0));
        this.resetTexture();
    }

    public void drawPolygon(int[] x1, int[] y1, int count) {
        this.setLineStroke();
        this.graphics.drawPolygon(x1, y1, count);
    }

    public void drawRect(int x1, int y1, int w, int h) {
        this.setLineStroke();
        ((Graphics2D)this.graphics).draw(new Rectangle2D.Double(x1, y1, w, h));
    }

    public void createFadeArea(ChartColor colorFrom, ChartColor colorUntil, int x, int y, int w, int h, boolean vertical, boolean cyclic) {
        if (!vertical) {
            ((Graphics2D)this.graphics).setPaint(new GradientPaint(x, y, ((ChartAwtColor)colorFrom).getColor(), x + w, y, ((ChartAwtColor)colorUntil).getColor(), cyclic));
        } else {
            ((Graphics2D)this.graphics).setPaint(new GradientPaint(x, y, ((ChartAwtColor)colorFrom).getColor(), x, y + h, ((ChartAwtColor)colorUntil).getColor(), cyclic));
        }
        this.graphics.fillRect(x, y, w, h);
    }

    public void fillArc(int x, int y, int w, int h, int a1, int a2) {
        this.setTexture();
        this.graphics.fillArc(x, y, w, h, a1, a2);
        this.resetTexture();
    }

    public void setAlpha(float a) {
        if (this.graphics instanceof Graphics2D) {
            ((Graphics2D)this.graphics).setComposite(AlphaComposite.getInstance(3, a));
        }
    }

    public void setAlphaComposite(Object a) {
        if (this.graphics instanceof Graphics2D) {
            ((Graphics2D)this.graphics).setComposite((AlphaComposite)a);
        }
    }

    public Object getAlphaComposite() {
        return (AlphaComposite)((Graphics2D)this.graphics).getComposite();
    }

    public void setLineStyle(int style) {
        super.setLineStyle(style);
    }

    public void setLineWidth(int w) {
        super.setLineWidth(w);
    }

    protected void setLineStroke() {
        if (this.graphics instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.graphics;
            BasicStroke st = null;
            float[] dash1 = new float[]{10.0f};
            float[] dash2 = new float[]{2.0f};
            st = new BasicStroke(this.lineWidth);
            if (this.lineStyle == ChartGraphics.STROKE_DASHED) {
                st = new BasicStroke(this.lineWidth, 0, 0, 10.0f, dash1, 0.0f);
            }
            if (this.lineStyle == ChartGraphics.STROKE_DOTTED) {
                st = new BasicStroke(this.lineWidth, 0, 0, 10.0f, dash2, 0.0f);
            }
            g2.setStroke(st);
        }
    }
}

