/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.gc.awt;

import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.awt.ChartAwt1Graphics;
import com.java4less.rchart.gc.awt.ChartAwtColor;
import com.java4less.rchart.gc.awt.ImageEncoder1;
import com.java4less.rchart.gc.awt.ImageLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.io.InputStream;
import java.io.OutputStream;

public class ChartAwt1Image
extends ChartImage {
    public static Component visibleComponent = null;
    private Image image = null;
    protected Color transparentBackground = null;

    public ChartAwt1Image(Object o) {
        if (o instanceof String) {
            this.image = ImageLoader.getImage((String)o);
        } else if (o instanceof InputStream) {
            this.image = ImageLoader.getImage((InputStream)o);
        } else if (o instanceof Image) {
            this.image = (Image)o;
        }
    }

    public ChartAwt1Image(int w, int h, ChartColor transparent) {
        this.transparentBackground = ((ChartAwtColor)transparent).getColor();
        if (visibleComponent == null) {
            visibleComponent = new Frame();
            visibleComponent.setVisible(true);
        }
        this.image = visibleComponent.createImage(w, h);
        Graphics g = this.image.getGraphics();
        g.setColor(this.transparentBackground);
        g.fillRect(0, 0, w, h);
        g.dispose();
        g = null;
    }

    public ChartAwt1Image(int w, int h) {
        if (visibleComponent == null) {
            visibleComponent = new Frame();
            visibleComponent.setVisible(true);
        }
        this.image = visibleComponent.createImage(w, h);
    }

    public ChartGraphics getGraphics() {
        if (this.image == null) {
            return null;
        }
        return new ChartAwt1Graphics(this.image.getGraphics());
    }

    public int getWidth() {
        if (this.image == null) {
            return 1;
        }
        return this.image.getWidth(null);
    }

    public int getHeight() {
        if (this.image == null) {
            return 1;
        }
        return this.image.getHeight(null);
    }

    public Image getImage() {
        return this.image;
    }

    public boolean saveToStream(String sFormat, OutputStream os) {
        if (this.image == null) {
            return false;
        }
        try {
            ImageEncoder1.encode(sFormat, this.image, os);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

