/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.gc.awt;

import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.awt.ChartAwt1Image;
import com.java4less.rchart.gc.awt.ChartAwtColor;
import com.java4less.rchart.gc.awt.ChartAwtFont;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ChartAwt1Graphics
extends ChartGraphics {
    private Graphics graphics;

    public ChartAwt1Graphics(Object g) {
        this.graphics = (Graphics)g;
    }

    public void setColor(ChartColor color) {
        this.graphics.setColor(((ChartAwtColor)color).getColor());
    }

    public void setFont(ChartFont font) {
        this.graphics.setFont(((ChartAwtFont)font).getFont());
    }

    public ChartColor getColor() {
        return new ChartAwtColor(this.graphics.getColor());
    }

    public ChartFont getFont() {
        return new ChartAwtFont(this.graphics.getFont());
    }

    public void drawArc(int x, int y, int w, int h, int a1, int a2) {
        this.graphics.drawArc(x, y, w, h, a1, a2);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    public int getFontHeight(ChartFont font) {
        if (font != null) {
            this.graphics.getFontMetrics(((ChartAwtFont)font).getFont()).getHeight();
        }
        return this.graphics.getFontMetrics().getHeight();
    }

    public int getFontWidth(ChartFont font, String s) {
        if (font != null) {
            this.graphics.getFontMetrics(((ChartAwtFont)font).getFont()).stringWidth(s);
        }
        return this.graphics.getFontMetrics().stringWidth(s);
    }

    public boolean drawRotatedText(ChartFont descFont, ChartColor descColor, String txt, int angle, int x, int y, boolean b) {
        if (angle != 90 && angle != -90) {
            return false;
        }
        Color transparent = Color.white;
        if (descColor.equals(transparent)) {
            transparent = Color.black;
        }
        int iWidth = 300;
        int iHeight = 300;
        int[] pix = new int[iWidth * iHeight];
        Image tmpImage = new ChartAwt1Image(iWidth, iHeight).getImage();
        Graphics g = tmpImage.getGraphics();
        g.setColor(transparent);
        g.setFont(((ChartAwtFont)descFont).getFont());
        int h = g.getFontMetrics().getHeight();
        int w = g.getFontMetrics().stringWidth(txt);
        int x1 = x - h / 2;
        int y1 = y;
        g.fillRect(0, 0, w, h);
        g.setColor(((ChartAwtColor)descColor).getColor());
        g.drawString(txt, 0, h - g.getFontMetrics().getDescent());
        Image rotated = this.rotate(tmpImage, 90, w, h, transparent);
        this.graphics.drawImage(rotated, x1, y1, null);
        return true;
    }

    public void paintRotatedImage(ChartImage srcImage, int angle, int x, int y, int alignment) {
        if (angle == 45) {
            angle = 90;
        }
        if (angle != 90 && angle != -90) {
            return;
        }
        Color transparent = ((ChartAwt1Image)srcImage).transparentBackground;
        int iWidth = 500;
        int iHeight = 500;
        int[] pix = new int[iWidth * iHeight];
        Image tmpImage = new ChartAwt1Image(iWidth, iHeight).getImage();
        Graphics g = tmpImage.getGraphics();
        g.setColor(transparent);
        int h = srcImage.getHeight();
        int w = srcImage.getWidth();
        int x1 = x + w / 2;
        int y1 = y;
        if (alignment == ChartGraphics.ROTATE_LEFTTOP) {
            x1 = x;
            y1 = y;
        }
        g.fillRect(0, 0, iWidth, iHeight);
        g.drawImage(((ChartAwt1Image)srcImage).getImage(), 0, 0, null);
        g.dispose();
        g = null;
        Image rotated = this.rotate(tmpImage, 90, w, h, transparent);
        this.graphics.drawImage(rotated, x1, y1, null);
    }

    private Image rotate(Image im, int angle, int maxw, int maxh, Color transparent) {
        int w = im.getWidth(null);
        int h = im.getHeight(null);
        if (maxw > w) {
            maxw = w;
        }
        if (maxh > h) {
            maxh = h;
        }
        ColorModel cm = null;
        int[] pixels = new int[w * h];
        int[] pixels2 = new int[maxw * maxh];
        PixelGrabber pg = new PixelGrabber(im, 0, 0, w, h, pixels, 0, w);
        cm = pg.getColorModel();
        DirectColorModel dcm = null;
        IndexColorModel icm = null;
        if (cm instanceof DirectColorModel) {
            dcm = (DirectColorModel)cm;
        }
        if (cm instanceof IndexColorModel) {
            icm = (IndexColorModel)cm;
        }
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        if (angle == -90) {
            int i = 0;
            while (i < maxw) {
                int j = 0;
                while (j < maxh) {
                    int dummy = 0;
                    dummy = pixels[j * w + i];
                    int al = 0;
                    al = dcm.getAlpha(dummy);
                    if (new Color(dummy).equals(transparent)) {
                        if (icm != null) {
                            dummy = icm.getTransparentPixel();
                        }
                        if (dcm != null) {
                            dummy = (dcm.getBlueMask() | dcm.getRedMask() | dcm.getGreenMask()) & dummy;
                        }
                    }
                    pixels2[maxh * (maxw - (i + 1)) + j] = dummy;
                    ++j;
                }
                ++i;
            }
            cm.finalize();
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(maxh, maxw, cm, pixels2, 0, maxh));
        }
        if (angle == 180) {
            int i = 0;
            while (i < maxw) {
                int j = 0;
                while (j < maxh) {
                    int dummy = 0;
                    dummy = pixels[j * w + i];
                    int al = 0;
                    al = dcm.getAlpha(dummy);
                    if (new Color(dummy).equals(transparent)) {
                        if (icm != null) {
                            dummy = icm.getTransparentPixel();
                        }
                        if (dcm != null) {
                            dummy = (dcm.getBlueMask() | dcm.getRedMask() | dcm.getGreenMask()) & dummy;
                        }
                    }
                    pixels2[(maxh - (j + 1)) * maxw + (maxw - (i + 1))] = dummy;
                    ++j;
                }
                ++i;
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(maxw, maxh, cm, pixels2, 0, maxw));
        }
        if (angle == 90) {
            int i = 0;
            while (i < maxw) {
                int j = 0;
                while (j < maxh) {
                    int dummy = 0;
                    dummy = pixels[j * w + i];
                    int al = 0;
                    al = dcm.getAlpha(dummy);
                    if (new Color(dummy).equals(transparent)) {
                        if (icm != null) {
                            dummy = icm.getTransparentPixel();
                        }
                        if (dcm != null) {
                            dummy = (dcm.getBlueMask() | dcm.getRedMask() | dcm.getGreenMask()) & dummy;
                        }
                    }
                    pixels2[maxh * i + (maxh - (j + 1))] = dummy;
                    ++j;
                }
                ++i;
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(maxh, maxw, cm, pixels2, 0, maxh));
        }
        return null;
    }

    public void drawString(String s, int x, int y) {
        this.graphics.drawString(s, x, y);
    }

    public void drawImage(ChartImage image, int x, int y) {
        if (image == null) {
            return;
        }
        Image i = ((ChartAwt1Image)image).getImage();
        if (i == null) {
            return;
        }
        this.graphics.drawImage(i, x, y, null);
    }

    public void drawImage(ChartImage image, int x1Dest, int y1Dest, int x2Dest, int y2Dest, int x1Source, int y1Source, int x2Source, int y2Source) {
        long start = System.currentTimeMillis();
        ChartAwt1Image i = (ChartAwt1Image)image;
        if (i == null) {
            return;
        }
        if (i.getImage() == null) {
            return;
        }
        this.graphics.drawImage(i.getImage(), x1Dest, y1Dest, x2Dest, y2Dest, x1Source, y1Source, x2Source, y2Source, null);
    }

    public void fillPolygon(int[] x1, int[] y1, int count) {
        this.graphics.fillPolygon(x1, y1, count);
    }

    public void fillRect(int x1, int y1, int w, int h) {
        this.graphics.fillRect(x1, y1, w, h);
    }

    public void drawPolygon(int[] x1, int[] y1, int count) {
        this.graphics.drawPolygon(x1, y1, count);
    }

    public void drawRect(int x1, int y1, int w, int h) {
        super.drawRect(x1, y1, w, h);
    }

    public void createFadeArea(ChartColor colorFrom, ChartColor colorUntil, int x, int y, int w, int h, boolean vertical, boolean cyclic) {
        int[] pix = new int[w * h];
        int index = 0;
        int r1 = colorFrom.getRed();
        int b1 = colorFrom.getBlue();
        int g1 = colorFrom.getGreen();
        int r2 = colorUntil.getRed();
        int b2 = colorUntil.getBlue();
        int g2 = colorUntil.getGreen();
        int red = 0;
        int blue = 0;
        int green = 0;
        int reddiff = r2 - r1;
        int bluediff = b2 - b1;
        int greendiff = g2 - g1;
        int y1 = 0;
        while (y1 < h) {
            if (vertical) {
                red = (int)((double)r1 + (double)reddiff / (double)h * (double)y1);
                blue = (int)((double)b1 + (double)bluediff / (double)h * (double)y1);
                green = (int)((double)g1 + (double)greendiff / (double)h * (double)y1);
            }
            int x1 = 0;
            while (x1 < w) {
                if (!vertical) {
                    red = (int)((double)r1 + (double)reddiff / (double)w * (double)x1);
                    blue = (int)((double)b1 + (double)bluediff / (double)w * (double)x1);
                    green = (int)((double)g1 + (double)greendiff / (double)w * (double)x1);
                }
                pix[index++] = new Color(red, green, blue).getRGB();
                ++x1;
            }
            ++y1;
        }
        Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pix, 0, w));
        int wimg = img.getWidth(null);
        int himg = img.getHeight(null);
        this.graphics.drawImage(img, x, y, null);
    }

    public void fillArc(int x, int y, int w, int h, int a1, int a2) {
        this.graphics.fillArc(x, y, w, h, a1, a2);
    }

    public void setAlpha(float a) {
    }

    public void setAlphaComposite(Object a) {
    }

    public Object getAlphaComposite() {
        return null;
    }

    public void setLineStyle(int style) {
        super.setLineStyle(style);
    }

    public void setLineWidth(int w) {
        super.setLineWidth(w);
    }
}

