/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.gc;

import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.awt.ChartAwt1Graphics;
import com.java4less.rchart.gc.awt.ChartAwt1Image;
import com.java4less.rchart.gc.awt.ChartAwtColor;
import com.java4less.rchart.gc.awt.ChartAwtFont;
import com.java4less.rchart.gc.awt.ChartAwtGraphics;
import com.java4less.rchart.gc.awt.ChartAwtImage;
import com.java4less.rchart.gc.swt.ChartSwtColor;
import com.java4less.rchart.gc.swt.ChartSwtFont;
import com.java4less.rchart.gc.swt.ChartSwtGraphics;
import com.java4less.rchart.gc.swt.ChartSwtImage;
import com.java4less.rchart.gc.swt.SwtGraphicsProvider;

public class GraphicsProvider {
    public static int MODE_AWT_SWING = 0;
    public static int MODE_SWT = 1;
    public static int MODE_AWT1 = 2;
    private static int mode = MODE_AWT_SWING;

    static {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.indexOf("1.1") == 0) {
            GraphicsProvider.setMode(MODE_AWT1);
        }
    }

    public static void setMode(int m) {
        mode = m;
    }

    public static int getMode() {
        return mode;
    }

    public static ChartColor getColor(String c) {
        if (mode == MODE_AWT_SWING || mode == MODE_AWT1) {
            return new ChartAwtColor(c);
        }
        return new ChartSwtColor(c);
    }

    public static ChartColor getColor(int red, int green, int blue) {
        if (mode == MODE_AWT_SWING || mode == MODE_AWT1) {
            return new ChartAwtColor(red, green, blue);
        }
        return new ChartSwtColor(red, green, blue);
    }

    public static ChartColor getColorFromObject(Object o) {
        if (mode == MODE_AWT_SWING || mode == MODE_AWT1) {
            return new ChartAwtColor(o);
        }
        return new ChartSwtColor(o);
    }

    public static ChartFont getFont(String c, int style, int size) {
        if (mode == MODE_AWT_SWING || mode == MODE_AWT1) {
            return new ChartAwtFont(c, style, size);
        }
        return new ChartSwtFont(c, style, size);
    }

    public static ChartFont getFontFromObject(Object o) {
        if (mode == MODE_AWT_SWING || mode == MODE_AWT1) {
            return new ChartAwtFont(o);
        }
        return new ChartSwtFont(o);
    }

    public static ChartGraphics getGraphics(Object o) {
        if (mode == MODE_AWT_SWING) {
            return new ChartAwtGraphics(o);
        }
        if (mode == MODE_AWT1) {
            return new ChartAwt1Graphics(o);
        }
        return new ChartSwtGraphics(o);
    }

    public static ChartImage getImage(Object o) {
        try {
            if (mode == MODE_AWT_SWING) {
                return new ChartAwtImage(o);
            }
            if (mode == MODE_AWT1) {
                return new ChartAwt1Image(o);
            }
            return new ChartSwtImage(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ChartImage getImageFromFile(String file) {
        try {
            if (mode == MODE_AWT_SWING) {
                return new ChartAwtImage(file);
            }
            if (mode == MODE_AWT1) {
                return new ChartAwt1Image(file);
            }
            return new ChartSwtImage(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ChartImage createImage(int w, int h) {
        if (mode == MODE_AWT_SWING) {
            return new ChartAwtImage(w, h);
        }
        if (mode == MODE_AWT1) {
            return new ChartAwt1Image(w, h);
        }
        return new ChartSwtImage(w, h);
    }

    public static ChartImage createTransparentImage(int w, int h, ChartColor transparent) {
        if (mode == MODE_AWT_SWING) {
            return new ChartAwtImage(w, h, transparent);
        }
        if (mode == MODE_AWT1) {
            return new ChartAwt1Image(w, h, transparent);
        }
        return new ChartSwtImage(w, h, transparent);
    }

    public static void startUIThread(Runnable r) {
        if (mode == MODE_AWT_SWING || mode == MODE_AWT1) {
            new Thread(r).start();
        } else {
            SwtGraphicsProvider.startUIThread(r);
        }
    }
}

