/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.awt;

import com.java4less.rchart.BarPlotter3D;
import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartAdapter;
import com.java4less.rchart.LinePlotter3D;
import com.java4less.rchart.awt.ChartCanvas;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.MemoryImageSource;

public class ChartViewer
extends Panel
implements AdjustmentListener,
ActionListener {
    private int[] imageP = new int[]{0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -1, -1, -1, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -1, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -16777088, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -1, -16777088, -1, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -16777088, -16777088, -16777088, -16777088, -16777088, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -1, -16777088, -1, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -16777088, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -1, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -1, -1, -1, -16777216, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, 0xC0C0C0};
    private int[] imageM = new int[]{0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -1, -1, -1, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -1, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -1, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -16777088, -16777088, -16777088, -16777088, -16777088, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -1, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -1, -1, -1, -1, -1, -1, -1, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -1, -1, -1, -16777216, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, -16777216, -16777216, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, 0xC0C0C0, -16777216, 0xC0C0C0};
    private Scrollbar scH = new Scrollbar(0);
    private Scrollbar scV = new Scrollbar(1);
    private ChartCanvas canvas = new ChartCanvas();
    private static Cursor pointCursor = new Cursor(12);
    private static Cursor waitCursor = new Cursor(3);
    private static Cursor defaultCursor = new Cursor(0);
    private iButton plusZoom = new iButton(this.imageP);
    private iButton minusZoom = new iButton(this.imageM);
    private Label zoom = new Label("100%");
    private Panel zoomPanel = new Panel();
    private int lastWidth = -1;
    private int lastHeight = -1;
    private int lastZoom = 0;
    private int originalHeight = -1;
    private int originalWidth = -1;
    public boolean allowZoom = true;
    public int maxZoom = 200;
    public int minZoom = 50;
    public int currentZoom = 100;
    public int zoomIncrement = 25;
    public boolean changePointer = true;
    ChartAdapter chartAdapter = new ChartAdapter(){

        public void chartEvent(Chart c, int type) {
            if (type == 2) {
                ChartViewer.this.canvas.setCursor(pointCursor);
            }
            if (type == 3) {
                ChartViewer.this.canvas.setCursor(defaultCursor);
            }
        }
    };

    public ChartViewer() {
        this.plusZoom.addActionListener(this);
        this.minusZoom.addActionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (ChartViewer.this.canvas.getChart() == null) {
                    return;
                }
                ChartViewer.this.placeControls();
                ChartViewer.this.updateScrollBarsConfiguration();
                ChartViewer.this.updateSize();
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    private void placeControls() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 0));
        if (this.canvas.getChart().virtualHeight > 0) {
            this.add("East", this.scV);
            this.scV.doLayout();
            this.scV.addAdjustmentListener(this);
            this.canvas.getChart().withScroll = true;
            this.canvas.getChart().repaintAlways = false;
        }
        if (this.allowZoom && (this.canvas.getChart().virtualHeight > 0 || this.canvas.getChart().virtualWidth > 0)) {
            this.zoomPanel = new SouthPanel(15);
            this.add("South", this.zoomPanel);
            this.doLayout();
            this.zoomPanel.setLayout(null);
            this.zoom.setBounds(2, 0, 30, this.zoomPanel.getSize().height);
            this.minusZoom.setBounds(35, 0, 20, this.zoomPanel.getSize().height);
            this.plusZoom.setBounds(55, 0, 20, this.zoomPanel.getSize().height);
            this.zoomPanel.add(this.zoom);
            this.zoomPanel.add(this.minusZoom);
            this.zoomPanel.add(this.plusZoom);
            this.plusZoom.repaint();
            this.minusZoom.repaint();
        }
        if (this.canvas.getChart().virtualWidth > 0) {
            if (this.allowZoom) {
                this.scH.setBounds(76, 0, this.zoomPanel.getSize().width - 76, this.zoomPanel.getSize().height);
                this.zoomPanel.add(this.scH);
            } else {
                this.add("South", this.scH);
            }
            this.scH.addAdjustmentListener(this);
            this.canvas.getChart().withScroll = true;
            this.canvas.getChart().repaintAlways = false;
        }
        this.add("Center", this.canvas);
        this.doLayout();
    }

    public Chart getChart() {
        return this.canvas.getChart();
    }

    public void setChart(Chart c) {
        if (this.canvas.getChart() != null) {
            this.canvas.getChart().removeChartListener(this.chartAdapter);
        }
        this.canvas.setChart(c);
        this.originalHeight = this.canvas.getChart().virtualHeight;
        this.originalWidth = this.canvas.getChart().virtualWidth;
        this.resetChart();
        this.placeControls();
        this.updateScrollBarsConfiguration();
        this.updateSize();
        if (this.changePointer) {
            this.canvas.getChart().addChartListener(this.chartAdapter);
        }
    }

    private void resetChart() {
        this.lastWidth = 0;
        this.lastHeight = 0;
        this.lastZoom = 0;
    }

    private void zoomUpdated() {
        this.zoom.setText("" + this.currentZoom + "%");
        this.updateSize();
        this.updateScrollBarsConfiguration();
        this.setCursor(waitCursor);
        this.canvas.paint(this.canvas.getGraphics());
        this.setCursor(defaultCursor);
    }

    private void plusZoom() {
        this.currentZoom = this.currentZoom + this.zoomIncrement < this.maxZoom ? (this.currentZoom += this.zoomIncrement) : this.maxZoom;
        this.zoomUpdated();
    }

    private void minusZoom() {
        this.currentZoom = this.currentZoom - this.zoomIncrement > this.minZoom ? (this.currentZoom -= this.zoomIncrement) : this.minZoom;
        this.zoomUpdated();
    }

    private void updateScrollBarsConfiguration() {
        if (this.canvas.getChart().virtualWidth > 0) {
            int w = this.canvas.getSize().width;
            this.scH.setMinimum(0);
            this.scH.setMaximum(this.canvas.getChart().virtualWidth);
            this.scH.setVisibleAmount(w);
            this.scH.setUnitIncrement((int)((double)this.canvas.getSize().width * 0.2));
            this.scH.setBlockIncrement((int)((double)this.canvas.getSize().width * 0.75));
            this.scH.setVisible(true);
            if (this.canvas.getChart().offsetX > this.canvas.getChart().virtualWidth - w) {
                this.canvas.getChart().offsetX = this.canvas.getChart().virtualWidth - w;
            }
            if (this.canvas.getChart().offsetX < 0) {
                this.canvas.getChart().offsetX = 0;
            }
            if (this.canvas.getChart().offsetX > this.canvas.getChart().virtualWidth - w) {
                this.canvas.getChart().offsetX = 0;
            }
            this.scH.setValue(this.canvas.getChart().offsetX);
        }
        if (this.canvas.getChart().virtualHeight > 0) {
            int h = this.canvas.getSize().height;
            this.scV.setMinimum(0);
            this.scV.setMaximum(this.canvas.getChart().virtualHeight);
            this.scV.setVisibleAmount(h);
            this.scV.setUnitIncrement((int)((double)this.canvas.getSize().height * 0.2));
            this.scV.setBlockIncrement((int)((double)this.canvas.getSize().height * 0.75));
            this.scV.setVisible(true);
            if (this.canvas.getChart().offsetY > this.canvas.getChart().virtualHeight - h) {
                this.canvas.getChart().offsetY = this.canvas.getChart().virtualHeight - h;
            }
            if (this.canvas.getChart().offsetY < 0) {
                this.canvas.getChart().offsetY = 0;
            }
            if (this.canvas.getChart().offsetY > this.canvas.getChart().virtualHeight - h) {
                this.canvas.getChart().offsetY = 0;
            }
            this.scV.setValue(this.canvas.getChart().offsetY);
        }
        if (this.allowZoom) {
            this.zoom.setBounds(2, 0, 30, this.zoomPanel.getSize().height);
            this.minusZoom.setBounds(35, 0, 20, this.zoomPanel.getSize().height);
            this.plusZoom.setBounds(55, 0, 20, this.zoomPanel.getSize().height);
            int tw = this.getSize().width;
            this.scH.setBounds(76, 0, tw - 76, this.zoomPanel.getSize().height);
        }
    }

    private void updateSize() {
        this.canvas.getChart().repaintAll = true;
        if (this.lastWidth != this.getSize().width || this.lastHeight != this.getSize().height || this.lastZoom != this.currentZoom) {
            this.canvas.getChart().setSize(this.getSize().width, this.getSize().height);
            this.lastWidth = this.getSize().width;
            this.lastHeight = this.getSize().height;
            this.lastZoom = this.currentZoom;
            if (this.canvas.getChart().withScroll) {
                if (this.allowZoom) {
                    this.canvas.getChart().virtualHeight = this.originalHeight > 0 ? this.originalHeight * this.currentZoom / 100 : 0;
                    this.canvas.getChart().virtualWidth = this.originalWidth > 0 ? this.originalWidth * this.currentZoom / 100 : 0;
                }
                this.canvas.getChart().repaintAll = true;
            }
        }
    }

    private void vSliderScroll(AdjustmentEvent e) {
        int newBase = 0;
        newBase = e.getValue() + this.scV.getVisibleAmount() < this.canvas.getChart().virtualHeight ? e.getValue() : this.canvas.getChart().virtualHeight - this.scV.getVisibleAmount();
        if (newBase < 0) {
            newBase = 0;
        }
        this.scV.setValue(newBase);
        this.canvas.getChart().offsetY = newBase;
        if (this.canvas.getChart().plotters[0] instanceof BarPlotter3D) {
            this.canvas.getChart().repaintAll = true;
        }
        if (this.canvas.getChart().plotters[0] instanceof LinePlotter3D) {
            this.canvas.getChart().repaintAll = true;
        }
        this.paint(this.getGraphics());
        this.canvas.paint(this.canvas.getGraphics());
    }

    private void hSliderScroll(AdjustmentEvent e) {
        int newBase = 0;
        newBase = e.getValue() + this.scH.getVisibleAmount() < this.canvas.getChart().virtualWidth ? e.getValue() : this.canvas.getChart().virtualWidth - this.scH.getVisibleAmount();
        if (newBase < 0) {
            newBase = 0;
        }
        this.scH.setValue(newBase);
        this.canvas.getChart().offsetX = newBase;
        if (this.canvas.getChart().plotters[0] instanceof LinePlotter3D) {
            this.canvas.getChart().repaintAll = true;
        }
        if (this.canvas.getChart().plotters[0] instanceof BarPlotter3D) {
            this.canvas.getChart().repaintAll = true;
        }
        this.paint(this.getGraphics());
        this.canvas.paint(this.canvas.getGraphics());
    }

    public void redrawChart() {
        if (this.canvas.getGraphics() != null) {
            this.canvas.paintAll(this.canvas.getGraphics());
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        Chart chart = this.canvas.getChart();
        if (chart == null) {
            return;
        }
        if (e.getSource() == this.scV) {
            this.vSliderScroll(e);
        } else if (e.getSource() == this.scH) {
            this.hSliderScroll(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.canvas.getChart() == null) {
            return;
        }
        String sActionCmd = e.getActionCommand();
        if (e.getSource() == this.plusZoom) {
            this.plusZoom();
        }
        if (e.getSource() == this.minusZoom) {
            this.minusZoom();
        }
    }

    class iButton
    extends Button {
        Image i = null;

        public iButton(int[] p) {
            super("");
            this.i = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(14, 14, p, 0, 14));
            this.i.getWidth(null);
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(this.i, 2, 1, null);
        }
    }

    class SouthPanel
    extends Panel {
        private int minHeight;

        public SouthPanel(int h) {
            this.minHeight = h;
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, this.minHeight);
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, this.minHeight);
        }
    }
}

