/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart.awt;

import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartListener;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.GraphicsProvider;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class ChartCanvas
extends Canvas
implements ChartListener {
    private Chart chart = null;

    public ChartCanvas() {
        MouseMotionAdapter mouseMove = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                ChartCanvas.this.mouseMoved(e);
            }
        };
        this.addMouseMotionListener(mouseMove);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ChartCanvas.this.mouseClick();
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ChartCanvas.this.resizeChart();
            }
        });
    }

    private void mouseMoved(MouseEvent e) {
        if (this.chart != null) {
            this.chart.mouseMoved(e.getX(), e.getY());
        }
    }

    private void mouseClick() {
        if (this.chart != null) {
            this.chart.mouseClick();
        }
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart c) {
        if (this.chart != null) {
            this.chart.removeChartListener(this);
        }
        this.chart = c;
        this.chart.addChartListener(this);
    }

    protected void resizeChart() {
        this.chart.setWidth(this.getSize().width + 1);
        this.chart.setHeight(this.getSize().height + 1);
    }

    public void paint(Graphics g) {
        try {
            this.resizeChart();
            if (g == null) {
                return;
            }
            ChartGraphics g2 = GraphicsProvider.getGraphics(g);
            this.chart.paint(g2);
            g2.dispose();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void paintUserExit(Chart c, ChartGraphics g) {
    }

    public void chartEvent(Chart c, int type) {
        if (type == 4) {
            this.paint(this.getGraphics());
        }
        if (type == 1) {
            GraphicsProvider.startUIThread(new Runnable(){

                public void run() {
                    ChartCanvas.this.paint(ChartCanvas.this.getGraphics());
                }
            });
        }
    }
}

