/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.ChartComponent;
import com.java4less.rchart.ChartLabel;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.GraphicsProvider;

public class Title
extends ChartComponent {
    public String text;
    public ChartFont font = GraphicsProvider.getFont("Arial", ChartFont.PLAIN, 14);
    public ChartColor color = GraphicsProvider.getColor(ChartColor.BLACK);

    public Title(String t) {
        this.text = t;
    }

    public void draw(ChartGraphics g) {
        g.setColor(this.color);
        g.setFont(this.font);
        if (this.text.indexOf("@") >= 0) {
            ChartLabel formattedLabel = new ChartLabel(this.text, "", false, true);
            formattedLabel.initialize(g, this.chart);
            formattedLabel.paint(g, this.x, this.y, this.width, this.height);
            return;
        }
        String[] txt = new String[3];
        txt[0] = this.text;
        if (txt[0].indexOf("\\n") > -1) {
            txt[1] = txt[0].substring(txt[0].indexOf("\\n") + 2, txt[0].length());
            txt[0] = txt[0].substring(0, txt[0].indexOf("\\n"));
            if (txt[1].indexOf("\\n") > -1) {
                txt[2] = txt[1].substring(txt[1].indexOf("\\n") + 2, txt[1].length());
                txt[1] = txt[1].substring(0, txt[1].indexOf("\\n"));
            }
        }
        int i = 0;
        while (i < 3) {
            if (txt[i] != null) {
                int toCenterY;
                int toCenterX = (this.width - g.getFontWidth(null, txt[i])) / 2;
                if (toCenterX < 0) {
                    toCenterX = 0;
                }
                if ((toCenterY = (this.height - g.getFontHeight()) / 2) < 0) {
                    toCenterY = 0;
                }
                g.drawString(txt[i], this.x + toCenterX, this.y + toCenterY + g.getFontHeight() * (i + 1));
            }
            ++i;
        }
    }
}

