/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.ChartLabel;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.LineDataSerie;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.GraphicsProvider;
import java.awt.Polygon;
import java.text.DecimalFormat;

public class RadarPlotter
extends Plotter {
    public double radiusModifier = 0.9;
    LineStyle border = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.BLACK), 1);
    public boolean drawCircle = false;
    public String[] factorNames;
    public ChartColor[] factorColors;
    public double[] factorMins;
    public double[] factorMaxs;
    public ChartFont factorFont = GraphicsProvider.getFont("Arial", ChartFont.PLAIN, 10);
    public ChartColor factorColor = GraphicsProvider.getColor(ChartColor.BLACK);
    public LineStyle gridStyle;
    public ChartFont gridFont;
    public ChartColor gridFontColor = GraphicsProvider.getColor(ChartColor.BLACK);
    public int ticks = 5;
    public String tickLabelFormat = "#.#";
    public FillStyle backStyle;
    public ChartColor[] pointColors = null;
    public double[] pointColorScale = null;

    public RadarPlotter() {
        this.combinable = false;
        this.needsAxis = 0;
    }

    protected void plotSerie(ChartGraphics g, DataSerie s, int serieSec) {
        double angle;
        int i;
        double lastPercent = 0.0;
        double lastAngle = 0.0;
        if (!(s instanceof LineDataSerie)) {
            return;
        }
        LineDataSerie p = (LineDataSerie)s;
        s.hotAreas.removeAllElements();
        double count = p.yData.size();
        int[] xs = new int[(int)count];
        int[] ys = new int[(int)count];
        int radi = 0;
        radi = this.width;
        if (this.height < radi) {
            radi = this.height;
        }
        radi = (int)((double)radi * this.radiusModifier);
        int toCenterX = (this.width - radi) / 2;
        int toCenterY = (this.height - radi) / 2;
        int PieCenterX = toCenterX + this.x + radi / 2;
        int PieCenterY = toCenterY + this.y + radi / 2;
        if (serieSec == 0 || serieSec >= this.series.size() - 1) {
            int relativeX;
            int relativeY;
            double Cos;
            double Sin;
            double radian;
            if (serieSec == 0 && this.backStyle != null && this.drawCircle) {
                this.backStyle.drawArc(g, toCenterX + this.x, toCenterY + this.y, radi, radi, 0, 360);
            }
            if (serieSec == 0 && this.backStyle != null && !this.drawCircle) {
                i = 0;
                while ((double)i < count) {
                    angle = 360.0 / count * (double)i;
                    if ((angle += 90.0) > 360.0) {
                        angle -= 360.0;
                    }
                    radian = 0.01745277777777778 * angle;
                    Sin = Math.sin(radian);
                    Cos = Math.cos(radian);
                    relativeY = (int)(Sin * (double)(radi / 2));
                    relativeX = (int)(Cos * (double)(radi / 2));
                    xs[i] = PieCenterX + relativeX;
                    ys[i] = PieCenterY + (relativeY *= -1);
                    ++i;
                }
                this.backStyle.drawPolygon(g, xs, ys, (int)count);
            }
            if (serieSec == this.series.size() - 1 && this.border != null) {
                if (this.drawCircle) {
                    this.border.drawArc(g, toCenterX + this.x, toCenterY + this.y, radi, radi, 0, 360);
                }
                i = 0;
                while ((double)i < count) {
                    angle = 360.0 / count * (double)i;
                    if ((angle += 90.0) > 360.0) {
                        angle -= 360.0;
                    }
                    radian = 0.01745277777777778 * angle;
                    Sin = Math.sin(radian);
                    Cos = Math.cos(radian);
                    relativeY = (int)(Sin * (double)(radi / 2));
                    relativeX = (int)(Cos * (double)(radi / 2));
                    this.border.draw(g, PieCenterX, PieCenterY, PieCenterX + relativeX, PieCenterY + (relativeY *= -1));
                    ++i;
                }
            }
            if (serieSec == 0 && this.factorFont != null) {
                g.setFont(this.factorFont);
                i = 0;
                while ((double)i < count) {
                    g.setColor(this.factorColor);
                    if (this.factorColors != null && this.factorColors.length > i) {
                        g.setColor(this.factorColors[i]);
                    }
                    angle = 360.0 / count * (double)i;
                    if ((angle += 90.0) > 360.0) {
                        angle -= 360.0;
                    }
                    int tmpradi = (int)((double)radi * 1.1 / 2.0);
                    int correction = 0;
                    if (angle > 120.0 && angle < 240.0) {
                        correction = g.getFontWidth(this.factorNames[i]);
                    }
                    double radian2 = 0.01745277777777778 * angle;
                    double Sin2 = Math.sin(radian2);
                    double Cos2 = Math.cos(radian2);
                    int relativeY2 = (int)(Sin2 * (double)tmpradi);
                    int relativeX2 = (int)(Cos2 * (double)tmpradi);
                    relativeY2 *= -1;
                    if (this.factorNames.length > i) {
                        if (this.factorNames[i].indexOf("@") >= 0) {
                            ChartLabel label = new ChartLabel(this.factorNames[i], "", false, false);
                            label.initialize(g, this.chart);
                            label.paint(g, PieCenterX + relativeX2 - correction, PieCenterY + relativeY2, -1, -1);
                        } else {
                            g.drawString(this.factorNames[i], PieCenterX + relativeX2 - correction, PieCenterY + relativeY2);
                        }
                    }
                    ++i;
                }
            }
        }
        i = 0;
        while ((double)i < count) {
            angle = 360.0 / count * (double)i;
            if ((angle += 90.0) > 360.0) {
                angle -= 360.0;
            }
            int tmpradi = 0;
            double min = 0.0;
            double max = 100.0;
            if (this.factorMins.length >= i + 1) {
                min = this.factorMins[i];
            }
            if (this.factorMaxs.length >= i + 1) {
                max = this.factorMaxs[i];
            }
            tmpradi = (int)(((Double)p.getElementY(i) - min) * 100.0 / (max - min));
            tmpradi = tmpradi * radi / 100;
            double radian = 0.01745277777777778 * angle;
            double Sin = Math.sin(radian);
            double Cos = Math.cos(radian);
            int relativeY = (int)(Sin * (double)(tmpradi / 2));
            int relativeX = (int)(Cos * (double)(tmpradi / 2));
            xs[i] = PieCenterX + relativeX;
            ys[i] = PieCenterY + (relativeY *= -1);
            ++i;
        }
        if (p.style != null) {
            p.style.drawPolygon(g, xs, ys, (int)count);
        }
        if (p.fillStyle != null) {
            p.fillStyle.drawPolygon(g, xs, ys, (int)count);
        }
        i = 0;
        while ((double)i < count) {
            double YValue;
            Polygon po = new Polygon();
            po.addPoint(xs[i] - 3, ys[i] - 3);
            po.addPoint(xs[i] - 3, ys[i] + 3);
            po.addPoint(xs[i] + 3, ys[i] + 3);
            po.addPoint(xs[i] + 3, ys[i] - 3);
            s.hotAreas.addElement(po);
            if (p.drawPoint) {
                ChartColor c = p.pointColor;
                YValue = (Double)p.getElementY(i);
                if (this.pointColors != null && this.pointColorScale != null) {
                    if (this.pointColors.length > 0) {
                        c = this.pointColors[0];
                    }
                    int j = 1;
                    while (j < this.pointColors.length) {
                        if (this.pointColorScale.length >= j) {
                            if (!(this.pointColorScale[j - 1] <= YValue)) break;
                            c = this.pointColors[j];
                        }
                        ++j;
                    }
                }
                g.setColor(c);
                if (p.icon == null) {
                    g.fillRect(xs[i] - 3, ys[i] - 3, 6, 6);
                } else {
                    g.drawImage(p.icon, xs[i] - 4, ys[i] - 4);
                }
            }
            if (p.valueFont != null) {
                g.setColor(p.valueColor);
                g.setFont(p.valueFont);
                YValue = (Double)p.getElementY(i);
                String txt = p.doubleToString(new Double(YValue));
                if (YValue == (double)((int)YValue)) {
                    txt = new Integer((int)YValue).toString();
                }
                String txtValue = txt;
                if (p.labelTemplate.length() > 0) {
                    txt = p.labelTemplate;
                }
                if (p.dataLabels != null && p.dataLabels.length > i) {
                    txt = p.dataLabels[i];
                }
                if (txt.indexOf("@") >= 0) {
                    ChartLabel label = new ChartLabel(txt, txtValue, false, false);
                    label.initialize(g, this.chart);
                    label.paint(g, xs[i] + 7, ys[i], -1, -1);
                } else {
                    g.drawString(txt, xs[i] + 7, ys[i]);
                }
            }
            ++i;
        }
        if (this.gridStyle != null) {
            double min = 0.0;
            double max = 100.0;
            if (this.factorMins.length >= 1) {
                min = this.factorMins[0];
            }
            if (this.factorMaxs.length >= 1) {
                max = this.factorMaxs[0];
            }
            int tickInterval = 100 / this.ticks;
            double tickIntervalAbs = (max - min) / (double)this.ticks;
            int tickAt = 0;
            double tickAtAbs = 0.0;
            int j = 0;
            while (j < this.ticks) {
                tickAt += tickInterval;
                tickAtAbs += tickIntervalAbs;
                int i2 = 0;
                while ((double)i2 < count) {
                    angle = 360.0 / count * (double)i2;
                    if ((angle += 90.0) > 360.0) {
                        angle -= 360.0;
                    }
                    int tmpradi = radi * tickAt / 100;
                    double radian = 0.01745277777777778 * angle;
                    double Sin = Math.sin(radian);
                    double Cos = Math.cos(radian);
                    int relativeY = (int)(Sin * (double)(tmpradi / 2));
                    int relativeX = (int)(Cos * (double)(tmpradi / 2));
                    xs[i2] = PieCenterX + relativeX;
                    ys[i2] = PieCenterY + (relativeY *= -1);
                    ++i2;
                }
                if (serieSec >= this.series.size() - 1) {
                    this.gridStyle.drawPolygon(g, xs, ys, (int)count);
                }
                if (serieSec >= this.series.size() - 1 && this.gridFont != null) {
                    g.setColor(this.gridFontColor);
                    g.setFont(this.gridFont);
                    double tickValue = tickAtAbs;
                    String v = "";
                    v = "" + tickValue;
                    if (tickValue == (double)((int)tickValue)) {
                        v = "" + (int)tickValue;
                    }
                    if (this.tickLabelFormat.length() > 0) {
                        DecimalFormat df = null;
                        df = new DecimalFormat(this.tickLabelFormat);
                        v = df.format(new Double(tickValue));
                    }
                    g.drawString("" + v, xs[0] - 3 - g.getFontWidth("" + v), ys[0]);
                }
                ++j;
            }
        }
    }
}

