/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

class RMatrix {
    private int rows;
    private int columns;
    private double[][] data;

    public RMatrix(double[][] d) {
        this.rows = d.length;
        this.columns = d[0].length;
        this.data = d;
    }

    public RMatrix(int[][] d) {
        this.rows = d.length;
        this.columns = d[0].length;
        this.data = new double[this.rows][this.columns];
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                this.data[i][j] = d[i][j];
                ++j;
            }
            ++i;
        }
    }

    public RMatrix(int prows, int pcolumns) {
        this.rows = prows;
        this.columns = pcolumns;
        this.data = new double[this.rows][this.columns];
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                this.data[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public RMatrix add(RMatrix m2) {
        RMatrix newMatrix = new RMatrix(this.rows, this.columns);
        if (this.rows == m2.rows && this.columns == m2.columns) {
            int i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.columns) {
                    newMatrix.data[i][j] = this.data[i][j] + m2.data[i][j];
                    ++j;
                }
                ++i;
            }
        }
        return newMatrix;
    }

    public RMatrix invert() {
        int j;
        int n = this.data.length;
        double[][] D = new double[n + 1][2 * n + 2];
        int i = 0;
        while (i < this.rows) {
            j = 0;
            while (j < this.columns) {
                D[i + 1][j + 1] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        boolean error = false;
        int n2 = 2 * n;
        i = 1;
        while (i <= n) {
            j = 1;
            while (j <= n) {
                D[i][j + n] = 0.0;
                ++j;
            }
            D[i][i + n] = 1.0;
            ++i;
        }
        i = 1;
        while (i <= n) {
            double alpha = D[i][i];
            if (alpha == 0.0) {
                error = true;
                break;
            }
            j = 1;
            while (j <= n2) {
                D[i][j] = D[i][j] / alpha;
                ++j;
            }
            int k = 1;
            while (k <= n) {
                if (k - i != 0) {
                    double beta = D[k][i];
                    j = 1;
                    while (j <= n2) {
                        D[k][j] = D[k][j] - beta * D[i][j];
                        ++j;
                    }
                }
                ++k;
            }
            ++i;
        }
        RMatrix m = new RMatrix(this.rows, this.columns);
        i = 0;
        while (i < this.rows) {
            j = 0;
            while (j < this.columns) {
                m.data[i][j] = D[i + 1][j + 1 + n];
                ++j;
            }
            ++i;
        }
        return m;
    }

    public RMatrix mult(double v) {
        RMatrix newMatrix = new RMatrix(this.rows, this.columns);
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                newMatrix.data[i][j] = v * this.data[i][j];
                ++j;
            }
            ++i;
        }
        return newMatrix;
    }

    public void setValue(int r, int c, double v) {
        this.data[r][c] = v;
    }

    public double getValue(int r, int c) {
        return this.data[r][c];
    }

    public RMatrix mult(RMatrix m2) {
        RMatrix m1 = this;
        RMatrix newMatrix = new RMatrix(m1.rows, m2.columns);
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < m2.columns) {
                int k = 0;
                while (k < this.columns) {
                    double[] dArray = newMatrix.data[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.data[i][k] * m2.data[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return newMatrix;
    }

    public RMatrix transpose() {
        RMatrix newMatrix = new RMatrix(this.columns, this.rows);
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                newMatrix.data[j][i] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        return newMatrix;
    }
}

