/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.BarPlotter;
import com.java4less.rchart.BarPlotter3D;
import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartComponent;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.LinePlotter;
import com.java4less.rchart.LinePlotter3D;
import com.java4less.rchart.RadarPlotter;
import com.java4less.rchart.Scale;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import java.util.Calendar;
import java.util.Vector;

public class Plotter
extends ChartComponent {
    protected int needsAxis = 2;
    protected boolean combinable = true;
    public Scale XScale;
    public Scale YScale;
    public Scale Y2Scale;
    public FillStyle back = null;
    public ChartImage backImage;
    public int visibleWidth = 0;
    public int visibleHeight = 0;
    public int depth = 0;
    Vector series = new Vector(0, 1);

    public int getNeedsAxis() {
        return this.needsAxis;
    }

    public boolean getCombinable() {
        return this.combinable;
    }

    public void plotBackground(ChartGraphics g, int bw, int bh, int offsetX, int offsetY) {
        if (this.back != null) {
            boolean D3 = false;
            if (this instanceof BarPlotter3D) {
                D3 = true;
            }
            if (this instanceof LinePlotter3D) {
                D3 = true;
            }
            if (D3) {
                int[] xs = new int[6];
                int[] ys = new int[6];
                xs[0] = this.x + offsetX;
                ys[0] = this.y + offsetY;
                xs[1] = this.x + offsetX + this.depth;
                ys[1] = this.y + offsetY - this.depth;
                xs[2] = this.x + offsetX + this.visibleWidth;
                ys[2] = this.y + offsetY - this.depth;
                xs[3] = this.x + offsetX + this.visibleWidth;
                ys[3] = this.y + offsetY + this.visibleHeight - this.depth - this.depth;
                xs[4] = this.x + offsetX + this.visibleWidth - this.depth;
                ys[4] = this.y + offsetY + this.visibleHeight - this.depth;
                xs[5] = this.x + offsetX;
                ys[5] = this.y + offsetY + this.visibleHeight - this.depth;
                this.back.drawPolygon(g, xs, ys, 6);
            } else {
                this.back.draw(g, this.x, this.y, this.x + bw, this.y + bh);
            }
        }
        if (this.backImage != null) {
            int w = this.backImage.getWidth();
            int h = this.backImage.getHeight();
            if (w > -1 && h > -1) {
                int toCenterY;
                int toCenterX = (bw - w) / 2;
                if (toCenterX < 0) {
                    toCenterX = 0;
                }
                if ((toCenterY = (bh - h) / 2) < 0) {
                    toCenterY = 0;
                }
                g.drawImage(this.backImage, toCenterX + this.x, this.y + toCenterY);
            }
        }
    }

    public void plot(ChartGraphics g) {
        int i = 0;
        while (i < this.series.size()) {
            DataSerie s = (DataSerie)this.series.elementAt(i);
            this.plotSerie(g, s, i);
            ++i;
        }
    }

    protected void plotSerie(ChartGraphics g, DataSerie s, int serieSec) {
    }

    public int getSeriesCount() {
        return this.series.size();
    }

    public DataSerie getSerie(int p) {
        return (DataSerie)this.series.elementAt(p);
    }

    public void setSerie(int p, DataSerie s) {
        if (p < this.series.size()) {
            this.series.setElementAt(s, p);
        }
    }

    public void addSerie(DataSerie s) {
        this.replaceSerie(-1, s);
    }

    public void replaceSerie(int p, DataSerie s) {
        Scale tmpScaleX = this.getActiveXScale(s);
        Scale tmpScaleY = this.getActiveYScale(s);
        if (p >= this.series.size()) {
            return;
        }
        int month = Calendar.getInstance().get(2);
        if (Chart.d() != 1 && s.getSize() > 10) {
            return;
        }
        if (Chart.d() != 1 && this.series.size() > 3) {
            return;
        }
        if (p == -1) {
            this.series.addElement(s);
        } else {
            this.series.setElementAt(s, p);
        }
        boolean fixedLimits = false;
        if (this instanceof LinePlotter) {
            fixedLimits = ((LinePlotter)this).fixedLimits;
        }
        if (this instanceof LinePlotter3D) {
            fixedLimits = ((LinePlotter3D)this).fixedLimits;
        }
        boolean cumulative = false;
        if (this instanceof BarPlotter && ((BarPlotter)this).cumulative && !((BarPlotter)this).cumulativeBackwardsCompatible) {
            cumulative = true;
        }
        if (this instanceof BarPlotter3D && ((BarPlotter3D)this).cumulative) {
            cumulative = true;
        }
        if (!(this instanceof RadarPlotter)) {
            int i = 0;
            while (i < s.getSize()) {
                if (s.getElementY(i) != null) {
                    double XValue = (Double)s.getElementX(i);
                    double YValue = (Double)s.getElementY(i);
                    if (cumulative) {
                        YValue = 0.0;
                        int si = 0;
                        while (si < this.series.size()) {
                            DataSerie ser = (DataSerie)this.series.elementAt(si);
                            if (this.inSameSubChart(ser, s) && ser.getSize() > i && ser.getElementY(i) != null) {
                                double d = (Double)ser.getElementY(i);
                                YValue += d;
                            }
                            ++si;
                        }
                    }
                    if (XValue >= tmpScaleX.max) {
                        if (this instanceof BarPlotter || this instanceof BarPlotter3D) {
                            tmpScaleX.max = XValue + 1.0;
                            if (this instanceof BarPlotter && ((BarPlotter)this).barAtAxis) {
                                tmpScaleX.max = XValue;
                            }
                        } else {
                            this.calculateNewMax(tmpScaleX, XValue);
                        }
                    }
                    if (XValue < tmpScaleX.min) {
                        this.calculateNewMin(tmpScaleX, XValue);
                    }
                    if (!fixedLimits) {
                        if (YValue > tmpScaleY.max) {
                            this.calculateNewMax(tmpScaleY, YValue);
                        }
                        if (YValue < tmpScaleY.min) {
                            this.calculateNewMin(tmpScaleY, YValue);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void calculateNewMax(Scale s, double m) {
        if (!s.exactMaxValue) {
            s.max = m;
            return;
        }
        if (s.preferred_MaxMin_values != null && s.preferred_MaxMin_values.length > 0) {
            int j = 0;
            while (j < s.preferred_MaxMin_values.length) {
                if (s.preferred_MaxMin_values[j] >= m) {
                    s.max = s.preferred_MaxMin_values[j];
                    break;
                }
                ++j;
            }
        }
    }

    protected Scale getActiveXScale(DataSerie s) {
        Scale scale = this.XScale;
        if (s.secondaryXAxis != null) {
            scale = s.secondaryXAxis.scale;
        }
        return scale;
    }

    protected Scale getActiveYScale(DataSerie s) {
        Scale scale = this.YScale;
        if (s.secondYAxis && this.Y2Scale != null) {
            scale = this.Y2Scale;
        } else if (s.secondaryYAxis != null) {
            scale = s.secondaryYAxis.scale;
        }
        return scale;
    }

    private void calculateNewMin(Scale s, double m) {
        if (!s.exactMinValue) {
            s.min = m;
            return;
        }
        if (s.preferred_MaxMin_values != null && s.preferred_MaxMin_values.length > 0) {
            int j = s.preferred_MaxMin_values.length - 1;
            while (j > 0) {
                if (s.preferred_MaxMin_values[j] <= m) {
                    s.min = s.preferred_MaxMin_values[j];
                    break;
                }
                --j;
            }
        }
    }

    protected boolean inSameSubChart(DataSerie tmpSerie, DataSerie s) {
        boolean usingStackAxis = false;
        if (s.secondaryYAxis != null && s.secondaryYAxis.mainAxis.stackAdditionalAxis) {
            usingStackAxis = true;
        }
        if (tmpSerie.secondaryYAxis != null && tmpSerie.secondaryYAxis.mainAxis.stackAdditionalAxis) {
            usingStackAxis = true;
        }
        return tmpSerie.secondaryXAxis == s.secondaryXAxis && (tmpSerie.secondaryYAxis == s.secondaryYAxis || !usingStackAxis);
    }
}

