/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.ChartLabel;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.PieDataSerie;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.GraphicsProvider;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

public class PiePlotter
extends Plotter {
    public LineStyle labelLine = null;
    public double radiusModifier = 1.0;
    public LineStyle border = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.BLACK), 1);
    public boolean drawRadius = false;
    public boolean effect3D = false;
    public String labelFormat = "";
    public int space = 20;
    private Vector lblPositions = new Vector(10);

    public PiePlotter() {
        this.combinable = false;
        this.needsAxis = 0;
    }

    private String subStr(String s, String a, String b) {
        int p = s.indexOf(a);
        if (p >= 0) {
            s = String.valueOf(s.substring(0, p)) + b + s.substring(p + a.length(), s.length());
        }
        return s;
    }

    private boolean inRectangle(Rectangle r, Rectangle r2) {
        return r.intersects(r2);
    }

    private int lenLabel(ChartGraphics g, String t) {
        String[] lines = this.splitText(t);
        int max = 0;
        int i = 0;
        while (i < lines.length) {
            int laenge = g.getFontWidth(lines[i]);
            if (laenge > max) {
                max = laenge;
            }
            ++i;
        }
        return max;
    }

    private void drawLabel(ChartGraphics g, String t, String v, int x, int y) {
        if (t.indexOf("@") >= 0) {
            ChartLabel label = new ChartLabel(t, v, false, true);
            label.initialize(g, this.chart);
            Rectangle newR = new Rectangle(x, y, label.requiredWidth, label.requiredHeight);
            int i = 0;
            while (i < this.lblPositions.size()) {
                Rectangle r = (Rectangle)this.lblPositions.elementAt(i);
                if (this.inRectangle(r, newR)) {
                    newR = new Rectangle(newR.x, r.y + r.height, label.requiredWidth, label.requiredHeight);
                    i = 0;
                }
                ++i;
            }
            this.lblPositions.addElement(newR);
            label.paint(g, newR.x, newR.y, label.requiredWidth, label.requiredHeight);
        } else {
            String[] lines = this.splitText(t);
            int maxlen = this.lenLabel(g, t);
            int h = g.getFontHeight() * lines.length;
            int charH = g.getFontHeight();
            int w = maxlen;
            Rectangle newR = new Rectangle(x, y, w, h);
            int i = 0;
            while (i < this.lblPositions.size()) {
                Rectangle r = (Rectangle)this.lblPositions.elementAt(i);
                if (this.inRectangle(r, newR)) {
                    newR = new Rectangle(newR.x, r.y + r.height, w, h);
                    i = 0;
                }
                ++i;
            }
            this.lblPositions.addElement(newR);
            int pos = newR.x;
            int thislen = g.getFontWidth(lines[0]);
            pos = pos + maxlen / 2 - thislen / 2;
            g.drawString(lines[0], pos, newR.y);
            i = 1;
            while (i < lines.length) {
                pos = newR.x;
                thislen = g.getFontWidth(lines[i]);
                pos = pos + maxlen / 2 - thislen / 2;
                g.drawString(lines[i], pos, newR.y + charH * i);
                ++i;
            }
        }
    }

    private String[] splitText(String s) {
        String[] r = new String[100];
        int lines = 0;
        while (s.indexOf("\\n") > -1) {
            r[lines] = s.substring(0, s.indexOf("\\n"));
            s = s.substring(s.indexOf("\\n") + 2, s.length());
            if (++lines >= r.length) break;
        }
        r[lines] = s;
        String[] a = new String[lines + 1];
        int i = 0;
        while (i <= lines) {
            a[i] = r[i];
            ++i;
        }
        return a;
    }

    protected void plotSerie(ChartGraphics g, DataSerie s, int serieSec) {
        double YValue;
        double lastPercent = 0.0;
        double lastAngle = 0.0;
        int tmpY = this.y;
        int border3D = 1;
        this.lblPositions.removeAllElements();
        s.hotAreas.removeAllElements();
        if (!(s instanceof PieDataSerie)) {
            return;
        }
        PieDataSerie p = (PieDataSerie)s;
        int count = p.yData.size();
        double[] ZPositionMin = new double[count];
        double[] ZPositionMax = new double[count];
        int[] ZPositionSortedMaxs = new int[count];
        int[] ZPositionSortedMins = new int[count];
        double[] lastAngles = new double[count];
        double[] angles = new double[count];
        double[] lastPercents = new double[count];
        double[] percents = new double[count];
        lastAngle = 0.0;
        lastPercent = 0.0;
        int i = 0;
        while (i < count) {
            YValue = (Double)p.getElementY(i);
            double percent = YValue * 100.0 / p.total;
            double angle = percent * 3.6;
            angle = (double)Math.round(lastAngle + angle) - lastAngle;
            if (i == count - 1) {
                angle = 360.0 - lastAngle;
            }
            if (angle < 10.0) {
                angle = 10.0;
            }
            percents[i] = percent;
            angles[i] = angle;
            lastPercents[i] = lastPercent;
            lastAngles[i] = lastAngle;
            double radian = 0.01745277777777778 * lastAngle;
            double Sin = Math.sin(radian);
            ZPositionMin[i] = Sin * 1.0;
            ZPositionMax[i] = Sin * 1.0;
            radian = 0.01745277777777778 * (lastAngle + angle);
            Sin = Math.sin(radian);
            double tmp = Sin * 1.0;
            if (tmp > ZPositionMax[i]) {
                ZPositionMax[i] = tmp;
            }
            if (tmp < ZPositionMin[i]) {
                ZPositionMin[i] = tmp;
            }
            if (lastAngle <= 270.0 && angle >= 270.0) {
                ZPositionMin[i] = -1.0;
            }
            if (lastAngle <= 90.0 && angle >= 90.0) {
                ZPositionMax[i] = 1.0;
            }
            lastAngle += angle;
            lastPercent += percent;
            Polygon po = new Polygon();
            s.hotAreas.addElement(po);
            ++i;
        }
        i = 0;
        while (i < count) {
            double maxZ = -2.0;
            int maxZIndex = 0;
            double maxminZ = -2.0;
            int maxminZIndex = 0;
            int k = 0;
            while (k < count) {
                if (ZPositionMax[k] > maxZ) {
                    maxZ = ZPositionMax[k];
                    maxZIndex = k;
                }
                if (ZPositionMin[k] > maxminZ) {
                    maxminZ = ZPositionMin[k];
                    maxminZIndex = k;
                }
                ++k;
            }
            ZPositionSortedMaxs[i] = maxZIndex;
            ZPositionSortedMins[i] = maxminZIndex;
            ZPositionMin[maxminZIndex] = -2.0;
            ZPositionMax[maxZIndex] = -2.0;
            ++i;
        }
        int radi = 0;
        int radiy = 0;
        radi = this.width;
        if (this.height < radi) {
            radi = this.height;
        }
        radi = (int)((double)radi * this.radiusModifier);
        int toCenterX = (this.width - radi) / 2;
        int toCenterY = (this.height - radi) / 2;
        radiy = radi;
        if (this.effect3D) {
            radiy = (int)((double)radi * 0.5);
            border3D = (int)((double)radi * 0.15);
            tmpY += radiy / 2;
        }
        int PieCenterX = toCenterX + this.x + radi / 2;
        int PieCenterY = toCenterY + tmpY + radi / 2;
        int j = 0;
        while (j < 3) {
            int h = border3D - 1;
            while (h >= 0) {
                if (j == 2 && h != border3D - 1) break;
                int l = 0;
                while (l < count) {
                    i = j == 0 ? ZPositionSortedMaxs[l] : ZPositionSortedMins[l];
                    boolean keepTogether = true;
                    if (p.itemsTogether.size() >= i) {
                        keepTogether = (Boolean)p.itemsTogether.elementAt(i);
                    }
                    if (!keepTogether) {
                        this.border = null;
                    }
                    int movedX = 0;
                    int movedY = 0;
                    YValue = (Double)p.getElementY(i);
                    FillStyle currentStyle = (FillStyle)p.Styles.elementAt(i);
                    if (currentStyle == null) {
                        currentStyle = new FillStyle(GraphicsProvider.getColor(ChartColor.WHITE));
                    }
                    LineStyle darkerLine = new LineStyle(0.2f, currentStyle.color.darker(), 1);
                    if (h > 2) {
                        currentStyle = new FillStyle(currentStyle.color.darker().darker());
                    }
                    if (!keepTogether) {
                        double tmpAngle = lastAngles[i] + angles[i] / 2.0;
                        double radian = 0.01745277777777778 * tmpAngle;
                        double Sin = Math.sin(radian);
                        double Cos = Math.cos(radian);
                        movedY = (int)(Sin * (double)this.space);
                        movedX = (int)(Cos * (double)this.space);
                        movedY *= -1;
                        if (this.effect3D) {
                            movedY /= 2;
                        }
                    }
                    if (j == 0 || j == 1) {
                        boolean drawNow = false;
                        double tmplastAngle = lastAngles[i];
                        double tmpangle = angles[i];
                        if (j == 0 && lastAngles[i] + angles[i] <= 180.0) {
                            drawNow = true;
                        }
                        if (j == 1 && lastAngles[i] >= 180.0 && lastAngles[i] + angles[i] >= 180.0) {
                            drawNow = true;
                        }
                        if (j == 1 && lastAngles[i] <= 180.0 && lastAngles[i] + angles[i] >= 180.0) {
                            drawNow = true;
                            tmpangle = tmpangle + tmplastAngle - 180.0;
                            tmplastAngle = 180.0;
                        }
                        if (j == 0 && lastAngles[i] < 180.0 && lastAngles[i] + angles[i] > 180.0) {
                            drawNow = true;
                            tmpangle = 180.0 - tmplastAngle;
                        }
                        if (drawNow) {
                            currentStyle.drawArc(g, toCenterX + this.x + movedX, toCenterY + movedY + tmpY + h, radi, radiy, (int)tmplastAngle, (int)tmpangle);
                            if (h > 0) {
                                darkerLine.drawArc(g, toCenterX + this.x + movedX, toCenterY + movedY + tmpY + h, radi, radiy, (int)tmplastAngle, (int)tmpangle);
                            }
                        }
                    }
                    if (this.border != null && j == 2) {
                        this.border.drawArc(g, toCenterX + this.x, toCenterY + tmpY, radi, radiy, (int)lastAngles[i], (int)angles[i]);
                        if (this.effect3D) {
                            this.border.drawArc(g, toCenterX + this.x, toCenterY + tmpY + (border3D - 1), radi, radiy, 180, 180);
                            this.border.draw(g, toCenterX + this.x, toCenterY + tmpY + radiy / 2, toCenterX + this.x, toCenterY + tmpY + radiy / 2 + border3D);
                            this.border.draw(g, toCenterX + this.x + radi, toCenterY + tmpY + radiy / 2, toCenterX + this.x + radi, toCenterY + tmpY + radiy / 2 + border3D);
                        }
                        double radian = 0.01745277777777778 * (lastAngles[i] + angles[i]);
                        double Sin = Math.sin(radian);
                        double Cos = Math.cos(radian);
                        int relativeY = (int)(Sin * (double)(radi / 2));
                        int relativeX = (int)(Cos * (double)(radi / 2));
                        relativeY *= -1;
                        if (this.drawRadius && !this.effect3D) {
                            this.border.draw(g, PieCenterX, PieCenterY, PieCenterX + relativeX, PieCenterY + relativeY);
                        }
                    }
                    if (j == 2) {
                        h = border3D - 1;
                        Polygon po = (Polygon)s.hotAreas.elementAt(i);
                        po.addPoint(PieCenterX + movedX, toCenterY + tmpY + radiy / 2 + movedY);
                        int xModifier = 1;
                        int yModifier = -1;
                        double normAngle = lastAngles[i] + angles[i];
                        double radian = 0.01745277777777778 * normAngle;
                        double Sin = Math.sin(radian);
                        double Cos = Math.cos(radian);
                        int relativeY = (int)(Sin * (double)(radiy / 2));
                        int relativeX = (int)(Cos * (double)(radi / 2));
                        po.addPoint(PieCenterX + (relativeX *= xModifier) + movedX, toCenterY + tmpY + radiy / 2 + (relativeY *= yModifier) + movedY);
                        xModifier = 1;
                        yModifier = -1;
                        normAngle = lastAngles[i] + angles[i] * 2.0 / 3.0;
                        radian = 0.01745277777777778 * normAngle;
                        Sin = Math.sin(radian);
                        Cos = Math.cos(radian);
                        relativeY = (int)(Sin * (double)(radiy / 2));
                        relativeX = (int)(Cos * (double)(radi / 2));
                        po.addPoint(PieCenterX + (relativeX *= xModifier) + movedX, toCenterY + tmpY + radiy / 2 + (relativeY *= yModifier) + movedY);
                        xModifier = 1;
                        yModifier = -1;
                        normAngle = lastAngles[i] + angles[i] / 3.0;
                        radian = 0.01745277777777778 * normAngle;
                        Sin = Math.sin(radian);
                        Cos = Math.cos(radian);
                        relativeY = (int)(Sin * (double)(radiy / 2));
                        relativeX = (int)(Cos * (double)(radi / 2));
                        po.addPoint(PieCenterX + (relativeX *= xModifier) + movedX, toCenterY + tmpY + radiy / 2 + (relativeY *= yModifier) + movedY);
                        xModifier = 1;
                        yModifier = -1;
                        normAngle = lastAngles[i];
                        radian = 0.01745277777777778 * normAngle;
                        Sin = Math.sin(radian);
                        Cos = Math.cos(radian);
                        relativeY = (int)(Sin * (double)(radiy / 2));
                        relativeX = (int)(Cos * (double)(radi / 2));
                        po.addPoint(PieCenterX + (relativeX *= xModifier) + movedX, toCenterY + tmpY + radiy / 2 + (relativeY *= yModifier) + movedY);
                    }
                    if (p.valueFont != null && j == 2) {
                        g.setColor(p.valueColor);
                        g.setFont(p.valueFont);
                        String txt = p.doubleToString(new Double(percents[i]));
                        if (txt.compareTo("") == 0) {
                            txt = "0";
                        }
                        String percenStr = txt = String.valueOf(txt) + " %";
                        String absoluteStr = p.doubleToString(new Double(YValue));
                        if (absoluteStr.compareTo("") == 0) {
                            absoluteStr = "0";
                        }
                        if (!p.drawPercentages) {
                            txt = absoluteStr;
                        }
                        if (this.labelFormat.length() > 0) {
                            txt = this.labelFormat;
                            txt = this.subStr(txt, "#PERCENTAGE#", percenStr);
                            txt = this.subStr(txt, "#VALUE#", absoluteStr);
                            if (p.itemsLabel.size() > i) {
                                txt = this.subStr(txt, "#LABEL#", (String)p.itemsLabel.elementAt(i));
                            }
                        }
                        String txtValue = txt;
                        if (p.labelTemplate.length() > 0) {
                            txt = p.labelTemplate;
                        }
                        if (p.dataLabels != null && p.dataLabels.length > i) {
                            txt = p.dataLabels[i];
                        }
                        int xModifier = 1;
                        int yModifier = -1;
                        double normAngle = lastAngles[i] + angles[i] / 2.0;
                        int relativeX = 0;
                        int relativeY = 0;
                        double radian = 0.01745277777777778 * normAngle;
                        double Sin = Math.sin(radian);
                        double Cos = Math.cos(radian);
                        relativeY = (int)(Sin * (double)(radiy / 2) * p.textDistanceToCenter);
                        relativeX = (int)(Cos * (double)(radi / 2) * p.textDistanceToCenter);
                        relativeX *= xModifier;
                        relativeY *= yModifier;
                        int toCenterValueX = 5;
                        if (Cos < 0.0) {
                            toCenterValueX = (this.lenLabel(g, txt) + 5) * -1;
                        }
                        int toCenterValueY = g.getFontHeight() + 5;
                        if (Sin > 0.0) {
                            toCenterValueY = -5;
                        }
                        int labelx = 0;
                        int labely = 0;
                        if (this.effect3D) {
                            labelx = PieCenterX + movedX + relativeX + toCenterValueX;
                            labely = toCenterY + tmpY + radiy / 2 + movedY + relativeY + toCenterValueY;
                        } else {
                            labelx = PieCenterX + relativeX + toCenterValueX;
                            labely = PieCenterY + relativeY + toCenterValueY;
                        }
                        int borderMiddleX = 0;
                        int borderMiddleY = 0;
                        double middlePointAngle = lastAngles[i] + angles[i] / 2.0;
                        xModifier = 1;
                        yModifier = -1;
                        normAngle = middlePointAngle;
                        radian = 0.01745277777777778 * normAngle;
                        Sin = Math.sin(radian);
                        Cos = Math.cos(radian);
                        relativeY = (int)(Sin * (double)(radiy / 2));
                        relativeX = (int)(Cos * (double)(radi / 2));
                        borderMiddleX = PieCenterX + (relativeX *= xModifier) + movedX;
                        borderMiddleY = toCenterY + tmpY + radiy / 2 + (relativeY *= yModifier) + movedY;
                        if (this.labelLine != null) {
                            int endLineX = labelx;
                            int endLineY = labely;
                            int endLineX2 = labelx;
                            int endLineY2 = labely;
                            int txtLength = g.getFontWidth(txt);
                            int txtHeight = g.getFontHeight();
                            if (middlePointAngle <= 45.0 || middlePointAngle >= 315.0) {
                                endLineX = labelx - 10;
                                endLineY = labely;
                                endLineX2 = labelx - 1;
                                endLineY2 = labely;
                            }
                            if (middlePointAngle >= 45.0 && middlePointAngle <= 135.0) {
                                endLineX = labelx + txtLength / 2;
                                endLineY = labely + 10;
                                endLineX2 = labelx + txtLength / 2;
                                endLineY2 = labely + 2;
                            }
                            if (middlePointAngle <= 225.0 && middlePointAngle >= 135.0) {
                                endLineX = labelx + txtLength + 10;
                                endLineY = labely;
                                endLineX2 = labelx + txtLength;
                                endLineY2 = labely;
                            }
                            if (middlePointAngle >= 225.0 && middlePointAngle <= 315.0) {
                                endLineX = labelx + txtLength / 2;
                                endLineY = labely - txtHeight - 10;
                                endLineX2 = labelx + txtLength / 2;
                                endLineY2 = labely - txtHeight - 2;
                            }
                            this.labelLine.draw(g, endLineX, endLineY, borderMiddleX, borderMiddleY);
                            this.labelLine.draw(g, endLineX, endLineY, endLineX2, endLineY2);
                        }
                        this.drawLabel(g, txt, txtValue, labelx, labely);
                    }
                    ++l;
                }
                --h;
            }
            ++j;
        }
    }
}

