/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Scale;

public class LogScale
extends Scale {
    public double base = 2.0;

    public LogScale() {
    }

    public LogScale(int ma, int mi) {
        this.max = ma;
        this.min = mi;
    }

    public int getScreenCoord(double v) {
        double logMax = Math.log(this.max) / Math.log(this.base);
        double logMin = 0.0;
        if (this.min > 0.0) {
            logMin = Math.log(this.min) / Math.log(this.base);
        }
        double l = v > 0.0 ? Math.log(v) / Math.log(this.base) : 0.0;
        if ((l -= logMin) <= 0.0) {
            l = 0.0;
        }
        int i = this.screenMaxMargin - this.screenMin;
        i = (int)(l * (double)i / (logMax - logMin));
        i = !this.reverse ? (i += this.screenMin) : this.screenMax - this.screenMin - i + this.screenMin;
        return i;
    }

    public double getValue(int c) {
        c = !this.reverse ? (c -= this.screenMin) : this.screenMax - c;
        double logMax = Math.log(this.max) / Math.log(this.base);
        double logMin = 0.0;
        if (this.min > 0.0) {
            logMin = Math.log(this.min) / Math.log(this.base);
        }
        double i = this.screenMaxMargin - this.screenMin;
        double l = (double)c * (logMax - logMin) / i;
        l += logMin;
        l = Math.pow(this.base, l);
        return l;
    }
}

