/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.ChartLoader;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartGraphics;

public class LineStyle {
    int lineType;
    float lWidth;
    ChartColor color;
    public float alphaValue = 1.0f;
    public static final int LINE_NORMAL = 1;
    public static final int LINE_DASHED = 2;
    public static final int LINE_DOTS = 3;

    public LineStyle(float w, ChartColor c, int t) {
        this.lineType = t;
        this.lWidth = w;
        this.color = c;
    }

    public LineStyle(float w, ChartColor c, int t, float alpha) {
        this(w, c, t);
        this.alphaValue = alpha;
    }

    public static LineStyle createFromString(String s) {
        String[] items = ChartLoader.convertList(s);
        if (items == null) {
            return null;
        }
        if (items.length < 3) {
            return null;
        }
        float floa = 0.0f;
        try {
            floa = new Float(items[0]).floatValue();
        }
        catch (Exception e) {
            floa = 0.2f;
        }
        int typ = 1;
        if (items[2].compareTo("DASHED") == 0) {
            typ = 2;
        }
        if (items[2].compareTo("DOTS") == 0) {
            typ = 3;
        }
        ChartColor c = ChartLoader.convertColor(items[1]);
        try {
            if (items.length <= 3) {
                return new LineStyle(floa, c, typ);
            }
            return new LineStyle(floa, c, typ, new Float(items[3]).floatValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setType(int t) {
        this.lineType = t;
    }

    public int getType() {
        return this.lineType;
    }

    public ChartColor getColor() {
        return this.color;
    }

    public void setColor(ChartColor c) {
        this.color = c;
    }

    public float getWidth() {
        return this.lWidth;
    }

    public void setWidth(float f) {
        this.lWidth = f;
    }

    public void drawArc(ChartGraphics g, int x, int y, int w, int h, int a1, int a2) {
        this.setGraphicsProperties(g);
        g.drawArc(x, y, w, h, a1, a2);
    }

    public void drawPolygon(ChartGraphics g, int[] x, int[] y, int c) {
        int i = 1;
        while (i < c) {
            this.draw(g, x[i - 1], y[i - 1], x[i], y[i]);
            ++i;
        }
        this.draw(g, x[0], y[0], x[c - 1], y[c - 1]);
    }

    public void drawOpenPolygon(ChartGraphics g, int[] x, int[] y, int c) {
        int i = 1;
        while (i < c) {
            this.draw(g, x[i - 1], y[i - 1], x[i], y[i]);
            ++i;
        }
    }

    public void drawRoundRect(ChartGraphics g, int x1, int y1, int x2, int y2) {
        int iX = x1;
        int iY = y1;
        int w = x2 - x1;
        int h = y2 - y1;
        if (w < 0) {
            w *= -1;
            iX = x2;
        }
        if (h < 0) {
            h *= -1;
            iY = y2;
        }
        this.setGraphicsProperties(g);
        g.drawRoundedRect(iX, iY, w, h);
    }

    public void drawRect(ChartGraphics g, int x1, int y1, int x2, int y2) {
        int iX = x1;
        int iY = y1;
        int w = x2 - x1;
        int h = y2 - y1;
        if (w < 0) {
            w *= -1;
            iX = x2;
        }
        if (h < 0) {
            h *= -1;
            iY = y2;
        }
        this.setGraphicsProperties(g);
        g.drawRect(iX, iY, w, h);
    }

    public void draw(ChartGraphics g, int x1, int y1, int x2, int y2) {
        this.setGraphicsProperties(g);
        g.drawLineWithStyle(x1, y1, x2, y2);
    }

    protected void setGraphicsProperties(ChartGraphics g) {
        g.setColor(this.color);
        int tmp = (int)this.lWidth;
        if (tmp == 0 && this.lWidth > 0.0f) {
            tmp = 1;
        }
        g.setLineWidth(tmp);
        g.setLineStyle(ChartGraphics.STROKE_NORMAL);
        if (this.lineType == 2) {
            g.setLineStyle(ChartGraphics.STROKE_DASHED);
        }
        if (this.lineType == 3) {
            g.setLineStyle(ChartGraphics.STROKE_DOTTED);
        }
    }
}

