/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.ChartLabel;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.LineDataSerie;
import com.java4less.rchart.MaxMinDataSerie;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.Scale;
import com.java4less.rchart.gc.ChartGraphics;
import java.awt.Polygon;

public class LinePlotter
extends Plotter {
    public boolean hideCeros = false;
    public static final int TYPE_LINE = 0;
    public static final int TYPE_CUBIC_NATURAL = 1;
    public static final int TYPE_B_SPLINES = 2;
    public static final int TYPE_LEAST_SQUARES_LINE = 3;
    public static final int MM_NORMAL = 0;
    public static final int MM_OHLC = 1;
    public static final int MM_CANDLESTICK = 2;
    public boolean fixedLimits = false;
    public int MaxMinType = 0;
    public int pointSize = 6;
    protected int[][] bottomCorners = new int[2][2];

    protected double[][] clipLines(double[][] Points, double MaxY, double MinY) {
        int position = 0;
        int lastPointPosition = 0;
        double[][] result = new double[2][Points[0].length * 2];
        int resultCount = 0;
        if (Points[0].length == 0) {
            return Points;
        }
        if (Points[1][0] < MinY) {
            lastPointPosition = 1;
        }
        if (Points[1][0] > MaxY) {
            lastPointPosition = 2;
        }
        if (lastPointPosition == 0) {
            result[0][0] = Points[0][0];
            result[1][0] = Points[1][0];
            ++resultCount;
        }
        int i = 1;
        while (i < Points[0].length) {
            position = 0;
            if (Points[1][i] < MinY) {
                position = 1;
            }
            if (Points[1][i] > MaxY) {
                position = 2;
            }
            if (position == 0 && lastPointPosition == 0) {
                result[0][resultCount] = Points[0][i];
                result[1][resultCount] = Points[1][i];
                ++resultCount;
            }
            if (position != lastPointPosition && (position == 0 || lastPointPosition == 0)) {
                double limit = MinY;
                if (position == 2 || lastPointPosition == 2) {
                    limit = MaxY;
                }
                double slope = (Points[0][i] - Points[0][i - 1]) / (Points[1][i] - Points[1][i - 1]);
                double newX = Points[0][i - 1] + slope * (limit - Points[1][i - 1]);
                double newX1 = Points[0][i];
                if (position == 0 && newX1 < newX) {
                    result[0][resultCount] = newX1;
                    result[1][resultCount] = Points[1][i];
                    ++resultCount;
                }
                result[0][resultCount] = newX;
                result[1][resultCount] = limit;
                ++resultCount;
                if (position == 0 && newX1 >= newX) {
                    result[0][resultCount] = newX1;
                    result[1][resultCount] = Points[1][i];
                    ++resultCount;
                }
            }
            if (position != lastPointPosition && position != 0 && lastPointPosition != 0) {
                double slope = (Points[0][i] - Points[0][i - 1]) / (Points[1][i] - Points[1][i - 1]);
                double newX1 = Points[0][i - 1] + slope * (MaxY - Points[1][i - 1]);
                double newX2 = Points[0][i - 1] + slope * (MinY - Points[1][i - 1]);
                if (position == 2) {
                    result[0][resultCount] = newX2;
                    result[1][resultCount] = MinY;
                    result[0][++resultCount] = newX1;
                    result[1][resultCount] = MaxY;
                    ++resultCount;
                } else {
                    result[0][resultCount] = newX1;
                    result[1][resultCount] = MaxY;
                    result[0][++resultCount] = newX2;
                    result[1][resultCount] = MinY;
                    ++resultCount;
                }
            }
            lastPointPosition = position;
            ++i;
        }
        double[][] finalP = new double[2][resultCount];
        int i2 = 0;
        while (i2 < resultCount) {
            finalP[0][i2] = result[0][i2];
            finalP[1][i2] = result[1][i2];
            ++i2;
        }
        return finalP;
    }

    protected void plotSerie(ChartGraphics g, DataSerie s, int serieSec) {
        double YValue;
        int i;
        double XValue;
        s.hotAreas.removeAllElements();
        if (!(s instanceof LineDataSerie)) {
            return;
        }
        LineDataSerie l = (LineDataSerie)s;
        int count = l.getSize();
        int scX = 0;
        int scY = 0;
        int scYMin = 0;
        int scYMax = 0;
        int previousX = -1;
        int previousY = -1;
        boolean isNull = false;
        Scale tmpScaleY = super.getActiveYScale(s);
        Scale tmpScaleX = super.getActiveXScale(s);
        if (l.fillStyle != null && count > 1) {
            double[][] Points = new double[2][count + 2];
            XValue = 0.0;
            i = 0;
            while (i < count) {
                XValue = (Double)l.getElementX(i);
                YValue = l.getElementY(i) == null ? 0.0 : (Double)l.getElementY(i);
                if (i == 0) {
                    Points[0][0] = XValue;
                    Points[1][0] = tmpScaleY.min;
                }
                Points[0][i + 1] = XValue;
                Points[1][i + 1] = YValue;
                ++i;
            }
            Points[0][count + 1] = XValue;
            Points[1][count + 1] = tmpScaleY.min;
            if (this.fixedLimits) {
                Points = this.clipLines(Points, tmpScaleY.max, tmpScaleY.min);
            }
            int[][] PointsSC = new int[2][Points[0].length];
            i = 0;
            while (i < Points[0].length) {
                PointsSC[0][i] = tmpScaleX.getScreenCoord(Points[0][i]);
                PointsSC[1][i] = tmpScaleY.getScreenCoord(Points[1][i]);
                ++i;
            }
            this.bottomCorners[0][0] = PointsSC[0][0];
            this.bottomCorners[1][0] = PointsSC[1][0];
            this.bottomCorners[0][1] = PointsSC[0][PointsSC[0].length - 1];
            this.bottomCorners[1][1] = PointsSC[1][PointsSC[0].length - 1];
            if (l.lineType == 0) {
                l.fillStyle.drawPolygon(g, PointsSC[0], PointsSC[1], PointsSC[0].length);
            }
        }
        double[][] linePoints = new double[2][count];
        boolean[] nullPoints = new boolean[count];
        int iteration = 0;
        while (iteration < 2) {
            i = 0;
            while (i < count) {
                XValue = (Double)l.getElementX(i);
                isNull = false;
                YValue = 0.0;
                if (l.getElementY(i) == null) {
                    isNull = true;
                } else {
                    YValue = (Double)l.getElementY(i);
                }
                if (l.fillStyle != null) {
                    isNull = false;
                }
                scX = tmpScaleX.getScreenCoord(XValue);
                scY = tmpScaleY.getScreenCoord(YValue);
                nullPoints[i] = isNull;
                if (l.style != null && iteration == 0) {
                    linePoints[0][i] = XValue;
                    linePoints[1][i] = YValue;
                }
                if (l.vstyle != null && iteration == 1) {
                    l.vstyle.draw(g, scX, tmpScaleY.getScreenCoord(tmpScaleY.min), scX, scY);
                }
                if (l instanceof MaxMinDataSerie && iteration == 0 && !((MaxMinDataSerie)l).bubbleChart && !isNull) {
                    double tmpY;
                    MaxMinDataSerie m = (MaxMinDataSerie)l;
                    double YMinValue = (Double)m.minData.elementAt(i);
                    double YMaxValue = (Double)m.maxData.elementAt(i);
                    scYMin = tmpScaleY.getScreenCoord(YMinValue);
                    scYMax = tmpScaleY.getScreenCoord(YMaxValue);
                    m.maxminStyle.draw(g, scX, scYMin, scX, scYMax);
                    if (m.drawLineEnd) {
                        m.maxminStyle.draw(g, scX - 3, scYMin, scX + 3, scYMin);
                    }
                    if (m.drawLineEnd) {
                        m.maxminStyle.draw(g, scX - 3, scYMax, scX + 3, scYMax);
                    }
                    if (this.MaxMinType == 1) {
                        tmpY = (Double)m.getElementY(i);
                        scY = tmpScaleY.getScreenCoord(tmpY);
                        m.maxminStyle.draw(g, scX - m.openCloseWidth, scY, scX, scY);
                        YValue = (Double)m.closeData.elementAt(i);
                        scY = tmpScaleY.getScreenCoord(YValue);
                        m.maxminStyle.draw(g, scX + m.openCloseWidth, scY, scX, scY);
                    }
                    if (this.MaxMinType == 2) {
                        tmpY = (Double)m.getElementY(i);
                        int scYOpen = tmpScaleY.getScreenCoord(tmpY);
                        tmpY = (Double)m.closeData.elementAt(i);
                        int scYClose = tmpScaleY.getScreenCoord(tmpY);
                        FillStyle fill = new FillStyle(m.positiveValueColor);
                        if (scYClose > scYOpen) {
                            fill = new FillStyle(m.negativeValueColor);
                            int t = scYClose;
                            scYClose = scYOpen;
                            scYOpen = t;
                        }
                        fill.draw(g, scX - m.openCloseWidth / 2, scYClose, scX + m.openCloseWidth / 2, scYOpen);
                        m.maxminStyle.drawRect(g, scX + m.openCloseWidth / 2, scYOpen, scX - m.openCloseWidth / 2, scYClose);
                    }
                }
                if (l.drawPoint && iteration == 1 && !isNull && YValue <= tmpScaleY.max && YValue >= tmpScaleY.min) {
                    g.setColor(l.pointColor);
                    Polygon p = new Polygon();
                    if (l.icon == null) {
                        int halfPoint = this.pointSize / 2;
                        g.fillRect(scX - halfPoint, scY - halfPoint, this.pointSize, this.pointSize);
                        p.addPoint(scX - halfPoint, scY - halfPoint);
                        p.addPoint(scX - halfPoint, scY + halfPoint);
                        p.addPoint(scX + halfPoint, scY + halfPoint);
                        p.addPoint(scX + halfPoint, scY - halfPoint);
                    } else {
                        g.drawImage(l.icon, scX - 4, scY - 4);
                        p.addPoint(scX - 4, scY - 4);
                        p.addPoint(scX - 4, scY - 4 + l.icon.getHeight());
                        p.addPoint(scX - 4 + l.icon.getWidth(), scY - 4 + l.icon.getHeight());
                        p.addPoint(scX - 4 + l.icon.getWidth(), scY - 4);
                    }
                    l.hotAreas.addElement(p);
                }
                if (l instanceof MaxMinDataSerie && ((MaxMinDataSerie)l).bubbleChart && !isNull) {
                    g.setColor(l.pointColor);
                    double rValue = 0.0;
                    if (((MaxMinDataSerie)l).maxData.size() > i) {
                        rValue = (Double)((MaxMinDataSerie)l).maxData.elementAt(i);
                    }
                    int r = tmpScaleY.getScreenCoord(rValue + YValue);
                    if ((r -= scY) < 0) {
                        r *= -1;
                    }
                    if (r > 0) {
                        if (((MaxMinDataSerie)l).fillBubble) {
                            g.fillArc(scX - r, scY - r, r * 2, r * 2, 0, 360);
                        } else {
                            g.drawArc(scX - r, scY - r, r * 2, r * 2, 0, 360);
                        }
                    }
                }
                if (l.valueFont != null && iteration == 1 && !isNull && YValue <= tmpScaleY.max && YValue >= tmpScaleY.min) {
                    g.setColor(l.valueColor);
                    g.setFont(l.valueFont);
                    String txt = l.doubleToString(new Double(YValue));
                    if (this.hideCeros && txt.compareTo("0") == 0) {
                        txt = "";
                    }
                    String txtValue = txt;
                    if (s.labelTemplate.length() > 0) {
                        txt = s.labelTemplate;
                    }
                    if (s.dataLabels != null && s.dataLabels.length > i) {
                        txt = s.dataLabels[i];
                    }
                    ChartLabel label = new ChartLabel(txt, txtValue, false, false);
                    label.initialize(g, this.chart);
                    label.paint(g, scX + 4, scY - 4 - label.requiredHeight, -1, -1);
                }
                previousX = scX;
                previousY = scY;
                ++i;
            }
            if (iteration == 0 && l.style != null) {
                if (this.fixedLimits) {
                    linePoints = this.clipLines(linePoints, tmpScaleY.max, tmpScaleY.min);
                }
                int[][] linePointsSC = new int[2][linePoints[0].length];
                int j = 0;
                while (j < linePoints[0].length) {
                    isNull = false;
                    if (!this.fixedLimits && nullPoints[j]) {
                        isNull = true;
                    }
                    if (!isNull) {
                        linePointsSC[0][j] = tmpScaleX.getScreenCoord(linePoints[0][j]);
                        linePointsSC[1][j] = tmpScaleY.getScreenCoord(linePoints[1][j]);
                    }
                    ++j;
                }
                if (l.lineType != 0) {
                    this.plotCurve(g, linePointsSC, l);
                } else {
                    j = 1;
                    while (j < linePoints[0].length) {
                        isNull = false;
                        if (!this.fixedLimits && (nullPoints[j] || nullPoints[j - 1])) {
                            isNull = true;
                        }
                        if (!isNull) {
                            boolean draw = true;
                            if (this.fixedLimits && linePoints[1][j - 1] == tmpScaleY.max && linePoints[1][j] == tmpScaleY.max) {
                                draw = false;
                            }
                            if (this.fixedLimits && linePoints[1][j - 1] == tmpScaleY.min && linePoints[1][j] == tmpScaleY.min) {
                                draw = false;
                            }
                            if (draw) {
                                l.style.draw(g, linePointsSC[0][j - 1], linePointsSC[1][j - 1], linePointsSC[0][j], linePointsSC[1][j]);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++iteration;
        }
    }

    protected void plotCurve(ChartGraphics g, int[][] linePointsSC, LineDataSerie l) {
    }
}

