/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartComponent;
import com.java4less.rchart.ChartLabel;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.GraphicsProvider;
import java.util.Enumeration;
import java.util.Vector;

public class Legend
extends ChartComponent {
    Vector items = new Vector(10, 10);
    Vector names = new Vector(10, 10);
    public FillStyle background;
    public LineStyle border;
    public int legendMargin = 8;
    public String title = null;
    public ChartColor color = GraphicsProvider.getColor(ChartColor.BLACK);
    public ChartFont font = GraphicsProvider.getFont("Arial", ChartFont.PLAIN, 10);
    public boolean verticalLayout = true;
    public String legendLabel = "";

    public Legend() {
        if (Chart.d() != 1) {
            this.addItem("RChart demo", null);
        } else if (this.title != null) {
            this.addItem(this.title, null);
        }
    }

    public void addItem(String name, Object icon) {
        this.items.addElement(icon);
        this.names.addElement(name);
    }

    public void draw(ChartGraphics g) {
        if (this.legendLabel != null && this.legendLabel.length() > 0) {
            ChartLabel cl = new ChartLabel(this.legendLabel, "", false, true);
            cl.initialize(g, this.chart);
            cl.paint(g, this.x, this.y, this.width, this.height);
            return;
        }
        if (this.verticalLayout) {
            this.drawVertical(g);
        } else {
            this.drawHorizontal(g);
        }
    }

    public void drawHorizontal(ChartGraphics g) {
        g.setFont(this.font);
        int textWidth = 0;
        int iconWidth = 0;
        int totalWidth = 0;
        int iconHeight = 0;
        int w = 0;
        int h = 0;
        int textHeight = g.getFontHeight();
        int iconSeparator = 3;
        int textSeparator = 5;
        Enumeration e = this.names.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            w = g.getFontWidth(s);
            if (w <= textWidth) continue;
            textWidth = w;
        }
        totalWidth = (textWidth + textSeparator) * this.names.size();
        e = this.items.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            w = 0;
            h = 0;
            if (o instanceof LineStyle) {
                w = 10;
                h = 10;
            }
            if (o instanceof FillStyle) {
                w = 10;
                h = 10;
            }
            if (o instanceof ChartImage) {
                w = ((ChartImage)o).getWidth();
                h = ((ChartImage)o).getHeight();
            }
            if (w > iconWidth) {
                iconWidth = w;
            }
            if (h <= iconHeight) continue;
            iconHeight = h;
        }
        totalWidth += (iconWidth + iconSeparator) * this.names.size();
        int itemHeight = textHeight;
        if (iconHeight > itemHeight) {
            itemHeight = iconHeight;
        }
        int toCenterX = (this.width - totalWidth) / 2;
        int toCenterY = (this.height - itemHeight) / 2;
        if (toCenterY < 0) {
            toCenterY = 0;
        }
        if (toCenterX < 0) {
            toCenterX = 0;
        }
        int legendX1 = this.x + toCenterX;
        int legendY1 = this.y + toCenterY;
        int legendX2 = this.x + toCenterX + totalWidth;
        int legendY2 = this.y + toCenterY + itemHeight;
        if (this.background != null) {
            this.background.draw(g, legendX1 - this.legendMargin, legendY1 - this.legendMargin, legendX2 + this.legendMargin, legendY2 + this.legendMargin);
        }
        if (this.border != null) {
            this.border.drawRect(g, legendX1 - this.legendMargin, legendY1 - this.legendMargin, legendX2 + this.legendMargin, legendY2 + this.legendMargin);
        }
        int offset = 0;
        int i = 1;
        while (i <= this.names.size()) {
            g.setColor(this.color);
            g.drawString((String)this.names.elementAt(i - 1), toCenterX + offset + iconWidth + iconSeparator + this.x, toCenterY + this.y + itemHeight);
            offset = offset + iconWidth + iconSeparator + textWidth + textSeparator;
            ++i;
        }
        offset = 0;
        int i2 = 1;
        while (i2 <= this.names.size()) {
            Object icon = this.items.elementAt(i2 - 1);
            if (icon instanceof ChartImage) {
                g.drawImage((ChartImage)icon, toCenterX + this.x + offset, toCenterY + this.y);
            }
            if (icon instanceof LineStyle) {
                LineStyle l = (LineStyle)icon;
                l.draw(g, toCenterX + this.x + offset, toCenterY + this.y + iconHeight / 2, toCenterX + this.x + iconWidth - 2 + offset, toCenterY + this.y + iconHeight / 2);
            }
            if (icon instanceof FillStyle) {
                int sidelentgh = iconWidth / 2;
                FillStyle f = (FillStyle)icon;
                f.draw(g, toCenterX + this.x + offset, toCenterY + this.y, toCenterX + this.x + offset + sidelentgh, toCenterY + this.y + sidelentgh);
            }
            offset = offset + iconWidth + iconSeparator + textWidth + textSeparator;
            ++i2;
        }
    }

    public void drawVertical(ChartGraphics g) {
        g.setFont(this.font);
        int textWidth = 0;
        int iconWidth = 0;
        int iconHeight = 0;
        int w = 0;
        int h = 0;
        int textHeight = g.getFontHeight();
        Enumeration e = this.names.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            w = g.getFontWidth(s);
            if (w <= textWidth) continue;
            textWidth = w;
        }
        e = this.items.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            w = 0;
            h = 0;
            if (o instanceof LineStyle) {
                w = 10;
                h = 10;
            }
            if (o instanceof FillStyle) {
                w = 10;
                h = 10;
            }
            if (o instanceof ChartImage) {
                w = ((ChartImage)o).getWidth();
                h = ((ChartImage)o).getHeight();
            }
            if (w > iconWidth) {
                iconWidth = w;
            }
            if (h <= iconHeight) continue;
            iconHeight = h;
        }
        int itemHeight = textHeight;
        if (iconHeight > itemHeight) {
            itemHeight = iconHeight;
        }
        int toCenterX = (this.width - (iconWidth + textWidth)) / 2;
        int toCenterY = (this.height - this.names.size() * itemHeight) / 2;
        if (toCenterY < 0) {
            toCenterY = 0;
        }
        if (toCenterX < 0) {
            toCenterX = 0;
        }
        int legendX1 = this.x + toCenterX;
        int legendY1 = this.y + toCenterY;
        int legendX2 = this.x + toCenterX + iconWidth + textWidth;
        int legendY2 = this.y + toCenterY + this.names.size() * itemHeight;
        if (this.background != null) {
            this.background.draw(g, legendX1 - this.legendMargin, legendY1 - this.legendMargin, legendX2 + this.legendMargin, legendY2 + this.legendMargin);
        }
        if (this.border != null) {
            this.border.drawRect(g, legendX1 - this.legendMargin, legendY1 - this.legendMargin, legendX2 + this.legendMargin, legendY2 + this.legendMargin);
        }
        int i = 1;
        while (i <= this.names.size()) {
            g.setColor(this.color);
            g.drawString((String)this.names.elementAt(i - 1), toCenterX + iconWidth + this.x, toCenterY + this.y + i * itemHeight);
            ++i;
        }
        int i2 = 1;
        while (i2 <= this.names.size()) {
            Object icon = this.items.elementAt(i2 - 1);
            if (icon instanceof ChartImage) {
                g.drawImage((ChartImage)icon, toCenterX + this.x, toCenterY + this.y + (i2 - 1) * itemHeight);
            }
            if (icon instanceof LineStyle) {
                LineStyle l = (LineStyle)icon;
                l.draw(g, toCenterX + this.x, toCenterY + this.y + iconHeight / 2 + (i2 - 1) * itemHeight, toCenterX + this.x + iconWidth - 2, toCenterY + this.y + iconHeight / 2 + (i2 - 1) * itemHeight);
            }
            if (icon instanceof FillStyle) {
                int sidelentgh = iconWidth / 2;
                FillStyle f = (FillStyle)icon;
                f.draw(g, toCenterX + this.x, toCenterY + this.y + itemHeight / 2 + (i2 - 1) * itemHeight, toCenterX + this.x + sidelentgh, toCenterY + this.y + itemHeight / 2 + (i2 - 1) * itemHeight + sidelentgh);
            }
            ++i2;
        }
    }
}

