/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

class JDBCSource {
    private Connection connection;
    private Statement statement;

    JDBCSource() {
    }

    public boolean open(String db, String dr, String user, String pwd) {
        try {
            if (dr.trim().length() == 0) {
                String v = System.getProperty("java.vendor");
                if (v.indexOf("Microsoft") >= 0) {
                    Class.forName("com.ms.jdbc.odbc.JdbcOdbcDriver");
                } else {
                    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                }
            } else {
                Class.forName(dr.trim());
            }
            if (db.toUpperCase().indexOf(":") < 0) {
                db = "jdbc:odbc:" + db;
            }
            this.connection = DriverManager.getConnection(db, user, pwd);
            this.statement = this.connection.createStatement();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean close() {
        try {
            this.statement.close();
            this.statement = null;
            this.connection.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String executeQuery(String query) {
        try {
            ResultSet r = this.statement.executeQuery(query);
            String sResult = "";
            String v = "";
            int c = 0;
            while (r.next()) {
                if (c > 0) {
                    sResult = String.valueOf(sResult) + "|";
                }
                v = r.getString(1);
                if (r.wasNull()) {
                    v = "";
                }
                sResult = String.valueOf(sResult) + v;
                ++c;
            }
            r.close();
            r = null;
            return sResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

