/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Axis;
import com.java4less.rchart.Chart;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.GaugeDataSerie;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.GraphicsProvider;
import java.awt.Point;
import java.awt.Polygon;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public class GaugePlotter
extends Plotter {
    public int needleBase = 8;
    public double radiusModifier = 1.0;
    public LineStyle border = new LineStyle(2.0f, GraphicsProvider.getColor(ChartColor.BLACK), 1);
    private Vector lblPositions = new Vector(10);
    public int axis1LabelMargin = 10;
    public int axis2LabelMargin = -20;
    public int axis2Margin = 40;
    public int axis1Margin = 5;
    public Axis axis1;
    public Axis axis2;
    public FillStyle maxZoneColor = new FillStyle(GraphicsProvider.getColor(ChartColor.RED));
    public int maxminZoneWidth = 50;
    public int maxminZoneMargin = 5;
    public double maxZone = -1.0;
    public FillStyle minZoneColor = new FillStyle(GraphicsProvider.getColor(ChartColor.GREEN));
    public double minZone = -1.0;
    public int startAngle = -20;
    public int endAngle = 200;
    public FillStyle gaugeback = new FillStyle(GraphicsProvider.getColor(ChartColor.BLUE));
    private int angleRange = 0;
    private int CenterX = 0;
    private int CenterY = 0;
    public GaugePlotter subGauge1 = null;
    public GaugePlotter subGauge2 = null;
    protected GaugePlotter parentGauge = null;
    public int subGaugeSize = 30;

    public GaugePlotter() {
        this.combinable = false;
        this.needsAxis = 0;
    }

    protected void plotSerie(ChartGraphics g, DataSerie s, int serieSec) {
        int radi = 0;
        radi = this.width;
        if (this.height < radi) {
            radi = this.height;
        }
        radi = (int)((double)radi * this.radiusModifier);
        if (this.axis1 == null) {
            g.setColor(GraphicsProvider.getColor(ChartColor.RED));
            g.drawString("Error: No axis/scale has been defined", 30, 30);
            return;
        }
        int toCenterX = (this.width - radi) / 2;
        int toCenterY = (this.height - radi) / 2;
        s.hotAreas.removeAllElements();
        this.plotGauge(g, s, serieSec, toCenterX, toCenterY, radi, false);
    }

    protected void plotGauge(ChartGraphics g, DataSerie s, int serieSec, int toCenterX, int toCenterY, int radi, boolean isSubGauge) {
        int subToCenterY;
        int subToCenterX;
        int aux;
        boolean circle = false;
        if (this.startAngle > 180 || this.endAngle > 180) {
            circle = true;
        }
        if (!(s instanceof GaugeDataSerie)) {
            return;
        }
        GaugeDataSerie p = (GaugeDataSerie)s;
        int tmpEnd = 180;
        if (circle) {
            tmpEnd = 360;
        }
        if (!circle) {
            toCenterY += radi / 4;
        }
        this.CenterX = toCenterX + this.x + radi / 2;
        this.CenterY = toCenterY + this.y + radi / 2;
        this.angleRange = this.startAngle - this.endAngle;
        this.angleRange = Math.abs(this.angleRange);
        if (this.axis1 != null) {
            this.axis1.scale.screenMin = 0;
            this.axis1.scale.screenMax = 100;
            this.axis1.scale.screenMaxMargin = 100;
            this.axis1.scale.reverse = false;
        }
        if (this.axis2 != null) {
            this.axis2.scale.screenMin = 0;
            this.axis2.scale.screenMax = 100;
            this.axis2.scale.screenMaxMargin = 100;
            this.axis2.scale.reverse = false;
        }
        this.gaugeback.drawArc(g, toCenterX + this.x, toCenterY + this.y, radi, radi, 0, tmpEnd);
        if (this.maxZone > 0.0 && this.axis1 != null) {
            int angle1 = this.getAngleForValue(this.axis1, this.maxZone);
            int angle2 = this.getAngleForValue(this.axis1, this.axis1.scale.max);
            this.maxZoneColor.drawArc(g, toCenterX + this.x + this.maxminZoneMargin, toCenterY + this.y + this.maxminZoneMargin, radi - this.maxminZoneMargin * 2, radi - this.maxminZoneMargin * 2, angle1, angle2 - angle1);
            aux = -5;
            if (this.startAngle > this.endAngle) {
                aux = 5;
            }
            this.gaugeback.drawArc(g, toCenterX + this.x + (this.maxminZoneWidth + this.maxminZoneMargin), toCenterY + this.y + (this.maxminZoneWidth + this.maxminZoneMargin), radi - (this.maxminZoneWidth + this.maxminZoneMargin) * 2, radi - (this.maxminZoneWidth + this.maxminZoneMargin) * 2, angle1 + aux, angle2 - angle1 - aux * 2);
        }
        if (this.minZone > 0.0 && this.axis1 != null) {
            int angle2 = this.getAngleForValue(this.axis1, this.minZone);
            int angle1 = this.getAngleForValue(this.axis1, this.axis1.scale.min);
            this.minZoneColor.drawArc(g, toCenterX + this.x + this.maxminZoneMargin, toCenterY + this.y + this.maxminZoneMargin, radi - this.maxminZoneMargin * 2, radi - this.maxminZoneMargin * 2, angle1, angle2 - angle1);
            aux = -5;
            if (this.startAngle > this.endAngle) {
                aux = 5;
            }
            this.gaugeback.drawArc(g, toCenterX + this.x + (this.maxminZoneWidth + this.maxminZoneMargin), toCenterY + this.y + (this.maxminZoneWidth + this.maxminZoneMargin), radi - (this.maxminZoneWidth + this.maxminZoneMargin) * 2, radi - (this.maxminZoneWidth + this.maxminZoneMargin) * 2, angle1 + aux, angle2 - angle1 - aux * 2);
        }
        if (this.axis2 != null) {
            this.paintScale(g, this.axis2, this.axis2Margin, radi, this.axis2LabelMargin);
        }
        if (this.axis1 != null) {
            this.paintScale(g, this.axis1, this.axis1Margin, radi, this.axis1LabelMargin);
        }
        if (this.border != null) {
            this.border.drawArc(g, toCenterX + this.x, toCenterY + this.y, radi, radi, 0, tmpEnd);
        }
        if (!circle) {
            this.border.draw(g, toCenterX + this.x, toCenterY + this.y + radi / 2, toCenterX + this.x + radi, toCenterY + this.y + radi / 2);
        }
        if (!isSubGauge && this.subGauge1 != null) {
            double subRadi = radi;
            subRadi = subRadi * (double)this.subGaugeSize / 100.0;
            subToCenterX = (int)((double)(toCenterX + radi / 2) - subRadi / 2.0);
            subToCenterY = (int)((double)(toCenterY + radi / 4) - subRadi / 2.0);
            this.subGauge1.x = this.x;
            this.subGauge1.y = this.y;
            this.subGauge1.parentGauge = this;
            this.subGauge1.plotGauge(g, s, serieSec, subToCenterX, subToCenterY, (int)subRadi, true);
        }
        if (!isSubGauge && this.subGauge2 != null) {
            double subRadi = radi;
            subRadi = subRadi * (double)this.subGaugeSize / 100.0;
            subToCenterX = (int)((double)(toCenterX + radi / 2) - subRadi / 2.0);
            subToCenterY = (int)((double)(toCenterY + radi / 2 + radi / 4) - subRadi / 2.0);
            this.subGauge2.x = this.x;
            this.subGauge2.y = this.y;
            this.subGauge2.parentGauge = this;
            this.subGauge2.plotGauge(g, s, serieSec, subToCenterX, subToCenterY, (int)subRadi, true);
        }
        int subGaugesCount = 0;
        int startPos = 0;
        if (!isSubGauge) {
            if (this.subGauge1 != null) {
                ++subGaugesCount;
            }
            if (this.subGauge2 != null) {
                ++subGaugesCount;
            }
        } else {
            startPos = p.yData.size() - 1;
            if (this.parentGauge.subGauge1 == this && this.parentGauge.subGauge2 != null) {
                startPos = p.yData.size() - 2;
            }
        }
        int count = p.yData.size() - subGaugesCount;
        int sCount = 0;
        int i = startPos;
        while (i < count) {
            FillStyle tmpS = null;
            if (p.Styles.size() > i) {
                tmpS = (FillStyle)p.Styles.elementAt(i);
            }
            if (tmpS == null) {
                tmpS = new FillStyle(p.needleStyle.color);
            }
            LineStyle tmpL = new LineStyle(p.needleStyle.getWidth(), tmpS.color, p.needleStyle.getType());
            double tmp1 = radi * this.needleBase / 100;
            double tmp2 = radi / 2 * (100 - this.needleBase) / 100;
            tmpS.drawArc(g, sCount * 3 + toCenterX + this.x + (int)tmp2, sCount * 3 + toCenterY + this.y + (int)tmp2, (int)tmp1 - sCount * 6, (int)tmp1 - sCount * 6, 0, 360);
            double YValue = (Double)p.getElementY(i);
            int angle = this.getAngleForValue(this.axis1, YValue);
            Point p1 = this.getArcPoint(angle, (int)((double)(radi / 2) * (double)p.needleLength / 100.0));
            tmpL.draw(g, this.CenterX + p1.x, this.CenterY + p1.y, this.CenterX, this.CenterY);
            if (p.valueFont != null && i == startPos && !isSubGauge) {
                g.setFont(p.valueFont);
                g.setColor(p.valueColor);
                String txt = "" + YValue;
                int FontH = g.getFontHeight();
                int FontW = g.getFontWidth(txt);
                g.drawString(txt, this.CenterX - FontW / 2, this.CenterY + FontH + 5 + radi / 2 * (this.needleBase / 100));
            }
            if (isSubGauge) break;
            ++sCount;
            if (!isSubGauge) {
                Polygon po = new Polygon();
                po.addPoint(this.CenterX + p1.x, this.CenterY + p1.y);
                po.addPoint(this.CenterX, this.CenterY);
                if (p1.y <= 20) {
                    po.addPoint(this.CenterX, this.CenterY + 5);
                    po.addPoint(this.CenterX + p1.x, this.CenterY + p1.y + 5);
                } else {
                    po.addPoint(this.CenterX + 5, this.CenterY);
                    po.addPoint(this.CenterX + p1.x + 5, this.CenterY + p1.y);
                }
                s.hotAreas.addElement(po);
            }
            ++i;
        }
    }

    private void paintScale(ChartGraphics g, Axis axis, int axisMargin, int radi, int axisLabelMargin) {
        int numberBigTicks = 0;
        int tickCount = 0;
        if (axis.startWithBigTick) {
            tickCount = axis.bigTickInterval - 1;
        }
        double v = axis.scale.min;
        while (v <= axis.scale.max) {
            ++tickCount;
            int angle = this.getAngleForValue(axis, v);
            Point p1 = this.getArcPoint(angle, radi / 2 - axisMargin);
            int relativeY = p1.y;
            int relativeX = p1.x;
            p1 = this.getArcPoint(angle, radi / 2 - axis.tickPixels - axisMargin);
            int relativeY2 = p1.y;
            int relativeX2 = p1.x;
            if (tickCount == axis.bigTickInterval) {
                p1 = this.getArcPoint(angle, radi / 2 - axis.bigTickPixels - axisMargin);
                relativeY2 = p1.y;
                relativeX2 = p1.x;
            }
            axis.style.draw(g, this.CenterX + relativeX2, this.CenterY + relativeY2, this.CenterX + relativeX, this.CenterY + relativeY);
            if (tickCount == axis.bigTickInterval) {
                ++numberBigTicks;
                if (axis.DescFont != null) {
                    g.setFont(axis.DescFont);
                    g.setColor(axis.DescColor);
                    String txt = new Double(v).toString();
                    if (axis.scaleLabelFormat.length() > 0) {
                        DecimalFormat df = null;
                        if (Chart.numberLocale == null) {
                            df = new DecimalFormat(axis.scaleLabelFormat);
                        } else {
                            NumberFormat nf = NumberFormat.getNumberInstance(new Locale(Chart.numberLocale, ""));
                            df = (DecimalFormat)nf;
                            df.applyPattern(axis.scaleLabelFormat);
                        }
                        txt = df.format(new Double(v));
                    }
                    if (axis.IntegerScale) {
                        txt = new Integer((int)v).toString();
                    }
                    if (axis.tickLabels != null) {
                        txt = axis.tickLabels.length >= numberBigTicks ? axis.tickLabels[numberBigTicks - 1] : " ";
                    }
                    p1 = this.getArcPoint(angle, radi / 2 - axisMargin + axisLabelMargin);
                    int h = g.getFontHeight();
                    int w = g.getFontWidth(txt);
                    Point p2 = this.getArcPoint(angle, radi / 2 - axisMargin);
                    if (this.axis1LabelMargin > 0) {
                        if (p1.x + w > p2.x && p1.x < p2.x) {
                            g.drawString(txt, this.CenterX + p1.x - w, this.CenterY + p1.y);
                        } else {
                            g.drawString(txt, this.CenterX + p1.x, this.CenterY + p1.y);
                        }
                    } else if (p1.x + w > p2.x && p1.x < p2.x) {
                        g.drawString(txt, this.CenterX + p1.x - w, this.CenterY + p1.y);
                    } else {
                        g.drawString(txt, this.CenterX + p1.x, this.CenterY + p1.y);
                    }
                }
                tickCount = 0;
            }
            v += axis.scaleTickInterval;
        }
    }

    private int getAngleForValue(Axis axis, double v) {
        int angle = (int)((double)axis.scale.getScreenCoord(v) * (double)this.angleRange / 100.0);
        if (this.startAngle > this.endAngle) {
            angle = this.angleRange - angle;
            return this.endAngle + angle;
        }
        return this.startAngle + angle;
    }

    private Point getArcPoint(int angle, int distanceCenter) {
        double radian = 0.01745277777777778 * (double)angle;
        double Sin = Math.sin(radian);
        double Cos = Math.cos(radian);
        double relativeY = Sin * (double)distanceCenter;
        double relativeX = Cos * (double)distanceCenter;
        return new Point((int)relativeX, (int)(relativeY *= -1.0));
    }
}

