/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.ChartLoader;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.GraphicsProvider;

public class FillStyle {
    public static int NO_GRADIENT = 0;
    public static int GRADIENT_HORIZONTAL = 1;
    public static int GRADIENT_VERTICAL = 2;
    public Object fillPatern = null;
    public float alphaValue = 1.0f;
    private Object composite = null;
    ChartColor color;
    public ChartColor colorFrom = GraphicsProvider.getColor(ChartColor.RED);
    public ChartColor colorUntil = GraphicsProvider.getColor(ChartColor.WHITE);
    public int gradientType = NO_GRADIENT;
    public boolean gradientCyclic = false;
    public ChartImage textureImage = null;

    public FillStyle(ChartColor c) {
        this.color = c;
    }

    public FillStyle(ChartImage i) {
        this.textureImage = i;
        this.color = GraphicsProvider.getColor(ChartColor.WHITE);
    }

    public FillStyle(ChartColor c, float f) {
        this.color = c;
        this.alphaValue = f;
    }

    public String toString() {
        if (this.gradientType != NO_GRADIENT) {
            return String.valueOf(this.colorFrom.getRGBString()) + ";" + this.colorUntil.getRGBString();
        }
        if (this.alphaValue != 1.0f) {
            return String.valueOf(this.color.getRGBString()) + "|" + this.alphaValue;
        }
        return this.color.getRGBString();
    }

    public static FillStyle createFromString(String f) {
        if (f.toUpperCase().indexOf(".JPEG") > 0 || f.toUpperCase().indexOf(".JPG") > 0 || f.toUpperCase().indexOf(".PNG") > 0 || f.toUpperCase().indexOf(".GIF") > 0) {
            ChartImage image = GraphicsProvider.getImageFromFile(f);
            return new FillStyle(image);
        }
        int p = f.indexOf(";");
        String separator = ";";
        if (p == -1) {
            p = f.indexOf(":");
            separator = ":";
        }
        if (p > -1) {
            String[] items = ChartLoader.convertList(f, separator);
            FillStyle fillFrom = new FillStyle(GraphicsProvider.getColor(ChartColor.BLACK));
            fillFrom.color = fillFrom.colorFrom = ChartLoader.convertColor(items[0]);
            fillFrom.colorUntil = ChartLoader.convertColor(items[1]);
            fillFrom.gradientType = GRADIENT_VERTICAL;
            if (items.length > 2 && items[2].toUpperCase().compareTo("HORIZONTAL") == 0) {
                fillFrom.gradientType = GRADIENT_HORIZONTAL;
            }
            return fillFrom;
        }
        if (f.compareTo("") == 0) {
            return null;
        }
        String[] items = ChartLoader.convertList(f);
        if (items == null) {
            return null;
        }
        if (items.length < 1) {
            return null;
        }
        ChartColor c = ChartLoader.convertColor(items[0]);
        try {
            if (items.length == 1) {
                return new FillStyle(c);
            }
            return new FillStyle(c, new Float(items[1]).floatValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ChartColor getColor() {
        return this.color;
    }

    protected void drawArc(ChartGraphics g, int x, int y, int w, int h, int a1, int a2) {
        g.setTexture(this.textureImage);
        g.setColor(this.color);
        this.setAlpha(g);
        g.fillArc(x, y, w, h, a1, a2);
        this.resetAlpha(g);
    }

    private void setAlpha(ChartGraphics g) {
        if (this.alphaValue != 1.0f) {
            this.composite = g.getAlphaComposite();
            g.setAlpha(this.alphaValue);
        }
    }

    private void resetAlpha(ChartGraphics g) {
        if (this.composite != null) {
            g.setAlphaComposite(this.composite);
        }
        this.composite = null;
    }

    protected void drawPolygon(ChartGraphics g, int[] x1, int[] y1, int num) {
        g.setTexture(this.textureImage);
        g.setColor(this.color);
        this.setAlpha(g);
        g.fillPolygon(x1, y1, num);
        this.resetAlpha(g);
    }

    protected void draw(ChartGraphics g, int x1, int y1, int x2, int y2) {
        g.setTexture(this.textureImage);
        g.setColor(this.color);
        if (this.gradientType != NO_GRADIENT) {
            g.createFadeArea(this.colorFrom, this.colorUntil, x1, y1, x2 - x1, y2 - y1, this.gradientType == GRADIENT_VERTICAL, this.gradientCyclic);
        } else {
            this.setAlpha(g);
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
            this.resetAlpha(g);
        }
    }

    public void drawRoundRect(ChartGraphics g, int x1, int y1, int x2, int y2) {
        g.setTexture(this.textureImage);
        g.setColor(this.color);
        this.setAlpha(g);
        g.fillRoundRect(x1, y1, x2 - x1, y2 - y1);
        this.resetAlpha(g);
    }
}

