/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.LineDataSerie;
import com.java4less.rchart.LinePlotter;
import com.java4less.rchart.RMatrix;
import com.java4less.rchart.gc.ChartGraphics;
import java.awt.Polygon;

public class CurvePlotter
extends LinePlotter {
    private static final int X = 0;
    private static final int Y = 1;
    public int segments = 24;

    private float b(int i, float t) {
        switch (i) {
            case -2: {
                return (((-t + 3.0f) * t - 3.0f) * t + 1.0f) / 6.0f;
            }
            case -1: {
                return ((3.0f * t - 6.0f) * t * t + 4.0f) / 6.0f;
            }
            case 0: {
                return (((-3.0f * t + 3.0f) * t + 3.0f) * t + 1.0f) / 6.0f;
            }
            case 1: {
                return t * t * t / 6.0f;
            }
        }
        return 0.0f;
    }

    private int[] p(int i, float t, int[][] linePointsSC) {
        float px = 0.0f;
        float py = 0.0f;
        int j = -2;
        while (j <= 1) {
            px += this.b(j, t) * (float)linePointsSC[0][i + j];
            py += this.b(j, t) * (float)linePointsSC[1][i + j];
            ++j;
        }
        int[] point = new int[]{Math.round(px), Math.round(py)};
        return point;
    }

    private void plotLeastSquares(ChartGraphics g, int[][] linePointsSC, LineDataSerie l) {
        int pts = linePointsSC[0].length;
        int degree = 1;
        RMatrix Pm = new RMatrix(pts, degree + 1);
        RMatrix Ym = new RMatrix(pts, 1);
        int i = 0;
        while (i < pts) {
            int k = 0;
            while (k <= degree) {
                Pm.setValue(i, k, Math.pow(linePointsSC[0][i], k));
                ++k;
            }
            Ym.setValue(i, 0, linePointsSC[1][i]);
            ++i;
        }
        RMatrix T = Pm.transpose();
        RMatrix MT = T.mult(Pm);
        RMatrix resultMatrix = MT.invert().mult(T).mult(Ym);
        double a1 = resultMatrix.getValue(0, 0);
        double a2 = resultMatrix.getValue(1, 0);
        int x1 = linePointsSC[0][0];
        int y1 = (int)Math.round(a1 + (double)x1 * a2);
        int x2 = linePointsSC[0][pts - 1];
        int y2 = (int)Math.round(a1 + (double)x2 * a2);
        l.style.draw(g, x1, y1, x2, y2);
    }

    private void plotBSPLines(ChartGraphics g, int[][] plinePointsSC, LineDataSerie l) {
        int[][] linePointsSC = new int[2][plinePointsSC[0].length + 2];
        int i = 0;
        while (i < plinePointsSC[0].length) {
            linePointsSC[0][i + 1] = plinePointsSC[0][i];
            linePointsSC[1][i + 1] = plinePointsSC[1][i];
            ++i;
        }
        linePointsSC[0][0] = linePointsSC[0][1];
        linePointsSC[1][0] = linePointsSC[1][1];
        linePointsSC[0][linePointsSC[0].length - 1] = plinePointsSC[0][plinePointsSC[0].length - 1];
        linePointsSC[1][linePointsSC[0].length - 1] = plinePointsSC[1][plinePointsSC[0].length - 1];
        int pieces = this.segments;
        int[] xpoints = new int[pieces * (linePointsSC[0].length - 3) + 1 + 2];
        int[] ypoints = new int[pieces * (linePointsSC[0].length - 3) + 1 + 2];
        Polygon pol = new Polygon();
        int[] q = this.p(2, 0.0f, linePointsSC);
        xpoints[0] = q[0];
        ypoints[0] = q[1];
        int cou = 1;
        int i2 = 2;
        while (i2 < linePointsSC[0].length - 1) {
            int j = 1;
            while (j <= pieces) {
                q = this.p(i2, (float)j / (float)pieces, linePointsSC);
                xpoints[cou] = q[0];
                ypoints[cou] = q[1];
                ++cou;
                ++j;
            }
            ++i2;
        }
        if (l.fillStyle != null) {
            xpoints[cou + 1] = xpoints[0];
            ypoints[cou + 1] = this.bottomCorners[1][0];
            xpoints[cou] = xpoints[cou - 1];
            ypoints[cou] = this.bottomCorners[1][1];
            l.fillStyle.drawPolygon(g, xpoints, ypoints, cou + 2);
        }
        xpoints[0] = linePointsSC[0][0];
        ypoints[0] = linePointsSC[1][0];
        xpoints[cou - 1] = linePointsSC[0][linePointsSC[0].length - 1];
        ypoints[cou - 1] = linePointsSC[1][linePointsSC[1].length - 1];
        l.style.drawOpenPolygon(g, xpoints, ypoints, cou);
    }

    private void plotCubicNatural(ChartGraphics g, int[][] linePointsSC, LineDataSerie l) {
        float[][] polyX = this.naturalCubic(linePointsSC[0].length - 1, linePointsSC[0]);
        float[][] polyY = this.naturalCubic(linePointsSC[1].length - 1, linePointsSC[1]);
        int pieces = this.segments;
        int[] xpoints = new int[pieces * polyX[0].length + 1 + 2];
        int[] ypoints = new int[pieces * polyX[0].length + 1 + 2];
        xpoints[0] = Math.round(this.evalPolynomial(polyX[0][0], polyX[1][0], polyX[2][0], polyX[3][0], 0.0f));
        ypoints[0] = Math.round(this.evalPolynomial(polyY[0][0], polyY[1][0], polyY[2][0], polyY[3][0], 0.0f));
        int cou = 0;
        int k = 0;
        while (k < polyX[0].length) {
            int j = 1;
            while (j <= pieces) {
                float u = (float)j / (float)pieces;
                xpoints[cou] = Math.round(this.evalPolynomial(polyX[0][k], polyX[1][k], polyX[2][k], polyX[3][k], u));
                ypoints[cou] = Math.round(this.evalPolynomial(polyY[0][k], polyY[1][k], polyY[2][k], polyY[3][k], u));
                ++cou;
                ++j;
            }
            ++k;
        }
        if (l.fillStyle != null) {
            xpoints[cou + 1] = this.bottomCorners[0][0];
            ypoints[cou + 1] = this.bottomCorners[1][0];
            xpoints[cou] = this.bottomCorners[0][1];
            ypoints[cou] = this.bottomCorners[1][1];
            l.fillStyle.drawPolygon(g, xpoints, ypoints, cou + 2);
        }
        xpoints[0] = linePointsSC[0][0];
        ypoints[0] = linePointsSC[1][0];
        l.style.drawOpenPolygon(g, xpoints, ypoints, cou);
    }

    protected void plotCurve(ChartGraphics g, int[][] linePointsSC, LineDataSerie l) {
        if (linePointsSC.length > 1) {
            if (l.lineType == 1) {
                this.plotCubicNatural(g, linePointsSC, l);
            }
            if (l.lineType == 2) {
                this.plotBSPLines(g, linePointsSC, l);
            }
            if (l.lineType == 3) {
                this.plotLeastSquares(g, linePointsSC, l);
            }
        }
    }

    private float[][] naturalCubic(int n, int[] x) {
        float[] g = new float[n + 1];
        float[] d = new float[n + 1];
        float[] D = new float[n + 1];
        g[0] = 0.5f;
        int i = 1;
        while (i < n) {
            g[i] = 1.0f / (4.0f - g[i - 1]);
            ++i;
        }
        g[n] = 1.0f / (2.0f - g[n - 1]);
        d[0] = (float)(3 * (x[1] - x[0])) * g[0];
        i = 1;
        while (i < n) {
            d[i] = ((float)(3 * (x[i + 1] - x[i - 1])) - d[i - 1]) * g[i];
            ++i;
        }
        d[n] = ((float)(3 * (x[n] - x[n - 1])) - d[n - 1]) * g[n];
        D[n] = d[n];
        i = n - 1;
        while (i >= 0) {
            D[i] = d[i] - g[i] * D[i + 1];
            --i;
        }
        float[][] P = new float[4][n];
        i = 0;
        while (i < n) {
            P[0][i] = x[i];
            P[1][i] = D[i];
            P[2][i] = (float)(3 * (x[i + 1] - x[i])) - 2.0f * D[i] - D[i + 1];
            P[3][i] = (float)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1];
            ++i;
        }
        return P;
    }

    private float evalPolynomial(float a1, float a2, float a3, float a4, float x) {
        return ((a4 * x + a3) * x + a2) * x + a1;
    }
}

