/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Axis;
import com.java4less.rchart.AxisTargetZone;
import com.java4less.rchart.BarDataSerie;
import com.java4less.rchart.BarPlotter;
import com.java4less.rchart.BarPlotter3D;
import com.java4less.rchart.Chart;
import com.java4less.rchart.CurvePlotter;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.GaugeDataSerie;
import com.java4less.rchart.GaugePlotter;
import com.java4less.rchart.HAxisLabel;
import com.java4less.rchart.JDBCSource;
import com.java4less.rchart.Legend;
import com.java4less.rchart.LineDataSerie;
import com.java4less.rchart.LinePlotter;
import com.java4less.rchart.LinePlotter3D;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.LogScale;
import com.java4less.rchart.MaxMinDataSerie;
import com.java4less.rchart.ParamInput;
import com.java4less.rchart.PieDataSerie;
import com.java4less.rchart.PiePlotter;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.RadarPlotter;
import com.java4less.rchart.Scale;
import com.java4less.rchart.TargetZone;
import com.java4less.rchart.Title;
import com.java4less.rchart.VAxisLabel;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.GraphicsProvider;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChartLoader {
    public String fileEncoding = "";
    private Applet chartApplet;
    private JDBCSource jdbcsource = null;
    private Component parentComponent = null;
    public Chart gChart = null;
    public boolean paintDirect = true;
    String ptitle;
    String ptitleFont;
    String ptitleColor;
    String Y2label;
    String Y2labelFont;
    String Y2labelColor;
    String Xlabel;
    String Ylabel;
    String XlabelFont;
    String YlabelFont;
    String XlabelColor;
    String YlabelColor;
    double pchartLeftMargin;
    double pchartTopMargin;
    double pchartLegendMargin;
    double pchartBottomMargin;
    double pchartSecondYAxisMargin;
    String plegendPosition;
    String pSerie;
    public String[] pSeriesNames = new String[50];
    String[] pSeriesData = new String[50];
    String[] pSeriesMaxData = new String[50];
    String[] pSeriesMinData = new String[50];
    String[] pSeriesCloseData = new String[50];
    public DataSerie[] pSeries = new DataSerie[50];
    public int pnumSeries = 0;
    boolean plegend;
    String[] loadedParameters = new String[1500];
    String[] loadedValues = new String[1500];
    int loadedParametersCount = 0;
    public boolean promptForParameters = false;
    private String dataFile = "";
    private String[] SQLparams = new String[10];
    private String[] SQLparamsV = new String[10];
    private int SQLparamCount = 0;

    public ChartLoader(Applet ap) {
        this.chartApplet = ap;
        this.loadedParametersCount = 0;
    }

    public ChartLoader() {
        this.loadedParametersCount = 0;
    }

    private String getSQLParameterValue(String param) {
        int i = 0;
        while (i < this.SQLparamCount) {
            if (this.SQLparams[i].compareTo(param) == 0) {
                return this.SQLparamsV[i];
            }
            ++i;
        }
        return null;
    }

    private String repSQLParameters(String s) {
        int p1 = s.indexOf("[%");
        if (p1 == -1) {
            return s;
        }
        int p2 = s.indexOf("]", p1);
        while (p1 >= 0 && p2 >= 0 && p2 > p1) {
            String param = s.substring(p1 + 2, p2);
            String value = this.getSQLParameterValue(param);
            if (value == null && this.promptForParameters) {
                ParamInput pi = new ParamInput((Frame)this.parentComponent, param);
                pi.show();
                if (!pi.cancelled) {
                    value = pi.result;
                }
                pi = null;
            }
            if (value != null) {
                s = String.valueOf(s.substring(0, p1)) + value + s.substring(p2 + 1, s.length());
            }
            if ((p1 = s.indexOf("[%", p2 + 1)) == -1) {
                return s;
            }
            p2 = s.indexOf("]", p1);
        }
        return s;
    }

    public void setSQLParameter(String param, String value) {
        int i = 0;
        while (i < this.SQLparamCount) {
            if (this.SQLparams[i].compareTo(param) == 0) {
                this.SQLparamsV[i] = value;
                return;
            }
            ++i;
        }
        this.SQLparams[this.SQLparamCount] = param;
        this.SQLparamsV[this.SQLparamCount] = value;
        ++this.SQLparamCount;
    }

    protected static boolean convertBooleanParam(String s, boolean def) {
        try {
            if (s.compareTo("") == 0) {
                return def;
            }
            if (s.toUpperCase().compareTo("N") == 0) {
                return false;
            }
            if (s.toUpperCase().compareTo("NO") == 0) {
                return false;
            }
            if (s.toUpperCase().compareTo("0") == 0) {
                return false;
            }
            if (s.toUpperCase().compareTo("FALSE") == 0) {
                return false;
            }
            if (s.toUpperCase().compareTo("Y") == 0) {
                return true;
            }
            if (s.toUpperCase().compareTo("YES") == 0) {
                return true;
            }
            if (s.toUpperCase().compareTo("TRUE") == 0) {
                return true;
            }
            if (s.toUpperCase().compareTo("1") == 0) {
                return true;
            }
            return Boolean.valueOf(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean getBooleanParam(String Param, boolean def) {
        String s = this.getParameter(Param, "");
        return ChartLoader.convertBooleanParam(s, def);
    }

    private String replaceStr(String s, String sub1, String sub2) {
        int p = s.indexOf(sub1);
        while (p >= 0) {
            s = String.valueOf(s.substring(0, p)) + sub2 + s.substring(p + sub1.length(), s.length());
            p = s.indexOf(sub1);
        }
        return s;
    }

    protected Date getDateParam(String Param, String def) {
        try {
            String s = this.getParameter(Param, "");
            if (s.compareTo("") == 0) {
                s = def;
            }
            if (s.compareTo("") == 0) {
                return null;
            }
            s = this.replaceStr(s, "/", "-");
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
            if (s.length() > 10) {
                df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            }
            return df.parse(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Integer getIntParam(String Param, Integer def) {
        try {
            String s = this.getParameter(Param, "");
            if (s.compareTo("") == 0) {
                return def;
            }
            return new Integer(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Double getDoubleParam(String Param, Double def) {
        try {
            String s = this.getParameter(Param, "");
            if (s.compareTo("") == 0) {
                return def;
            }
            return new Double(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private String getStringParam(String Param, String def) {
        return this.getParameter(Param, def);
    }

    private String getParsedValue(String s) {
        if (this.jdbcsource == null) {
            return s;
        }
        if (s.indexOf("JDBC:") == 0) {
            s = this.repSQLParameters(s);
            s = this.jdbcsource.executeQuery(s.substring(5, s.length()));
        }
        return s;
    }

    public String getParameter(String key, String def) {
        String v = "";
        int i = 0;
        while (i < this.loadedParametersCount) {
            if (this.loadedParameters[i].compareTo(key) == 0) {
                v = this.loadedValues[i];
                if (v.length() == 0) {
                    return def;
                }
                return this.getParsedValue(v);
            }
            ++i;
        }
        if (this.chartApplet != null) {
            v = this.chartApplet.getParameter(key);
        }
        if (v == null) {
            return def;
        }
        if (v.length() == 0) {
            return def;
        }
        return v;
    }

    public static ChartColor convertColor(String s) {
        return GraphicsProvider.getColor(s);
    }

    protected static ChartFont convertFont(String f) {
        String[] items = ChartLoader.convertList(f, "|");
        if (items == null) {
            return null;
        }
        if (items.length < 3) {
            return null;
        }
        int s = ChartFont.PLAIN;
        if (items[1].compareTo("BOLD") == 0) {
            s = ChartFont.BOLD;
        }
        if (items[1].compareTo("ITALIC") == 0) {
            s = ChartFont.ITALIC;
        }
        try {
            return GraphicsProvider.getFont(items[0], s, new Integer(items[2]));
        }
        catch (Exception e) {
            System.out.println("Error converting font " + f + " " + e.getMessage());
            return null;
        }
    }

    protected static String[] convertList(String items) {
        return ChartLoader.convertList(items, "|");
    }

    protected static String[] convertList(String items, String separator) {
        int elements = 1;
        int p = items.indexOf(separator);
        while (p >= 0) {
            ++elements;
            p = items.indexOf(separator, p + 1);
        }
        String[] itema = new String[elements];
        int itemCount = 0;
        p = items.indexOf(separator);
        while (p >= 0) {
            itema[itemCount++] = items.substring(0, p);
            items = items.substring(p + separator.length(), items.length());
            p = items.indexOf(separator);
        }
        if (items.compareTo("") != 0) {
            itema[itemCount++] = items;
        }
        if (itemCount == 0) {
            return null;
        }
        String[] result = new String[itemCount];
        int i = 0;
        while (i < itemCount) {
            result[i] = itema[i];
            ++i;
        }
        return result;
    }

    private String[] getItemsParameter(String key) {
        String items = this.getStringParam(key, "");
        return ChartLoader.convertList(items);
    }

    private double[] convertDoubleList(String s) {
        String[] items = ChartLoader.convertList(s);
        if (items == null) {
            return null;
        }
        double[] d = new double[items.length];
        int i = 0;
        while (i < items.length) {
            try {
                d[i] = new Double(items[i]);
            }
            catch (Exception e) {
                d[i] = 0.0;
            }
            ++i;
        }
        return d;
    }

    private int[] convertIntList(String s) {
        String[] items = ChartLoader.convertList(s);
        int[] d = new int[items.length];
        int i = 0;
        while (i < items.length) {
            try {
                d[i] = new Integer(items[i]);
            }
            catch (Exception e) {
                d[i] = 0;
            }
            ++i;
        }
        return d;
    }

    private Double[] convertDoubleListWithNulls(String s) {
        String[] items = ChartLoader.convertList(s);
        if (items == null) {
            return new Double[0];
        }
        Double[] d = new Double[items.length];
        int i = 0;
        while (i < items.length) {
            try {
                d[i] = items[i].toUpperCase().compareTo("NULL") == 0 ? null : new Double(items[i]);
            }
            catch (Exception e) {
                d[i] = new Double(0.0);
            }
            ++i;
        }
        return d;
    }

    private boolean[] convertBooleanList(String s) {
        String[] items = ChartLoader.convertList(s);
        boolean[] d = new boolean[items.length];
        int i = 0;
        while (i < items.length) {
            try {
                d[i] = items[i].compareTo("0") != 0 && items[i].toUpperCase().compareTo("FALSE") != 0;
            }
            catch (Exception e) {
                d[i] = false;
            }
            ++i;
        }
        return d;
    }

    protected static LineStyle convertLineStyle(String f) {
        return LineStyle.createFromString(f);
    }

    protected static FillStyle convertFillStyle(String f) {
        return FillStyle.createFromString(f);
    }

    private String convertFromDates(String v, String dateStep, Date initialDate) {
        String[] vs = ChartLoader.convertList(v);
        String result = "";
        int i = 0;
        while (i < vs.length) {
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
            if (vs[i].length() > 10) {
                df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            }
            Date d = initialDate;
            vs[i] = this.replaceStr(vs[i], "/", "-");
            try {
                d = df.parse(vs[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            double diff2 = Axis.convertFromDate(d, dateStep, initialDate);
            if (i > 0) {
                result = String.valueOf(result) + "|";
            }
            diff2 = Math.floor(diff2 * 100.0) / 100.0;
            result = String.valueOf(result) + diff2;
            ++i;
        }
        return result;
    }

    private Axis loadAxisAndScale(String name, int type) {
        int iTmp;
        Scale sc = new Scale();
        if (this.getBooleanParam(String.valueOf(name) + "SCALE_LOG", false)) {
            sc = new LogScale();
        }
        if ((iTmp = this.getIntParam(String.valueOf(name) + "SCALE_LOG_BASE", new Integer(2)).intValue()) != 2 && sc instanceof LogScale) {
            ((LogScale)sc).base = iTmp;
        }
        Double scaleMin = this.getDoubleParam(String.valueOf(name) + "SCALE_MIN", null);
        Double scaleMax = this.getDoubleParam(String.valueOf(name) + "SCALE_MAX", null);
        if (scaleMin != null) {
            sc.min = scaleMin;
        }
        if (scaleMax != null) {
            sc.max = scaleMax;
        }
        boolean bigTicksGrid = this.getBooleanParam("GRID" + name, false);
        Double scaleTickInterval = this.getDoubleParam("TICK_INTERVAL" + name, new Double(1.0));
        Integer bigTickInterval = this.getIntParam("BIG_TICK_INTERVAL" + name, new Integer(5));
        int[] bigTickIntervalList = null;
        if (this.getStringParam("BIG_TICK_INTERVAL_LIST" + name, "").length() > 0) {
            bigTickIntervalList = this.convertIntList(this.getStringParam("BIG_TICK_INTERVAL_LIST" + name, ""));
        }
        String axisLabels = this.getStringParam(String.valueOf(name) + "AXIS_LABELS", "");
        sc.exactMaxValue = this.getBooleanParam(String.valueOf(name) + "SCALE_EXACT_MAX", false);
        sc.exactMinValue = this.getBooleanParam(String.valueOf(name) + "SCALE_EXACT_MIN", false);
        if (this.getStringParam(String.valueOf(name) + "SCALE_PREF_MAXMIN", "").length() > 0) {
            sc.preferred_MaxMin_values = this.convertDoubleList(this.getStringParam(String.valueOf(name) + "SCALE_PREF_MAXMIN", ""));
        }
        Axis axis = new Axis(type, sc);
        axis.bigTickInterval = bigTickInterval;
        axis.bigTickIntervalList = bigTickIntervalList;
        axis.scaleTickInterval = scaleTickInterval;
        axis.bigTicksGrid = bigTicksGrid;
        if (axisLabels.compareTo("") != 0) {
            axis.tickLabels = ChartLoader.convertList(axisLabels);
        }
        this.loadAxis(axis, name);
        int subAxis = 1;
        while (this.getBooleanParam(String.valueOf(name) + "_" + subAxis + "AXIS", false)) {
            axis.addAdditionalAxis(this.loadAxisAndScale(String.valueOf(name) + "_" + subAxis, type));
            ++subAxis;
        }
        return axis;
    }

    private void loadAxis(Axis axis, String name) {
        String tmp;
        ChartColor c;
        FillStyle fstyle;
        LineStyle lstyle;
        axis.autoNumberOfTicks = this.getIntParam(String.valueOf(name) + "AXIS_AUTO_TICKS", new Integer(0));
        if (this.getStringParam(String.valueOf(name) + "AXIS_PREF_TICK_INTERVAL", "").length() > 0) {
            axis.ticks_preferred_Interval = this.convertDoubleList(this.getStringParam(String.valueOf(name) + "AXIS_PREF_TICK_INTERVAL", ""));
        }
        if (this.getBooleanParam(String.valueOf(name) + "AXIS_START_WITH_BIG_TICK", false)) {
            axis.startWithBigTick = true;
        }
        axis.logarithmicIntervals = this.getBooleanParam("TICK_LOG_INTERVAL" + name, false);
        axis.axisFrame = this.getBooleanParam(String.valueOf(name) + "AXIS_CLOSED", false);
        axis.xscaleOnTop = this.getBooleanParam(String.valueOf(name) + "AXIS_ON_TOP", false);
        axis.stackAdditionalAxis = this.getBooleanParam(String.valueOf(name) + "AXIS_STACK_ADDITIONAL", false);
        axis.labelTemplate = this.getStringParam(String.valueOf(name) + "AXIS_TEMPLATE", "");
        axis.label = this.getStringParam(String.valueOf(name) + "AXIS_LABEL", "");
        axis.dateLabelFormat = this.getStringParam(String.valueOf(name) + "AXIS_DATE_FORMAT", "dd-MMM-yyyy");
        axis.dateStep = this.getStringParam(String.valueOf(name) + "AXIS_DATE_STEP", "d");
        axis.initialDate = this.getDateParam(String.valueOf(name) + "AXIS_INITIAL_DATE", "");
        Date d = this.getDateParam(String.valueOf(name) + "AXIS_FINAL_DATE", "");
        if (d != null) {
            axis.scale.max = Axis.convertFromDate(d, axis.dateStep, axis.initialDate);
            axis.dateStepPerUnit = true;
        }
        axis.tickLabelLength = this.getIntParam(String.valueOf(name) + "AXIS_TICK_TEXT_LINE", new Integer(1000));
        axis.tickPixels = (int)this.getDoubleParam(String.valueOf(name) + "AXIS_TICKPIXELS", new Double(axis.tickPixels)).doubleValue();
        axis.bigTickPixels = (int)this.getDoubleParam(String.valueOf(name) + "AXIS_BIGTICKPIXELS", new Double(axis.bigTickPixels)).doubleValue();
        String ceroAxis = this.getStringParam("CERO_XAXIS", "");
        if (ceroAxis.compareTo("LINE") == 0) {
            axis.ceroAxis = 0;
        }
        if (ceroAxis.compareTo("NO") == 0) {
            axis.ceroAxis = 1;
        }
        if (ceroAxis.compareTo("SCALE") == 0) {
            axis.ceroAxis = 2;
        }
        if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("CERO_XAXIS_STYLE", ""))) != null) {
            axis.ceroAxisStyle = lstyle;
        }
        if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam(String.valueOf(name) + "AXIS_STYLE", ""))) != null) {
            axis.style = lstyle;
        }
        if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam(String.valueOf(name) + "AXIS_GRID", ""))) != null) {
            axis.gridStyle = lstyle;
        }
        if ((fstyle = ChartLoader.convertFillStyle(this.getStringParam(String.valueOf(name) + "AXIS_FILL_GRID", ""))) != null) {
            axis.gridFillStyle = fstyle;
        }
        axis.DescColor = c = ChartLoader.convertColor(this.getStringParam(String.valueOf(name) + "AXIS_FONT_COLOR", ""));
        ChartFont font = ChartLoader.convertFont(this.getStringParam(String.valueOf(name) + "AXIS_FONT", ""));
        if (font != null) {
            axis.DescFont = font;
        }
        axis.IntegerScale = this.getBooleanParam(String.valueOf(name) + "AXIS_INTEGER", true);
        axis.scaleLabelFormat = this.getStringParam(String.valueOf(name) + "AXIS_LABEL_FORMAT", "");
        axis.tickAtBase = this.getBooleanParam(String.valueOf(name) + "AXIS_TICKATBASE", false);
        axis.rotateLabels = this.getIntParam(String.valueOf(name) + "AXIS_ROTATE_LABELS", new Integer(0));
        if (this.getBooleanParam(String.valueOf(name) + "AXIS_VERTICAL_LABELS", false)) {
            axis.rotateLabels = 90;
        }
        if ((fstyle = ChartLoader.convertFillStyle(this.getStringParam(String.valueOf(name) + "AXIS_FILLING", ""))) != null) {
            axis.barFilling = fstyle;
        }
        if ((tmp = this.getStringParam(String.valueOf(name) + "AXIS_BAR_STYLE", "NONE")).equals("BAR")) {
            axis.barStyle = 1;
        }
        if (tmp.equals("RAISED")) {
            axis.barStyle = 2;
        }
        axis.barWidth = this.getIntParam(String.valueOf(name) + "AXIS_BAR_WIDTH", new Integer(axis.barWidth));
        int zoneNr = 1;
        while (this.getParameter(String.valueOf(name) + "AXIS_TARGET_ZONE_" + zoneNr, "").length() > 0) {
            axis.addTargetZone(AxisTargetZone.createFromString(this.getParameter(String.valueOf(name) + "AXIS_TARGET_ZONE_" + zoneNr, "")));
            ++zoneNr;
        }
    }

    private void setAxisForSerie(int i, Axis cXAxis, Axis cYAxis, DataSerie s) {
        int secAxis = this.getIntParam("SERIE_SECONDARY_XAXIS_" + i, new Integer(0));
        if (secAxis > 0 && cXAxis.getAdditionalAxisCount() >= secAxis) {
            s.secondaryXAxis = cXAxis.getAdditionalAxis(secAxis - 1);
        }
        if ((secAxis = this.getIntParam("SERIE_SECONDARY_YAXIS_" + i, new Integer(0)).intValue()) > 0 && cYAxis.getAdditionalAxisCount() >= secAxis) {
            s.secondaryYAxis = cYAxis.getAdditionalAxis(secAxis - 1);
        }
    }

    private Chart buildChart(Chart currentChart) {
        String backImageStr;
        double tmpDouble;
        Double d;
        Chart chart;
        LinePlotter plot;
        Double dob;
        LineStyle lstyle;
        FillStyle fstyle;
        ChartColor c;
        ChartFont font = null;
        Title cTitle = null;
        HAxisLabel cXLabel = null;
        VAxisLabel cYLabel = null;
        VAxisLabel cY2Label = null;
        Plotter gaugePlot = null;
        LinePlotter linePlot = null;
        Plotter linePlot3D = null;
        Plotter barPlot = null;
        Plotter barPlot3D = null;
        Plotter piePlot = null;
        Plotter radarPlot = null;
        String jdbcdb = "";
        String jdbcdriver = "";
        String jdbcuser = "";
        String jdbcpwd = "";
        Axis cXAxis = null;
        Axis cYAxis = null;
        Axis cY2Axis = null;
        Legend clegend = new Legend();
        jdbcdb = this.getStringParam("JDBC_DATABASE", "");
        jdbcdriver = this.getStringParam("JDBC_DRIVER", "");
        jdbcuser = this.getStringParam("JDBC_USER", "");
        jdbcpwd = this.getStringParam("JDBC_PASSWORD", "");
        if (jdbcdb.length() > 0) {
            this.jdbcsource = new JDBCSource();
            this.jdbcsource.open(jdbcdb, jdbcdriver, jdbcuser, jdbcpwd);
        }
        LineDataSerie.startingXValue = this.getIntParam("LINECHART_START_VALUE_X", new Integer(0));
        this.ptitle = this.getStringParam("TITLECHART", "");
        if (this.ptitle.compareTo("") == 0) {
            this.ptitle = this.getStringParam("TITLE", "");
        }
        if (this.ptitle.compareTo("") != 0) {
            cTitle = new Title(this.ptitle);
            this.ptitleFont = this.getStringParam("TITLE_FONT", "");
            font = ChartLoader.convertFont(this.ptitleFont);
            if (font != null) {
                cTitle.font = font;
            }
            this.ptitleColor = this.getStringParam("TITLE_COLOR", "");
            if (this.ptitleColor != null) {
                cTitle.color = ChartLoader.convertColor(this.ptitleColor);
            }
        }
        this.Xlabel = this.getStringParam("XLABEL", "");
        if (this.Xlabel.compareTo("") != 0) {
            this.XlabelFont = this.getStringParam("XLABEL_FONT", "");
            font = ChartLoader.convertFont(this.XlabelFont);
            if (font == null) {
                font = GraphicsProvider.getFont("Arial", ChartFont.BOLD, 12);
            }
            this.XlabelColor = this.getStringParam("XLABEL_COLOR", "");
            c = this.XlabelColor != null ? ChartLoader.convertColor(this.XlabelColor) : GraphicsProvider.getColor(ChartColor.BLACK);
            cXLabel = new HAxisLabel(this.Xlabel, c, font);
            cXLabel.vertical = this.getBooleanParam("XLABEL_VERTICAL", false);
        }
        this.Ylabel = this.getStringParam("YLABEL", "");
        if (this.Ylabel.compareTo("") != 0) {
            this.YlabelFont = this.getStringParam("YLABEL_FONT", "");
            font = ChartLoader.convertFont(this.YlabelFont);
            if (font == null) {
                font = GraphicsProvider.getFont("Arial", ChartFont.BOLD, 12);
            }
            this.YlabelColor = this.getStringParam("YLABEL_COLOR", "");
            c = this.YlabelColor != null ? ChartLoader.convertColor(this.YlabelColor) : GraphicsProvider.getColor(ChartColor.BLACK);
            cYLabel = new VAxisLabel(this.Ylabel, c, font);
            cYLabel.vertical = this.getBooleanParam("YLABEL_VERTICAL", false);
        }
        this.Y2label = this.getStringParam("Y2LABEL", "");
        if (this.Y2label.compareTo("") != 0) {
            this.Y2labelFont = this.getStringParam("Y2LABEL_FONT", "");
            font = ChartLoader.convertFont(this.Y2labelFont);
            if (font == null) {
                font = GraphicsProvider.getFont("Arial", ChartFont.BOLD, 12);
            }
            this.Y2labelColor = this.getStringParam("Y2LABEL_COLOR", "");
            c = this.Y2labelColor != null ? ChartLoader.convertColor(this.Y2labelColor) : GraphicsProvider.getColor(ChartColor.BLACK);
            cY2Label = new VAxisLabel(this.Y2label, c, font);
            cY2Label.vertical = this.getBooleanParam("Y2LABEL_VERTICAL", false);
        }
        boolean axisX = this.getBooleanParam("XAXIS", true);
        boolean axisY = this.getBooleanParam("YAXIS", true);
        boolean axisY2 = this.getBooleanParam("Y2AXIS", false);
        if (axisX) {
            cXAxis = this.loadAxisAndScale("X", 0);
        }
        if (axisY) {
            cYAxis = this.loadAxisAndScale("Y", 1);
        }
        if (axisY2) {
            cY2Axis = this.loadAxisAndScale("Y2", 1);
        }
        if ((fstyle = ChartLoader.convertFillStyle(this.getStringParam("LEGEND_FILL", ""))) != null) {
            clegend.background = fstyle;
        }
        if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("LEGEND_BORDER", ""))) != null) {
            clegend.border = lstyle;
        }
        clegend.color = c = ChartLoader.convertColor(this.getStringParam("LEGEND_COLOR", ""));
        font = ChartLoader.convertFont(this.getStringParam("LEGEND_FONT", ""));
        if (font != null) {
            clegend.font = font;
        }
        clegend.verticalLayout = this.getBooleanParam("LEGEND_VERTICAL", true);
        clegend.legendLabel = this.getStringParam("LEGEND_LABEL", "");
        this.pnumSeries = 0;
        int i = 1;
        while (i < 50) {
            FillStyle[] styles;
            String Xs;
            FillStyle backstyle;
            this.pSerie = this.getStringParam("SERIE_" + i, "");
            if (this.pSerie.compareTo("") == 0) break;
            this.pSeriesNames[i] = this.pSerie;
            this.pSeriesData[i] = this.getStringParam("SERIE_DATA_" + i, "");
            if (this.pSeriesData[i].indexOf("/") > 0) {
                this.pSeriesData[i] = this.convertFromDates(this.pSeriesData[i], cYAxis.dateStep, cYAxis.initialDate);
            }
            String Typ = this.getStringParam("SERIE_TYPE_" + i, "LINE");
            this.pSeries[i] = null;
            if (Typ.compareTo("LINE") == 0 || Typ.compareTo("B-SPLINES") == 0 || Typ.compareTo("CURVE") == 0 || Typ.compareTo("LINE_LEAST_SQUARES") == 0) {
                String Xs2;
                LineStyle mmstyle;
                if (linePlot == null) {
                    linePlot = Typ.compareTo("LINE") == 0 ? new LinePlotter() : new CurvePlotter();
                    linePlot.XScale = cXAxis.scale;
                    linePlot.YScale = cYAxis.scale;
                    if (cY2Axis != null) {
                        linePlot.Y2Scale = cY2Axis.scale;
                    }
                    linePlot.fixedLimits = this.getBooleanParam("LINECHART_FIXED_LIMITS", false);
                    linePlot.pointSize = this.getIntParam("LINECHART_POINT_SIZE", new Integer(6));
                    backstyle = ChartLoader.convertFillStyle(this.getStringParam("LINECHART_BACK", ""));
                    if (backstyle != null) {
                        linePlot.back = backstyle;
                    }
                }
                if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("SERIE_STYLE_" + i, ""))) == null) {
                    lstyle = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.BLACK), 1);
                }
                LineStyle vstyle = ChartLoader.convertLineStyle(this.getStringParam("SERIE_V_STYLE_" + i, ""));
                if (!this.getBooleanParam("SERIE_DRAW_LINE_" + i, true)) {
                    lstyle = null;
                }
                this.pSeriesMaxData[i] = this.getStringParam("SERIE_MAX_DATA_" + i, "");
                this.pSeriesMaxData[i] = this.getStringParam("SERIE_MAX_DATA_" + i, "");
                this.pSeriesMinData[i] = this.getStringParam("SERIE_MIN_DATA_" + i, "");
                this.pSeriesCloseData[i] = this.getStringParam("SERIE_CLOSE_DATA_" + i, "");
                this.pSeries[i] = null;
                if (this.pSeriesMaxData[i].length() == 0) {
                    this.pSeries[i] = new LineDataSerie(this.convertDoubleListWithNulls(this.pSeriesData[i]), lstyle);
                    ((LineDataSerie)this.pSeries[i]).vstyle = vstyle;
                }
                if (this.pSeriesMaxData[i].length() > 0 && this.pSeriesCloseData[i].length() == 0) {
                    this.pSeries[i] = new MaxMinDataSerie(this.convertDoubleListWithNulls(this.pSeriesData[i]), lstyle);
                    if (this.pSeriesMinData[i].length() > 0) {
                        ((MaxMinDataSerie)this.pSeries[i]).setMaxMinValues(this.convertDoubleList(this.pSeriesMaxData[i]), this.convertDoubleList(this.pSeriesMinData[i]));
                    } else {
                        ((MaxMinDataSerie)this.pSeries[i]).setMaxMinValues(this.convertDoubleList(this.pSeriesMaxData[i]), null);
                    }
                    ((MaxMinDataSerie)this.pSeries[i]).drawLineEnd = this.getStringParam("SERIE_LINE_END_" + i, "").toUpperCase().compareTo("TRUE") == 0;
                    linePlot.MaxMinType = 0;
                    mmstyle = ChartLoader.convertLineStyle(this.getStringParam("SERIE_MAXMIN_STYLE_" + i, ""));
                    if (mmstyle != null) {
                        ((MaxMinDataSerie)this.pSeries[i]).maxminStyle = mmstyle;
                    }
                    if (this.getStringParam("SERIE_BUBBLE_" + i, "").toUpperCase().compareTo("TRUE") == 0) {
                        ((MaxMinDataSerie)this.pSeries[i]).bubbleChart = true;
                        ((MaxMinDataSerie)this.pSeries[i]).fillBubble = this.getStringParam("SERIE_FILL_BUBBLE_" + i, "").toUpperCase().compareTo("TRUE") == 0;
                    }
                }
                if (this.pSeriesMaxData[i].length() > 0 && this.pSeriesCloseData[i].length() > 0) {
                    this.pSeries[i] = new MaxMinDataSerie(this.convertDoubleListWithNulls(this.pSeriesData[i]), this.convertDoubleList(this.pSeriesCloseData[i]), this.convertDoubleList(this.pSeriesMaxData[i]), this.convertDoubleList(this.pSeriesMinData[i]), lstyle);
                    linePlot.MaxMinType = 1;
                    ((MaxMinDataSerie)this.pSeries[i]).drawLineEnd = false;
                    if (this.getStringParam("SERIE_LINE_TYPE_" + i, "").compareTo("CANDLESTICK") == 0) {
                        linePlot.MaxMinType = 2;
                    }
                    if (this.getStringParam("SERIE_CANDLE_POSITIVE_COLOR_" + i, "").length() > 0) {
                        ((MaxMinDataSerie)this.pSeries[i]).positiveValueColor = ChartLoader.convertColor(this.getStringParam("SERIE_CANDLE_POSITIVE_COLOR_" + i, ""));
                    }
                    if (this.getStringParam("SERIE_CANDLE_NEGATIVE_COLOR_" + i, "").length() > 0) {
                        ((MaxMinDataSerie)this.pSeries[i]).negativeValueColor = ChartLoader.convertColor(this.getStringParam("SERIE_CANDLE_NEGATIVE_COLOR_" + i, ""));
                    }
                    ((MaxMinDataSerie)this.pSeries[i]).openCloseWidth = this.getIntParam("SERIE_OPENCLOSE_WIDTH_" + i, new Integer(7));
                    mmstyle = ChartLoader.convertLineStyle(this.getStringParam("SERIE_MAXMIN_STYLE_" + i, ""));
                    if (mmstyle != null) {
                        ((MaxMinDataSerie)this.pSeries[i]).maxminStyle = mmstyle;
                    }
                }
                if (Typ.compareTo("LINE") == 0) {
                    ((LineDataSerie)this.pSeries[i]).lineType = 0;
                }
                if (Typ.compareTo("B-SPLINES") == 0) {
                    ((LineDataSerie)this.pSeries[i]).lineType = 2;
                }
                if (Typ.compareTo("CURVE") == 0) {
                    ((LineDataSerie)this.pSeries[i]).lineType = 1;
                }
                if (Typ.compareTo("LINE_LEAST_SQUARES") == 0) {
                    ((LineDataSerie)this.pSeries[i]).lineType = 3;
                }
                if ((Xs2 = this.getStringParam("SERIE_DATAX_" + i, "")).length() > 0) {
                    if (Xs2.indexOf("/") > 0) {
                        Xs2 = this.convertFromDates(Xs2, cXAxis.dateStep, cXAxis.initialDate);
                    }
                    this.pSeries[i].setDatax(this.convertDoubleList(Xs2));
                }
                this.pSeries[i].secondYAxis = this.getBooleanParam("SERIE_SECONDYAXIS_" + i, false);
                this.setAxisForSerie(i, cXAxis, cYAxis, this.pSeries[i]);
                fstyle = ChartLoader.convertFillStyle(this.getStringParam("SERIE_FILL_" + i, ""));
                if (fstyle != null) {
                    ((LineDataSerie)this.pSeries[i]).fillStyle = fstyle;
                }
                if ((font = ChartLoader.convertFont(this.getStringParam("SERIE_FONT_" + i, ""))) != null) {
                    ((LineDataSerie)this.pSeries[i]).valueFont = font;
                }
                ((LineDataSerie)this.pSeries[i]).valueColor = c = ChartLoader.convertColor(this.getStringParam("SERIE_COLOR_" + i, ""));
                ((LineDataSerie)this.pSeries[i]).pointColor = c = ChartLoader.convertColor(this.getStringParam("SERIE_POINT_COLOR_" + i, ""));
                ((LineDataSerie)this.pSeries[i]).drawPoint = this.getBooleanParam("SERIE_POINT_" + i, false);
                ChartImage im2 = null;
                String pointImageStr = this.getStringParam("SERIE_POINT_IMAGE_" + i, "");
                if (pointImageStr.compareTo("") != 0) {
                    ((LineDataSerie)this.pSeries[i]).icon = im2 = GraphicsProvider.getImage(pointImageStr);
                }
                if (!this.pSeriesNames[i].startsWith("HIDDEN")) {
                    if (im2 != null) {
                        clegend.addItem(this.pSeriesNames[i], im2);
                    } else if (fstyle == null) {
                        if (lstyle != null) {
                            clegend.addItem(this.pSeriesNames[i], lstyle);
                        } else {
                            clegend.addItem(this.pSeriesNames[i], new FillStyle(((LineDataSerie)this.pSeries[i]).valueColor));
                        }
                    } else {
                        clegend.addItem(this.pSeriesNames[i], fstyle);
                    }
                }
                this.pSeries[i].name = this.pSeriesNames[i];
                linePlot.addSerie(this.pSeries[i]);
            }
            if (Typ.compareTo("LINE3D") == 0) {
                if (linePlot3D == null) {
                    linePlot3D = new LinePlotter3D();
                    linePlot3D.XScale = cXAxis.scale;
                    linePlot3D.YScale = cYAxis.scale;
                    if (cY2Axis != null) {
                        linePlot3D.Y2Scale = cY2Axis.scale;
                    }
                    ((LinePlotter3D)linePlot3D).fixedLimits = this.getBooleanParam("LINECHART_FIXED_LIMITS", false);
                    if (this.getStringParam("LINECHART3D_BORDER", "").length() > 0) {
                        ((LinePlotter3D)linePlot3D).border = ChartLoader.convertLineStyle(this.getStringParam("LINECHART3D_BORDER", ""));
                    }
                    if (this.getStringParam("LINECHART3D_DEPTH", "").length() > 0) {
                        linePlot3D.depth = (int)this.getDoubleParam("LINECHART3D_DEPTH", new Double(20.0)).doubleValue();
                    }
                    if (this.getStringParam("LINECHART3D_SEPARATOR", "").length() > 0) {
                        ((LinePlotter3D)linePlot3D).interLineSpace = (int)this.getDoubleParam("LINECHART3D_SEPARATOR", new Double(0.0)).doubleValue();
                    }
                    if ((backstyle = ChartLoader.convertFillStyle(this.getStringParam("LINECHART3D_BACK", ""))) != null) {
                        linePlot3D.back = backstyle;
                    }
                }
                if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("SERIE_STYLE_" + i, ""))) == null) {
                    lstyle = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.BLACK), 1);
                }
                if (this.getStringParam("SERIE_DRAW_LINE_" + i, "").compareTo("N") == 0) {
                    lstyle = null;
                }
                this.pSeries[i] = new LineDataSerie(this.convertDoubleListWithNulls(this.pSeriesData[i]), lstyle);
                Xs = this.getStringParam("SERIE_DATAX_" + i, "");
                if (Xs.length() > 0) {
                    this.pSeries[i].setDatax(this.convertDoubleList(Xs));
                }
                this.pSeries[i].secondYAxis = this.getBooleanParam("SERIE_SECONDYAXIS_" + i, false);
                this.setAxisForSerie(i, cXAxis, cYAxis, this.pSeries[i]);
                fstyle = ChartLoader.convertFillStyle(this.getStringParam("SERIE_FILL_" + i, ""));
                if (fstyle != null) {
                    ((LineDataSerie)this.pSeries[i]).fillStyle = fstyle;
                }
                if ((font = ChartLoader.convertFont(this.getStringParam("SERIE_FONT_" + i, ""))) != null) {
                    ((LineDataSerie)this.pSeries[i]).valueFont = font;
                }
                ((LineDataSerie)this.pSeries[i]).valueColor = c = ChartLoader.convertColor(this.getStringParam("SERIE_COLOR_" + i, ""));
                ChartImage im2 = null;
                String pointImageStr = this.getStringParam("SERIE_POINT_IMAGE_" + i, "");
                if (pointImageStr.compareTo("") != 0) {
                    ((LineDataSerie)this.pSeries[i]).icon = im2 = GraphicsProvider.getImage(pointImageStr);
                }
                if (im2 != null) {
                    clegend.addItem(this.pSeriesNames[i], im2);
                } else if (fstyle == null) {
                    if (lstyle != null) {
                        clegend.addItem(this.pSeriesNames[i], lstyle);
                    } else {
                        clegend.addItem(this.pSeriesNames[i], new FillStyle(((LineDataSerie)this.pSeries[i]).valueColor));
                    }
                } else {
                    clegend.addItem(this.pSeriesNames[i], fstyle);
                }
                this.pSeries[i].name = this.pSeriesNames[i];
                linePlot3D.addSerie(this.pSeries[i]);
            }
            if (Typ.compareTo("RADAR") == 0) {
                if (radarPlot == null) {
                    radarPlot = new RadarPlotter();
                }
                if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("SERIE_STYLE_" + i, ""))) == null) {
                    lstyle = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.BLACK), 1);
                }
                this.pSeries[i] = null;
                this.pSeries[i] = new LineDataSerie(this.convertDoubleList(this.pSeriesData[i]), lstyle);
                fstyle = ChartLoader.convertFillStyle(this.getStringParam("SERIE_FILL_" + i, ""));
                if (fstyle != null) {
                    ((LineDataSerie)this.pSeries[i]).fillStyle = fstyle;
                }
                if (fstyle == null) {
                    clegend.addItem(this.pSeriesNames[i], lstyle);
                } else {
                    clegend.addItem(this.pSeriesNames[i], fstyle);
                }
                font = ChartLoader.convertFont(this.getStringParam("SERIE_FONT_" + i, ""));
                if (font != null) {
                    ((LineDataSerie)this.pSeries[i]).valueFont = font;
                }
                ((LineDataSerie)this.pSeries[i]).valueColor = c = ChartLoader.convertColor(this.getStringParam("SERIE_COLOR_" + i, ""));
                ((LineDataSerie)this.pSeries[i]).pointColor = c = ChartLoader.convertColor(this.getStringParam("SERIE_POINT_COLOR_" + i, ""));
                ((LineDataSerie)this.pSeries[i]).drawPoint = this.getBooleanParam("SERIE_POINT_" + i, false);
                this.pSeries[i].name = this.pSeriesNames[i];
                radarPlot.addSerie(this.pSeries[i]);
            }
            if (Typ.compareTo("BAR3D") == 0) {
                fstyle = ChartLoader.convertFillStyle(this.getStringParam("SERIE_STYLE_" + i, ""));
                if (fstyle == null) {
                    fstyle = ChartLoader.convertFillStyle(this.getStringParam("SERIE_BAR_STYLE_" + i, ""));
                }
                if (fstyle == null) {
                    fstyle = new FillStyle(GraphicsProvider.getColor(ChartColor.BLUE));
                }
                this.pSeries[i] = new BarDataSerie(this.convertDoubleList(this.pSeriesData[i]), fstyle);
                if (this.getStringParam("SERIE_NEGATIVE_STYLE_" + i, "").length() > 0) {
                    ((BarDataSerie)this.pSeries[i]).negativeStyle = ChartLoader.convertFillStyle(this.getStringParam("SERIE_NEGATIVE_STYLE_" + i, ""));
                }
                clegend.addItem(this.pSeriesNames[i], fstyle);
                if (this.getStringParam("SERIE_BARS_COLORS_" + i, "").length() > 0) {
                    String[] listTMP = ChartLoader.convertList(this.getStringParam("SERIE_BARS_COLORS_" + i, ""));
                    ((BarDataSerie)this.pSeries[i]).barStyles = new FillStyle[listTMP.length];
                    int j = 0;
                    while (j < listTMP.length) {
                        ((BarDataSerie)this.pSeries[i]).barStyles[j] = new FillStyle(ChartLoader.convertColor(listTMP[j]));
                        ++j;
                    }
                }
                if ((font = ChartLoader.convertFont(this.getStringParam("SERIE_FONT_" + i, ""))) != null) {
                    ((BarDataSerie)this.pSeries[i]).valueFont = font;
                }
                ((BarDataSerie)this.pSeries[i]).valueColor = c = ChartLoader.convertColor(this.getStringParam("SERIE_COLOR_" + i, ""));
                this.pSeries[i].secondYAxis = this.getBooleanParam("SERIE_SECONDYAXIS_" + i, false);
                this.setAxisForSerie(i, cXAxis, cYAxis, this.pSeries[i]);
                String t = this.getStringParam("SERIE_BORDER_TYPE_" + i, "");
                if (t.compareTo("LOWERED") == 0) {
                    ((BarDataSerie)this.pSeries[i]).borderType = 1;
                }
                if (t.compareTo("RAISED") == 0) {
                    ((BarDataSerie)this.pSeries[i]).borderType = 2;
                }
                if (t.compareTo("NO") == 0) {
                    ((BarDataSerie)this.pSeries[i]).borderType = 3;
                }
                if (t.compareTo("NORMAL") == 0) {
                    ((BarDataSerie)this.pSeries[i]).borderType = 0;
                }
                if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("SERIE_BORDER_" + i, ""))) != null) {
                    ((BarDataSerie)this.pSeries[i]).border = lstyle;
                }
                if (barPlot3D == null) {
                    barPlot3D = new BarPlotter3D();
                    barPlot3D.XScale = cXAxis.scale;
                    barPlot3D.YScale = cYAxis.scale;
                    if (cY2Axis != null) {
                        barPlot3D.Y2Scale = cY2Axis.scale;
                    }
                    if (this.getStringParam("BARCHART3D_DEPTH", "").length() > 0) {
                        barPlot3D.depth = (int)this.getDoubleParam("BARCHART3D_DEPTH", new Double(20.0)).doubleValue();
                    }
                    ((BarPlotter3D)barPlot3D).fullDepth = this.getStringParam("BARCHART3D_FULL_DEPTH", "").toUpperCase().compareTo("TRUE") == 0;
                    FillStyle backstyle2 = ChartLoader.convertFillStyle(this.getStringParam("BARCHART3D_BACK", ""));
                    if (backstyle2 != null) {
                        barPlot3D.back = backstyle2;
                    }
                    ((BarPlotter3D)barPlot3D).cumulative = this.getBooleanParam("BARCHART_CUMULATIVE", false);
                }
                ((BarPlotter3D)barPlot3D).verticalBars = this.getBooleanParam("BARCHART_VERTICAL", true);
                this.pSeries[i].name = this.pSeriesNames[i];
                ((BarPlotter3D)barPlot3D).addSerie(this.pSeries[i]);
            }
            if (Typ.compareTo("BAR") == 0) {
                fstyle = ChartLoader.convertFillStyle(this.getStringParam("SERIE_STYLE_" + i, ""));
                if (fstyle == null) {
                    fstyle = ChartLoader.convertFillStyle(this.getStringParam("SERIE_BAR_STYLE_" + i, ""));
                }
                if (fstyle == null) {
                    fstyle = new FillStyle(GraphicsProvider.getColor(ChartColor.BLUE));
                }
                this.pSeries[i] = new BarDataSerie(this.convertDoubleList(this.pSeriesData[i]), fstyle);
                ((BarDataSerie)this.pSeries[i]).addBarsBase(this.convertDoubleList(this.getStringParam("SERIE_BARS_START_" + i, "")));
                Xs = this.getStringParam("SERIE_DATAX_" + i, "");
                if (Xs.length() > 0) {
                    this.pSeries[i].setDatax(this.convertDoubleList(Xs));
                }
                if (this.getStringParam("SERIE_NEGATIVE_STYLE_" + i, "").length() > 0) {
                    ((BarDataSerie)this.pSeries[i]).negativeStyle = ChartLoader.convertFillStyle(this.getStringParam("SERIE_NEGATIVE_STYLE_" + i, ""));
                }
                clegend.addItem(this.pSeriesNames[i], fstyle);
                if (this.getStringParam("SERIE_BARS_COLORS_" + i, "").length() > 0) {
                    String[] listTMP = ChartLoader.convertList(this.getStringParam("SERIE_BARS_COLORS_" + i, ""));
                    ((BarDataSerie)this.pSeries[i]).barStyles = new FillStyle[listTMP.length];
                    int j = 0;
                    while (j < listTMP.length) {
                        ((BarDataSerie)this.pSeries[i]).barStyles[j] = new FillStyle(ChartLoader.convertColor(listTMP[j]));
                        ++j;
                    }
                }
                if ((font = ChartLoader.convertFont(this.getStringParam("SERIE_FONT_" + i, ""))) != null) {
                    ((BarDataSerie)this.pSeries[i]).valueFont = font;
                }
                ((BarDataSerie)this.pSeries[i]).valueColor = c = ChartLoader.convertColor(this.getStringParam("SERIE_COLOR_" + i, ""));
                this.pSeries[i].secondYAxis = this.getBooleanParam("SERIE_SECONDYAXIS_" + i, false);
                this.setAxisForSerie(i, cXAxis, cYAxis, this.pSeries[i]);
                String t = this.getStringParam("SERIE_BORDER_TYPE_" + i, "");
                if (t.compareTo("LOWERED") == 0) {
                    ((BarDataSerie)this.pSeries[i]).borderType = 1;
                }
                if (t.compareTo("RAISED") == 0) {
                    ((BarDataSerie)this.pSeries[i]).borderType = 2;
                }
                if (t.compareTo("NO") == 0) {
                    ((BarDataSerie)this.pSeries[i]).borderType = 3;
                }
                if (t.compareTo("NORMAL") == 0) {
                    ((BarDataSerie)this.pSeries[i]).borderType = 0;
                }
                if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("SERIE_BORDER_" + i, ""))) != null) {
                    ((BarDataSerie)this.pSeries[i]).border = lstyle;
                }
                if (barPlot == null) {
                    barPlot = new BarPlotter();
                    barPlot.XScale = cXAxis.scale;
                    barPlot.YScale = cYAxis.scale;
                    if (cY2Axis != null) {
                        barPlot.Y2Scale = cY2Axis.scale;
                    }
                    ((BarPlotter)barPlot).barAtAxis = this.getBooleanParam("BARCHART_BAR_AT_AXIS", false);
                    FillStyle backstyle3 = ChartLoader.convertFillStyle(this.getStringParam("BARCHART_BACK", ""));
                    if (backstyle3 != null) {
                        barPlot.back = backstyle3;
                    }
                    ((BarPlotter)barPlot).cumulative = this.getBooleanParam("BARCHART_CUMULATIVE", false);
                    if (this.getBooleanParam("BARCHART_CUMULATIVE_BACK_COMPATIBLE", false)) {
                        ((BarPlotter)barPlot).cumulativeBackwardsCompatible = true;
                    }
                    ((BarPlotter)barPlot).eventChart = this.getBooleanParam("BARCHART_EVENTCHART", false);
                }
                ((BarPlotter)barPlot).verticalBars = this.getBooleanParam("BARCHART_VERTICAL", true);
                this.pSeries[i].name = this.pSeriesNames[i];
                ((BarPlotter)barPlot).addSerie(this.pSeries[i]);
            }
            if (Typ.compareTo("PIE") == 0) {
                styles = new FillStyle[50];
                int j = 1;
                while (j < 50) {
                    fstyle = ChartLoader.convertFillStyle(this.getStringParam("PIE_STYLE_" + j, ""));
                    if (fstyle == null) break;
                    styles[j - 1] = fstyle;
                    clegend.addItem(this.getStringParam("PIE_NAME_" + j, ""), fstyle);
                    ++j;
                }
                boolean[] pieKeepTogether = null;
                String[] pieLabels = null;
                if (this.getStringParam("SERIE_LABELS_" + i, "").length() > 0) {
                    pieLabels = this.getItemsParameter("SERIE_LABELS_" + i);
                }
                if (this.getStringParam("SERIE_TOGETHER_" + i, "").length() > 0) {
                    pieKeepTogether = this.convertBooleanList(this.getStringParam("SERIE_TOGETHER_" + i, ""));
                }
                this.pSeries[i] = new PieDataSerie(this.convertDoubleList(this.pSeriesData[i]), styles, pieKeepTogether, pieLabels);
                font = ChartLoader.convertFont(this.getStringParam("SERIE_FONT_" + i, ""));
                if (font != null) {
                    ((PieDataSerie)this.pSeries[i]).valueFont = font;
                }
                if (this.getStringParam("SERIE_FONT_" + i, "").compareTo("NULL") == 0) {
                    ((PieDataSerie)this.pSeries[i]).valueFont = null;
                }
                ((PieDataSerie)this.pSeries[i]).valueColor = c = ChartLoader.convertColor(this.getStringParam("SERIE_COLOR_" + i, ""));
                ((PieDataSerie)this.pSeries[i]).drawPercentages = this.getBooleanParam("SERIE_PERCENTAGES_" + i, true);
                Double d2 = this.getDoubleParam("SERIE_DISTCENTER_" + i, null);
                if (d2 != null) {
                    ((PieDataSerie)this.pSeries[i]).textDistanceToCenter = d2;
                }
                if (piePlot == null) {
                    piePlot = new PiePlotter();
                    ((PiePlotter)piePlot).labelFormat = this.getStringParam("PIE_LABEL_FORMAT", "");
                }
                this.pSeries[i].name = this.pSeriesNames[i];
                piePlot.addSerie(this.pSeries[i]);
            }
            if (Typ.compareTo("GAUGE") == 0) {
                if (this.pSeriesData[i].compareTo("") == 0) break;
                styles = new FillStyle[50];
                int j = 1;
                while (j < 50) {
                    fstyle = ChartLoader.convertFillStyle(this.getStringParam("GAUGE_NEEDLE_STYLE_" + j, ""));
                    if (fstyle == null) break;
                    styles[j - 1] = fstyle;
                    clegend.addItem(this.getStringParam("GAUGE_NEEDLE_" + j, ""), fstyle);
                    ++j;
                }
                this.pSeries[i] = new GaugeDataSerie(this.convertDoubleList(this.pSeriesData[i]), styles);
                font = ChartLoader.convertFont(this.getStringParam("SERIE_FONT_" + i, ""));
                if (font != null) {
                    ((GaugeDataSerie)this.pSeries[i]).valueFont = font;
                }
                if (this.getStringParam("SERIE_FONT_" + i, "").compareTo("NULL") == 0) {
                    ((GaugeDataSerie)this.pSeries[i]).valueFont = null;
                }
                ((GaugeDataSerie)this.pSeries[i]).valueColor = c = ChartLoader.convertColor(this.getStringParam("SERIE_COLOR_" + i, ""));
                lstyle = ChartLoader.convertLineStyle(this.getStringParam("SERIE_NEEDLE_STYLE_" + i, ""));
                if (lstyle == null) {
                    lstyle = new LineStyle(2.0f, GraphicsProvider.getColor(ChartColor.BLACK), 1);
                }
                ((GaugeDataSerie)this.pSeries[i]).needleStyle = lstyle;
                ((GaugeDataSerie)this.pSeries[i]).needleLength = this.getIntParam("SERIE_NEEDLE_LENTGH_" + i, new Integer(80));
                if (gaugePlot == null) {
                    gaugePlot = new GaugePlotter();
                }
                this.pSeries[i].name = this.pSeriesNames[i];
                gaugePlot.addSerie(this.pSeries[i]);
            }
            if (this.pSeries[i] != null) {
                this.pSeries[i].valueFormat = this.getStringParam("SERIE_FORMAT_" + i, "#####.##");
                this.pSeries[i].labelTemplate = this.getStringParam("SERIE_LABEL_TEMPLATE_" + i, "");
                this.pSeries[i].tips = ChartLoader.convertList(this.getStringParam("SERIE_TIPS_" + i, ""));
                this.pSeries[i].htmlLinks = ChartLoader.convertList(this.getStringParam("SERIE_LINKS_" + i, ""));
                if (this.getStringParam("SERIE_DATA_LABELS_" + i, "").length() > 0) {
                    this.pSeries[i].dataLabels = ChartLoader.convertList(this.getStringParam("SERIE_DATA_LABELS_" + i, ""));
                }
            }
            ++i;
        }
        if (linePlot != null && linePlot instanceof CurvePlotter) {
            ((CurvePlotter)linePlot).segments = this.getIntParam("CURVECHART_SEGMENTS", new Integer(24));
        }
        if (barPlot != null) {
            ((BarPlotter)barPlot).barsBase = this.getDoubleParam("BARCHART_BASE", new Double(0.0));
            ((BarPlotter)barPlot).summedLabels = this.getBooleanParam("BARCHART_SUMMED_LABELS", true);
            Integer in = this.getIntParam("BARCHART_BARWIDTH", null);
            if (in != null) {
                ((BarPlotter)barPlot).barWidth = in;
            }
            if ((in = this.getIntParam("BARCHART_BARSPACE", null)) != null) {
                ((BarPlotter)barPlot).interBarSpace = in;
            }
            if ((dob = this.getDoubleParam("BARCHART_GROUPSPACE", null)) != null) {
                ((BarPlotter)barPlot).InterGroupSpace = dob;
            }
        }
        if (barPlot3D != null) {
            ((BarPlotter3D)barPlot3D).barsBase = this.getDoubleParam("BARCHART_BASE", new Double(0.0));
            ((BarPlotter3D)barPlot3D).summedLabels = this.getBooleanParam("BARCHART_SUMMED_LABELS", true);
            Integer in = this.getIntParam("BARCHART_BARWIDTH", null);
            if (in != null) {
                ((BarPlotter3D)barPlot3D).barWidth = in;
            }
            if ((in = this.getIntParam("BARCHART_BARSPACE", null)) != null) {
                ((BarPlotter3D)barPlot3D).interBarSpace = in;
            }
            if ((dob = this.getDoubleParam("BARCHART_GROUPSPACE", null)) != null) {
                ((BarPlotter3D)barPlot3D).InterGroupSpace = dob;
            }
        }
        if (radarPlot != null) {
            String[] listTMP;
            Double d3 = this.getDoubleParam("RADARCHART_RADIUS", null);
            if (d3 != null) {
                ((RadarPlotter)radarPlot).radiusModifier = d3;
            }
            ((RadarPlotter)radarPlot).drawCircle = this.getBooleanParam("RADARCHART_CIRCLE", false);
            fstyle = ChartLoader.convertFillStyle(this.getStringParam("RADARCHART_BACK", ""));
            if (fstyle != null) {
                ((RadarPlotter)radarPlot).backStyle = fstyle;
            }
            if (this.getStringParam("RADARCHART_POINT_COLORS_SCALE", "").length() > 0) {
                ((RadarPlotter)radarPlot).pointColorScale = this.convertDoubleList(this.getStringParam("RADARCHART_POINT_COLORS_SCALE", ""));
            }
            if (this.getStringParam("RADARCHART_POINT_COLORS", "").length() > 0) {
                listTMP = ChartLoader.convertList(this.getStringParam("RADARCHART_POINT_COLORS", ""));
                ((RadarPlotter)radarPlot).pointColors = new ChartColor[listTMP.length];
                int j = 0;
                while (j < listTMP.length) {
                    ((RadarPlotter)radarPlot).pointColors[j] = ChartLoader.convertColor(listTMP[j]);
                    ++j;
                }
            }
            if (this.getStringParam("RADARCHART_FACTOR_COLORS", "").length() > 0) {
                listTMP = ChartLoader.convertList(this.getStringParam("RADARCHART_FACTOR_COLORS", ""));
                ((RadarPlotter)radarPlot).factorColors = new ChartColor[listTMP.length];
                int j = 0;
                while (j < listTMP.length) {
                    ((RadarPlotter)radarPlot).factorColors[j] = ChartLoader.convertColor(listTMP[j]);
                    ++j;
                }
            }
            if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("RADARCHART_BORDER", ""))) != null) {
                ((RadarPlotter)radarPlot).border = lstyle;
            }
            if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("RADARCHART_GRID", ""))) != null) {
                ((RadarPlotter)radarPlot).gridStyle = lstyle;
            }
            if ((font = ChartLoader.convertFont(this.getStringParam("RADARCHART_GRID_FONT", ""))) != null) {
                ((RadarPlotter)radarPlot).gridFont = font;
            }
            ((RadarPlotter)radarPlot).gridFontColor = ChartLoader.convertColor(this.getStringParam("RADARCHART_GRID_FONT_COLOR", ""));
            font = ChartLoader.convertFont(this.getStringParam("RADARCHART_FACTOR_FONT", ""));
            if (font != null) {
                ((RadarPlotter)radarPlot).factorFont = font;
            }
            ((RadarPlotter)radarPlot).factorColor = ChartLoader.convertColor(this.getStringParam("RADARCHART_FACTOR_COLOR", ""));
            String tmpList = this.getStringParam("RADARCHART_FACTOR_MAX", "");
            if (tmpList.length() > 0) {
                ((RadarPlotter)radarPlot).factorMaxs = this.convertDoubleList(tmpList);
            }
            if ((tmpList = this.getStringParam("RADARCHART_FACTOR_MIN", "")).length() > 0) {
                ((RadarPlotter)radarPlot).factorMins = this.convertDoubleList(tmpList);
            }
            if ((tmpList = this.getStringParam("RADARCHART_FACTOR_NAMES", "")).length() > 0) {
                ((RadarPlotter)radarPlot).factorNames = ChartLoader.convertList(tmpList);
            }
            if ((tmpList = this.getStringParam("RADARCHART_TICKS", "")).length() > 0) {
                ((RadarPlotter)radarPlot).ticks = new Integer(tmpList);
            }
            ((RadarPlotter)radarPlot).tickLabelFormat = this.getStringParam("RADARCHART_TICK_FORMAT", "");
        }
        if (piePlot != null) {
            Double d4 = this.getDoubleParam("PIECHART_RADIUS", null);
            if (d4 != null) {
                ((PiePlotter)piePlot).radiusModifier = d4;
            }
            ((PiePlotter)piePlot).effect3D = this.getBooleanParam("PIECHART_3D", false);
            lstyle = ChartLoader.convertLineStyle(this.getStringParam("PIE_BORDER", ""));
            if (lstyle != null) {
                ((PiePlotter)piePlot).border = lstyle;
            }
            if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("PIE_LABEL_LINE", ""))) != null) {
                ((PiePlotter)piePlot).labelLine = lstyle;
            }
        }
        if (gaugePlot != null) {
            Double d5 = this.getDoubleParam("GAUGE_RADIUS", null);
            if (d5 != null) {
                ((GaugePlotter)gaugePlot).radiusModifier = d5;
            }
            ((GaugePlotter)gaugePlot).subGaugeSize = this.getIntParam("GAUGE_SUBGAUGE_SIZE", new Integer(30));
            ((GaugePlotter)gaugePlot).axis2Margin = this.getIntParam("GAUGE_AXIS2_MARGIN", new Integer(40));
            ((GaugePlotter)gaugePlot).axis2LabelMargin = this.getIntParam("GAUGE_AXIS2_LABEL_MARGIN", new Integer(-20));
            Plotter gp = null;
            Plotter gp1 = null;
            Plotter gp2 = null;
            int sb = 0;
            while (sb < 3) {
                String prefix = "";
                if (sb > 0) {
                    prefix = "" + sb;
                }
                gp = null;
                if (sb == 0) {
                    gp = gaugePlot;
                }
                if (sb == 1 && this.getBooleanParam("GAUGE1_ENABLE", false)) {
                    gp1 = gp = new GaugePlotter();
                }
                if (sb == 2 && this.getBooleanParam("GAUGE2_ENABLE", false)) {
                    gp2 = gp = new GaugePlotter();
                }
                if (gp != null) {
                    lstyle = ChartLoader.convertLineStyle(this.getStringParam("GAUGE" + prefix + "_BORDER", ""));
                    if (lstyle != null) {
                        ((GaugePlotter)gp).border = lstyle;
                    }
                    ((GaugePlotter)gp).needleBase = this.getIntParam("GAUGE" + prefix + "_BASE", new Integer(8));
                    ((GaugePlotter)gp).axis1Margin = this.getIntParam("GAUGE" + prefix + "_AXIS1_MARGIN", new Integer(5));
                    ((GaugePlotter)gp).axis1LabelMargin = this.getIntParam("GAUGE" + prefix + "_AXIS1_LABEL_MARGIN", new Integer(10));
                    ((GaugePlotter)gp).maxZone = this.getDoubleParam("GAUGE" + prefix + "_MAX_ZONE", new Double(-1.0));
                    if (this.getStringParam("GAUGE" + prefix + "_MAX_ZONE_COLOR", "").length() > 0) {
                        ((GaugePlotter)gp).maxZoneColor = new FillStyle(ChartLoader.convertColor(this.getStringParam("GAUGE_MAX_ZONE_COLOR", "")));
                    }
                    ((GaugePlotter)gp).minZone = this.getDoubleParam("GAUGE" + prefix + "_MIN_ZONE", new Double(-1.0));
                    if (this.getStringParam("GAUGE" + prefix + "_MIN_ZONE_COLOR", "").length() > 0) {
                        ((GaugePlotter)gp).minZoneColor = new FillStyle(ChartLoader.convertColor(this.getStringParam("GAUGE_MIN_ZONE_COLOR", "")));
                    }
                    ((GaugePlotter)gp).maxminZoneWidth = this.getIntParam("GAUGE" + prefix + "_MAXMIN_ZONE_WIDTH", new Integer(50));
                    ((GaugePlotter)gp).maxminZoneMargin = this.getIntParam("GAUGE" + prefix + "_MAXMIN_ZONE_MARGIN", new Integer(5));
                    ((GaugePlotter)gp).endAngle = this.getIntParam("GAUGE" + prefix + "_END_ANGLE", new Integer(200));
                    ((GaugePlotter)gp).startAngle = this.getIntParam("GAUGE" + prefix + "_START_ANGLE", new Integer(-20));
                    fstyle = ChartLoader.convertFillStyle(this.getStringParam("GAUGE" + prefix + "_BACK", ""));
                    if (fstyle != null) {
                        ((GaugePlotter)gp).gaugeback = fstyle;
                    }
                }
                ++sb;
            }
            ((GaugePlotter)gaugePlot).subGauge1 = gp1;
            ((GaugePlotter)gaugePlot).subGauge2 = gp2;
            ((GaugePlotter)gaugePlot).axis1 = cXAxis;
            if (gp1 != null) {
                ((GaugePlotter)gp1).axis1 = cYAxis;
            }
            if (gp2 != null) {
                ((GaugePlotter)gp2).axis1 = cY2Axis;
            }
            if (gp2 == null) {
                ((GaugePlotter)gaugePlot).axis2 = cY2Axis;
            }
            if (gp1 == null) {
                ((GaugePlotter)gaugePlot).axis2 = cYAxis;
            }
            cXAxis = null;
            cYAxis = null;
            cY2Axis = null;
        }
        if ((plot = null) == null) {
            plot = barPlot;
        }
        if (plot == null) {
            plot = barPlot3D;
        }
        if (plot == null) {
            plot = linePlot3D;
        }
        if (plot == null) {
            plot = linePlot;
        }
        if (plot == null) {
            plot = piePlot;
        }
        if (plot == null) {
            plot = radarPlot;
        }
        if (plot == null) {
            plot = gaugePlot;
        }
        if ((chart = currentChart) == null) {
            chart = new Chart();
        }
        chart.resetChart(cTitle, plot, cXAxis, cYAxis);
        if (plot == piePlot) {
            chart.resetChart(cTitle, plot, null, null);
        }
        if (plot == radarPlot) {
            chart.resetChart(cTitle, plot, null, null);
        }
        chart.showTips = this.getBooleanParam("CHART_SHOW_TIPS", false);
        chart.showPosition = this.getBooleanParam("CHART_SHOW_POSITION", false);
        chart.activateSelection = this.getBooleanParam("CHART_POINT_SELECTION", false);
        if (chart.showTips) {
            chart.activateSelection = true;
        }
        if (chart.showPosition) {
            chart.activateSelection = true;
        }
        int noteCount = 1;
        while (this.getStringParam("CHART_NOTE" + noteCount, "").length() > 0) {
            chart.addNote(this.getStringParam("CHART_NOTE" + noteCount, ""));
            ++noteCount;
        }
        chart.tipColor = ChartLoader.convertColor(this.getStringParam("CHART_TIPS_COLOR", "YELLOW"));
        chart.tipFontColor = ChartLoader.convertColor(this.getStringParam("CHART_TIPS_FONT_COLOR", "BLACK"));
        chart.tipFont = ChartLoader.convertFont(this.getStringParam("CHART_TIPS_FONT", "SERIF|PLAIN|10"));
        chart.htmlLinkTarget = this.getStringParam("CHART_LINKS_TARGET", "_new");
        chart.repaintAll = true;
        chart.XLabel = cXLabel;
        chart.YLabel = cYLabel;
        chart.Y2Label = cY2Label;
        if (cY2Axis != null) {
            chart.setY2Scale(cY2Axis);
        }
        if (piePlot != null && piePlot != plot) {
            chart.addPlotter(piePlot);
        }
        if (linePlot != null && linePlot != plot) {
            chart.addPlotter(linePlot);
        }
        if (linePlot3D != null && linePlot3D != plot) {
            chart.addPlotter(linePlot3D);
        }
        if (barPlot3D != null && barPlot3D != plot) {
            chart.addPlotter(barPlot3D);
        }
        if (barPlot != null && barPlot != plot) {
            chart.addPlotter(barPlot);
        }
        if (gaugePlot != null && gaugePlot != plot) {
            chart.addPlotter(gaugePlot);
        }
        if (this.getBooleanParam("LEGEND", true)) {
            chart.legend = clegend;
        }
        this.plegendPosition = this.getStringParam("LEGEND_POSITION", "RIGHT");
        if (this.plegendPosition.compareTo("RIGHT") == 0) {
            chart.layout = 0;
        }
        if (this.plegendPosition.compareTo("BOTTOM") == 0) {
            chart.layout = 2;
        }
        if (this.plegendPosition.compareTo("TOP") == 0) {
            chart.layout = 1;
        }
        if ((d = this.getDoubleParam("LEFT_MARGIN", null)) != null) {
            chart.leftMargin = d;
        }
        if ((d = this.getDoubleParam("RIGHT_MARGIN", null)) != null) {
            chart.rightMargin = d;
        }
        if ((d = this.getDoubleParam("TOP_MARGIN", null)) != null) {
            chart.topMargin = d;
        }
        if ((d = this.getDoubleParam("LEGEND_MARGIN", null)) != null) {
            chart.legendMargin = d;
        }
        if ((d = this.getDoubleParam("BOTTOM_MARGIN", null)) != null) {
            chart.bottomMargin = d;
        }
        if ((lstyle = ChartLoader.convertLineStyle(this.getStringParam("CHART_BORDER", ""))) != null) {
            chart.border = lstyle;
        }
        if ((fstyle = ChartLoader.convertFillStyle(this.getStringParam("CHART_FILL", ""))) != null) {
            chart.back = fstyle;
        }
        if (this.getBooleanParam("CHART_FULL_XAXIS", false)) {
            chart.fullXAxis = true;
        }
        chart.secondYAxisMargin = tmpDouble = this.getDoubleParam("CHART_SECOND_AXIS_MARGIN", new Double(0.0)).doubleValue();
        if (this.getStringParam("CHART_AXIS_MARGIN", "").length() > 0) {
            chart.axisMargin = this.getDoubleParam("CHART_AXIS_MARGIN", new Double(0.0));
        }
        if ((backImageStr = this.getStringParam("BACK_IMAGE", "")).compareTo("") != 0) {
            ChartImage im2 = null;
            chart.backImage = im2 = GraphicsProvider.getImage(backImageStr);
        }
        chart.repaintAll = true;
        chart.repaintAlways = true;
        this.gChart = chart;
        if (this.getStringParam("DOUBLE_BUFFERING", "").toUpperCase().compareTo("NO") == 0) {
            chart.doubleBuffering = false;
        }
        if (this.chartApplet == null) {
            this.paintDirect = true;
        }
        if (this.paintDirect && this.chartApplet != null) {
            chart.setHeight(this.chartApplet.getSize().height);
            chart.setWidth(this.chartApplet.getSize().width);
            this.chartApplet.paint(this.chartApplet.getGraphics());
        }
        chart.virtualWidth = (int)this.getDoubleParam("CHART_WIDTH", new Double(0.0)).doubleValue();
        chart.virtualHeight = (int)this.getDoubleParam("CHART_HEIGHT", new Double(0.0)).doubleValue();
        int zoneNr = 1;
        while (this.getParameter("CHART_TARGET_ZONE_" + zoneNr, "").length() > 0) {
            chart.addTargetZone(TargetZone.createFromString(this.getParameter("CHART_TARGET_ZONE_" + zoneNr, "")));
            ++zoneNr;
        }
        chart.msecs = this.getIntParam("REALTIME_MSECS", new Integer(2000)).intValue();
        chart.reloadFrom = this.getParameter("REALTIME_DATAFILE", "");
        if (this.chartApplet == null) {
            int w = 500;
            int h = 500;
            try {
                w = new Integer(this.getStringParam("WIDTH", "500"));
                h = new Integer(this.getStringParam("HEIGHT", "500"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            chart.setWidth(w);
            chart.setHeight(h);
        }
        if (this.jdbcsource != null) {
            this.jdbcsource = null;
        }
        chart.loader = this;
        return chart;
    }

    private void loadDataFromFile(String sFile, String userpsw) {
        String fileData = "";
        String param = "";
        String value = "";
        try {
            BufferedReader in = null;
            if (this.chartApplet != null && sFile.indexOf(":/") == -1) {
                sFile = this.chartApplet.getCodeBase() + sFile;
            }
            in = null;
            if (sFile.indexOf("file://") == 0) {
                in = this.fileEncoding.length() > 0 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sFile.substring(7, sFile.length())), this.fileEncoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(sFile.substring(7, sFile.length()))));
            } else {
                URL u = null;
                try {
                    u = this.getClass().getClassLoader().getResource(sFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (u == null) {
                        u = ClassLoader.getSystemResource(sFile);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (u == null) {
                    u = new URL(sFile);
                }
                URLConnection uc = u.openConnection();
                if (userpsw.length() > 0) {
                    uc.setRequestProperty("Authorization", "Basic " + userpsw);
                }
                InputStream content = uc.getInputStream();
                in = this.fileEncoding.length() > 0 ? new BufferedReader(new InputStreamReader(content, this.fileEncoding)) : new BufferedReader(new InputStreamReader(content));
            }
            String inputLine = "";
            while ((inputLine = in.readLine()) != null) {
                fileData = String.valueOf(fileData) + inputLine + '\r' + '\n';
            }
            in.close();
        }
        catch (Exception e) {
            String err = e.getMessage();
            System.out.println("Could not open file: " + sFile + " " + e);
        }
        String line = "";
        while (fileData.length() > 0) {
            int p2;
            int p = fileData.indexOf("\r\n");
            if (p <= (p2 = fileData.indexOf("\n")) && p >= 0) {
                line = fileData.substring(0, p);
                fileData = fileData.substring(p + 2, fileData.length());
            }
            if (p > p2 && p2 >= 0) {
                line = fileData.substring(0, p2);
                fileData = fileData.substring(p2 + 1, fileData.length());
            }
            if (p2 == -1 && p == -1) {
                line = fileData;
                fileData = "";
            }
            if ((p = line.indexOf("=")) <= -1) continue;
            param = line.substring(0, p);
            value = line.substring(p + 1, line.length());
            param = param.toUpperCase();
            boolean alreadyFound = false;
            int h = 0;
            while (h < this.loadedParametersCount) {
                if (this.loadedParameters[h].compareTo(param) == 0) {
                    this.loadedValues[h] = value;
                    alreadyFound = true;
                }
                ++h;
            }
            if (alreadyFound) continue;
            this.loadedParameters[this.loadedParametersCount] = param;
            this.loadedValues[this.loadedParametersCount] = value;
            ++this.loadedParametersCount;
        }
    }

    public int getLoadedParametersCount() {
        return this.loadedParametersCount;
    }

    public String getLoadedParameter(int i) {
        return this.loadedParameters[i];
    }

    public String getLoadedValue(int i) {
        return this.loadedValues[i];
    }

    public void setDataFile(String df) {
        this.dataFile = df;
    }

    public Chart build(boolean clear, boolean reReadFile) {
        return this.build(null, clear, reReadFile);
    }

    public Chart build(Chart currentChart, boolean clear, boolean reReadFile) {
        if (clear) {
            this.loadedParametersCount = 0;
        }
        if (reReadFile) {
            String pFile = this.dataFile;
            if (this.chartApplet != null) {
                pFile = this.dataFile = this.getStringParam("DATAFILE", "");
            }
            if (pFile.length() > 0) {
                this.loadFromFile(pFile, false);
            }
        }
        if (this.getStringParam("PAINT_DIRECT", "").compareTo("NO") == 0) {
            this.paintDirect = false;
        }
        return this.buildChart(currentChart);
    }

    public void clearParams() {
        this.loadedParametersCount = 0;
    }

    public void loadFromFile(String psFile, boolean Clear, String userpsw) {
        if (Clear) {
            this.loadedParametersCount = 0;
        }
        this.loadDataFromFile(psFile, userpsw);
    }

    public void loadFromFile(String psFile, boolean Clear) {
        if (Clear) {
            this.loadedParametersCount = 0;
        }
        this.loadDataFromFile(psFile, "");
    }

    public void setParameter(String param, String value) {
        boolean alreadyFound = false;
        int h = 0;
        while (h < this.loadedParametersCount) {
            if (this.loadedParameters[h].compareTo(param) == 0) {
                this.loadedValues[h] = value;
                alreadyFound = true;
                return;
            }
            ++h;
        }
        if (!alreadyFound) {
            this.loadedParameters[this.loadedParametersCount] = param;
            this.loadedValues[this.loadedParametersCount] = value;
            ++this.loadedParametersCount;
        }
    }
}

