/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartLoader;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.IFloatingObject;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.GraphicsProvider;
import com.java4less.rchart.tags.TagObject;
import com.java4less.rchart.tags.TagParser;
import java.awt.Polygon;

public class ChartLabel
implements IFloatingObject {
    protected static int ALIGN_LEFT = 0;
    protected static int ALIGN_CENTER = 1;
    protected static int ALIGN_RIGHT = 2;
    protected static int BORDER_RECT = 0;
    protected static int BORDER_ROUNDRECT = 1;
    protected static int BORDER_OVAL = 2;
    protected Polygon clickableArea = null;
    protected Chart chart = null;
    private String sFormat = "";
    int[] lineWidths = new int[100];
    int[] lineHeights = new int[100];
    int lineCount = 0;
    int requiredWidth = 0;
    int requiredHeight = 0;
    TagObject[] objects = null;
    protected FillStyle background = null;
    protected LineStyle border = null;
    protected int borderShape = BORDER_RECT;
    protected String clickInfo = "";
    protected int rotation = 0;
    protected int rotationAlign = ChartGraphics.ROTATE_CENTER;
    protected int positionX = 0;
    protected int positionY = 0;
    protected int align = ALIGN_LEFT;
    protected int anchorX = 0;
    protected int anchorY = 0;
    protected int marginX = 2;
    protected int marginY = 2;
    protected LineStyle lineToAnchor = null;
    protected String name = "";
    protected String tip = "";
    protected boolean ignorePosition = false;

    public ChartLabel(String pformat, String pvalue, boolean pvertical, boolean pCenter) {
        int p;
        if (pformat.length() == 0) {
            pformat = pvalue;
        }
        if (pvertical) {
            pformat = "@rotation value='90'@" + pformat;
        }
        if (pCenter) {
            pformat = "@align value='CENTER'@" + pformat;
        }
        if ((p = pformat.indexOf("#value#")) >= 0) {
            pformat = String.valueOf(pformat.substring(0, p - 1)) + pvalue + pformat.substring(p + 7);
        }
        this.sFormat = pformat;
    }

    protected int getRotatedWidth() {
        if (this.rotation == 90 || this.rotation == -90 || this.rotation == 270) {
            return this.requiredHeight;
        }
        return this.requiredWidth;
    }

    protected int getRotatedHeight() {
        if (this.rotation == 90 || this.rotation == -90 || this.rotation == 270) {
            return this.requiredWidth;
        }
        return this.requiredHeight;
    }

    public void initialize(ChartGraphics g, Chart c) {
        this.chart = c;
        TagParser tagParser = new TagParser();
        this.objects = tagParser.parseTags(this.sFormat);
        this.preProcessTags(g);
    }

    public void paint(ChartGraphics g, int x, int y, int width, int height) {
        this.preProcessPositionTags(g, x, y, width, height);
        if (this.chart != null) {
            this.chart.placeFloatingObject(this);
        }
        if (this.chart != null) {
            this.chart.addFloationgObject(this);
        }
        this.render(g);
    }

    protected void preProcessTags(ChartGraphics g) {
        ChartFont tmpFont = g.getFont();
        this.positionX = 0;
        this.positionY = 0;
        this.requiredWidth = 1;
        this.requiredHeight = 1;
        this.lineHeights[this.lineCount] = g.getFontHeight();
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i].compareAtt(TagObject.ATT_TYPE, TagObject.TAG_LF)) {
                ++this.lineCount;
                this.lineHeights[this.lineCount] = g.getFontHeight();
            }
            if (this.objects[i].compareAtt(TagObject.ATT_TYPE, TagObject.TAG_STRING)) {
                this.lineWidths[this.lineCount] = this.lineWidths[this.lineCount] + g.getFontWidth(this.objects[i].getAttribute(TagObject.ATT_VALUE));
            }
            if (this.objects[i].compareAtt(TagObject.ATT_TYPE, TagObject.TAG_OBJECT)) {
                ChartFont font;
                String[] items;
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_ALIGN)) {
                    if (this.objects[i].compareAtt(TagObject.ATT_VALUE, "CENTER")) {
                        this.align = ALIGN_CENTER;
                    }
                    if (this.objects[i].compareAtt(TagObject.ATT_VALUE, "LEFT")) {
                        this.align = ALIGN_LEFT;
                    }
                    if (this.objects[i].compareAtt(TagObject.ATT_VALUE, "RIGHT")) {
                        this.align = ALIGN_RIGHT;
                    }
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_BACKGROUND)) {
                    this.background = ChartLoader.convertFillStyle(this.objects[i].getAttribute(TagObject.ATT_VALUE));
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_BORDER)) {
                    this.border = ChartLoader.convertLineStyle(this.objects[i].getAttribute(TagObject.ATT_VALUE));
                    if (this.objects[i].compareAtt("SHAPE", "ROUNDRECT")) {
                        this.borderShape = BORDER_ROUNDRECT;
                    }
                    if (this.objects[i].compareAtt("SHAPE", "OVAL")) {
                        this.borderShape = BORDER_OVAL;
                    }
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_ROTATION)) {
                    this.rotation = this.parseInt(this.objects[i].getAttribute(TagObject.ATT_VALUE));
                    if (this.rotation != 90 && this.rotation != -90 && this.rotation != 180 && this.rotation != 270 && this.rotation != 45 && this.rotation != -45) {
                        this.rotation = 0;
                    }
                    if (this.objects[i].compareAtt("CENTER", "LEFTTOP")) {
                        this.rotationAlign = ChartGraphics.ROTATE_LEFTTOP;
                    }
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_CLICKINFO)) {
                    this.clickInfo = this.objects[i].getAttribute(TagObject.ATT_VALUE);
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_TIP)) {
                    this.tip = this.objects[i].getAttribute(TagObject.ATT_VALUE);
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_POSITION) && this.objects[i].compareAtt("IGNORE", "TRUE")) {
                    this.ignorePosition = true;
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_SIZE) && !this.ignorePosition) {
                    int tmp;
                    items = ChartLoader.convertList(this.objects[i].getAttribute(TagObject.ATT_VALUE), ",");
                    if (items == null) {
                        items = new String[]{};
                    }
                    if (items.length > 0 && (tmp = this.calcX(items[0])) > this.requiredWidth) {
                        this.requiredWidth = tmp;
                    }
                    if (items.length > 1 && (tmp = this.calcY(items[1])) > this.requiredHeight) {
                        this.requiredHeight = tmp;
                    }
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_MARGIN)) {
                    items = ChartLoader.convertList(this.objects[i].getAttribute(TagObject.ATT_VALUE), ",");
                    if (items == null) {
                        items = new String[]{};
                    }
                    if (items.length > 0) {
                        this.marginX = this.calcX(items[0]);
                    }
                    if (items.length > 1) {
                        this.marginY = this.calcY(items[1]);
                    }
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_FONT) && (font = ChartLoader.convertFont(this.objects[i].getAttribute(TagObject.ATT_VALUE))) != null) {
                    g.setFont(font);
                    if (g.getFontHeight() > this.lineHeights[this.lineCount]) {
                        this.lineHeights[this.lineCount] = g.getFontHeight();
                    }
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_IMAGE)) {
                    ChartImage image = GraphicsProvider.getImage(this.objects[i].getAttribute(TagObject.ATT_VALUE));
                    this.lineWidths[this.lineCount] = this.lineWidths[this.lineCount] + image.getWidth();
                }
            }
            ++i;
        }
        int w = 0;
        int h = this.marginY * 2;
        int i2 = 0;
        while (i2 <= this.lineCount) {
            int lineW = this.lineWidths[i2] + this.marginX * 2;
            if (w < lineW) {
                w = lineW;
            }
            h += this.lineHeights[i2];
            ++i2;
        }
        if (w > this.requiredWidth) {
            this.requiredWidth = w;
        }
        if (h > this.requiredHeight) {
            this.requiredHeight = h;
        }
        g.setFont(tmpFont);
    }

    protected void preProcessPositionTags(ChartGraphics g, int x, int y, int width, int height) {
        this.positionX = x;
        this.positionY = y;
        this.requiredWidth = width;
        this.requiredHeight = height;
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i].compareAtt(TagObject.ATT_TYPE, TagObject.TAG_OBJECT)) {
                int tmp;
                String[] items;
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_POSITION)) {
                    if (this.objects[i].compareAtt("IGNORE", "TRUE")) {
                        this.ignorePosition = true;
                    }
                    if (!this.ignorePosition) {
                        items = ChartLoader.convertList(this.objects[i].getAttribute(TagObject.ATT_VALUE), ",");
                        if (items == null) {
                            items = new String[]{};
                        }
                        if (items.length > 0) {
                            this.positionX = this.calcRelativeX(items[0], x);
                        }
                        if (items.length > 1) {
                            this.positionY = this.calcRelativeY(items[1], y);
                        }
                    }
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_ANCHOR) && !this.ignorePosition) {
                    this.lineToAnchor = ChartLoader.convertLineStyle(this.objects[i].getAttribute("LINE"));
                    items = ChartLoader.convertList(this.objects[i].getAttribute(TagObject.ATT_VALUE), ",");
                    if (items == null) {
                        items = new String[]{};
                    }
                    if (items.length > 0) {
                        this.anchorX = tmp = this.calcX(items[0]);
                    }
                    if (items.length > 1) {
                        this.anchorY = tmp = this.calcY(items[1]);
                    }
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_SIZE) && !this.ignorePosition) {
                    items = ChartLoader.convertList(this.objects[i].getAttribute(TagObject.ATT_VALUE), ",");
                    if (items == null) {
                        items = new String[]{};
                    }
                    if (items.length > 0 && (tmp = this.calcX(items[0])) > this.requiredWidth) {
                        this.requiredWidth = tmp;
                    }
                    if (items.length > 1 && (tmp = this.calcY(items[1])) > this.requiredHeight) {
                        this.requiredHeight = tmp;
                    }
                }
            }
            ++i;
        }
        int w = 0;
        int h = this.marginY * 2;
        int i2 = 0;
        while (i2 <= this.lineCount) {
            int lineW = this.lineWidths[i2] + this.marginX * 2;
            if (w < lineW) {
                w = lineW;
            }
            h += this.lineHeights[i2];
            ++i2;
        }
        if (w > this.requiredWidth) {
            this.requiredWidth = w;
        }
        if (h > this.requiredHeight) {
            this.requiredHeight = h;
        }
    }

    protected void render(ChartGraphics g2) {
        ChartGraphics g = g2;
        ChartImage rotatedImage = null;
        int tmpPositionX = this.positionX;
        int tmpPositionY = this.positionY;
        if (this.lineToAnchor != null && this.rotation == 0) {
            if (this.anchorY > this.positionY) {
                if (this.anchorX <= this.positionX) {
                    this.lineToAnchor.draw(g2, this.anchorX, this.anchorY, this.positionX, this.positionY + this.requiredHeight - 1);
                } else {
                    this.lineToAnchor.draw(g2, this.anchorX, this.anchorY, this.positionX + this.requiredWidth, this.positionY + this.requiredHeight - 1);
                }
            } else if (this.anchorX <= this.positionX) {
                this.lineToAnchor.draw(g2, this.anchorX, this.anchorY, this.positionX, this.positionY);
            } else {
                this.lineToAnchor.draw(g2, this.anchorX, this.anchorY, this.positionX + this.requiredWidth, this.positionY);
            }
        }
        if (this.rotation != 0) {
            ChartColor transparentColor = GraphicsProvider.getColor(1, 1, 1);
            rotatedImage = GraphicsProvider.createTransparentImage(this.requiredWidth, this.requiredHeight, transparentColor);
            g = rotatedImage.getGraphics();
            g.setFont(g2.getFont());
            g.setColor(g2.getColor());
            this.positionX = 0;
            this.positionY = 0;
        }
        int line = 0;
        boolean leftMargin = false;
        int x = this.positionX;
        int y = this.positionY + this.marginY;
        int lineStart = 0;
        if (this.background != null) {
            ChartColor c = g.getColor();
            if (this.borderShape == BORDER_RECT) {
                this.background.draw(g, this.positionX, this.positionY, this.positionX + this.requiredWidth - 1, this.positionY + this.requiredHeight - 1);
            }
            if (this.borderShape == BORDER_ROUNDRECT) {
                this.background.drawRoundRect(g, this.positionX, this.positionY, this.positionX + this.requiredWidth - 1, this.positionY + this.requiredHeight - 1);
            }
            if (this.borderShape == BORDER_OVAL) {
                this.background.drawArc(g, (int)((double)this.positionX - (double)this.requiredWidth * 0.1), (int)((double)this.positionY - (double)this.requiredHeight * 0.1), (int)((double)this.requiredWidth + (double)this.requiredWidth * 0.2 - 1.0), (int)((double)this.requiredHeight + (double)this.requiredHeight * 0.3 - 1.0), 0, 360);
            }
            g.setColor(c);
        }
        if (this.align == ALIGN_CENTER) {
            x += (this.requiredWidth - this.marginX * 2 - this.lineWidths[0]) / 2;
        }
        if (this.align == ALIGN_RIGHT) {
            x += this.requiredWidth - this.marginX * 2 - this.lineWidths[0];
        }
        x = lineStart = x + this.marginX;
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i].compareAtt(TagObject.ATT_TYPE, TagObject.TAG_LF)) {
                leftMargin = false;
                x = this.positionX;
                y += this.lineHeights[++line - 1];
                if (this.align == ALIGN_CENTER) {
                    x += (this.requiredWidth - this.marginX * 2 - this.lineWidths[line]) / 2;
                }
                if (this.align == ALIGN_RIGHT) {
                    x += this.requiredWidth - this.marginX * 2 - this.lineWidths[line];
                }
                lineStart = x + this.marginX;
            }
            if (this.objects[i].compareAtt(TagObject.ATT_TYPE, TagObject.TAG_BACKSPACE)) {
                x -= g.getFontWidth(" ");
            }
            if (this.objects[i].compareAtt(TagObject.ATT_TYPE, TagObject.TAG_CR)) {
                x = lineStart;
            }
            if (this.objects[i].compareAtt(TagObject.ATT_TYPE, TagObject.TAG_STRING)) {
                String s = this.objects[i].getAttribute(TagObject.ATT_VALUE);
                g.drawString(s, x, y + this.lineHeights[line]);
                x += g.getFontWidth(s);
            }
            if (this.objects[i].compareAtt(TagObject.ATT_TYPE, TagObject.TAG_OBJECT)) {
                ChartColor c;
                ChartFont font;
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_FONT) && (font = ChartLoader.convertFont(this.objects[i].getAttribute(TagObject.ATT_VALUE))) != null) {
                    g.setFont(font);
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_COLOR) && (c = ChartLoader.convertColor(this.objects[i].getAttribute(TagObject.ATT_VALUE))) != null) {
                    g.setColor(c);
                }
                if (this.objects[i].compareAtt(TagObject.ATT_OBJECT_NAME, TagObject.OBJ_IMAGE)) {
                    ChartImage image = GraphicsProvider.getImage(this.objects[i].getAttribute(TagObject.ATT_VALUE));
                    g.drawImage(image, x, y);
                    x += image.getWidth();
                }
            }
            ++i;
        }
        if (this.border != null) {
            if (this.borderShape == BORDER_RECT) {
                this.border.drawRect(g, this.positionX, this.positionY, this.positionX + this.requiredWidth - 1, this.positionY + this.requiredHeight - 1);
            }
            if (this.borderShape == BORDER_ROUNDRECT) {
                this.border.drawRoundRect(g, this.positionX, this.positionY, this.positionX + this.requiredWidth - 1, this.positionY + this.requiredHeight - 1);
            }
            if (this.borderShape == BORDER_OVAL) {
                this.border.drawArc(g, (int)((double)this.positionX - (double)this.requiredWidth * 0.1), (int)((double)this.positionY - (double)this.requiredHeight * 0.1), (int)((double)this.requiredWidth + (double)this.requiredWidth * 0.2 - 1.0), (int)((double)this.requiredHeight + (double)this.requiredHeight * 0.3 - 1.0), 0, 360);
            }
        }
        this.clickableArea = null;
        if (this.rotation != 0) {
            this.positionX = tmpPositionX;
            this.positionY = tmpPositionY;
            g2.paintRotatedImage(rotatedImage, this.rotation, this.positionX, this.positionY, this.rotationAlign);
        } else {
            this.clickableArea = new Polygon();
            this.clickableArea.addPoint(this.positionX, this.positionY);
            this.clickableArea.addPoint(this.positionX, this.positionY + this.requiredHeight - 1);
            this.clickableArea.addPoint(this.positionX + this.requiredWidth - 1, this.positionY + this.requiredHeight - 1);
            this.clickableArea.addPoint(this.positionX + this.requiredWidth - 1, this.positionY);
            if (this.chart != null) {
                this.chart.chartHotAreas.addElement(this);
            }
        }
    }

    protected int calcRelativeX(String s, int x) {
        if (s.length() == 0) {
            return x;
        }
        if (s.indexOf("+") == 0) {
            return x + this.calcX(s.substring(1));
        }
        if (s.indexOf("-") == 0) {
            return x - this.calcX(s.substring(1));
        }
        return this.calcX(s);
    }

    protected int calcRelativeY(String s, int y) {
        if (s.length() == 0) {
            return y;
        }
        if (s.indexOf("+") == 0) {
            return y + this.calcY(s.substring(1));
        }
        if (s.indexOf("-") == 0) {
            return y - this.calcY(s.substring(1));
        }
        return this.calcY(s);
    }

    protected int calcX(String s) {
        if (s.indexOf("px") > 0) {
            return this.parseInt(s.substring(0, s.indexOf("px")));
        }
        if (s.indexOf("%") > 0) {
            return this.chart.getWidth() * Integer.parseInt(s.substring(0, s.indexOf("%"))) / 100;
        }
        if (this.chart.XAxis == null) {
            return 0;
        }
        return this.chart.XAxis.scale.getScreenCoord(new Double(s));
    }

    protected int calcY(String s) {
        if (s.indexOf("px") > 0) {
            return this.parseInt(s.substring(0, s.indexOf("px")));
        }
        if (s.indexOf("%") > 0) {
            return this.chart.getHeight() * Integer.parseInt(s.substring(0, s.indexOf("%"))) / 100;
        }
        if (this.chart.YAxis == null) {
            return 0;
        }
        return this.chart.YAxis.scale.getScreenCoord(new Double(s));
    }

    private int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getClickInfo() {
        return this.clickInfo;
    }

    public String getTip() {
        return this.tip;
    }

    public int getX() {
        return this.positionX;
    }

    public void setX(int x) {
        this.positionX = x;
    }

    public int getY() {
        return this.positionY;
    }

    public void setY(int y) {
        this.positionY = y;
    }

    public Polygon getObjectBounds() {
        Polygon pol = new Polygon();
        pol.addPoint(this.positionX, this.positionY);
        pol.addPoint(this.positionX + this.requiredWidth, this.positionY);
        pol.addPoint(this.positionX + this.requiredWidth, this.positionY + this.requiredHeight);
        pol.addPoint(this.positionX, this.positionY + this.requiredHeight);
        return pol;
    }
}

