/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Axis;
import com.java4less.rchart.BarPlotter3D;
import com.java4less.rchart.ChartLabel;
import com.java4less.rchart.ChartListener;
import com.java4less.rchart.ChartLoader;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.HAxisLabel;
import com.java4less.rchart.IFloatingObject;
import com.java4less.rchart.Legend;
import com.java4less.rchart.LineDataSerie;
import com.java4less.rchart.LinePlotter3D;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.TargetZone;
import com.java4less.rchart.Title;
import com.java4less.rchart.VAxisLabel;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.ChartImage;
import com.java4less.rchart.gc.GraphicsProvider;
import java.awt.Polygon;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public class Chart {
    public static final int LAYOUT_LEGEND_RIGHT = 0;
    public static final int LAYOUT_LEGEND_TOP = 1;
    public static final int LAYOUT_LEGEND_BOTTOM = 2;
    protected static final int MAX_SERIES = 50;
    public static final int dnum = 10;
    public static String numberLocale;
    public VAxisLabel YLabel;
    public VAxisLabel Y2Label;
    public HAxisLabel XLabel;
    public Legend legend;
    public Axis XAxis;
    public Axis YAxis;
    public Axis Y2Axis;
    public Title title;
    public double bottomMargin = 0.125;
    public double topMargin = 0.125;
    public double secondYAxisMargin = 0.0;
    public double leftMargin = 0.125;
    public double rightMargin = 0.125;
    public double legendMargin = 0.2;
    public double axisMargin = 0.0625;
    public boolean autoSize = true;
    public Plotter[] plotters = new Plotter[10];
    private int plottersCount = 0;
    public int layout = 0;
    public FillStyle back = null;
    public LineStyle border = null;
    public int offsetX = 0;
    public int offsetY = 0;
    private int width = 0;
    private int height = 0;
    private int minimumWidth = 0;
    private int minimumHeight = 0;
    public ChartImage backImage;
    private ChartImage chartImage = null;
    private ChartImage finalImage = null;
    private ChartImage backTmpImage = null;
    public boolean doubleBuffering = true;
    public int virtualWidth = 0;
    public int virtualHeight = 0;
    private int originalVirtualWidth = -1;
    private int originalVirtualHeight = -1;
    public boolean withScroll = false;
    public boolean repaintAll = true;
    public boolean repaintAlways = true;
    private Vector chartListeners = new Vector();
    public boolean fullXAxis = false;
    public ChartLabel selectedLabel = null;
    public DataSerie selectedSerie = null;
    public int selectedSeriePoint = -1;
    private int lastWidth = -1;
    private int lastHeight = -1;
    public boolean activateSelection = false;
    public int currentX;
    public int currentY;
    public double currentValueX;
    public double currentValueY;
    public double currentValueY2;
    private boolean showingTip = false;
    ChartColor tipColor = GraphicsProvider.getColor(ChartColor.YELLOW);
    ChartColor tipFontColor = GraphicsProvider.getColor(ChartColor.BLACK);
    ChartFont tipFont = GraphicsProvider.getFont("Serif", ChartFont.PLAIN, 10);
    private int cursorLastX = 0;
    private int cursorLastY = 0;
    public String htmlLinkTarget = "";
    public boolean showTips = false;
    public boolean showPosition = false;
    public ChartLoader loader = null;
    public long msecs = 2000L;
    private boolean stopped = false;
    public String reloadFrom = "";
    public boolean autoRebuild = true;
    private Updater deamon = null;
    protected Vector targetZones = new Vector();
    protected Vector notes = new Vector();
    protected Vector chartHotAreas = new Vector(0, 5);
    protected Vector floatingObjects = new Vector(0, 5);

    public Chart(Title t, Plotter p, Axis X, Axis Y) {
        this.resetChart(t, p, X, Y);
    }

    protected Chart() {
    }

    protected void resetChart(Title t, Plotter p, Axis X, Axis Y) {
        this.plottersCount = 0;
        this.plotters = new Plotter[10];
        this.XAxis = null;
        this.YAxis = null;
        this.Y2Axis = null;
        this.YLabel = null;
        this.Y2Label = null;
        this.XLabel = null;
        this.legend = null;
        this.title = null;
        this.border = null;
        this.back = null;
        this.selectedSerie = null;
        this.selectedSeriePoint = -1;
        this.repaintAll = true;
        this.removeTargetZones();
        this.removeNotes();
        this.chartHotAreas.removeAllElements();
        this.plotters[0] = p;
        this.XAxis = X;
        this.YAxis = Y;
        if (X != null && this.plotters[0] != null) {
            this.plotters[0].XScale = X.scale;
            X.plot = this.plotters[0];
        }
        if (Y != null && this.plotters[0] != null) {
            this.plotters[0].YScale = Y.scale;
            Y.plot = this.plotters[0];
        }
        this.title = t;
        if (this.title == null) {
            this.title = new Title("");
        }
        this.plottersCount = 1;
    }

    protected static int d() {
        return 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setMinimumSize(int w, int h) {
        this.minimumWidth = w;
        this.minimumHeight = h;
    }

    public void setSize(int w, int h) {
        this.setWidth(w);
        this.setHeight(h);
    }

    public void addTargetZone(TargetZone zone) {
        this.targetZones.addElement(zone);
    }

    public void removeTargetZones() {
        this.targetZones.removeAllElements();
    }

    public void addNote(String note) {
        this.notes.addElement(note);
    }

    public void removeNotes() {
        this.notes.removeAllElements();
    }

    public TargetZone[] getTargetZones() {
        TargetZone[] a = new TargetZone[this.targetZones.size()];
        int i = 0;
        while (i < a.length) {
            a[i] = (TargetZone)this.targetZones.elementAt(i);
            ++i;
        }
        return a;
    }

    protected void paintTargetZones(ChartGraphics g) {
        g.setFont(GraphicsProvider.getFont("Arial", ChartFont.BOLD, 10));
        int i = 0;
        while (i < this.targetZones.size()) {
            TargetZone z = (TargetZone)this.targetZones.elementAt(i);
            z.chart = this;
            z.effect3D = this.plotters[0].depth;
            z.paint(g, this.XAxis, this.YAxis);
            ++i;
        }
    }

    public void setWidth(int w) {
        if (w > this.minimumWidth) {
            this.width = w;
        }
    }

    public void setHeight(int h) {
        if (h > this.minimumHeight) {
            this.height = h;
        }
    }

    public void addChartListener(ChartListener cl) {
        this.chartListeners.addElement(cl);
    }

    public void removeChartListener(ChartListener cl) {
        this.chartListeners.removeElement(cl);
    }

    public void removeAllChartListener() {
        this.chartListeners.removeAllElements();
    }

    public void addPlotter(Plotter p) {
        this.plotters[this.plottersCount] = p;
        this.plotters[this.plottersCount].XScale = this.plotters[0].XScale;
        this.plotters[this.plottersCount].YScale = this.plotters[0].YScale;
        this.plotters[this.plottersCount].Y2Scale = this.plotters[0].Y2Scale;
        ++this.plottersCount;
    }

    public void removePlotters() {
        int i = 0;
        while (i < this.plottersCount) {
            this.plotters[i] = null;
            ++i;
        }
        this.plottersCount = 0;
    }

    private void AutoSize() {
        if (this.layout == 0) {
            this.AutoSize_LayoutRight();
        }
        if (this.layout == 1) {
            this.AutoSize_LayoutTop();
        }
        if (this.layout == 2) {
            this.AutoSize_LayoutBottom();
        }
    }

    public void setY2Scale(Axis a) {
        this.plotters[0].Y2Scale = a.scale;
        this.Y2Axis = a;
        a.rightAxis = true;
        a.plot = this.plotters[0];
    }

    private void setPlotterSize() {
        int i = 1;
        while (i < this.plottersCount) {
            this.plotters[i].x = this.plotters[0].x;
            this.plotters[i].y = this.plotters[0].y;
            this.plotters[i].width = this.plotters[0].width;
            this.plotters[i].height = this.plotters[0].height;
            ++i;
        }
    }

    private int getCountParallelAxis(Axis axis) {
        if (axis.stackAdditionalAxis) {
            return 0;
        }
        return axis.getAdditionalAxisCount();
    }

    private void setPositionStackedAxis(Axis axis) {
        block5: {
            if (axis == null) {
                return;
            }
            int aCount = axis.getAdditionalAxisCount() + 1;
            if (!axis.stackAdditionalAxis || aCount <= 1) break block5;
            if (axis.orientation == 1) {
                int tmpY = axis.y;
                int h = axis.height / aCount;
                int screenMin = axis.scale.screenMin;
                int screenMax = axis.scale.screenMax;
                int screenH = (axis.scale.screenMax - axis.scale.screenMin) / aCount;
                int screenH2 = (axis.scale.screenMaxMargin - axis.scale.screenMin) / aCount;
                int visibleH = axis.visibleSize / aCount;
                tmpY += h;
                screenMin += screenH;
                axis.height = h;
                axis.scale.screenMax = axis.scale.screenMin + screenH;
                axis.scale.screenMaxMargin = axis.scale.screenMin + screenH2;
                axis.visibleSize = visibleH;
                int i = 0;
                while (i < axis.getAdditionalAxisCount()) {
                    Axis a = axis.getAdditionalAxis(i);
                    a.y = tmpY;
                    a.height = h;
                    a.scale.screenMin = screenMin;
                    a.scale.screenMax = a.scale.screenMin + screenH;
                    a.scale.screenMaxMargin = a.scale.screenMin + screenH2;
                    a.visibleSize = visibleH;
                    a.realPosition = axis.realPosition;
                    a.width = axis.width;
                    tmpY += h;
                    screenMin += screenH;
                    ++i;
                }
            } else {
                int tmpX = axis.x;
                int w = axis.width / aCount;
                int screenMin = axis.scale.screenMin;
                int screenMax = axis.scale.screenMax;
                int screenW = (axis.scale.screenMax - axis.scale.screenMin) / aCount;
                int screenW2 = (axis.scale.screenMaxMargin - axis.scale.screenMin) / aCount;
                int visibleW = axis.visibleSize / aCount;
                tmpX += w;
                screenMin += screenW;
                axis.width = w;
                axis.scale.screenMax = axis.scale.screenMin + screenW;
                axis.scale.screenMaxMargin = axis.scale.screenMin + screenW2;
                axis.visibleSize = visibleW;
                int i = 0;
                while (i < axis.getAdditionalAxisCount()) {
                    Axis a = axis.getAdditionalAxis(i);
                    a.x = tmpX;
                    a.width = w;
                    a.scale.screenMin = screenMin;
                    a.scale.screenMax = a.scale.screenMin + screenW;
                    a.scale.screenMaxMargin = a.scale.screenMin + screenW2;
                    a.visibleSize = visibleW;
                    a.realPosition = axis.realPosition;
                    a.height = axis.height;
                    tmpX += w;
                    screenMin += screenW;
                    ++i;
                }
            }
        }
    }

    private void AutoSize_LayoutTop() {
        int myHeight = this.getHeight();
        int myWidth = this.getWidth();
        if (this.virtualWidth < myWidth) {
            this.virtualWidth = myWidth;
        }
        if (this.virtualHeight < myHeight) {
            this.virtualHeight = myHeight;
        }
        this.plotters[0].visibleWidth = (int)((double)myWidth * (1.0 - (this.leftMargin + this.rightMargin)));
        this.plotters[0].visibleHeight = (int)((double)myHeight * (1.0 - (this.topMargin + this.legendMargin + this.bottomMargin)));
        this.plotters[0].x = (int)((double)myWidth * this.leftMargin);
        this.plotters[0].y = (int)((double)myHeight * (this.topMargin + this.legendMargin));
        this.plotters[0].width = this.virtualWidth - (myWidth - this.plotters[0].visibleWidth);
        this.plotters[0].height = this.virtualHeight - (myHeight - this.plotters[0].visibleHeight);
        this.title.x = 0;
        this.title.y = 0;
        if (this.XAxis != null && this.XAxis.xscaleOnTop) {
            this.title.y = this.virtualHeight - (int)((double)myHeight * this.bottomMargin);
        }
        this.title.height = (int)((double)myHeight * this.topMargin);
        this.title.width = myWidth;
        if (this.XAxis != null) {
            this.XAxis.x = (int)((double)myWidth * this.leftMargin);
            this.XAxis.y = this.virtualHeight - (int)((double)myHeight * this.bottomMargin);
            this.XAxis.realPosition = (int)((double)myHeight * (1.0 - this.bottomMargin));
            this.XAxis.height = (int)((double)myHeight * (this.bottomMargin / (double)(2 + this.getCountParallelAxis(this.XAxis))));
            this.XAxis.visibleSize = (int)((double)myWidth * (1.0 - (this.leftMargin + this.rightMargin)));
            this.XAxis.width = this.virtualWidth - (myWidth - this.XAxis.visibleSize);
        }
        if (this.YAxis != null) {
            this.YAxis.width = (int)((double)myWidth * (this.leftMargin / (double)(2 + this.getCountParallelAxis(this.YAxis))));
            this.YAxis.realPosition = this.YAxis.x = (int)((double)myWidth * this.leftMargin) - this.YAxis.width;
            this.YAxis.y = (int)((double)myHeight * (this.topMargin + this.legendMargin));
            this.YAxis.visibleSize = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.YAxis.height = this.virtualHeight - (myHeight - this.YAxis.visibleSize);
        }
        if (this.XLabel != null) {
            this.XLabel.height = (int)((double)myHeight * (this.bottomMargin / (double)(2 + this.getCountParallelAxis(this.XAxis))));
            this.XLabel.x = (int)((double)myWidth * this.leftMargin);
            this.XLabel.y = myHeight - this.XLabel.height;
            if (this.XAxis != null && this.XAxis.xscaleOnTop) {
                this.XLabel.y = (int)((double)myHeight * this.legendMargin);
            }
            this.XLabel.width = (int)((double)myWidth * (1.0 - (this.leftMargin + this.leftMargin)));
        }
        if (this.YLabel != null) {
            this.YLabel.x = 0;
            this.YLabel.y = (int)((double)myHeight * (this.topMargin + this.legendMargin));
            this.YLabel.height = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.YLabel.width = (int)((double)myWidth * (this.leftMargin / (double)(2 + this.getCountParallelAxis(this.YAxis))));
        }
        if (this.Y2Axis != null) {
            this.plotters[0].width = (int)((double)this.plotters[0].width - (double)myWidth * this.secondYAxisMargin / 2.0);
        }
        if (this.Y2Label != null) {
            this.plotters[0].width = (int)((double)this.plotters[0].width - (double)myWidth * this.secondYAxisMargin / 2.0);
        }
        if (this.Y2Axis != null) {
            this.Y2Axis.x = this.plotters[0].x + this.plotters[0].width;
            this.Y2Axis.realPosition = this.plotters[0].x + this.plotters[0].visibleWidth;
            this.Y2Axis.y = (int)((double)myHeight * (this.topMargin + this.legendMargin));
            this.Y2Axis.visibleSize = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.Y2Axis.width = (int)((double)myWidth * this.rightMargin / (double)(2 + this.getCountParallelAxis(this.Y2Axis)));
            this.Y2Axis.height = this.virtualHeight - (myHeight - this.Y2Axis.visibleSize);
        }
        if (this.Y2Label != null) {
            int tmp = 2 + this.getCountParallelAxis(this.Y2Axis);
            this.Y2Label.x = this.plotters[0].x + this.plotters[0].visibleWidth + (int)((double)myWidth * this.rightMargin * (double)(tmp - 1) / (double)tmp);
            this.Y2Label.y = (int)((double)myHeight * (this.topMargin + this.legendMargin));
            this.Y2Label.height = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.Y2Label.width = (int)((double)myWidth * this.rightMargin / (double)(2 + this.getCountParallelAxis(this.Y2Axis)));
        }
        if (this.legend != null) {
            this.legend.x = (int)((double)myWidth * this.leftMargin);
            this.legend.width = (int)((double)myWidth * (1.0 - (this.leftMargin + this.rightMargin)));
            this.legend.y = (int)((double)myHeight * this.topMargin);
            if (this.XAxis != null && this.XAxis.xscaleOnTop) {
                this.legend.y = 0;
            }
            this.legend.height = (int)((double)myHeight * this.legendMargin);
        }
        this.adjustSize3d();
        this.setPlotterSize();
    }

    private void AutoSize_LayoutBottom() {
        int tmp;
        int myHeight = this.getHeight();
        int myWidth = this.getWidth();
        if (this.virtualWidth < myWidth) {
            this.virtualWidth = myWidth;
        }
        if (this.virtualHeight < myHeight) {
            this.virtualHeight = myHeight;
        }
        this.plotters[0].visibleWidth = (int)((double)myWidth * (1.0 - (this.leftMargin + this.rightMargin)));
        this.plotters[0].visibleHeight = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
        this.plotters[0].x = (int)((double)myWidth * this.leftMargin);
        this.plotters[0].y = (int)((double)myHeight * this.topMargin);
        this.plotters[0].width = this.virtualWidth - (myWidth - this.plotters[0].visibleWidth);
        this.plotters[0].height = this.virtualHeight - (myHeight - this.plotters[0].visibleHeight);
        this.title.x = 0;
        this.title.y = 0;
        if (this.XAxis != null && this.XAxis.xscaleOnTop) {
            this.title.y = this.virtualHeight - (int)((double)myHeight * (this.bottomMargin + this.legendMargin));
        }
        this.title.height = (int)((double)myHeight * this.topMargin);
        this.title.width = myWidth;
        if (this.XAxis != null) {
            this.XAxis.x = (int)((double)myWidth * this.leftMargin);
            this.XAxis.y = this.virtualHeight - (int)((double)myHeight * (this.bottomMargin + this.legendMargin));
            this.XAxis.realPosition = (int)((double)myHeight * (1.0 - this.bottomMargin - this.legendMargin));
            this.XAxis.height = (int)((double)myHeight * (this.bottomMargin / (double)(2 + this.getCountParallelAxis(this.XAxis))));
            this.XAxis.visibleSize = (int)((double)myWidth * (1.0 - (this.leftMargin + this.rightMargin)));
            this.XAxis.width = this.virtualWidth - (myWidth - this.XAxis.visibleSize);
        }
        if (this.YAxis != null) {
            this.YAxis.width = (int)((double)myWidth * (this.leftMargin / (double)(2 + this.getCountParallelAxis(this.YAxis))));
            this.YAxis.realPosition = this.YAxis.x = (int)((double)myWidth * this.leftMargin) - this.YAxis.width;
            this.YAxis.y = (int)((double)myHeight * this.topMargin);
            this.YAxis.visibleSize = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.YAxis.height = this.virtualHeight - (myHeight - this.YAxis.visibleSize);
        }
        if (this.XLabel != null) {
            tmp = 2 + this.getCountParallelAxis(this.XAxis);
            this.XLabel.x = (int)((double)myWidth * this.leftMargin);
            this.XLabel.y = (int)((double)myHeight * (1.0 - this.legendMargin)) - (int)((double)myHeight * (this.bottomMargin / (double)tmp));
            if (this.XAxis != null && this.XAxis.xscaleOnTop) {
                this.XLabel.y = 0;
            }
            this.XLabel.height = (int)((double)myHeight * (this.bottomMargin / (double)(2 + this.getCountParallelAxis(this.XAxis))));
            this.XLabel.width = (int)((double)myWidth * (1.0 - (this.leftMargin + this.leftMargin)));
        }
        if (this.YLabel != null) {
            this.YLabel.x = 0;
            this.YLabel.y = (int)((double)myHeight * this.topMargin);
            this.YLabel.height = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.YLabel.width = (int)((double)myWidth * (this.leftMargin / (double)(2 + this.getCountParallelAxis(this.YAxis))));
        }
        if (this.Y2Axis != null) {
            this.plotters[0].width = (int)((double)this.plotters[0].width - (double)myWidth * this.secondYAxisMargin / 2.0);
        }
        if (this.Y2Label != null) {
            this.plotters[0].width = (int)((double)this.plotters[0].width - (double)myWidth * this.secondYAxisMargin / 2.0);
        }
        if (this.Y2Axis != null) {
            this.Y2Axis.x = this.plotters[0].x + this.plotters[0].width;
            this.Y2Axis.realPosition = this.plotters[0].x + this.plotters[0].visibleWidth;
            this.Y2Axis.y = (int)((double)myHeight * this.topMargin);
            this.Y2Axis.visibleSize = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.Y2Axis.width = (int)((double)myWidth * this.rightMargin / (double)(2 + this.getCountParallelAxis(this.Y2Axis)));
            this.Y2Axis.height = this.virtualHeight - (myHeight - this.Y2Axis.visibleSize);
        }
        if (this.Y2Label != null) {
            tmp = 2 + this.getCountParallelAxis(this.Y2Axis);
            this.Y2Label.x = this.plotters[0].x + this.plotters[0].visibleWidth + (int)((double)myWidth * this.rightMargin * (double)(tmp - 1) / (double)tmp);
            this.Y2Label.y = (int)((double)myHeight * this.topMargin);
            this.Y2Label.height = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.Y2Label.width = (int)((double)myWidth * this.rightMargin / (double)(2 + this.getCountParallelAxis(this.Y2Axis)));
        }
        if (this.legend != null) {
            this.legend.x = (int)((double)myWidth * this.leftMargin);
            this.legend.width = (int)((double)myWidth * (1.0 - (this.leftMargin + this.leftMargin)));
            this.legend.y = (int)((double)myHeight * (1.0 - this.legendMargin));
            this.legend.height = (int)((double)myHeight * this.legendMargin);
        }
        this.adjustSize3d();
        this.setPlotterSize();
    }

    private void AutoSize_LayoutRight() {
        int myHeight = this.getHeight();
        int myWidth = this.getWidth();
        if (this.virtualWidth < myWidth) {
            this.virtualWidth = myWidth;
        }
        if (this.virtualHeight < myHeight) {
            this.virtualHeight = myHeight;
        }
        this.plotters[0].visibleWidth = (int)((double)myWidth * (1.0 - (this.legendMargin + this.leftMargin)));
        if (this.Y2Axis != null) {
            this.plotters[0].visibleWidth = (int)((double)myWidth * (1.0 - (this.legendMargin + this.rightMargin + this.leftMargin)));
        }
        this.plotters[0].visibleHeight = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin)));
        this.plotters[0].x = (int)((double)myWidth * this.leftMargin);
        this.plotters[0].y = (int)((double)myHeight * this.topMargin);
        this.plotters[0].width = this.virtualWidth - (myWidth - this.plotters[0].visibleWidth);
        this.plotters[0].height = this.virtualHeight - (myHeight - this.plotters[0].visibleHeight);
        this.title.x = 0;
        this.title.y = 0;
        if (this.XAxis != null && this.XAxis.xscaleOnTop) {
            this.title.y = this.virtualHeight - (int)((double)myHeight * this.bottomMargin);
        }
        this.title.height = (int)((double)myHeight * this.topMargin);
        this.title.width = myWidth;
        if (this.XAxis != null) {
            this.XAxis.x = (int)((double)myWidth * this.leftMargin);
            this.XAxis.y = this.virtualHeight - (int)((double)myHeight * this.bottomMargin);
            this.XAxis.realPosition = (int)((double)myHeight * (1.0 - this.bottomMargin));
            this.XAxis.height = (int)((double)myHeight * (this.bottomMargin / (double)(2 + this.getCountParallelAxis(this.XAxis))));
            this.XAxis.visibleSize = this.plotters[0].visibleWidth;
            this.XAxis.width = this.virtualWidth - (myWidth - this.XAxis.visibleSize);
        }
        if (this.YAxis != null) {
            this.YAxis.width = (int)((double)myWidth * (this.leftMargin / (double)(2 + this.getCountParallelAxis(this.YAxis))));
            this.YAxis.realPosition = this.YAxis.x = (int)((double)myWidth * this.leftMargin) - this.YAxis.width;
            this.YAxis.y = (int)((double)myHeight * this.topMargin);
            this.YAxis.visibleSize = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin)));
            this.YAxis.height = this.virtualHeight - (myHeight - this.YAxis.visibleSize);
        }
        if (this.XLabel != null) {
            this.XLabel.height = (int)((double)myHeight * (this.bottomMargin / (double)(2 + this.getCountParallelAxis(this.XAxis))));
            this.XLabel.x = (int)((double)myWidth * this.leftMargin);
            this.XLabel.y = myHeight - this.XLabel.height;
            if (this.XAxis != null && this.XAxis.xscaleOnTop) {
                this.XLabel.y = 0;
            }
            this.XLabel.width = (int)((double)myWidth * (1.0 - (this.legendMargin + this.leftMargin)));
        }
        if (this.YLabel != null) {
            this.YLabel.x = 0;
            this.YLabel.y = (int)((double)myHeight * this.topMargin);
            this.YLabel.height = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin)));
            this.YLabel.width = (int)((double)myWidth * (this.leftMargin / (double)(2 + this.getCountParallelAxis(this.YAxis))));
        }
        if (this.Y2Axis != null) {
            this.plotters[0].width = (int)((double)this.plotters[0].width - (double)myWidth * this.secondYAxisMargin / 2.0);
        }
        if (this.Y2Label != null) {
            this.plotters[0].width = (int)((double)this.plotters[0].width - (double)myWidth * this.secondYAxisMargin / 2.0);
        }
        if (this.Y2Axis != null) {
            this.Y2Axis.x = this.plotters[0].x + this.plotters[0].width;
            this.Y2Axis.realPosition = this.plotters[0].x + this.plotters[0].visibleWidth;
            this.Y2Axis.y = (int)((double)myHeight * this.topMargin);
            this.Y2Axis.visibleSize = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin)));
            this.Y2Axis.width = (int)((double)myWidth * this.rightMargin / (double)(2 + this.getCountParallelAxis(this.Y2Axis)));
            this.Y2Axis.height = this.virtualHeight - (myHeight - this.Y2Axis.visibleSize);
        }
        if (this.Y2Label != null) {
            int tmp = 2 + this.getCountParallelAxis(this.Y2Axis);
            this.Y2Label.x = this.plotters[0].x + this.plotters[0].visibleWidth + (int)((double)myWidth * this.rightMargin * (double)(tmp - 1) / (double)tmp);
            this.Y2Label.y = (int)((double)myHeight * this.topMargin);
            this.Y2Label.height = (int)((double)myHeight * (1.0 - (this.topMargin + this.bottomMargin)));
            this.Y2Label.width = (int)((double)myWidth * this.rightMargin / (double)(2 + this.getCountParallelAxis(this.Y2Axis)));
        }
        if (this.legend != null) {
            this.legend.x = (int)((double)myWidth * (1.0 - this.legendMargin));
            this.legend.width = (int)((double)myWidth * this.legendMargin);
            this.legend.y = (int)((double)myHeight * this.topMargin);
            this.legend.height = (int)((double)myHeight * 0.5);
        }
        this.adjustSize3d();
        this.setPlotterSize();
    }

    private void adjustSize3d() {
        boolean D3 = false;
        int i = 0;
        while (i < this.plottersCount) {
            if (this.plotters[i] instanceof BarPlotter3D) {
                D3 = true;
            }
            if (this.plotters[i] instanceof LinePlotter3D) {
                D3 = true;
            }
            if (D3 && this.plotters[i].depth == 0) {
                this.plotters[i].depth = 20;
            }
            this.plotters[i].width -= this.plotters[i].depth;
            this.plotters[i].height -= this.plotters[i].depth;
            this.plotters[i].y += this.plotters[i].depth;
            ++i;
        }
        if (this.Y2Axis != null) {
            this.Y2Axis.visibleSize -= this.plotters[0].depth;
            this.Y2Axis.y = this.Y2Axis.y;
            this.Y2Axis.height -= this.plotters[0].depth;
        }
        if (this.YAxis != null) {
            this.YAxis.visibleSize -= this.plotters[0].depth;
            this.YAxis.y += this.plotters[0].depth;
            this.YAxis.height -= this.plotters[0].depth;
        }
        if (this.XAxis != null) {
            this.XAxis.visibleSize -= this.plotters[0].depth;
            this.XAxis.width -= this.plotters[0].depth;
        }
    }

    private void drawBackImage(ChartGraphics g) {
        int ImageW = this.backImage.getWidth();
        int ImageH = this.backImage.getHeight();
        if (ImageW == -1 || ImageH == -1) {
            return;
        }
        int j = 0;
        while (j < this.virtualWidth) {
            int i = 0;
            while (i < this.virtualHeight) {
                g.drawImage(this.backImage, j, i);
                i += ImageH;
            }
            j += ImageW;
        }
    }

    protected void addFloationgObject(IFloatingObject obj) {
        this.floatingObjects.addElement(obj);
    }

    protected void placeFloatingObject(IFloatingObject obj) {
    }

    public void paint(ChartGraphics pg) {
        this.floatingObjects.removeAllElements();
        long start = System.currentTimeMillis();
        if (this.plotters[0] == null || this.plottersCount <= 0) {
            pg.setColor(GraphicsProvider.getColor(ChartColor.RED));
            pg.drawString("Error: No plotters/series have been defined", 30, 30);
            return;
        }
        int j = 0;
        while (j < this.plottersCount) {
            if (this.plotters[j].getNeedsAxis() > 0 && this.XAxis == null) {
                pg.setColor(GraphicsProvider.getColor(ChartColor.RED));
                pg.drawString("Error: No X axis have been defined", 30, 30);
                return;
            }
            if (this.plotters[j].getNeedsAxis() > 1 && this.YAxis == null) {
                pg.setColor(GraphicsProvider.getColor(ChartColor.RED));
                pg.drawString("Error: No Y axis have been defined", 30, 30);
                return;
            }
            if (this.plottersCount > 1 && !this.plotters[j].getCombinable()) {
                pg.setColor(GraphicsProvider.getColor(ChartColor.RED));
                pg.drawString("Error: These plotters cannot be combined", 30, 30);
                return;
            }
            ++j;
        }
        ChartGraphics gScroll = pg;
        ChartGraphics gBack = pg;
        ChartGraphics g = pg;
        if (this.lastWidth != this.width || this.lastHeight != this.height) {
            this.repaintAll = true;
            this.lastWidth = this.width;
            this.lastHeight = this.height;
        }
        if (this.originalVirtualHeight == -1) {
            this.originalVirtualHeight = this.virtualHeight;
        }
        if (this.originalVirtualWidth == -1) {
            this.originalVirtualWidth = this.virtualWidth;
        }
        if (!this.withScroll) {
            this.repaintAlways = true;
        }
        if (this.repaintAlways) {
            this.repaintAll = true;
        }
        if (this.autoSize) {
            if (!this.withScroll) {
                this.virtualHeight = this.originalVirtualHeight;
                this.virtualWidth = this.originalVirtualWidth;
            }
            this.AutoSize();
        }
        try {
            if (this.doubleBuffering && (this.repaintAll || this.finalImage == null)) {
                if (this.finalImage != null) {
                    this.finalImage.dispose();
                }
                this.finalImage = GraphicsProvider.createImage(this.getWidth(), this.getHeight());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.finalImage != null) {
            gScroll = g = this.finalImage.getGraphics();
            gBack = g;
        }
        if (this.withScroll) {
            if (this.repaintAll || this.chartImage == null) {
                if (this.chartImage != null) {
                    this.chartImage.dispose();
                }
                this.chartImage = GraphicsProvider.createImage(this.virtualWidth, this.virtualHeight);
            }
            gScroll = this.chartImage.getGraphics();
            if (this.repaintAll || this.backTmpImage == null) {
                if (this.backTmpImage != null) {
                    this.backTmpImage.dispose();
                }
                this.backTmpImage = GraphicsProvider.createImage(this.virtualWidth, this.virtualHeight);
            }
            gBack = this.backTmpImage.getGraphics();
        }
        if (this.virtualWidth > this.width && this.XAxis.stackAdditionalAxis) {
            this.XAxis.stackAdditionalAxis = false;
            System.err.println("Warnning: additional axis cannot be stacked if using scroll.");
            if (this.XAxis.getTargetZones().length > 0) {
                this.XAxis.removeTargetZones();
                System.err.println("Warnning: axis target zones not compatible scroll.");
            }
        }
        if (this.virtualHeight > this.height && this.YAxis.stackAdditionalAxis) {
            this.YAxis.stackAdditionalAxis = false;
            System.err.println("Warnning: additional axis cannot be stacked if using scroll.");
            if (this.YAxis.getTargetZones().length > 0) {
                this.YAxis.removeTargetZones();
                System.err.println("Warnning: axis target zones not compatible scroll.");
            }
        }
        if (this.repaintAll) {
            if (this.back != null) {
                this.back.draw(gBack, 0, 0, this.virtualWidth, this.virtualHeight);
            }
            if (this.backImage != null) {
                this.drawBackImage(gBack);
            }
        }
        if (this.withScroll && (this.backImage != null || this.back != null)) {
            if (this.repaintAll) {
                gScroll.drawImage(this.backTmpImage, 0, 0, this.virtualWidth, this.virtualHeight, 0, 0, this.virtualWidth, this.virtualHeight);
            }
            g.drawImage(this.backTmpImage, 0, 0, this.getWidth(), this.getHeight(), this.offsetX, this.offsetY, this.getWidth() + this.offsetX, this.getHeight() + this.offsetY);
        }
        if (this.plotters[0].XScale != null) {
            this.plotters[0].XScale.screenMax = this.plotters[0].x + this.plotters[0].width;
            this.plotters[0].XScale.screenMaxMargin = (int)((double)this.plotters[0].XScale.screenMax * (1.0 - this.axisMargin));
            if (this.fullXAxis) {
                this.plotters[0].XScale.screenMaxMargin = this.plotters[0].XScale.screenMax;
            }
            this.plotters[0].XScale.screenMin = this.plotters[0].x;
        }
        if (this.plotters[0].YScale != null) {
            this.plotters[0].YScale.screenMax = this.plotters[0].y + this.plotters[0].height;
            this.plotters[0].YScale.screenMaxMargin = (int)((double)this.plotters[0].YScale.screenMax * (1.0 - this.axisMargin));
            this.plotters[0].YScale.screenMin = this.plotters[0].y;
        }
        if (this.plotters[0].Y2Scale != null) {
            this.plotters[0].Y2Scale.screenMax = this.plotters[0].y + this.plotters[0].height - this.plotters[0].depth;
            this.plotters[0].Y2Scale.screenMaxMargin = (int)((double)this.plotters[0].Y2Scale.screenMax * (1.0 - this.axisMargin));
            this.plotters[0].Y2Scale.screenMin = this.plotters[0].y - this.plotters[0].depth;
        }
        if (this.repaintAll) {
            int plotterBackWidth = this.plotters[0].width;
            int plotterBackHeight = this.plotters[0].height;
            if (this.XAxis != null) {
                plotterBackWidth = this.XAxis.width;
            }
            if (this.YAxis != null) {
                plotterBackHeight = this.YAxis.height;
            }
            this.plotters[0].plotBackground(gScroll, plotterBackWidth, plotterBackHeight, this.offsetX, this.offsetY);
        }
        this.title.chart = this;
        this.title.draw(g);
        if (this.repaintAll) {
            if (this.XAxis != null) {
                this.XAxis.chart = this;
            }
            if (this.YAxis != null) {
                this.YAxis.chart = this;
            }
            if (this.Y2Axis != null) {
                this.Y2Axis.chart = this;
            }
            this.setPositionStackedAxis(this.XAxis);
            this.setPositionStackedAxis(this.YAxis);
            this.setPositionStackedAxis(this.Y2Axis);
            if (this.XAxis != null) {
                this.XAxis.offset = this.offsetX;
            }
            if (this.YAxis != null) {
                this.YAxis.offset = this.offsetY;
            }
            if (this.Y2Axis != null) {
                this.Y2Axis.offset = this.offsetY;
            }
            if (this.XAxis != null) {
                this.XAxis.drawGridBackground(gScroll, this.YAxis);
            }
            if (this.YAxis != null) {
                this.YAxis.drawGridBackground(gScroll, this.XAxis);
            }
            if (this.Y2Axis != null) {
                this.Y2Axis.drawGridBackground(gScroll, this.XAxis);
            }
            if (this.XAxis != null) {
                this.XAxis.drawBackground(gScroll, this.YAxis);
            }
            if (this.YAxis != null) {
                this.YAxis.drawBackground(gScroll, this.XAxis);
            }
            if (this.Y2Axis != null) {
                this.Y2Axis.drawBackground(gScroll, this.XAxis);
            }
        }
        this.paintTargetZones(g);
        if (Chart.d() != 1 && this.legend == null) {
            this.legend = new Legend();
        }
        if (this.legend != null) {
            this.legend.chart = this;
            this.legend.draw(g);
        }
        if (this.XLabel != null) {
            this.XLabel.chart = this;
            this.XLabel.draw(g);
        }
        if (this.YLabel != null) {
            this.YLabel.chart = this;
            this.YLabel.draw(g);
        }
        if (this.Y2Label != null) {
            this.Y2Label.chart = this;
            this.Y2Label.draw(g);
        }
        if (this.repaintAll) {
            int i = 0;
            while (i < this.plottersCount) {
                this.plotters[i].chart = this;
                this.plotters[i].plot(gScroll);
                ++i;
            }
        }
        if (this.border != null) {
            this.border.drawRect(g, 0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        if (this.chartImage != null) {
            int x1 = this.plotters[0].x;
            int x2 = this.plotters[0].x + this.plotters[0].visibleWidth;
            int y1 = this.plotters[0].y - this.plotters[0].depth;
            int y2 = this.plotters[0].y - this.plotters[0].depth + this.plotters[0].visibleHeight;
            g.drawImage(this.chartImage, x1, y1, x2, y2, x1 + this.offsetX, y1 + this.offsetY, x2 + this.offsetX, y2 + this.offsetY);
        }
        if (this.chartListeners != null) {
            int i = 0;
            while (i < this.chartListeners.size()) {
                ((ChartListener)this.chartListeners.elementAt(i)).paintUserExit(this, g);
                ++i;
            }
        }
        if (this.XAxis != null) {
            this.XAxis.offset = this.offsetX;
            this.XAxis.drawForeground(g, this.YAxis);
        }
        if (this.YAxis != null) {
            this.YAxis.offset = this.offsetY;
            this.YAxis.drawForeground(g, this.XAxis);
        }
        if (this.Y2Axis != null) {
            this.Y2Axis.offset = this.offsetY;
            this.Y2Axis.drawForeground(g, this.XAxis);
        }
        this.paintNotes(g);
        this.paintTips(g);
        if (this.finalImage != null) {
            pg.drawImage(this.finalImage, 0, 0, this.getWidth() - 1, this.getHeight() - 1, 0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        this.repaintAll = false;
        if (gScroll != pg) {
            gScroll.dispose();
        }
        if (gBack != pg) {
            gBack.dispose();
        }
        if (g != pg) {
            g.dispose();
        }
    }

    public void addSerie(DataSerie s) {
        this.plotters[0].addSerie(s);
    }

    public void dispose() {
        int i = 0;
        while (i < this.plottersCount) {
            if (this.plotters[i] != null) {
                int j = 0;
                while (j < this.plotters[i].getSeriesCount()) {
                    if (this.plotters[i].getSerie(j) instanceof LineDataSerie) {
                        LineDataSerie lSerie = (LineDataSerie)this.plotters[i].getSerie(j);
                        if (lSerie.icon != null) {
                            lSerie.icon.dispose();
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.chartImage != null) {
            this.chartImage.dispose();
        }
        if (this.finalImage != null) {
            this.finalImage.dispose();
        }
        if (this.backTmpImage != null) {
            this.backTmpImage.dispose();
        }
        if (this.backImage != null) {
            this.backImage.dispose();
        }
        this.stopUpdater();
    }

    public void saveToFile(OutputStream os, String psFormat) throws Exception {
        ChartImage image = GraphicsProvider.createImage(this.width, this.height);
        ChartGraphics g = null;
        try {
            g = image.getGraphics();
            this.paint(g);
            image.saveToStream(psFormat, os);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (g != null) {
                g.dispose();
            }
            image.dispose();
            throw throwable;
        }
        Object var5_7 = null;
        if (g != null) {
            g.dispose();
        }
        image.dispose();
    }

    public void saveToFile(String psFile, String psFormat) throws Exception {
        this.saveToFile(new FileOutputStream(psFile), psFormat);
    }

    private void paintNotes(ChartGraphics g) {
        if (g == null) {
            return;
        }
        int i = 0;
        while (i < this.notes.size()) {
            ChartLabel label = new ChartLabel((String)this.notes.elementAt(i), "", false, false);
            label.initialize(g, this);
            label.paint(g, 0, 0, 0, 0);
            ++i;
        }
    }

    private void paintTips(ChartGraphics g) {
        this.showingTip = false;
        String tipStr = "";
        if (this.showTips && this.selectedSerie != null && this.selectedSeriePoint >= 0 && this.selectedSerie.tips != null && this.selectedSerie.tips.length > this.selectedSeriePoint) {
            tipStr = this.selectedSerie.tips[this.selectedSeriePoint];
        }
        if (this.showTips && this.selectedLabel != null) {
            tipStr = this.selectedLabel.getTip();
        }
        if (tipStr != null && tipStr.length() > 0) {
            String[] tip = ChartLoader.convertList(tipStr, "\\n");
            g.setFont(this.tipFont);
            String val = "" + (int)this.currentValueY;
            int he = g.getFontHeight() + 4;
            int wi = 4;
            int h = 0;
            while (h < tip.length) {
                if (g.getFontWidth(tip[h]) + 4 > wi) {
                    wi = g.getFontWidth(tip[h]) + 4;
                }
                ++h;
            }
            g.setColor(this.tipColor);
            g.fillRect(this.currentX, this.currentY - he * tip.length, wi, he * tip.length);
            g.setColor(this.tipFontColor);
            g.drawRect(this.currentX, this.currentY - he * tip.length, wi, he * tip.length);
            h = 0;
            while (h < tip.length) {
                g.drawString(tip[h], this.currentX + 2, this.currentY - 2 - he * (tip.length - h - 1));
                ++h;
            }
            this.showingTip = true;
            return;
        }
        if (this.showPosition && this.currentX > 0 && this.currentY > 0) {
            String txt = "" + this.currentValueY;
            String sFormat = this.YAxis.scaleLabelFormat;
            if (sFormat.length() == 0) {
                sFormat = "#";
            }
            if (this.YAxis != null && sFormat.length() > 0) {
                DecimalFormat df = null;
                if (numberLocale == null) {
                    df = new DecimalFormat(sFormat);
                } else {
                    NumberFormat nf = NumberFormat.getNumberInstance(new Locale(numberLocale, ""));
                    df = (DecimalFormat)nf;
                    df.applyPattern(sFormat);
                }
                txt = df.format(new Double(this.currentValueY));
            }
            g.setFont(this.tipFont);
            int he = g.getFontHeight() + 4;
            int wi = g.getFontWidth(String.valueOf(txt) + "  ");
            g.setColor(this.tipColor);
            g.fillRect(this.currentX, this.currentY - he, wi, he);
            g.setColor(this.tipFontColor);
            g.drawRect(this.currentX, this.currentY - he, wi, he);
            this.showingTip = true;
            g.drawString(txt, this.currentX + 2, this.currentY - 2);
        }
    }

    public void mouseClick() {
        if (this.selectedSerie != null && this.selectedSeriePoint >= 0 || this.selectedLabel != null) {
            this.triggerEvent(5);
        }
    }

    private void triggerEvent(int event) {
        int i = 0;
        while (i < this.chartListeners.size()) {
            ((ChartListener)this.chartListeners.elementAt(i)).chartEvent(this, event);
            ++i;
        }
    }

    public void mouseMoved(int eX, int eY) {
        if (this.plotters[0] == null) {
            return;
        }
        this.currentValueX = 0.0;
        this.currentValueY = 0.0;
        this.currentValueY2 = 0.0;
        this.currentX = eX;
        this.currentY = eY;
        Object previousSelectedObject = this.selectedSerie;
        int previousPoint = this.selectedSeriePoint;
        if (this.selectedSerie == null && this.selectedLabel != null) {
            previousSelectedObject = this.selectedLabel;
        }
        this.selectedSerie = null;
        this.selectedLabel = null;
        this.selectedSeriePoint = -1;
        if (this.XAxis != null) {
            this.currentValueX = this.XAxis.scale.getValue(this.currentX + this.offsetX);
        }
        if (this.YAxis != null) {
            this.currentValueY = this.YAxis.scale.getValue(this.currentY + this.offsetY);
            if (this.Y2Axis != null) {
                this.currentValueY2 = this.Y2Axis.scale.getValue(this.currentY + this.offsetY);
            }
        }
        if (this.activateSelection) {
            int h = 0;
            while (h < this.plotters.length) {
                if (this.plotters[h] == null) break;
                int k = 0;
                while (k < this.plotters[h].getSeriesCount()) {
                    DataSerie d = this.plotters[h].getSerie(k);
                    int i = 0;
                    while (i < d.hotAreas.size()) {
                        if (((Polygon)d.hotAreas.elementAt(i)).contains(this.currentX + this.offsetX, this.currentY + this.offsetY)) {
                            boolean triggerEnter = false;
                            if (previousSelectedObject == null) {
                                triggerEnter = true;
                            } else if (previousSelectedObject != d || previousPoint != i) {
                                this.triggerEvent(3);
                                triggerEnter = true;
                            }
                            this.selectedSerie = d;
                            this.selectedSeriePoint = i;
                            if (!triggerEnter) break;
                            this.triggerEvent(2);
                            break;
                        }
                        ++i;
                    }
                    ++k;
                }
                ++h;
            }
            if (this.selectedSerie == null) {
                int i = 0;
                while (i < this.chartHotAreas.size()) {
                    ChartLabel label = (ChartLabel)this.chartHotAreas.elementAt(i);
                    if (label.clickableArea.contains(this.currentX + this.offsetX, this.currentY + this.offsetY)) {
                        this.selectedLabel = label;
                        break;
                    }
                    ++i;
                }
            }
            if (Math.abs(this.currentX - this.cursorLastX) > 2 || Math.abs(this.currentY - this.cursorLastY) > 2) {
                this.cursorLastX = this.loader.gChart.currentX;
                this.cursorLastY = this.loader.gChart.currentY;
                this.triggerEvent(4);
            }
        }
        if (previousSelectedObject != null && this.selectedSerie == null && this.selectedLabel == null) {
            this.triggerEvent(3);
        }
    }

    public void startUpdater() {
        this.stopped = false;
        this.deamon = new Updater();
        this.deamon.chart = this;
        new Thread(this.deamon).start();
    }

    public void stopUpdater() {
        this.stopped = true;
        if (this.deamon != null) {
            this.deamon.stop = true;
        }
        this.deamon = null;
    }

    public String getHTMLImageMap(String name) {
        String html = "<MAP NAME=\"" + name + "\" >";
        boolean hasContent = false;
        Chart c = this;
        int p = 0;
        while (p < c.plotters.length) {
            if (c.plotters[p] != null) {
                int s = 0;
                while (s < c.plotters[p].getSeriesCount()) {
                    DataSerie se = c.plotters[p].getSerie(s);
                    int a = 0;
                    while (a < se.hotAreas.size()) {
                        Polygon po = (Polygon)se.hotAreas.elementAt(a);
                        html = String.valueOf(html) + "<AREA SHAPE=POLY COORDS=\"";
                        int j = 0;
                        while (j < po.npoints) {
                            if (j > 0) {
                                html = String.valueOf(html) + ", ";
                            }
                            html = String.valueOf(html) + "" + po.xpoints[j] + ", " + po.ypoints[j];
                            ++j;
                        }
                        html = String.valueOf(html) + "\"";
                        String tip = "";
                        if (c.showTips) {
                            if (c.plotters[p].getSerie((int)s).tips != null && c.plotters[p].getSerie((int)s).tips.length > a) {
                                tip = c.plotters[p].getSerie((int)s).tips[a];
                            }
                            if ((tip = Chart.replaceStr(tip, "\\n", "")).length() > 0) {
                                hasContent = true;
                            }
                            html = String.valueOf(html) + " ALT=\"" + tip + "\"";
                            html = String.valueOf(html) + " TITLE=\"" + tip + "\"";
                        }
                        String link = "";
                        if (c.plotters[p].getSerie((int)s).htmlLinks != null && c.plotters[p].getSerie((int)s).htmlLinks.length > a) {
                            link = c.plotters[p].getSerie((int)s).htmlLinks[a];
                        }
                        if (link.length() > 0) {
                            html = String.valueOf(html) + " HREF=\"" + link + "\"";
                            if (link.length() > 0) {
                                hasContent = true;
                            }
                        }
                        if (this.htmlLinkTarget.length() > 0) {
                            html = String.valueOf(html) + " TARGET=\"" + this.htmlLinkTarget + "\"";
                        }
                        html = String.valueOf(html) + ">";
                        ++a;
                    }
                    ++s;
                }
            }
            ++p;
        }
        int i = 0;
        while (i < this.chartHotAreas.size()) {
            ChartLabel label = (ChartLabel)this.chartHotAreas.elementAt(i);
            Polygon po = label.clickableArea;
            html = String.valueOf(html) + "<AREA SHAPE=POLY COORDS=\"";
            int j = 0;
            while (j < po.npoints) {
                if (j > 0) {
                    html = String.valueOf(html) + ", ";
                }
                html = String.valueOf(html) + "" + po.xpoints[j] + ", " + po.ypoints[j];
                ++j;
            }
            html = String.valueOf(html) + "\"";
            String tip = "";
            if (c.showTips) {
                if (label.getTip() != null) {
                    tip = label.getTip();
                }
                if ((tip = Chart.replaceStr(tip, "\\n", "")).length() > 0) {
                    hasContent = true;
                }
                html = String.valueOf(html) + " ALT=\"" + tip + "\"";
                html = String.valueOf(html) + " TITLE=\"" + tip + "\"";
            }
            String link = "";
            if (label.getClickInfo() != null) {
                link = label.getClickInfo();
            }
            if (link.length() > 0) {
                html = String.valueOf(html) + " HREF=\"" + link + "\"";
                if (link.length() > 0) {
                    hasContent = true;
                }
            }
            if (this.htmlLinkTarget.length() > 0) {
                html = String.valueOf(html) + " TARGET=\"" + this.htmlLinkTarget + "\"";
            }
            html = String.valueOf(html) + ">";
            ++i;
        }
        html = String.valueOf(html) + "</MAP>";
        if (!hasContent) {
            return "";
        }
        return html;
    }

    private static String replaceStr(String s, String sub1, String sub2) {
        int p = s.indexOf(sub1);
        while (p >= 0) {
            s = String.valueOf(s.substring(0, p)) + sub2 + s.substring(p + sub1.length(), s.length());
            p = s.indexOf(sub1);
        }
        return s;
    }

    private class Updater
    implements Runnable {
        public boolean stop = false;
        public Chart chart = null;

        Updater() {
        }

        public void run() {
            while (!this.stop) {
                try {
                    Thread.sleep(Chart.this.msecs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.stop) break;
                try {
                    Chart.this.triggerEvent(0);
                    if (Chart.this.reloadFrom.length() > 0) {
                        Chart.this.loader.loadFromFile(Chart.this.reloadFrom, false);
                    }
                    if (Chart.this.autoRebuild) {
                        Chart.this.loader.build(Chart.this, false, false);
                    }
                    Chart.this.triggerEvent(1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

