/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.BarDataSerie;
import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartLabel;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.Scale;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.GraphicsProvider;
import java.awt.Polygon;

public class BarPlotter3D
extends Plotter {
    public boolean verticalBars = true;
    public int barWidth = 0;
    private int originalBarWidth = -1;
    public int interBarSpace = 0;
    public double InterGroupSpace = 0.1;
    public boolean cumulative = false;
    public double barsBase = 0.0;
    public boolean fullDepth = false;
    public boolean summedLabels = true;

    private void sortCorners(int[] Xs, int[] Ys, int[] Xn, int[] Yn) {
        int minX = Xs[0];
        int maxX = Xs[0];
        int maxY = Ys[0];
        int minY = Ys[0];
        int i = 1;
        while (i < 4) {
            if (Xs[i] < minX) {
                minX = Xs[i];
            }
            if (Ys[i] < minY) {
                minY = Ys[i];
            }
            if (Xs[i] > maxX) {
                maxX = Xs[i];
            }
            if (Ys[i] > maxY) {
                maxY = Ys[i];
            }
            ++i;
        }
        Xn[0] = minX;
        Yn[0] = maxY;
        Xn[1] = maxX;
        Yn[1] = maxY;
        Xn[2] = maxX;
        Yn[2] = minY;
        Xn[3] = minX;
        Yn[3] = minY;
    }

    protected void plotSerie(ChartGraphics g, DataSerie s, int serieSec) {
        LineStyle blackLine = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.BLACK), 1);
        LineStyle whiteLine = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.WHITE), 1);
        LineStyle grayLine = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.DARKGRAY), 1);
        int seriesCount = 0;
        FillStyle darkerStyle = null;
        FillStyle negativeDarkerStyle = null;
        FillStyle lighterStyle = null;
        FillStyle negativeLighterStyle = null;
        double tmpbarsBase = this.barsBase;
        Scale tmpScaleX = this.XScale;
        if (s.secondaryXAxis != null) {
            tmpScaleX = s.secondaryXAxis.scale;
        }
        int i = 0;
        while (i < this.series.size()) {
            DataSerie tmpSerie = (DataSerie)this.series.elementAt(i);
            if (super.inSameSubChart(tmpSerie, s)) {
                if (tmpSerie == s) {
                    serieSec = seriesCount;
                }
                ++seriesCount;
            }
            ++i;
        }
        boolean firstSerie = false;
        if (serieSec != 0) {
            return;
        }
        if (!(s instanceof BarDataSerie)) {
            return;
        }
        BarDataSerie b = (BarDataSerie)s;
        int count = b.getSize();
        int initialValue = 0;
        int finalValue = count;
        int step = 1;
        int i2 = 0;
        int drawStep = 0;
        while (drawStep < 2) {
            i2 = initialValue;
            while (i2 != finalValue) {
                double cumulativeValue = 0.0;
                double cumulativeValueMinus = 0.0;
                serieSec = -1;
                int currentSerie = 0;
                while (currentSerie < this.series.size()) {
                    b = (BarDataSerie)this.series.elementAt(currentSerie);
                    if (super.inSameSubChart(b, s)) {
                        ++serieSec;
                        if (drawStep == 0 && i2 == initialValue) {
                            b.hotAreas.removeAllElements();
                        }
                        if (b.yData.size() >= i2) {
                            double YValue;
                            int GroupWidth;
                            if (serieSec == 0) {
                                firstSerie = true;
                            }
                            if (this.cumulative) {
                                seriesCount = 1;
                                serieSec = 0;
                                this.interBarSpace = 0;
                                tmpbarsBase = this.barsBase;
                            }
                            boolean isNegative = false;
                            Scale scaleSerie = null;
                            Scale scaleValue = null;
                            if (this.verticalBars) {
                                scaleSerie = super.getActiveXScale(b);
                                scaleValue = super.getActiveYScale(b);
                            } else {
                                scaleSerie = super.getActiveYScale(b);
                                scaleValue = super.getActiveXScale(b);
                            }
                            int GroupInterval = scaleSerie.getScreenCoord(scaleSerie.min + 1.0) - scaleSerie.getScreenCoord(scaleSerie.min);
                            if (GroupInterval < 0) {
                                GroupInterval *= -1;
                            }
                            if (this.originalBarWidth == -1) {
                                this.originalBarWidth = this.barWidth;
                            }
                            this.barWidth = this.originalBarWidth;
                            if (this.barWidth == 0) {
                                GroupWidth = this.InterGroupSpace < 1.0 ? (int)((double)GroupInterval * (1.0 - this.InterGroupSpace)) : (int)((double)GroupInterval - this.InterGroupSpace);
                                this.barWidth = GroupWidth / seriesCount - this.interBarSpace;
                            }
                            GroupWidth = (this.barWidth + this.interBarSpace) * seriesCount;
                            int toCenterGroup = (GroupInterval - GroupWidth) / 2;
                            int effect3D = 0;
                            if (this.fullDepth) {
                                effect3D = this.depth;
                            }
                            if (effect3D == 0) {
                                effect3D = this.barWidth / 2;
                            }
                            if (effect3D > this.depth && this.depth > 0) {
                                effect3D = this.depth;
                            }
                            if (toCenterGroup < 0) {
                                toCenterGroup = 0;
                            }
                            int barx = 0;
                            barx = (this.barWidth + this.interBarSpace) * serieSec;
                            barx = barx + toCenterGroup - GroupInterval / 2;
                            if (!this.verticalBars) {
                                barx *= -1;
                            }
                            int barSizeHeight = 0;
                            int GroupBase = 0;
                            boolean scSerie = false;
                            boolean sc = false;
                            Scale tmpScaleY = super.getActiveYScale(b);
                            int[] Xs = new int[4];
                            int[] Ys = new int[4];
                            int[] Xn = new int[4];
                            int[] Yn = new int[4];
                            int[] Xside = new int[4];
                            int[] Yside = new int[4];
                            int[] Xtop = new int[4];
                            int[] Ytop = new int[4];
                            FillStyle styletoUse = b.style;
                            if (b.barStyles != null && b.barStyles.length > i2) {
                                styletoUse = b.barStyles[i2];
                            }
                            darkerStyle = new FillStyle(styletoUse.color.darker().darker());
                            negativeDarkerStyle = b.negativeStyle == null ? darkerStyle : new FillStyle(b.negativeStyle.color.darker().darker());
                            lighterStyle = new FillStyle(styletoUse.color.darker());
                            negativeLighterStyle = b.negativeStyle == null ? lighterStyle : new FillStyle(b.negativeStyle.color.darker());
                            double XValue = (Double)b.getElementX(i2);
                            double partialYValue = YValue = ((Double)b.getElementY(i2)).doubleValue();
                            if (this.cumulative) {
                                if (partialYValue >= 0.0) {
                                    YValue += cumulativeValue;
                                    tmpbarsBase = cumulativeValue;
                                    cumulativeValue += partialYValue;
                                }
                                if (partialYValue < 0.0) {
                                    YValue += cumulativeValueMinus;
                                    tmpbarsBase = cumulativeValueMinus;
                                    cumulativeValueMinus += partialYValue;
                                }
                            }
                            if (!this.verticalBars) {
                                double t = XValue;
                                XValue = YValue;
                                YValue = t;
                            }
                            int scX = tmpScaleX.getScreenCoord(XValue);
                            int scY = tmpScaleY.getScreenCoord(YValue);
                            GroupBase = scaleSerie.getScreenCoord(scaleSerie.min + (double)i2 + 1.0);
                            FillStyle darkerStyletoUse = darkerStyle;
                            FillStyle lighterStyletoUse = lighterStyle;
                            isNegative = false;
                            if (this.verticalBars) {
                                barSizeHeight = scY;
                                Xs[0] = GroupBase + barx;
                                Ys[0] = tmpScaleY.getScreenCoord(tmpbarsBase);
                                Xs[1] = GroupBase + barx + this.barWidth;
                                Ys[1] = tmpScaleY.getScreenCoord(tmpbarsBase);
                                Xs[2] = GroupBase + barx + this.barWidth;
                                Ys[2] = barSizeHeight;
                                Xs[3] = GroupBase + barx;
                                Ys[3] = barSizeHeight;
                                Xside[1] = Xs[1];
                                Yside[1] = Ys[1];
                                Xside[2] = Xs[2];
                                Yside[2] = Ys[2];
                                Xside[0] = Xs[1] + effect3D;
                                Yside[0] = Yside[1] - effect3D;
                                Xside[3] = Xside[0];
                                Yside[3] = Ys[2] - effect3D;
                                Xtop[2] = Xs[2];
                                Ytop[2] = Ys[2];
                                Xtop[3] = Xs[3];
                                Ytop[3] = Ys[3];
                                Xtop[1] = Xside[3];
                                Ytop[1] = Yside[3];
                                Xtop[0] = Xtop[3] + effect3D;
                                Ytop[0] = Yside[3];
                                if (YValue < 0.0) {
                                    if (b.negativeStyle != null) {
                                        styletoUse = b.negativeStyle;
                                        darkerStyletoUse = negativeDarkerStyle;
                                        lighterStyletoUse = negativeLighterStyle;
                                    }
                                    isNegative = true;
                                    Xtop[2] = Xs[1];
                                    Ytop[2] = Ys[1];
                                    Xtop[3] = Xs[0];
                                    Ytop[3] = Ys[0];
                                    Xtop[1] = Xside[0];
                                    Ytop[1] = Yside[0];
                                    Xtop[0] = Xtop[3] + effect3D;
                                    Ytop[0] = Yside[0];
                                }
                            } else {
                                barSizeHeight = scX;
                                Ys[0] = GroupBase + barx;
                                Xs[0] = tmpScaleX.getScreenCoord(tmpbarsBase);
                                Ys[3] = GroupBase + barx - this.barWidth;
                                Xs[3] = tmpScaleX.getScreenCoord(tmpbarsBase);
                                Ys[2] = GroupBase + barx - this.barWidth;
                                Xs[2] = barSizeHeight;
                                Ys[1] = GroupBase + barx;
                                Xs[1] = barSizeHeight;
                                Xside[1] = Xs[1];
                                Yside[1] = Ys[1];
                                Xside[2] = Xs[2];
                                Yside[2] = Ys[2];
                                Xside[0] = Xs[1] + effect3D;
                                Yside[0] = Yside[1] - effect3D;
                                Xside[3] = Xside[0];
                                Yside[3] = Ys[2] - effect3D;
                                Xtop[2] = Xs[2];
                                Ytop[2] = Ys[2];
                                Xtop[3] = Xs[3];
                                Ytop[3] = Ys[3];
                                Xtop[1] = Xside[3];
                                Ytop[1] = Yside[3];
                                Xtop[0] = Xtop[3] + effect3D;
                                Ytop[0] = Yside[3];
                                if (XValue < 0.0) {
                                    if (b.negativeStyle != null) {
                                        styletoUse = b.negativeStyle;
                                        darkerStyletoUse = negativeDarkerStyle;
                                        lighterStyletoUse = negativeLighterStyle;
                                    }
                                    Xside[1] = Xs[0];
                                    Yside[1] = Ys[0];
                                    Xside[2] = Xs[3];
                                    Yside[2] = Ys[3];
                                    Xside[0] = Xs[0] + effect3D;
                                    Yside[0] = Yside[1] - effect3D;
                                    Xside[3] = Xside[0];
                                    Yside[3] = Ys[3] - effect3D;
                                    isNegative = true;
                                }
                            }
                            if (drawStep == 0) {
                                Polygon p = new Polygon();
                                p.addPoint(Xs[0], Ys[0]);
                                p.addPoint(Xs[1], Ys[1]);
                                p.addPoint(Xs[2], Ys[2]);
                                p.addPoint(Xs[3], Ys[3]);
                                b.hotAreas.addElement(p);
                                styletoUse.drawPolygon(g, Xs, Ys, 4);
                                if (!this.cumulative || firstSerie || !this.verticalBars) {
                                    lighterStyletoUse.drawPolygon(g, Xtop, Ytop, 4);
                                }
                                if (!this.cumulative || firstSerie || this.verticalBars) {
                                    darkerStyletoUse.drawPolygon(g, Xside, Yside, 4);
                                }
                                LineStyle border1 = grayLine;
                                LineStyle border2 = new LineStyle(0.2f, styletoUse.color.brighter(), 1);
                                if (b.border != null) {
                                    border1 = b.border;
                                }
                                if (b.border2 != null) {
                                    border2 = b.border2;
                                }
                                if (isNegative && b.negativeborder2 != null) {
                                    border2 = b.negativeborder2;
                                }
                                if (isNegative && b.negativeborder != null) {
                                    border1 = b.negativeborder;
                                }
                                if (border1 != null && b.borderType == 0) {
                                    border1.drawPolygon(g, Xs, Ys, 4);
                                    border1.drawPolygon(g, Xside, Yside, 4);
                                    border1.drawPolygon(g, Xtop, Ytop, 4);
                                }
                                this.sortCorners(Xs, Ys, Xn, Yn);
                                if ((b.borderType == 1 || b.borderType == 2) && border2 != null) {
                                    border2.draw(g, Xn[2] - 1, Yn[2], Xn[3], Yn[3]);
                                    border2.draw(g, Xn[3], Yn[3], Xn[0], Yn[0] - 1);
                                }
                            }
                            if (b.valueFont != null && drawStep == 1) {
                                ChartLabel labelf;
                                String txtValue;
                                g.setColor(b.valueColor);
                                g.setFont(b.valueFont);
                                int toCenterValue = 0;
                                double labelValue = partialYValue;
                                if (this.summedLabels && this.cumulative) {
                                    labelValue = 0.0;
                                    int k = currentSerie;
                                    while (k >= 0) {
                                        if (super.inSameSubChart((DataSerie)this.series.elementAt(k), s)) {
                                            labelValue += ((Double)((BarDataSerie)this.series.elementAt(k)).getElementY(i2)).doubleValue();
                                        }
                                        --k;
                                    }
                                }
                                if (this.verticalBars) {
                                    String txt;
                                    txtValue = txt = b.doubleToString(new Double(labelValue));
                                    if (b.labelTemplate.length() > 0) {
                                        txt = b.labelTemplate;
                                    }
                                    if (b.dataLabels != null && b.dataLabels.length > i2) {
                                        txt = b.dataLabels[i2];
                                    }
                                    labelf = new ChartLabel(txt, txtValue, false, false);
                                    labelf.initialize(g, this.chart);
                                    toCenterValue = (this.barWidth - labelf.requiredWidth) / 2;
                                    if (toCenterValue < 0) {
                                        toCenterValue = 0;
                                    }
                                    if (!isNegative) {
                                        labelf.paint(g, GroupBase + barx + toCenterValue + effect3D / 2, barSizeHeight - effect3D / 2 - 4 - labelf.requiredHeight, -1, -1);
                                    } else {
                                        labelf.paint(g, GroupBase + barx + toCenterValue, barSizeHeight + 4, -1, -1);
                                    }
                                } else {
                                    String txt;
                                    txtValue = txt = b.doubleToString(new Double(labelValue));
                                    if (b.labelTemplate.length() > 0) {
                                        txt = b.labelTemplate;
                                    }
                                    if (b.dataLabels != null && b.dataLabels.length > i2) {
                                        txt = b.dataLabels[i2];
                                    }
                                    labelf = new ChartLabel(txt, txtValue, false, false);
                                    labelf.initialize(g, this.chart);
                                    toCenterValue = (Math.abs(this.barWidth) - labelf.requiredHeight) / 2;
                                    if (toCenterValue < 0) {
                                        toCenterValue = 0;
                                    }
                                    if (!isNegative) {
                                        labelf.paint(g, barSizeHeight + 4 + effect3D, GroupBase + barx - Math.abs(this.barWidth), -1, -1);
                                    } else {
                                        labelf.paint(g, barSizeHeight - 4 - labelf.requiredWidth, GroupBase + barx - Math.abs(this.barWidth), -1, -1);
                                    }
                                }
                            }
                        }
                    }
                    ++currentSerie;
                }
                i2 += step;
            }
            ++drawStep;
        }
    }

    public void addSerie(DataSerie s) {
        double t;
        Scale tmpScaleY = this.YScale;
        Scale tmpScaleX = this.XScale;
        if (s.secondaryXAxis != null) {
            tmpScaleX = s.secondaryXAxis.scale;
        }
        if (s.secondYAxis && this.Y2Scale != null) {
            tmpScaleY = this.Y2Scale;
        } else if (s.secondaryYAxis != null) {
            tmpScaleY = s.secondaryYAxis.scale;
        }
        if (Chart.d() != 1 && s.getSize() > 10) {
            return;
        }
        if (!this.verticalBars) {
            t = tmpScaleX.max;
            tmpScaleX.max = tmpScaleY.max;
            tmpScaleY.max = t;
            t = tmpScaleX.min;
            tmpScaleX.min = tmpScaleY.min;
            tmpScaleY.min = t;
        }
        super.addSerie(s);
        if (!this.verticalBars) {
            t = tmpScaleX.max;
            tmpScaleX.max = tmpScaleY.max;
            tmpScaleY.max = t;
            t = tmpScaleX.min;
            tmpScaleX.min = tmpScaleY.min;
            tmpScaleY.min = t;
        }
    }
}

