/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.BarDataSerie;
import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartLabel;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.Scale;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.GraphicsProvider;
import java.awt.Polygon;

public class BarPlotter
extends Plotter {
    public boolean verticalBars = true;
    public int barWidth = 0;
    private int originalBarWidth = -1;
    public int interBarSpace = 0;
    public double InterGroupSpace = 0.1;
    public boolean cumulative = false;
    public boolean summedLabels = true;
    public boolean eventChart = false;
    public double barsBase = 0.0;
    public boolean cumulativeBackwardsCompatible = false;
    public boolean barAtAxis = false;
    private int[] labelsPos = null;

    private void sortCorners(int[] Xs, int[] Ys, int[] Xn, int[] Yn) {
        int minX = Xs[0];
        int maxX = Xs[0];
        int maxY = Ys[0];
        int minY = Ys[0];
        int i = 1;
        while (i < 4) {
            if (Xs[i] < minX) {
                minX = Xs[i];
            }
            if (Ys[i] < minY) {
                minY = Ys[i];
            }
            if (Xs[i] > maxX) {
                maxX = Xs[i];
            }
            if (Ys[i] > maxY) {
                maxY = Ys[i];
            }
            ++i;
        }
        Xn[0] = minX;
        Yn[0] = maxY;
        Xn[1] = maxX;
        Yn[1] = maxY;
        Xn[2] = maxX;
        Yn[2] = minY;
        Xn[3] = minX;
        Yn[3] = minY;
    }

    protected void plotSerie(ChartGraphics g, DataSerie s, int serieSec) {
        int toCenterGroup;
        int GroupWidth;
        int GroupInterval;
        LineStyle blackLine = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.BLACK), 1);
        LineStyle whiteLine = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.WHITE), 1);
        LineStyle grayLine = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.DARKGRAY), 1);
        int seriesCount = 0;
        int serieOrder = serieSec;
        int i = 0;
        while (i < this.series.size()) {
            DataSerie tmpSerie = (DataSerie)this.series.elementAt(i);
            if (this.inSameSubChart(tmpSerie, s)) {
                if (tmpSerie == s) {
                    serieSec = seriesCount;
                }
                ++seriesCount;
            }
            ++i;
        }
        Scale tmpScaleX = super.getActiveXScale(s);
        if (this.cumulative || this.eventChart) {
            seriesCount = 1;
            serieSec = 0;
            this.interBarSpace = 0;
        }
        boolean isNegative = false;
        Scale scaleSerie = null;
        Scale scaleValue = null;
        if (this.verticalBars) {
            scaleSerie = super.getActiveXScale(s);
            scaleValue = super.getActiveYScale(s);
        } else {
            scaleSerie = super.getActiveYScale(s);
            scaleValue = super.getActiveXScale(s);
        }
        s.hotAreas.removeAllElements();
        if (!(s instanceof BarDataSerie)) {
            return;
        }
        BarDataSerie b = (BarDataSerie)s;
        if (serieOrder == 0) {
            this.labelsPos = new int[s.getSize()];
        }
        if ((GroupInterval = scaleSerie.getScreenCoord(scaleSerie.min + 1.0) - scaleSerie.getScreenCoord(scaleSerie.min)) < 0) {
            GroupInterval *= -1;
        }
        if (this.originalBarWidth == -1) {
            this.originalBarWidth = this.barWidth;
        }
        this.barWidth = this.originalBarWidth;
        if (this.barWidth == 0) {
            GroupWidth = this.InterGroupSpace < 1.0 ? (int)((double)GroupInterval * (1.0 - this.InterGroupSpace)) : (int)((double)GroupInterval - this.InterGroupSpace);
            this.barWidth = GroupWidth / seriesCount - this.interBarSpace;
        }
        if ((toCenterGroup = (GroupInterval - (GroupWidth = (this.barWidth + this.interBarSpace) * seriesCount)) / 2) < 0) {
            toCenterGroup = 0;
        }
        int barx = 0;
        barx = (this.barWidth + this.interBarSpace) * serieSec;
        barx = barx + toCenterGroup - GroupInterval / 2;
        if (!this.verticalBars) {
            barx *= -1;
        }
        int barSizeHeight = 0;
        int GroupBase = 0;
        int count = b.getSize();
        boolean scSerie = false;
        boolean sc = false;
        Scale tmpScaleY = super.getActiveYScale(s);
        int[] Xs = new int[4];
        int[] Ys = new int[4];
        int[] Xn = new int[4];
        int[] Yn = new int[4];
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int i2 = 0;
        while (i2 < count) {
            double XValue = (Double)b.getElementX(i2);
            double YValue = (Double)b.getElementY(i2);
            double tmpbarsBase = this.barsBase;
            if (b.barStart.size() > i2) {
                tmpbarsBase = (Double)b.barStart.elementAt(i2);
            }
            if (this.cumulative && !this.cumulativeBackwardsCompatible) {
                int k = serieOrder + 1;
                while (k < this.series.size()) {
                    BarDataSerie tmpBarSerie = (BarDataSerie)this.series.elementAt(k);
                    if (this.inSameSubChart(tmpBarSerie, s)) {
                        YValue += ((Double)tmpBarSerie.getElementY(i2)).doubleValue();
                    }
                    ++k;
                }
                YValue += tmpbarsBase;
            }
            GroupBase = scaleSerie.getScreenCoord(XValue + 1.0);
            if (this.barAtAxis) {
                GroupBase = scaleSerie.getScreenCoord(XValue);
            }
            if (!this.verticalBars) {
                double t = XValue;
                XValue = YValue;
                YValue = t;
            }
            int scX = tmpScaleX.getScreenCoord(XValue);
            int scY = tmpScaleY.getScreenCoord(YValue);
            FillStyle styletoUse = b.style;
            isNegative = false;
            if (this.verticalBars) {
                barSizeHeight = scY;
                Xs[0] = GroupBase + barx;
                Ys[0] = tmpScaleY.getScreenCoord(tmpbarsBase);
                Xs[1] = GroupBase + barx + this.barWidth;
                Ys[1] = tmpScaleY.getScreenCoord(tmpbarsBase);
                Xs[2] = GroupBase + barx + this.barWidth;
                Ys[2] = barSizeHeight;
                Xs[3] = GroupBase + barx;
                Ys[3] = barSizeHeight;
                x1 = Xs[3];
                y1 = Ys[3];
                x2 = Xs[1];
                y2 = Ys[1];
                if (YValue < 0.0) {
                    if (b.negativeStyle != null) {
                        styletoUse = b.negativeStyle;
                    }
                    isNegative = true;
                    x1 = Xs[0];
                    y1 = Ys[0];
                    x2 = Xs[2];
                    y2 = Ys[2];
                }
            } else {
                barSizeHeight = scX;
                Ys[0] = GroupBase + barx;
                Xs[0] = tmpScaleX.getScreenCoord(tmpbarsBase);
                Ys[3] = GroupBase + barx - this.barWidth;
                Xs[3] = tmpScaleX.getScreenCoord(tmpbarsBase);
                Ys[2] = GroupBase + barx - this.barWidth;
                Xs[2] = barSizeHeight;
                Ys[1] = GroupBase + barx;
                Xs[1] = barSizeHeight;
                x1 = Xs[3];
                y1 = Ys[3];
                x2 = Xs[1];
                y2 = Ys[1];
                if (XValue < 0.0) {
                    if (b.negativeStyle != null) {
                        styletoUse = b.negativeStyle;
                    }
                    isNegative = true;
                    x1 = Xs[2];
                    y1 = Ys[2];
                    x2 = Xs[0];
                    y2 = Ys[0];
                }
            }
            if (b.barStyles != null && b.barStyles.length > i2) {
                styletoUse = b.barStyles[i2];
            }
            Polygon p = new Polygon();
            p.addPoint(Xs[0], Ys[0]);
            p.addPoint(Xs[1], Ys[1]);
            p.addPoint(Xs[2], Ys[2]);
            p.addPoint(Xs[3], Ys[3]);
            s.hotAreas.addElement(p);
            styletoUse.draw(g, x1, y1, x2, y2);
            LineStyle border1 = grayLine;
            LineStyle border2 = whiteLine;
            if (b.border != null) {
                border1 = b.border;
            }
            if (b.border2 != null) {
                border2 = b.border2;
            }
            if (isNegative && b.negativeborder2 != null) {
                border2 = b.negativeborder2;
            }
            if (isNegative && b.negativeborder != null) {
                border1 = b.negativeborder;
            }
            if (border1 != null && b.borderType == 0) {
                border1.drawPolygon(g, Xs, Ys, 4);
            }
            this.sortCorners(Xs, Ys, Xn, Yn);
            if (b.borderType == 2) {
                if (border2 != null) {
                    border2.draw(g, Xn[2], Yn[2], Xn[3], Yn[3]);
                    border2.draw(g, Xn[3], Yn[3], Xn[0], Yn[0]);
                }
                if (border1 != null) {
                    border1.draw(g, Xn[0], Yn[0], Xn[1], Yn[1]);
                    border1.draw(g, Xn[1], Yn[1], Xn[2], Yn[2]);
                }
            }
            if (b.borderType == 1) {
                if (border1 != null) {
                    border2.draw(g, Xn[0], Yn[0], Xn[1], Yn[1]);
                    border2.draw(g, Xn[1], Yn[1], Xn[2], Yn[2]);
                }
                if (border2 != null) {
                    border1.draw(g, Xn[2], Yn[2], Xn[3], Yn[3]);
                    border1.draw(g, Xn[3], Yn[3], Xn[0], Yn[0]);
                }
            }
            if (b.valueFont != null) {
                ChartLabel labelf;
                String txtValue;
                String txt;
                g.setColor(b.valueColor);
                g.setFont(b.valueFont);
                int toCenterValue = 0;
                if (this.verticalBars) {
                    if (!this.summedLabels) {
                        YValue = (Double)b.getElementY(i2);
                    }
                    txt = b.doubleToString(new Double(YValue));
                    if (this.cumulative && (Double)b.getElementY(i2) == 0.0) {
                        txt = "";
                    }
                    txtValue = txt;
                    if (b.labelTemplate.length() > 0) {
                        txt = b.labelTemplate;
                    }
                    if (b.dataLabels != null && b.dataLabels.length > i2) {
                        txt = b.dataLabels[i2];
                    }
                    labelf = new ChartLabel(txt, txtValue, false, false);
                    labelf.initialize(g, this.chart);
                    toCenterValue = labelf.requiredWidth / 2;
                    if (toCenterValue < 0) {
                        toCenterValue = 0;
                    }
                    if (!isNegative) {
                        int tmpY = barSizeHeight - 4 - labelf.requiredHeight;
                        if (this.labelsPos.length > i2 && this.cumulative) {
                            if (serieOrder > 0 && tmpY - labelf.requiredHeight < this.labelsPos[i2] && super.inSameSubChart((DataSerie)this.series.elementAt(serieOrder - 1), s)) {
                                tmpY = this.labelsPos[i2] - labelf.requiredHeight;
                            }
                            if (txt.trim().length() > 0) {
                                this.labelsPos[i2] = tmpY;
                            }
                        }
                        labelf.paint(g, GroupBase + barx + toCenterValue, tmpY, -1, -1);
                    } else {
                        labelf.paint(g, GroupBase + barx + toCenterValue, barSizeHeight + 4, -1, -1);
                    }
                } else {
                    if (!this.summedLabels) {
                        XValue = (Double)b.getElementY(i2);
                    }
                    txt = b.doubleToString(new Double(XValue));
                    if (this.eventChart) {
                        txt = b.doubleToString(new Double(XValue - tmpbarsBase));
                        if (XValue - tmpbarsBase == (double)((int)XValue) - tmpbarsBase) {
                            txt = new Integer((int)(XValue - tmpbarsBase)).toString();
                        }
                    } else if (XValue == (double)((int)XValue)) {
                        txt = new Integer((int)XValue).toString();
                    }
                    if (this.cumulative && (Double)b.getElementY(i2) == 0.0) {
                        txt = "";
                    }
                    txtValue = txt;
                    if (b.labelTemplate.length() > 0) {
                        txt = b.labelTemplate;
                    }
                    if (b.dataLabels != null && b.dataLabels.length > i2) {
                        txt = b.dataLabels[i2];
                    }
                    labelf = new ChartLabel(txt, txtValue, false, false);
                    labelf.initialize(g, this.chart);
                    toCenterValue = (Math.abs(this.barWidth) - labelf.requiredHeight) / 2;
                    if (toCenterValue < 0) {
                        toCenterValue = 0;
                    }
                    if (this.eventChart) {
                        labelf.paint(g, barSizeHeight - 4 - labelf.requiredWidth, GroupBase - barx - labelf.requiredHeight, -1, -1);
                    } else if (!isNegative) {
                        labelf.paint(g, barSizeHeight + 4, GroupBase + barx - this.barWidth, -1, -1);
                    } else {
                        labelf.paint(g, barSizeHeight - 4 - labelf.requiredWidth, GroupBase + barx - this.barWidth, -1, -1);
                    }
                }
            }
            ++i2;
        }
    }

    public void addSerie(DataSerie s) {
        double t;
        Scale tmpScaleY = super.getActiveYScale(s);
        Scale tmpScaleX = super.getActiveXScale(s);
        if (Chart.d() != 1 && s.getSize() > 10) {
            return;
        }
        if (!this.verticalBars) {
            t = tmpScaleX.max;
            tmpScaleX.max = tmpScaleY.max;
            tmpScaleY.max = t;
            t = tmpScaleX.min;
            tmpScaleX.min = tmpScaleY.min;
            tmpScaleY.min = t;
        }
        super.addSerie(s);
        if (!this.verticalBars) {
            t = tmpScaleX.max;
            tmpScaleX.max = tmpScaleY.max;
            tmpScaleY.max = t;
            t = tmpScaleX.min;
            tmpScaleX.min = tmpScaleY.min;
            tmpScaleY.min = t;
        }
    }
}

