/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Axis;
import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartLabel;
import com.java4less.rchart.ChartLoader;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.gc.ChartGraphics;

public class AxisTargetZone {
    protected static int DISABLED = -1;
    public int unitStart = 0;
    public int unitEnd = 0;
    public double positionStart = DISABLED;
    public LineStyle style = null;
    public double positionEnd = DISABLED;
    public FillStyle fillStyle;
    public String label = "";
    protected Chart chart = null;

    public AxisTargetZone(double start, double end, int uStart, int uEnd) {
        this.unitStart = uStart;
        this.unitEnd = uEnd;
        this.positionStart = start;
        this.positionEnd = end;
    }

    protected void paint(ChartGraphics g, Axis axis, Axis peerAxis, int axisPosition) {
        String labelPrefix = "@COLOR value='BLACK'@@FONT value='Arial|NORMAL|10'@";
        boolean vertical = axis.orientation == 1;
        int pixelStart = 0;
        if (this.positionStart != (double)DISABLED) {
            if (this.unitStart == 1) {
                double tmp = (axis.scale.max - axis.scale.min) * this.positionStart / 100.0;
                pixelStart = axis.scale.getScreenCoord(tmp);
            } else {
                if (this.positionStart < axis.scale.min) {
                    this.positionStart = axis.scale.min;
                }
                if (this.positionStart > axis.scale.max) {
                    this.positionStart = axis.scale.max;
                }
                pixelStart = axis.scale.getScreenCoord(this.positionStart);
            }
        }
        int pixelEnd = 0;
        if (this.positionEnd != (double)DISABLED) {
            if (this.unitEnd == 1) {
                double tmp = (axis.scale.max - axis.scale.min) * this.positionEnd / 100.0;
                pixelEnd = axis.scale.getScreenCoord(tmp);
                if (this.positionEnd >= 100.0 && axis.orientation == 0) {
                    pixelEnd = axis.x + axis.visibleSize;
                }
                if (this.positionEnd >= 100.0 && axis.orientation == 1) {
                    pixelEnd = axis.y;
                }
            } else {
                if (this.positionEnd < axis.scale.min) {
                    this.positionEnd = axis.scale.min;
                }
                if (this.positionEnd > axis.scale.max) {
                    this.positionEnd = axis.scale.max;
                }
                pixelEnd = axis.scale.getScreenCoord(this.positionEnd);
            }
        }
        if (!vertical) {
            int hStart = axisPosition;
            int hEnd = axisPosition + axis.barWidth;
            if (this.fillStyle != null && pixelEnd >= 0) {
                int y1 = hStart;
                int x1 = pixelStart;
                int y2 = hEnd;
                int x2 = pixelEnd;
                if (y2 < y1) {
                    y2 = hStart;
                    y1 = hEnd;
                }
                if (x2 < x1) {
                    x1 = pixelEnd;
                    x2 = pixelStart;
                }
                this.fillStyle.draw(g, x1, y1, x2, y2);
            }
            if (this.style != null && pixelStart >= 0) {
                this.style.draw(g, pixelStart, hStart, pixelStart, hEnd);
            }
            if (this.style != null && pixelEnd >= 0) {
                this.style.draw(g, pixelEnd, hStart, pixelEnd, hEnd);
            }
            if (this.label.length() > 0) {
                ChartLabel clabel = new ChartLabel(String.valueOf(labelPrefix) + this.label, "", false, false);
                clabel.initialize(g, this.chart);
                if (!axis.xscaleOnTop) {
                    clabel.paint(g, pixelStart, hEnd, -1, -1);
                } else {
                    clabel.paint(g, pixelStart, hStart - clabel.requiredHeight, -1, -1);
                }
            }
        } else {
            int wStart = axisPosition;
            int wEnd = axisPosition + axis.barWidth;
            if (this.fillStyle != null && pixelEnd >= 0) {
                int x1 = wStart;
                int y1 = pixelStart;
                int x2 = wEnd;
                int y2 = pixelEnd;
                if (x2 < x1) {
                    x2 = wStart;
                    x1 = wEnd;
                }
                if (y2 < y1) {
                    y1 = pixelEnd;
                    y2 = pixelStart;
                }
                this.fillStyle.draw(g, x1, y1, x2, y2);
            }
            if (this.style != null && pixelStart >= 0) {
                this.style.draw(g, wStart, pixelStart, wEnd, pixelStart);
            }
            if (this.style != null && pixelEnd >= 0) {
                this.style.draw(g, wStart, pixelEnd, wEnd, pixelEnd);
            }
            if (this.label.length() > 0) {
                ChartLabel clabel = new ChartLabel("@rotation value='0' center='LEFTTOP'@" + labelPrefix + this.label, "", false, false);
                clabel.initialize(g, this.chart);
                if (!axis.rightAxis) {
                    clabel.paint(g, wStart - clabel.getRotatedWidth(), pixelEnd, -1, -1);
                } else {
                    clabel.paint(g, wEnd, pixelEnd, -1, -1);
                }
            }
        }
    }

    public static AxisTargetZone createFromString(String s) {
        if (s.length() == 0) {
            return null;
        }
        String[] items = ChartLoader.convertList(s, ";");
        double start = DISABLED;
        double end = DISABLED;
        int uStart = 0;
        int uEnd = 0;
        try {
            if (items.length > 0) {
                if (items[0].endsWith("%")) {
                    start = new Double(items[0].substring(0, items[0].length() - 1));
                    uStart = 1;
                } else {
                    start = new Double(items[0]);
                }
            }
            if (items.length > 1) {
                if (items[1].endsWith("%")) {
                    end = new Double(items[1].substring(0, items[1].length() - 1));
                    uEnd = 1;
                } else {
                    end = new Double(items[1]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        AxisTargetZone zone = new AxisTargetZone(start, end, uStart, uEnd);
        if (items.length > 2) {
            zone.style = ChartLoader.convertLineStyle(items[2]);
        }
        if (items.length > 3) {
            zone.fillStyle = ChartLoader.convertFillStyle(items[3]);
        }
        if (items.length > 4) {
            zone.label = items[4];
        }
        return zone;
    }
}

