/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.AxisTargetZone;
import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartComponent;
import com.java4less.rchart.ChartLabel;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.LogScale;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.Scale;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.ChartFont;
import com.java4less.rchart.gc.ChartGraphics;
import com.java4less.rchart.gc.GraphicsProvider;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class Axis
extends ChartComponent {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int CEROAXIS_LINE = 0;
    public static final int CEROAXIS_NO = 1;
    public static final int CEROAXIS_SCALE = 2;
    public static final int BAR_STYLE_NONE = 0;
    public static final int BAR_STYLE_BAR = 1;
    public static final int BAR_STYLE_RAISED_BAR = 2;
    public String label = "";
    public int barStyle = 0;
    public int barWidth = 12;
    public FillStyle barFilling = null;
    public boolean xscaleOnTop = false;
    public boolean axisFrame = false;
    public String dateLabelFormat = "dd-MMM-yyyy";
    public String dateStep = "d";
    public boolean dateStepPerUnit = false;
    public Date initialDate = null;
    protected int realPosition;
    protected int visibleSize = 0;
    protected int offset;
    private int maxTickLabelLength = 0;
    public boolean IntegerScale = false;
    public int autoNumberOfTicks = 0;
    public double[] ticks_preferred_Interval = new double[]{0.1, 0.5, 1.0, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0, 1000.0, 5000.0, 10000.0, 50000.0, 100000.0, 500000.0, 1000000.0};
    public String scaleLabelFormat = "";
    public String labelTemplate = "";
    public boolean logarithmicIntervals = false;
    public Scale scale;
    public boolean bigTicksGrid = false;
    public double scaleTickInterval = 1.0;
    public int bigTickInterval = 1;
    public int[] bigTickIntervalList;
    public int tickPixels = 4;
    public int bigTickPixels = 9;
    public Plotter plot;
    public Axis peerAxis;
    public int ceroAxis = 0;
    public LineStyle ceroAxisStyle = new LineStyle(0.2f, GraphicsProvider.getColor(ChartColor.DARKGRAY), 1);
    public boolean tickAtBase = false;
    public int rotateLabels = 0;
    public LineStyle style = new LineStyle(2.0f, GraphicsProvider.getColor(ChartColor.BLACK), 1);
    public LineStyle gridStyle = null;
    public FillStyle gridFillStyle = null;
    public int orientation;
    protected boolean rightAxis = false;
    public ChartColor DescColor = GraphicsProvider.getColor(ChartColor.BLACK);
    public ChartFont DescFont = GraphicsProvider.getFont("Arial", ChartFont.PLAIN, 10);
    public String[] tickLabels = null;
    public boolean startWithBigTick = false;
    public int tickLabelLength = 1000;
    protected Vector targetZones = new Vector();
    protected boolean isMainAxis = true;
    protected Axis mainAxis = null;
    protected Vector additionalAxis = new Vector();
    public boolean stackAdditionalAxis = false;

    public void addAdditionalAxis(Axis axis) {
        axis.isMainAxis = false;
        axis.mainAxis = this;
        this.additionalAxis.addElement(axis);
    }

    protected int getAdditionalAxisCount() {
        return this.additionalAxis.size();
    }

    protected Axis getAdditionalAxis(int i) {
        return (Axis)this.additionalAxis.elementAt(i);
    }

    public static double convertFromDate(Date d, String dateStep, Date initialDate) {
        long diff = d.getTime() - initialDate.getTime();
        double diff2 = diff;
        int step = 1;
        if (dateStep.length() > 1) {
            step = new Integer(dateStep.substring(1, dateStep.length()));
        }
        if (dateStep.toLowerCase().indexOf("d") == 0) {
            diff2 = (double)diff / 8.64E7;
        }
        if (dateStep.toLowerCase().indexOf("m") == 0) {
            diff2 = (double)diff / 8.64E7;
            diff2 /= 30.0;
        }
        if (dateStep.toLowerCase().indexOf("w") == 0) {
            diff2 = (double)diff / 8.64E7;
            diff2 /= 7.0;
        }
        if (dateStep.toLowerCase().indexOf("y") == 0) {
            diff2 = (double)diff / 8.64E7;
            diff2 /= 365.0;
        }
        if (dateStep.toLowerCase().indexOf("h") == 0) {
            diff2 = (double)diff / 3600000.0;
        }
        if (dateStep.toLowerCase().indexOf("s") == 0) {
            diff2 = (double)diff / 1000.0;
        }
        if (dateStep.toLowerCase().indexOf("n") == 0) {
            diff2 = (double)diff / 60000.0;
        }
        return diff2 /= (double)step;
    }

    public Axis(int o, Scale s) {
        this.orientation = o;
        this.scale = s;
        if (o == 1) {
            this.scale.reverse = true;
        }
    }

    protected void drawForeground(ChartGraphics g, Axis peerAxis) {
        if (this.isMainAxis && !this.xscaleOnTop) {
            int i = 0;
            while (i < this.additionalAxis.size()) {
                Axis a = (Axis)this.additionalAxis.elementAt(i);
                a.draw(g, peerAxis, true, false);
                ++i;
            }
        }
        this.draw(g, peerAxis, true, false);
    }

    protected void drawBackground(ChartGraphics g, Axis peerAxis) {
        this.maxTickLabelLength = 0;
        int tmpX = this.x;
        int tmpY = this.y;
        int realPositionY = this.realPosition;
        if (this.isMainAxis && !this.xscaleOnTop) {
            int i = 0;
            while (i < this.additionalAxis.size()) {
                Axis a = (Axis)this.additionalAxis.elementAt(i);
                a.mainAxis = this;
                if (this.rightAxis) {
                    a.rightAxis = true;
                }
                if (this.xscaleOnTop) {
                    a.xscaleOnTop = true;
                }
                if (!this.stackAdditionalAxis) {
                    if (this.orientation == 0 && !this.xscaleOnTop) {
                        tmpY += this.height;
                        a.realPosition = realPositionY += this.height;
                    }
                    if (this.orientation == 0 && this.xscaleOnTop) {
                        tmpY -= this.height;
                        a.realPosition = realPositionY -= this.height;
                    }
                    if (this.orientation == 1 && !this.rightAxis) {
                        tmpX -= this.width;
                    }
                    if (this.orientation == 1 && this.rightAxis) {
                        tmpX += this.width;
                    }
                    a.x = tmpX;
                    a.y = tmpY;
                    a.width = this.width;
                    a.height = this.height;
                    a.scale.screenMax = this.scale.screenMax;
                    a.scale.screenMaxMargin = this.scale.screenMaxMargin;
                    a.scale.screenMin = this.scale.screenMin;
                } else if (this.orientation == 1) {
                    a.x = this.x;
                } else {
                    a.y = this.y;
                }
                a.chart = this.chart;
                a.plot = this.plot;
                a.isMainAxis = false;
                a.visibleSize = this.visibleSize;
                a.draw(g, peerAxis, false, false);
                ++i;
            }
        }
        this.mainAxis = this;
        this.draw(g, peerAxis, false, false);
    }

    protected void drawGridBackground(ChartGraphics g, Axis peerAxis) {
        this.draw(g, peerAxis, false, true);
    }

    public void addTargetZone(AxisTargetZone zone) {
        if (zone != null) {
            this.targetZones.addElement(zone);
        }
    }

    public void removeTargetZones() {
        this.targetZones.removeAllElements();
    }

    public AxisTargetZone[] getTargetZones() {
        AxisTargetZone[] a = new AxisTargetZone[this.targetZones.size()];
        int i = 0;
        while (i < a.length) {
            a[i] = (AxisTargetZone)this.targetZones.elementAt(i);
            ++i;
        }
        return a;
    }

    protected void paintTargetZones(ChartGraphics g, Axis peerAxis, int position) {
        int i = 0;
        while (i < this.targetZones.size()) {
            AxisTargetZone z = (AxisTargetZone)this.targetZones.elementAt(i);
            z.chart = this.chart;
            z.paint(g, this, peerAxis, position);
            ++i;
        }
    }

    private String[] splitText(String s) {
        String[] r = new String[100];
        int lines = 0;
        if (this.tickLabelLength == 0) {
            this.tickLabelLength = 1000;
        }
        while (s.indexOf("\\n") > -1 || s.length() > this.tickLabelLength) {
            if (s.indexOf("\\n") > -1 && s.indexOf("\\n") < this.tickLabelLength) {
                r[lines] = s.substring(0, s.indexOf("\\n"));
                s = s.substring(s.indexOf("\\n") + 2, s.length());
            } else {
                r[lines] = s.substring(0, this.tickLabelLength);
                s = s.substring(this.tickLabelLength, s.length());
            }
            if (++lines >= r.length) break;
        }
        r[lines] = s;
        String[] a = new String[lines + 1];
        int i = 0;
        while (i <= lines) {
            a[i] = r[i];
            ++i;
        }
        return a;
    }

    public void draw(ChartGraphics g, Axis peerAxis, boolean drawForeGround, boolean drawGridBackground) {
        double range = this.scale.max - this.scale.min;
        int numberBigTicks = 0;
        int numberTicks = 0;
        if (this.scale.min < 0.0 && this.scale.max < 0.0) {
            range = (this.scale.min - this.scale.max) * -1.0;
        }
        int bigTickCount = 0;
        int axisPosition = 0;
        int axisCeroPosition = 0;
        boolean drawTick = true;
        int effect3D = this.plot.depth;
        if (!this.isMainAxis && !this.mainAxis.stackAdditionalAxis) {
            effect3D = 0;
        }
        int lastGridPosition = 0;
        boolean fillGrid = false;
        double usedTickInterval = this.scaleTickInterval;
        if (this.autoNumberOfTicks > 0) {
            usedTickInterval = Math.abs(range / (double)this.autoNumberOfTicks);
            int proposedNumberOfTicks = 0;
            double bestTickInterval = usedTickInterval;
            if (this.ticks_preferred_Interval != null && this.ticks_preferred_Interval.length > 0) {
                int j = 0;
                while (j < this.ticks_preferred_Interval.length) {
                    int newProposedNumberOfTicks;
                    if (proposedNumberOfTicks == 0) {
                        proposedNumberOfTicks = (int)Math.abs(range / this.ticks_preferred_Interval[j]);
                    }
                    if (Math.abs((newProposedNumberOfTicks = (int)Math.abs(range / this.ticks_preferred_Interval[j])) - this.autoNumberOfTicks) < Math.abs(proposedNumberOfTicks - this.autoNumberOfTicks)) {
                        proposedNumberOfTicks = newProposedNumberOfTicks;
                        usedTickInterval = bestTickInterval = this.ticks_preferred_Interval[j];
                    }
                    ++j;
                }
            }
        }
        if (peerAxis.scale.min < 0.0 && peerAxis.scale.max > 0.0) {
            axisCeroPosition = peerAxis.scale.getScreenCoord(0.0);
        }
        if (this.orientation == 0) {
            axisPosition = this.ceroAxis == 2 && axisCeroPosition != 0 ? axisCeroPosition : this.realPosition;
            if (drawForeGround) {
                if (!this.xscaleOnTop || this.axisFrame) {
                    this.style.draw(g, this.x, axisPosition, this.x + this.visibleSize, axisPosition);
                    if (!this.xscaleOnTop) {
                        if (this.barFilling != null && this.barStyle != 0) {
                            this.barFilling.draw(g, this.x, axisPosition, this.x + this.visibleSize, axisPosition + this.barWidth);
                        }
                        this.paintTargetZones(g, peerAxis, axisPosition);
                        if (this.barStyle == 1) {
                            this.style.drawRect(g, this.x, axisPosition, this.x + this.visibleSize, axisPosition + this.barWidth);
                        }
                        if (this.label.length() > 0) {
                            ChartLabel clabel = new ChartLabel(this.label, "", false, false);
                            g.setColor(this.DescColor);
                            g.setFont(this.DescFont);
                            clabel.initialize(g, this.chart);
                            if (this.mainAxis.stackAdditionalAxis) {
                                clabel.paint(g, this.x, this.y + this.height - clabel.requiredHeight, 0, 0);
                            } else {
                                clabel.paint(g, this.x - clabel.requiredWidth - 4, axisPosition, 0, 0);
                            }
                        }
                    }
                }
                if ((this.axisFrame || this.xscaleOnTop) && peerAxis != null && effect3D == 0) {
                    this.style.draw(g, this.x, axisPosition - peerAxis.visibleSize, this.x + this.visibleSize, axisPosition - peerAxis.visibleSize);
                    if (this.xscaleOnTop) {
                        if (this.barFilling != null && this.barStyle != 0) {
                            this.barFilling.draw(g, this.x, axisPosition - this.barWidth, this.x + this.visibleSize, axisPosition);
                        }
                        this.paintTargetZones(g, peerAxis, axisPosition - this.barWidth);
                        if (this.barStyle == 1) {
                            this.style.drawRect(g, this.x, axisPosition - this.barWidth, this.x + this.visibleSize, axisPosition);
                        }
                        if (this.label.length() > 0) {
                            ChartLabel clabel = new ChartLabel(this.label, "", false, false);
                            g.setColor(this.DescColor);
                            g.setFont(this.DescFont);
                            clabel.initialize(g, this.chart);
                            if (this.mainAxis.stackAdditionalAxis) {
                                clabel.paint(g, this.x, this.y, 0, 0);
                            } else {
                                clabel.paint(g, this.x - clabel.requiredWidth - 4, axisPosition - this.barWidth, 0, 0);
                            }
                        }
                    }
                }
            }
            if (!drawForeGround && !drawGridBackground) {
                int[] xs = new int[4];
                int[] ys = new int[4];
                int minPosition = peerAxis.scale.getScreenCoord(peerAxis.scale.min);
                int maxPosition = peerAxis.scale.getScreenCoord(peerAxis.scale.max);
                xs[0] = this.x + effect3D + this.offset;
                ys[0] = axisPosition + peerAxis.offset - effect3D;
                xs[1] = this.x + this.visibleSize + effect3D + this.offset;
                ys[1] = axisPosition + peerAxis.offset - effect3D;
                xs[2] = this.x + this.visibleSize + this.offset;
                ys[2] = axisPosition + peerAxis.offset;
                xs[3] = this.x + this.offset;
                ys[3] = axisPosition + peerAxis.offset;
                if (!this.rightAxis) {
                    if (effect3D != 0) {
                        this.style.draw(g, xs[0], ys[0], xs[1], ys[1]);
                    }
                    if (effect3D != 0) {
                        this.style.draw(g, xs[2], ys[2], xs[1], ys[1]);
                    }
                    if (effect3D != 0) {
                        this.style.draw(g, xs[3], ys[3], xs[0], ys[0]);
                    }
                    if (effect3D != 0) {
                        this.style.draw(g, xs[0], this.plot.y - effect3D + peerAxis.offset, xs[1], this.plot.y - effect3D + peerAxis.offset);
                    }
                }
            }
            if (axisCeroPosition != 0 && this.ceroAxis == 0 && !drawForeGround) {
                this.ceroAxisStyle.draw(g, this.x, axisCeroPosition, this.x + this.width, axisCeroPosition);
                if (!this.rightAxis) {
                    if (effect3D != 0) {
                        this.ceroAxisStyle.draw(g, this.x + effect3D, axisCeroPosition - effect3D, this.x + this.width + effect3D, axisCeroPosition - effect3D);
                    }
                    if (effect3D != 0) {
                        this.ceroAxisStyle.draw(g, this.x, axisCeroPosition, this.x + effect3D, axisCeroPosition - effect3D);
                    }
                    if (effect3D != 0) {
                        this.ceroAxisStyle.draw(g, this.x + this.width, axisCeroPosition, this.x + this.width + effect3D, axisCeroPosition - effect3D);
                    }
                }
            }
        } else {
            axisPosition = this.ceroAxis == 2 && axisCeroPosition != 0 ? axisCeroPosition : (!this.isMainAxis && this.rightAxis ? this.x : (this.rightAxis ? this.realPosition : this.x + this.width));
            if (drawForeGround) {
                this.style.draw(g, axisPosition, this.y, axisPosition, this.y + this.visibleSize);
                if (this.axisFrame && peerAxis != null && effect3D == 0 && !this.rightAxis) {
                    this.style.draw(g, axisPosition + peerAxis.visibleSize, this.y, axisPosition + peerAxis.visibleSize, this.y + this.visibleSize);
                }
                if (!this.rightAxis) {
                    if (this.barFilling != null && this.barStyle != 0) {
                        this.barFilling.draw(g, axisPosition - this.barWidth, this.y, axisPosition, this.y + this.visibleSize);
                    }
                    this.paintTargetZones(g, peerAxis, axisPosition - this.barWidth);
                    if (this.barStyle == 1) {
                        this.style.drawRect(g, axisPosition - this.barWidth, this.y, axisPosition, this.y + this.visibleSize);
                    }
                    if (this.label.length() > 0) {
                        ChartLabel clabel = new ChartLabel("@rotation value='90' center='LEFTTOP'@" + this.label, "", false, false);
                        g.setColor(this.DescColor);
                        g.setFont(this.DescFont);
                        clabel.initialize(g, this.chart);
                        if (this.mainAxis.stackAdditionalAxis) {
                            clabel.paint(g, this.x, this.y, 0, 0);
                        } else {
                            clabel.paint(g, axisPosition - this.barWidth, this.y + this.visibleSize + 4, 0, 0);
                        }
                    }
                }
                if (this.rightAxis) {
                    if (this.barFilling != null && this.barStyle != 0) {
                        this.barFilling.draw(g, axisPosition, this.y, axisPosition + this.barWidth, this.y + this.visibleSize);
                    }
                    this.paintTargetZones(g, peerAxis, axisPosition);
                    if (this.barStyle == 1) {
                        this.style.drawRect(g, axisPosition, this.y, axisPosition + this.barWidth, this.y + this.visibleSize);
                    }
                    if (this.label.length() > 0) {
                        ChartLabel clabel = new ChartLabel("@rotation value='90'  center='LEFTTOP'@" + this.label, "", false, false);
                        g.setColor(this.DescColor);
                        g.setFont(this.DescFont);
                        clabel.initialize(g, this.chart);
                        if (this.mainAxis.stackAdditionalAxis) {
                            clabel.paint(g, axisPosition + this.width - clabel.requiredHeight, this.y, 0, 0);
                        } else {
                            clabel.paint(g, axisPosition, this.y + this.visibleSize + 4, 0, 0);
                        }
                    }
                }
            }
            if (!drawForeGround && !drawGridBackground) {
                int[] xs = new int[4];
                int[] ys = new int[4];
                int[] xs2 = new int[4];
                int[] ys2 = new int[4];
                int minPosition = peerAxis.scale.getScreenCoord(peerAxis.scale.min);
                int maxPosition = peerAxis.scale.getScreenCoord(peerAxis.scale.max);
                xs[0] = axisPosition + peerAxis.offset + effect3D;
                ys[0] = this.y - effect3D + this.offset;
                xs[1] = axisPosition + peerAxis.offset + effect3D;
                ys[1] = this.y + this.visibleSize - effect3D + this.offset;
                xs[2] = axisPosition + peerAxis.offset;
                ys[2] = this.y + this.visibleSize + this.offset;
                xs[3] = axisPosition + peerAxis.offset;
                ys[3] = this.y + this.offset;
                xs2[0] = axisPosition + peerAxis.visibleSize + effect3D + peerAxis.offset;
                ys2[0] = ys[0];
                xs2[1] = axisPosition + peerAxis.visibleSize + effect3D + peerAxis.offset;
                ys2[1] = ys[1];
                xs2[2] = xs[1];
                ys2[2] = ys[1];
                xs2[3] = xs[0];
                ys2[3] = ys[0];
                if (!this.rightAxis) {
                    if (effect3D != 0) {
                        this.style.draw(g, xs[0], ys[0], xs[1], ys[1]);
                    }
                    if (effect3D != 0) {
                        this.style.draw(g, xs[2], ys[2], xs[1], ys[1]);
                    }
                    if (effect3D != 0) {
                        this.style.draw(g, xs[3], ys[3], xs[0], ys[0]);
                    }
                    if (effect3D != 0) {
                        this.style.draw(g, xs2[0], ys2[0], xs2[1], ys2[1]);
                    }
                }
            }
            if (axisCeroPosition != 0 && this.ceroAxis == 0 && !drawForeGround) {
                this.ceroAxisStyle.draw(g, axisCeroPosition, this.y, axisCeroPosition, this.y + this.height);
                if (!this.rightAxis) {
                    if (effect3D != 0) {
                        this.ceroAxisStyle.draw(g, axisCeroPosition + effect3D, this.y - effect3D, axisCeroPosition + effect3D, this.y + this.height - effect3D);
                    }
                    if (effect3D != 0) {
                        this.ceroAxisStyle.draw(g, axisCeroPosition, this.y + this.height, axisCeroPosition + effect3D, this.y + this.height - effect3D);
                    }
                    if (effect3D != 0) {
                        this.ceroAxisStyle.draw(g, axisCeroPosition, this.y, axisCeroPosition + effect3D, this.y - effect3D);
                    }
                }
            }
        }
        double tickBase = this.scale.min;
        int iteration = 0;
        if (this.logarithmicIntervals) {
            boolean ys2 = false;
        }
        if (this.startWithBigTick) {
            bigTickCount = this.bigTickInterval - 1;
        }
        Date tickDate = null;
        if (this.initialDate != null) {
            tickDate = this.initialDate;
        }
        double i2 = 0.0;
        double i = tickBase;
        while (i <= this.scale.max) {
            if (iteration > 1000) break;
            boolean nowBigTick = false;
            if (++iteration > 1 || this.tickAtBase) {
                int tickLength;
                ++numberTicks;
                int v = this.scale.getScreenCoord(i);
                if (this.bigTickIntervalList == null && ++bigTickCount == this.bigTickInterval) {
                    nowBigTick = true;
                }
                if (this.bigTickIntervalList != null) {
                    int j = 0;
                    while (j < this.bigTickIntervalList.length) {
                        if (numberTicks == this.bigTickIntervalList[j]) {
                            nowBigTick = true;
                        }
                        ++j;
                    }
                }
                if (nowBigTick) {
                    bigTickCount = 0;
                    tickLength = this.bigTickPixels;
                } else {
                    tickLength = this.tickPixels;
                }
                drawTick = true;
                if (drawTick) {
                    if (!(i == this.scale.min || drawForeGround || !drawGridBackground || this.gridFillStyle == null || bigTickCount != 0 && this.bigTicksGrid)) {
                        if (this.orientation == 0) {
                            if (fillGrid) {
                                this.gridFillStyle.draw(g, lastGridPosition + 1, this.plot.y - effect3D, v + effect3D, this.plot.y + this.plot.height - effect3D);
                            }
                            lastGridPosition = v + effect3D;
                        } else {
                            if (fillGrid) {
                                this.gridFillStyle.draw(g, this.plot.x + effect3D, v - effect3D + 1, this.plot.x + this.plot.width + effect3D, lastGridPosition);
                            }
                            lastGridPosition = v - effect3D;
                        }
                        boolean bl = fillGrid = !fillGrid;
                    }
                    if (!(i == this.scale.min || drawForeGround || drawGridBackground || this.gridStyle == null || bigTickCount != 0 && this.bigTicksGrid || this.ceroAxis == 0 && i == 0.0)) {
                        if (this.orientation == 0) {
                            if (effect3D != 0) {
                                this.gridStyle.draw(g, v, this.plot.y + this.plot.height, v + effect3D, this.plot.y + this.plot.height - effect3D);
                            }
                            this.gridStyle.draw(g, v + effect3D, this.plot.y - effect3D, v + effect3D, this.plot.y + this.plot.height - effect3D);
                        } else {
                            this.gridStyle.draw(g, this.plot.x + effect3D, v - effect3D, this.plot.x + this.plot.width + effect3D, v - effect3D);
                            if (effect3D != 0) {
                                this.gridStyle.draw(g, this.plot.x, v, this.plot.x + effect3D, v - effect3D);
                            }
                        }
                    }
                }
                if (drawForeGround) {
                    if (drawTick) {
                        if (this.orientation == 0) {
                            if (v - this.offset >= this.x && v - this.offset <= this.visibleSize + this.x) {
                                if (!this.xscaleOnTop) {
                                    this.style.draw(g, v - this.offset, axisPosition, v - this.offset, axisPosition + tickLength);
                                } else {
                                    this.style.draw(g, v - this.offset, axisPosition - peerAxis.visibleSize, v - this.offset, axisPosition - peerAxis.visibleSize - tickLength);
                                }
                            }
                        } else if (this.rightAxis) {
                            if (v - this.offset >= this.y && v - this.offset <= this.visibleSize + this.y) {
                                this.style.draw(g, axisPosition, v - this.offset, axisPosition + tickLength, v - this.offset);
                            }
                        } else if (v - this.offset >= this.y && v - this.offset <= this.visibleSize + this.y) {
                            this.style.draw(g, axisPosition - tickLength, v - this.offset, axisPosition, v - this.offset);
                        }
                    }
                    if (bigTickCount == 0) {
                        ++numberBigTicks;
                        g.setColor(this.DescColor);
                        g.setFont(this.DescFont);
                        String txt = new Double(i).toString();
                        if (this.scaleLabelFormat.length() > 0) {
                            DecimalFormat df = null;
                            if (Chart.numberLocale == null) {
                                df = new DecimalFormat(this.scaleLabelFormat);
                            } else {
                                NumberFormat nf = NumberFormat.getNumberInstance(new Locale(Chart.numberLocale, ""));
                                df = (DecimalFormat)nf;
                                df.applyPattern(this.scaleLabelFormat);
                            }
                            txt = df.format(new Double(i));
                        }
                        if (this.IntegerScale) {
                            txt = new Integer((int)i).toString();
                        }
                        if (tickDate != null) {
                            txt = new SimpleDateFormat(this.dateLabelFormat).format(tickDate);
                        }
                        ChartLabel formattedlabel = null;
                        if (this.tickLabels != null) {
                            if (this.tickLabels.length >= numberBigTicks) {
                                if (this.tickLabels[numberBigTicks - 1] != null) {
                                    formattedlabel = new ChartLabel(this.tickLabels[numberBigTicks - 1], txt, false, true);
                                    txt = this.tickLabels[numberBigTicks - 1];
                                } else {
                                    txt = " ";
                                }
                            } else {
                                txt = " ";
                            }
                        }
                        if (formattedlabel == null && this.labelTemplate.length() > 0) {
                            formattedlabel = new ChartLabel(this.labelTemplate, txt, false, false);
                        }
                        boolean labelPainted = false;
                        if (this.rotateLabels != 0 && this.orientation == 0 && v - this.offset >= this.x && v - this.offset <= this.visibleSize + this.x) {
                            int textWidth = g.getFontWidth(this.DescFont, txt);
                            labelPainted = !this.xscaleOnTop ? g.drawRotatedText(this.DescFont, this.DescColor, txt, this.rotateLabels, v - this.offset, this.realPosition + tickLength, false) : g.drawRotatedText(this.DescFont, this.DescColor, txt, this.rotateLabels, v - this.offset, this.realPosition - this.bigTickPixels - peerAxis.visibleSize - textWidth - 2, false);
                            if (this.maxTickLabelLength < textWidth) {
                                this.maxTickLabelLength = textWidth;
                            }
                        }
                        if (this.rotateLabels != 0 && this.orientation == 1 && v - this.offset >= this.y && v - this.offset <= this.visibleSize + this.y) {
                            int lblx = 0;
                            int lbly = 0;
                            int textHeight = g.getFontHeight(this.DescFont);
                            if (this.rightAxis) {
                                lblx = this.realPosition + tickLength + 1;
                            } else {
                                lblx = this.x + this.width - tickLength - g.getFontHeight(null);
                                if (this.barStyle != 0) {
                                    lblx = this.x + this.width - this.barWidth - g.getFontHeight(null);
                                }
                            }
                            lbly = v - g.getFontWidth(null, txt) / 2;
                            labelPainted = g.drawRotatedText(this.DescFont, this.DescColor, txt, this.rotateLabels, lblx, lbly - this.offset, false);
                            if (this.maxTickLabelLength < textHeight) {
                                this.maxTickLabelLength = textHeight;
                            }
                        }
                        if (!labelPainted && drawTick && formattedlabel != null) {
                            formattedlabel.initialize(g, this.chart);
                            labelPainted = true;
                            int lblw = formattedlabel.requiredWidth;
                            int lblh = formattedlabel.requiredHeight;
                            int lblx = 0;
                            int lbly = 0;
                            if (this.orientation == 1) {
                                if (this.rightAxis && !this.isMainAxis) {
                                    lblx = this.x + tickLength + 3;
                                    if (this.barStyle != 0) {
                                        lblx = this.x + this.barWidth + 3;
                                    }
                                } else if (this.rightAxis) {
                                    lblx = this.realPosition + tickLength + 3;
                                    if (this.barStyle != 0) {
                                        lblx = this.realPosition + this.barWidth + 3;
                                    }
                                } else {
                                    lblx = this.x + this.width - tickLength - lblw;
                                    if (this.barStyle != 0) {
                                        lblx = this.x + this.width - this.barWidth - lblw;
                                    }
                                }
                                if ((lbly = v - formattedlabel.requiredHeight) - this.offset >= this.y && lbly - this.offset <= this.visibleSize + this.y) {
                                    formattedlabel.paint(g, lblx, lbly - this.offset, formattedlabel.requiredWidth, formattedlabel.requiredHeight);
                                }
                                if (this.maxTickLabelLength < formattedlabel.getRotatedWidth()) {
                                    this.maxTickLabelLength = formattedlabel.getRotatedWidth();
                                }
                            } else {
                                lblx = v - lblw / 2;
                                lbly = this.realPosition + tickLength;
                                if (this.xscaleOnTop && !this.isMainAxis) {
                                    lbly = this.y - peerAxis.visibleSize - formattedlabel.requiredHeight - this.barWidth - tickLength;
                                }
                                if (this.xscaleOnTop && this.isMainAxis) {
                                    lbly = lbly - peerAxis.visibleSize - formattedlabel.requiredHeight - this.barWidth - tickLength;
                                }
                                if (v - this.offset >= this.x && v - this.offset <= this.visibleSize + this.x) {
                                    formattedlabel.paint(g, lblx - this.offset, lbly, formattedlabel.requiredWidth, formattedlabel.requiredHeight);
                                }
                                if (this.maxTickLabelLength < formattedlabel.getRotatedHeight()) {
                                    this.maxTickLabelLength = formattedlabel.getRotatedHeight();
                                }
                            }
                        }
                        if (!labelPainted && drawTick) {
                            int lblw1;
                            int h;
                            String[] txts = this.splitText(txt);
                            int lblw = g.getFontWidth(null, String.valueOf(txts[0]) + " ");
                            int lblh = g.getFontHeight(null);
                            int lblx = 0;
                            int lbly = 0;
                            if (this.orientation == 1) {
                                if (this.rightAxis && !this.isMainAxis) {
                                    lblx = this.x + tickLength + 3;
                                    if (this.barStyle != 0) {
                                        lblx = this.x + this.barWidth + 3;
                                    }
                                } else if (this.rightAxis) {
                                    lblx = this.realPosition + tickLength + 3;
                                    if (this.barStyle != 0) {
                                        lblx = this.realPosition + this.barWidth + 3;
                                    }
                                } else {
                                    lblx = this.x + this.width - tickLength - lblw;
                                    if (this.barStyle != 0) {
                                        lblx = this.x + this.width - this.barWidth - lblw;
                                    }
                                }
                                if ((lbly = v) - this.offset >= this.y && lbly - this.offset <= this.visibleSize + this.y) {
                                    g.drawString(txts[0], lblx, lbly - this.offset);
                                }
                                h = 1;
                                while (h < txts.length) {
                                    lblw1 = g.getFontWidth(null, txts[h]);
                                    lblx = this.rightAxis ? this.realPosition + tickLength + 1 : this.x + this.width - tickLength - lblw1;
                                    if (lbly - this.offset >= this.y && lbly - this.offset <= this.visibleSize + this.y) {
                                        g.drawString(txts[h], lblx, lbly - this.offset + lblh * h);
                                    }
                                    ++h;
                                }
                            } else {
                                lblx = v - lblw / 2;
                                lbly = this.realPosition + tickLength + lblh;
                                if (this.xscaleOnTop && this.isMainAxis) {
                                    lbly = lbly - peerAxis.visibleSize - txts.length * lblh - lblh - this.barWidth;
                                }
                                if (this.xscaleOnTop && !this.isMainAxis) {
                                    lbly = this.y - peerAxis.visibleSize - txts.length * lblh - lblh - this.barWidth;
                                }
                                if (v - this.offset >= this.x && v - this.offset <= this.visibleSize + this.x) {
                                    g.drawString(txts[0], lblx - this.offset, lbly);
                                }
                                h = 1;
                                while (h < txts.length) {
                                    lblw1 = g.getFontWidth(null, txts[h]);
                                    lblx = v - lblw1 / 2;
                                    if (v - this.offset >= this.x && v - this.offset <= this.visibleSize + this.x) {
                                        g.drawString(txts[h], lblx - this.offset, lbly + lblh * h);
                                    }
                                    ++h;
                                }
                            }
                        }
                    }
                }
            }
            if (this.logarithmicIntervals && this.scale instanceof LogScale) {
                if (i == 0.0) {
                    i = 1.0;
                }
                i *= ((LogScale)this.scale).base;
                continue;
            }
            i += usedTickInterval;
            i = Math.rint(i * 100000.0) / 100000.0;
            if (tickDate == null) continue;
            int step = 1;
            if (this.dateStep.length() > 1) {
                step = new Integer(this.dateStep.substring(1, this.dateStep.length()));
            }
            if (this.dateStepPerUnit) {
                step = (int)((double)step * usedTickInterval);
            }
            Calendar c = Calendar.getInstance();
            c.setTime(tickDate);
            if (this.dateStep.toLowerCase().indexOf("d") == 0) {
                c.add(5, step);
            }
            if (this.dateStep.toLowerCase().indexOf("m") == 0) {
                c.add(2, step);
            }
            if (this.dateStep.toLowerCase().indexOf("w") == 0) {
                c.add(5, step * 7);
            }
            if (this.dateStep.toLowerCase().indexOf("y") == 0) {
                c.add(1, step);
            }
            if (this.dateStep.toLowerCase().indexOf("h") == 0) {
                c.add(10, step);
            }
            if (this.dateStep.toLowerCase().indexOf("s") == 0) {
                c.add(13, step);
            }
            if (this.dateStep.toLowerCase().indexOf("n") == 0) {
                c.add(12, step);
            }
            tickDate = c.getTime();
        }
    }
}

