/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchartVB;

import com.java4less.rchart.LineStyle;
import com.java4less.rchart.gc.ChartColor;
import com.java4less.rchart.gc.GraphicsProvider;
import com.java4less.rchart.gc.awt.ChartAwtColor;
import com.java4less.rchartVB.RColorField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RStyleField
extends JPanel {
    RColorField textColor;
    JComboBox choiceType;
    JTextField textWidth;
    LineStyle style = new LineStyle(0.2f, GraphicsProvider.getColor((String)ChartColor.BLACK), 1);

    public RStyleField(JFrame f) {
        this.textColor = new RColorField(f);
        this.textColor.setSmallFormat();
        this.choiceType = new JComboBox();
        this.textWidth = new JTextField();
        try {
            this.jbInit();
            this.choiceType.addItem("Normal");
            this.choiceType.addItem("Dashed");
            this.choiceType.addItem("Dots");
            this.setSize(190, 20);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.textColor.setBounds(new Rectangle(1, 1, 90, 20));
        this.choiceType.setBounds(new Rectangle(92, 1, 73, 20));
        this.textWidth.setBounds(new Rectangle(165, 1, 25, 20));
        this.add((Component)this.textWidth, null);
        this.add((Component)this.textColor, null);
        this.add((Component)this.choiceType, null);
    }

    public void setStyle(LineStyle s) {
        if (s == null) {
            this.textWidth.setText("");
            this.textColor.setColor(Color.black);
            this.choiceType.setSelectedIndex(0);
            return;
        }
        this.style = s;
        this.textColor.setColor(((ChartAwtColor)s.getColor()).getColor());
        this.textWidth.setText("" + s.getWidth());
        if (s.getType() == 1) {
            this.choiceType.setSelectedIndex(0);
        }
        if (s.getType() == 2) {
            this.choiceType.setSelectedIndex(1);
        }
        if (s.getType() == 3) {
            this.choiceType.setSelectedIndex(2);
        }
    }

    public LineStyle getStyle() {
        if (this.textWidth.getText().length() == 0) {
            return null;
        }
        if (this.textColor.getColor() == null) {
            return null;
        }
        this.style.setColor(GraphicsProvider.getColorFromObject((Object)this.textColor.getColor()));
        this.style.setWidth(new Float(this.textWidth.getText()).floatValue());
        if (this.choiceType.getSelectedIndex() == 0) {
            this.style.setType(1);
        }
        if (this.choiceType.getSelectedIndex() == 1) {
            this.style.setType(2);
        }
        if (this.choiceType.getSelectedIndex() == 2) {
            this.style.setType(3);
        }
        return this.style;
    }

    public void setInternalStyle(String s) {
        this.setStyle(LineStyle.createFromString((String)s));
    }

    public String getInternalStyle() {
        if (this.textWidth.getText().length() == 0) {
            return "";
        }
        if (this.textColor.getColor() == null) {
            return "";
        }
        String w = "";
        String s = "";
        String c = "";
        w = "" + this.textWidth.getText();
        if (this.choiceType.getSelectedIndex() == 1) {
            s = "DASHED";
        }
        if (this.choiceType.getSelectedIndex() == 2) {
            s = "DOTS";
        }
        if (this.choiceType.getSelectedIndex() == 0) {
            s = "NORMAL";
        }
        c = this.textColor.getColorText();
        return String.valueOf(w) + "|" + c + "|" + s;
    }
}

