/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchartVB;

import com.java4less.rchartVB.ParamInfo;
import com.java4less.rchartVB.RColorField;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class RListEditor
extends JDialog
implements ListSelectionListener,
KeyListener,
ActionListener {
    Vector lista = new Vector(10, 10);
    JPopupMenu popupM = new JPopupMenu();
    JMenuItem itemAdd = new JMenuItem();
    JMenuItem itemInsert = new JMenuItem();
    JMenuItem itemDelete = new JMenuItem();
    private String dataType = ParamInfo.PARAM_STRING_LIST;
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    JButton btn = new JButton();
    TableModel dataModel = null;
    int currentRow = -1;
    JScrollPane jScrollPane1;
    JTable jTable1;
    JComboBox comboEdit;
    JComboBox comboShow;
    JLabel jLabel1 = new JLabel();
    static /* synthetic */ Class class$0;

    public RListEditor(JFrame f, String dt) {
        this.setTitle("List ...");
        if (dt != null) {
            this.dataType = dt;
        }
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return 1;
            }

            public int getRowCount() {
                return RListEditor.this.lista.size();
            }

            public Object getValueAt(int row, int col) {
                return RListEditor.this.lista.elementAt(row);
            }

            public boolean isCellEditable(int row, int pcol) {
                return true;
            }

            public Class getColumnClass(int pcol) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }

            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (rowIndex < RListEditor.this.lista.size()) {
                    RListEditor.this.lista.setElementAt(aValue, rowIndex);
                }
            }
        };
        this.jTable1 = new JTable(this.dataModel);
        this.jTable1.setTableHeader(null);
        this.jScrollPane1 = new JScrollPane(this.jTable1, 20, 31);
        if (dt.compareTo(ParamInfo.PARAM_COLOR_LIST) == 0) {
            RColorField cfe = new RColorField(f);
            RColorField cfr = new RColorField(f);
            this.jTable1.getColumnModel().getColumn(0).setCellEditor(cfe);
            this.jTable1.getColumnModel().getColumn(0).setCellRenderer(cfr);
        }
        this.jTable1.addKeyListener(this);
        this.jTable1.setRowHeight(21);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder("");
        this.getContentPane().setLayout(null);
        this.setModal(true);
        ((Component)this).setBounds((Toolkit.getDefaultToolkit().getScreenSize().width - 200) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - 270) / 2, 200, 270);
        this.jTable1.setBorder(BorderFactory.createEtchedBorder());
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setSize(178, 187);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(178);
        this.jTable1.addKeyListener(this);
        this.jTable1.getSelectionModel().addListSelectionListener(this);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                RListEditor.this.jTable1_mousePressed(e);
            }
        });
        this.itemAdd.setText("add");
        this.itemAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RListEditor.this.itemAdd_actionPerformed(e);
            }
        });
        this.itemInsert.setText("insert");
        this.itemInsert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RListEditor.this.itemInsert_actionPerformed(e);
            }
        });
        this.itemDelete.setText("delete");
        this.itemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RListEditor.this.itemDelete_actionPerformed(e);
            }
        });
        this.btn.setBorder(BorderFactory.createEtchedBorder());
        this.btn.setText("OK");
        this.btn.setBounds(new Rectangle(51, 208, 79, 27));
        this.btn.addActionListener(this);
        this.jScrollPane1.setBounds(new Rectangle(8, 21, 178, 183));
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                RListEditor.this.jTable1_mousePressed(e);
            }
        });
        this.jLabel1.setText("Mouse' right button for menu");
        this.jLabel1.setBounds(new Rectangle(10, 0, 178, 17));
        this.getContentPane().add((Component)this.jScrollPane1, null);
        this.getContentPane().add((Component)this.jLabel1, null);
        this.getContentPane().add((Component)this.btn, null);
        this.popupM.add(this.itemAdd);
        this.popupM.add(this.itemInsert);
        this.popupM.add(this.itemDelete);
    }

    void itemAdd_actionPerformed(ActionEvent e) {
        this.addRow();
    }

    void itemInsert_actionPerformed(ActionEvent e) {
        this.insertRow();
    }

    void itemDelete_actionPerformed(ActionEvent e) {
        this.deleteRow();
    }

    void jTable1_mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        KeyEvent k = e;
        if (k.getKeyCode() == 127) {
            this.deleteRow();
        }
        if (k.getKeyCode() == 40 && this.currentRow == this.lista.size() - 1) {
            this.addRow();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.popupM.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void deleteRow() {
        if (this.currentRow >= 0 && this.currentRow < this.lista.size()) {
            this.lista.removeElementAt(this.currentRow);
        }
        this.reloadTable();
    }

    public void insertRow() {
        if (this.currentRow >= 0 && this.currentRow < this.lista.size()) {
            this.lista.insertElementAt("", this.currentRow);
        }
        this.reloadTable();
    }

    public void addRow() {
        this.lista.addElement("");
        this.reloadTable();
    }

    public void actionPerformed(ActionEvent e) {
        String sActionCmd = e.getActionCommand();
        if (sActionCmd.compareTo("OK") == 0) {
            if (this.jTable1.isEditing()) {
                this.jTable1.getCellEditor().stopCellEditing();
            }
            ((Component)this).setVisible(false);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.currentRow = this.jTable1.getSelectedRow();
    }

    private void reloadTable() {
        ((AbstractTableModel)this.jTable1.getModel()).fireTableDataChanged();
    }

    public void setString(String p) {
        this.lista.removeAllElements();
        if (p == null) {
            return;
        }
        String[] s = RListEditor.convertList(p, "|");
        if (s != null) {
            int i = 0;
            while (i < s.length) {
                this.lista.addElement(s[i]);
                ++i;
            }
        }
        this.reloadTable();
    }

    public String getString() {
        String s = "";
        int i = 0;
        while (i < this.lista.size()) {
            if (i > 0) {
                s = String.valueOf(s) + "|";
            }
            s = String.valueOf(s) + (String)this.lista.elementAt(i);
            ++i;
        }
        return s;
    }

    protected static String[] convertList(String items, String separator) {
        if (items == null) {
            return null;
        }
        String[] itema = new String[5000];
        int itemCount = 0;
        int p = items.indexOf(separator);
        while (p >= 0) {
            itema[itemCount++] = items.substring(0, p);
            items = items.substring(p + separator.length(), items.length());
            p = items.indexOf(separator);
        }
        if (items.compareTo("") != 0) {
            itema[itemCount++] = items;
        }
        if (itemCount == 0) {
            return null;
        }
        String[] result = new String[itemCount];
        int i = 0;
        while (i < itemCount) {
            result[i] = itema[i];
            ++i;
        }
        return result;
    }
}

