/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchartVB;

import com.java4less.rchart.FillStyle;
import com.java4less.rchart.gc.awt.ChartAwtColor;
import com.java4less.rchartVB.RColorSelector;
import com.java4less.rchartVB.RFieldListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class RColorField
extends JPanel
implements ActionListener,
FocusListener,
TableCellRenderer,
TableCellEditor {
    private JTextField val = new JTextField();
    private JTextField ex = new JTextField();
    private JButton btn = new JButton("Color ...");
    private RColorSelector sel;
    public RFieldListener liste = null;
    private CellEditorListener mCellListener;

    public RColorField(Frame f) {
        this.sel = new RColorSelector(f);
        ((Component)this.sel).setVisible(false);
        this.btn.setBorder(BorderFactory.createRaisedBevelBorder());
        this.btn.setFont(new Font("Arial", 0, 10));
        this.setLayout(null);
        this.setSize(130, 20);
        this.val.setBounds(0, 0, 72, 20);
        this.val.addFocusListener(this);
        this.ex.setBounds(72, 0, 8, 20);
        this.ex.setEnabled(false);
        this.btn.setBounds(80, 0, 50, 20);
        this.btn.addActionListener(this);
        this.btn.setActionCommand("MORE");
        this.add(this.val);
        this.add(this.ex);
        this.add(this.btn);
    }

    public void setSmallFormat() {
        this.setSize(90, 20);
        this.val.setBounds(0, 0, 52, 20);
        this.ex.setBounds(52, 0, 8, 20);
        this.btn.setBounds(60, 0, 30, 20);
        this.btn.setText("...");
    }

    public void setColorText(String s) {
        this.val.setText(s);
        this.setLabelColor();
    }

    public void setLabelColor() {
        this.ex.setBackground(new ChartAwtColor((Object)this.val.getText()).getColor());
    }

    protected static String convertToString(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int rgb = r * 256 * 256 + g * 256 + b;
        String s = "0x" + Integer.toHexString(rgb);
        return s;
    }

    public void setFillStyle(FillStyle f) {
        if (f == null) {
            return;
        }
        this.setColor(((ChartAwtColor)f.getColor()).getColor());
    }

    public void setColor(Color c) {
        if (c == null) {
            this.val.setText("");
            this.ex.setBackground(Color.lightGray);
            return;
        }
        String s = RColorField.convertToString(c);
        this.val.setText(s);
        this.ex.setBackground(c);
    }

    public Color getColor() {
        if (this.val.getText().length() == 0) {
            return null;
        }
        return this.ex.getBackground();
    }

    public String getColorText() {
        return this.val.getText();
    }

    public void focusLost(FocusEvent e) {
        this.setLabelColor();
        if (this.liste != null) {
            this.liste.RFieldChanged(this, this.getName());
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String sActionCmd = e.getActionCommand();
        if (sActionCmd.compareTo("MORE") == 0) {
            this.sel.cancelled = false;
            this.sel.setColor(this.getColorText());
            ((Component)this.sel).setVisible(true);
            if (!this.sel.cancelled) {
                if (this.sel.colorSelected.toLowerCase().indexOf("0x") == 0) {
                    this.setColorText(this.sel.colorSelected);
                } else {
                    this.setColorText("0x" + this.sel.colorSelected);
                }
                if (this.liste != null) {
                    this.liste.RFieldChanged(this, this.getName());
                }
            }
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof String) {
            String SValue = (String)value;
            this.setColorText(SValue);
            if (isSelected) {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
        }
        return this;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof String) {
            String SValue = (String)value;
            this.setColorText(SValue);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
        }
        return this;
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.mCellListener = l;
    }

    public void cancelCellEditing() {
        this.mCellListener.editingCanceled(new ChangeEvent(this));
    }

    public Object getCellEditorValue() {
        return this.getColorText();
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.mCellListener = null;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        System.out.println("stop");
        this.mCellListener.editingStopped(new ChangeEvent(this));
        return true;
    }
}

