/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchartVB;

import com.java4less.rchartVB.Prog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class MiniChartCompiler {
    public String srcDirectory = "";
    public String outDirectory = "";
    public String outClassesDirectory = "";
    public String outFile = "miniChart.jar";
    public String compilationCmd = "javac -g:none -nowarn -classpath jaws.jar -sourcepath <SRC> -d <CLASSESDIR> ";
    public String jarCmd = "jar cvf <FILE> .";
    public String jaws = "";
    public String[] featuresToRemove = new String[0];
    private String log = "";

    public MiniChartCompiler() {
        try {
            this.outDirectory = new File("dummy").getAbsolutePath();
            this.outDirectory = this.outDirectory.substring(0, this.outDirectory.length() - 6);
            this.srcDirectory = String.valueOf(this.outDirectory) + File.separatorChar + "com" + File.separatorChar + "java4less" + File.separatorChar + "rchart";
            this.outDirectory = String.valueOf(this.outDirectory) + File.separatorChar + "tmp";
            this.outClassesDirectory = String.valueOf(this.outDirectory) + File.separatorChar + "classes";
            File d = new File(this.outDirectory);
            if (!d.exists()) {
                d.mkdir();
            }
            if (!(d = new File(this.outClassesDirectory)).exists()) {
                d.mkdir();
            }
            if (!(d = new File(String.valueOf(this.outDirectory) + File.separatorChar + "com")).exists()) {
                d.mkdir();
            }
            if (!(d = new File(String.valueOf(this.outDirectory) + File.separatorChar + "com" + File.separatorChar + "java4less")).exists()) {
                d.mkdir();
            }
            if (!(d = new File(String.valueOf(this.outDirectory) + File.separatorChar + "com" + File.separatorChar + "java4less" + File.separatorChar + "rchart")).exists()) {
                d.mkdir();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean requiredFile(String f) {
        if ((f = f.toUpperCase()).compareTo("MSG.JAVA") == 0) {
            return false;
        }
        if (f.compareTo("PARAMINPUT.JAVA") == 0) {
            return false;
        }
        if (f.compareTo("JDBCSOURCE.JAVA") == 0) {
            return false;
        }
        if (f.compareTo("CONTOURPLOTTER.JAVA") == 0) {
            return false;
        }
        if (f.compareTo("JCHARTBEAN.JAVA") == 0) {
            return false;
        }
        if (f.compareTo("JCHARTBEANBEANINFO.JAVA") == 0) {
            return false;
        }
        if (f.compareTo("JICHARTBEAN.JAVA") == 0) {
            return false;
        }
        if (f.compareTo("JICHARTBEANBEANINFO.JAVA") == 0) {
            return false;
        }
        if (f.compareTo("CHARTAPPLETBEACON.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("PIE") && f.compareTo("PIEDATASERIE.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("PIE") && f.compareTo("PIEPLOTTER.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("INTER") && f.compareTo("ICHART.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("LINE") && this.removeFeature("RADAR") && f.compareTo("LINEDATASERIE.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("LINE") && f.compareTo("LINEPLOTTER.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("LIN3D") && f.compareTo("LINEPLOTTER3D.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("LOG") && f.compareTo("LOGSCALE.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("MAX") && f.compareTo("MAXMINDATASERIE.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("RADAR") && f.compareTo("RADARPLOTTER.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("CURVE") && f.compareTo("CURVEPLOTTER.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("CURVE") && f.compareTo("RMATRIX.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("BAR") && f.compareTo("BARDATASERIE.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("BAR") && f.compareTo("BARPLOTTER.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("BA3D") && f.compareTo("BARPLOTTER3D.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("MAX") && f.compareTo("MAXMINDATASERIE.JAVA") == 0) {
            return false;
        }
        if (this.removeFeature("GAUGE") && f.compareTo("GAUGEPLOTTER.JAVA") == 0) {
            return false;
        }
        return !this.removeFeature("GAUGE") || f.compareTo("GAUGEDATASERIE.JAVA") != 0;
    }

    private boolean removeFeature(String f) {
        int j = 0;
        while (j < this.featuresToRemove.length) {
            if (f.compareTo(this.featuresToRemove[j]) == 0) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public String getLog() {
        return this.log;
    }

    public boolean compile() {
        this.log = "";
        String cmd = this.compilationCmd;
        String args = "";
        int p = cmd.indexOf("<SRC>");
        if (p > 0) {
            cmd = String.valueOf(cmd.substring(0, p)) + this.outDirectory + cmd.substring(p + 5, cmd.length());
        }
        if ((p = cmd.indexOf("<JAWS>")) > 0) {
            cmd = String.valueOf(cmd.substring(0, p)) + this.jaws + cmd.substring(p + 6, cmd.length());
        }
        if ((p = cmd.indexOf("<CLASSESDIR>")) > 0) {
            cmd = String.valueOf(cmd.substring(0, p)) + this.outClassesDirectory + cmd.substring(p + 12, cmd.length());
        }
        cmd = String.valueOf(cmd) + " " + this.outDirectory + File.separatorChar + "com" + File.separatorChar + "java4less" + File.separatorChar + "rchart" + File.separatorChar + "ChartApplet.java";
        try {
            Prog po = new Prog(cmd);
            po.start();
            this.log = po.getLog();
            String jar = this.jarCmd;
            p = jar.indexOf("<FILE>");
            if (p > 0) {
                jar = String.valueOf(jar.substring(0, p)) + this.outFile + jar.substring(p + 6, jar.length());
            }
            if ((p = jar.indexOf("<CLASSESDIR>")) > 0) {
                jar = String.valueOf(jar.substring(0, p)) + this.outClassesDirectory + jar.substring(p + 12, jar.length());
            }
            this.log = String.valueOf(this.log) + "\n\n\n";
            po = new Prog(jar, this.outClassesDirectory);
            po.start();
            this.log = String.valueOf(this.log) + po.getLog();
        }
        catch (Exception e) {
            System.err.println("Error starting compiler: " + e.getMessage());
            return false;
        }
        return true;
    }

    public void modifySrc() {
        int i;
        String outDir = String.valueOf(this.outDirectory) + File.separatorChar + "com" + File.separatorChar + "java4less" + File.separatorChar + "rchart";
        File d = new File(outDir);
        String[] files2 = d.list();
        if (files2 != null) {
            i = 0;
            while (i < files2.length) {
                new File(String.valueOf(outDir) + File.separatorChar + files2[i]).delete();
                ++i;
            }
        }
        try {
            d = new File(String.valueOf(this.outClassesDirectory) + File.separatorChar + "com" + File.separatorChar + "java4less" + File.separatorChar + "rchart");
            files2 = d.list();
            if (files2 != null) {
                i = 0;
                while (i < files2.length) {
                    new File(String.valueOf(this.outClassesDirectory) + File.separatorChar + "com" + File.separatorChar + "java4less" + File.separatorChar + "rchart" + File.separatorChar + files2[i]).delete();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        d = new File(this.srcDirectory);
        String[] files = d.list();
        int i2 = 0;
        while (i2 < files.length) {
            if (files[i2].toUpperCase().endsWith(".JAVA") && this.requiredFile(files[i2])) {
                this.modifyFile(String.valueOf(this.srcDirectory) + File.separatorChar + files[i2], String.valueOf(outDir) + File.separatorChar + files[i2]);
            }
            ++i2;
        }
    }

    private void modifyFile(String f1, String f2) {
        try {
            BufferedReader fi = new BufferedReader(new FileReader(f1));
            FileWriter fo = new FileWriter(f2);
            String removedFeature = "";
            String line = "";
            boolean include = true;
            while ((line = fi.readLine()) != null) {
                if (include && line.trim().startsWith("//++")) {
                    int j = 0;
                    while (j < this.featuresToRemove.length) {
                        if (line.indexOf(this.featuresToRemove[j]) > 0) {
                            removedFeature = this.featuresToRemove[j];
                            include = false;
                        }
                        ++j;
                    }
                }
                if (include) {
                    fo.write(String.valueOf(line) + "\n");
                }
                if (include || !line.trim().startsWith("//--") || line.indexOf(removedFeature) <= 0) continue;
                include = true;
                removedFeature = "";
            }
            fi.close();
            fo.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }
}

