/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchartVB;

import com.java4less.rchartVB.ParamInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

public class ChartParams {
    private static ParamInfo[] params = new ParamInfo[1500];
    private static int paramCount = 0;
    private static int NAME_FIELD = 0;
    private static int DESC_FIELD = 1;
    private static int LONG_DESC_FIELD = 2;
    private static int CLASSIFICATION_FIELD = 3;
    private static int DATA_TYPE_FIELD = 4;
    private static int DEFAULT = 5;
    private static int COMBO_VALUES = 6;

    private static String[] convertList(String items, String separator) {
        String[] itema = new String[50];
        int itemCount = 0;
        int p = items.indexOf(separator);
        while (p >= 0) {
            itema[itemCount++] = items.substring(0, p);
            items = items.substring(p + separator.length(), items.length());
            p = items.indexOf(separator);
        }
        if (items.compareTo("") != 0) {
            itema[itemCount++] = items;
        }
        if (itemCount == 0) {
            return null;
        }
        String[] result = new String[itemCount];
        int i = 0;
        while (i < itemCount) {
            result[i] = itema[i];
            ++i;
        }
        return result;
    }

    private static String replaceStr(String s, String sub1, String sub2) {
        int p = s.indexOf(sub1);
        while (p >= 0) {
            s = String.valueOf(s.substring(0, p)) + sub2 + s.substring(p + sub1.length(), s.length());
            p = s.indexOf(sub1);
        }
        return s;
    }

    public static int getParamCount() {
        return paramCount;
    }

    public static ParamInfo getParam(int i) {
        return params[i];
    }

    public static void clear() {
        int i = 0;
        while (i < paramCount) {
            ChartParams.params[i++].value = "";
        }
    }

    public static ParamInfo getParamByName(String p) {
        int i = 0;
        while (i < paramCount) {
            if (ChartParams.params[i].name.compareTo(p) == 0) {
                return params[i];
            }
            ++i;
        }
        return null;
    }

    public static void loadParamsDefinition() {
        String fileData = "";
        String param = "";
        String value = "";
        String defaultValue = "";
        try {
            BufferedReader in = null;
            URL url = ClassLoader.getSystemResource("com/java4less/rchartVB/params.txt");
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            String inputLine = "";
            String replaceWith = "";
            while ((inputLine = in.readLine()) != null) {
                String[] fields = ChartParams.convertList(inputLine, ";");
                String[] iterations = new String[]{""};
                if (fields[NAME_FIELD].indexOf("?") >= 0) {
                    iterations = new String[]{"X", "Y", "Y2", "X_1", "Y_1", "Y2_1", "X_2", "Y_2", "Y2_2"};
                }
                if (fields[NAME_FIELD].indexOf("*") >= 0) {
                    iterations = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
                }
                int i = 1;
                while (i <= iterations.length) {
                    ChartParams.params[ChartParams.paramCount] = new ParamInfo();
                    boolean bl = ChartParams.params[ChartParams.paramCount].isSeparator = fields[NAME_FIELD].charAt(0) == '_';
                    if (fields.length > DATA_TYPE_FIELD) {
                        ChartParams.params[ChartParams.paramCount].type = fields[DATA_TYPE_FIELD];
                    }
                    ChartParams.params[ChartParams.paramCount].value = "";
                    ChartParams.params[ChartParams.paramCount].defaultValue = "";
                    replaceWith = iterations[i - 1];
                    String iStr = "" + i;
                    ChartParams.params[ChartParams.paramCount].classification = ChartParams.replaceStr(ChartParams.replaceStr(fields[CLASSIFICATION_FIELD], "?", replaceWith), "*", iStr);
                    if (fields[NAME_FIELD].indexOf("*") >= 0) {
                        ChartParams.params[ChartParams.paramCount].isRepeteable = i;
                    }
                    ChartParams.params[ChartParams.paramCount].name = ChartParams.replaceStr(ChartParams.replaceStr(fields[NAME_FIELD], "?", replaceWith), "*", iStr);
                    ChartParams.params[ChartParams.paramCount].longDescription = ChartParams.replaceStr(ChartParams.replaceStr(fields[LONG_DESC_FIELD], "?", replaceWith), "*", iStr);
                    ChartParams.params[ChartParams.paramCount].shortDescription = ChartParams.replaceStr(ChartParams.replaceStr(fields[DESC_FIELD], "?", replaceWith), "*", iStr);
                    if (fields.length > DEFAULT) {
                        ChartParams.params[ChartParams.paramCount].defaultValue = fields[DEFAULT];
                        ChartParams.params[ChartParams.paramCount].value = fields[DEFAULT];
                    }
                    if (ChartParams.params[ChartParams.paramCount].name.compareTo("Y2AXIS") == 0) {
                        ChartParams.params[ChartParams.paramCount].value = "FALSE";
                        ChartParams.params[ChartParams.paramCount].defaultValue = "FALSE";
                    }
                    if (ChartParams.params[ChartParams.paramCount].name.compareTo("XSCALE_EXACT_MAX") == 0) {
                        ChartParams.params[ChartParams.paramCount].value = "FALSE";
                        ChartParams.params[ChartParams.paramCount].defaultValue = "FALSE";
                    }
                    if (ChartParams.params[ChartParams.paramCount].name.compareTo("XSCALE_EXACT_MIN") == 0) {
                        ChartParams.params[ChartParams.paramCount].value = "FALSE";
                        ChartParams.params[ChartParams.paramCount].defaultValue = "FALSE";
                    }
                    if (fields.length > COMBO_VALUES && fields[COMBO_VALUES].length() > 0) {
                        ChartParams.params[ChartParams.paramCount].comboValues = ChartParams.convertList(fields[COMBO_VALUES], ",");
                    }
                    ++paramCount;
                    ++i;
                }
            }
            in.close();
        }
        catch (Exception e) {
            String err = e.getMessage();
            e.printStackTrace();
            System.out.println("Error reading: params.txt " + e);
        }
    }
}

